/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed;

import com.nnpg.glazed.GlazedAddon;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.GuiThemes;
import meteordevelopment.meteorclient.gui.WindowScreen;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.utils.network.Http;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class MyScreen
extends WindowScreen {
    private int latestVersion = -1;
    private boolean isVersionFetched = false;
    private static boolean hasCheckedThisSession = false;

    public MyScreen(GuiTheme theme) {
        super(theme, "Version Check");
        this.fetchLatestVersion();
    }

    public static void checkVersionOnServerJoin() {
        if (hasCheckedThisSession) {
            return;
        }
        hasCheckedThisSession = true;
        MeteorExecutor.execute(() -> {
            try {
                int latestVersion;
                String versionString = Http.get((String)"https://glazedclient.com/versions/normal1.21.4.txt").sendString();
                if (versionString != null && !versionString.isEmpty() && (latestVersion = Integer.parseInt(versionString.trim())) > GlazedAddon.MyScreenVERSION) {
                    class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new MyScreen(GuiThemes.get())));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void resetSessionCheck() {
        hasCheckedThisSession = false;
    }

    public void initWidgets() {
        this.buildUI();
    }

    private void fetchLatestVersion() {
        MeteorExecutor.execute(() -> {
            try {
                String versionString = Http.get((String)"https://glazedclient.com/versions/normal1.21.4.txt").sendString();
                this.latestVersion = versionString != null && !versionString.isEmpty() ? Integer.parseInt(versionString.trim()) : GlazedAddon.MyScreenVERSION;
                this.isVersionFetched = true;
                this.reload();
            }
            catch (Exception e) {
                this.latestVersion = GlazedAddon.MyScreenVERSION;
                this.isVersionFetched = true;
                this.reload();
            }
        });
    }

    private void buildUI() {
        this.addWrappedMessage("Welcome to Overkill Client version checker. Here you can see your current version and check for updates.");
        this.add((WWidget)this.theme.horizontalSeparator()).padVertical(this.theme.scale(4.0)).expandX();
        this.addMessage(String.format("Installed Version: %d", GlazedAddon.MyScreenVERSION));
        if (this.isVersionFetched) {
            this.addMessage(String.format("Latest Version: %d", this.latestVersion));
        } else {
            this.addMessage("Latest Version: Checking...");
        }
        this.add((WWidget)this.theme.horizontalSeparator()).padVertical(this.theme.scale(8.0)).expandX();
        if (this.isVersionFetched && this.latestVersion > GlazedAddon.MyScreenVERSION) {
            this.addWrappedMessage("You're using an outdated version of the Overkill addon. Please update to the latest version. Newer versions may include important bug fixes, improvements, and additional features.");
        } else if (this.isVersionFetched && this.latestVersion == GlazedAddon.MyScreenVERSION) {
            this.addWrappedMessage("You're using the latest version of the Overkill addon. No update needed.");
        } else {
            this.addWrappedMessage("Checking for updates...");
        }
        this.add((WWidget)this.theme.horizontalSeparator()).padVertical(this.theme.scale(8.0)).expandX();
        WHorizontalList buttonsContainer = (WHorizontalList)this.add((WWidget)this.theme.horizontalList()).expandX().widget();
        WButton githubButton = (WButton)buttonsContainer.add((WWidget)this.theme.button("GitHub")).expandX().widget();
        githubButton.action = () -> class_156.method_668().method_670("https://discord.gg/mytPhFwJ6J");
        WButton websiteButton = (WButton)buttonsContainer.add((WWidget)this.theme.button("Website")).expandX().widget();
        websiteButton.action = () -> class_156.method_668().method_670("https://discord.gg/mytPhFwJ6J");
    }

    private void addMessage(String message) {
        WHorizontalList l = (WHorizontalList)this.add((WWidget)this.theme.horizontalList()).expandX().widget();
        l.add((WWidget)this.theme.label(message)).expandX();
    }

    private void addWrappedMessage(String message) {
        String[] words = message.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > 60 && currentLine.length() > 0) {
                this.addMessage(currentLine.toString());
                currentLine = new StringBuilder();
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            this.addMessage(currentLine.toString());
        }
    }
}

