/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.gui.themes.meteor;

import com.nnpg.glazed.gui.widgets.WRandomBetweenSlider;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.utils.render.color.Color;

public class WMeteorRandomBetweenSlider
extends WRandomBetweenSlider {
    protected final double min;
    protected final double max;
    protected final int decimalPlaces;
    protected boolean mouseOverMin = false;
    protected boolean mouseOverMax = false;
    protected boolean draggingMin = false;
    protected boolean draggingMax = false;

    public WMeteorRandomBetweenSlider(double valueMin, double valueMax, double min, double max, int decimalPlaces) {
        super(valueMin, valueMax, min, max, decimalPlaces);
        this.min = min;
        this.max = max;
        this.decimalPlaces = decimalPlaces;
    }

    @Override
    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        Color trackColor = new Color(100, 100, 100, 255);
        Color rangeColor = this.theme.textColor();
        Color handleColor = this.theme.textSecondaryColor();
        Color activeColor = this.theme.textColor();
        renderer.quad(this.x, this.y + this.height / 2.0 - 1.0, this.width, 2.0, trackColor);
        double minHandleX = this.getMinHandleX();
        double maxHandleX = this.getMaxHandleX();
        if (maxHandleX > minHandleX) {
            renderer.quad(this.x + minHandleX, this.y + this.height / 2.0 - 1.0, maxHandleX - minHandleX, 2.0, rangeColor);
        }
        Color minColor = this.mouseOverMin || this.draggingMin ? activeColor : handleColor;
        renderer.quad(this.x + minHandleX - 3.0, this.y + this.height / 2.0 - 6.0, 6.0, 12.0, minColor);
        Color maxColor = this.mouseOverMax || this.draggingMax ? activeColor : handleColor;
        renderer.quad(this.x + maxHandleX - 3.0, this.y + this.height / 2.0 - 6.0, 6.0, 12.0, maxColor);
        String minText = String.format("%." + this.decimalPlaces + "f", this.getMin());
        String maxText = String.format("%." + this.decimalPlaces + "f", this.getMax());
        double textY = this.y + this.height + 2.0;
        renderer.text(minText, this.x + minHandleX, textY, this.theme.textColor(), false);
        renderer.text(maxText, this.x + maxHandleX, textY, this.theme.textColor(), false);
    }

    private double getMinHandleX() {
        return (this.getMin() - this.min) / (this.max - this.min) * this.width;
    }

    private double getMaxHandleX() {
        return (this.getMax() - this.min) / (this.max - this.min) * this.width;
    }
}

