/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.gui.widgets;

import com.nnpg.glazed.gui.widgets.WRandomBetweenSlider;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;

public class WRandomBetweenDoubleEdit
extends WHorizontalList {
    public Runnable action;
    private final WTextBox minEdit;
    private final WTextBox maxEdit;
    private final WRandomBetweenSlider slider;
    private final double absoluteMin;
    private final double absoluteMax;
    private final double sliderMin;
    private final double sliderMax;
    private final boolean noSlider;

    public WRandomBetweenDoubleEdit(GuiTheme theme, double min, double max, double absoluteMin, double absoluteMax, double sliderMin, double sliderMax, boolean noSlider) {
        this.theme = theme;
        this.absoluteMin = absoluteMin;
        this.absoluteMax = absoluteMax;
        this.sliderMin = sliderMin;
        this.sliderMax = sliderMax;
        this.noSlider = noSlider;
        this.minEdit = (WTextBox)this.add((WWidget)theme.textBox(String.format("%.2f", min), this::filter)).minWidth(50.0).widget();
        this.slider = !noSlider ? (WRandomBetweenSlider)this.add(new WRandomBetweenSlider(min, max, sliderMin, sliderMax, 2)).expandX().widget() : null;
        this.maxEdit = (WTextBox)this.add((WWidget)theme.textBox(String.format("%.2f", max), this::filter)).minWidth(50.0).widget();
        this.minEdit.action = () -> {
            try {
                double newMin = Double.parseDouble(this.minEdit.get());
                newMin = Math.max(absoluteMin, Math.min(absoluteMax, newMin));
                if (newMin > this.getMax()) {
                    this.maxEdit.set(String.format("%.2f", newMin));
                }
                if (!noSlider && this.slider != null) {
                    this.slider.set(newMin, this.getMax());
                }
                if (this.action != null) {
                    this.action.run();
                }
            }
            catch (NumberFormatException e) {
                this.minEdit.set(String.format("%.2f", this.getMin()));
            }
        };
        this.maxEdit.action = () -> {
            try {
                double newMax = Double.parseDouble(this.maxEdit.get());
                newMax = Math.max(absoluteMin, Math.min(absoluteMax, newMax));
                if (newMax < this.getMin()) {
                    this.minEdit.set(String.format("%.2f", newMax));
                }
                if (!noSlider && this.slider != null) {
                    this.slider.set(this.getMin(), newMax);
                }
                if (this.action != null) {
                    this.action.run();
                }
            }
            catch (NumberFormatException e) {
                this.maxEdit.set(String.format("%.2f", this.getMax()));
            }
        };
        if (this.slider != null) {
            this.slider.action = () -> {
                this.minEdit.set(String.format("%.2f", this.slider.getMin()));
                this.maxEdit.set(String.format("%.2f", this.slider.getMax()));
                if (this.action != null) {
                    this.action.run();
                }
            };
        }
    }

    public void set(double min, double max) {
        this.minEdit.set(String.format("%.2f", min));
        this.maxEdit.set(String.format("%.2f", max));
        if (this.slider != null) {
            this.slider.set(min, max);
        }
    }

    public double getMin() {
        try {
            return Double.parseDouble(this.minEdit.get());
        }
        catch (NumberFormatException e) {
            return this.absoluteMin;
        }
    }

    public double getMax() {
        try {
            return Double.parseDouble(this.maxEdit.get());
        }
        catch (NumberFormatException e) {
            return this.absoluteMax;
        }
    }

    private boolean filter(String text, char c) {
        boolean good;
        boolean validate = true;
        if (c == '-' && !text.contains("-")) {
            good = true;
            validate = false;
        } else {
            good = c == '.' && !text.contains(".") ? true : Character.isDigit(c);
        }
        if (good && validate) {
            try {
                Double.parseDouble(text + c);
            }
            catch (NumberFormatException ignored) {
                good = false;
            }
        }
        return good;
    }
}

