/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.gui.widgets;

import com.nnpg.glazed.gui.widgets.WRandomBetweenSlider;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;

public class WRandomBetweenIntEdit
extends WHorizontalList {
    public Runnable action;
    private final WTextBox minEdit;
    private final WTextBox maxEdit;
    private final WRandomBetweenSlider slider;
    private final int absoluteMin;
    private final int absoluteMax;
    private final int sliderMin;
    private final int sliderMax;
    private final boolean noSlider;

    public WRandomBetweenIntEdit(GuiTheme theme, int min, int max, int absoluteMin, int absoluteMax, int sliderMin, int sliderMax, boolean noSlider) {
        this.theme = theme;
        this.absoluteMin = absoluteMin;
        this.absoluteMax = absoluteMax;
        this.sliderMin = sliderMin;
        this.sliderMax = sliderMax;
        this.noSlider = noSlider;
        this.minEdit = (WTextBox)this.add((WWidget)theme.textBox(String.valueOf(min), this::filter)).minWidth(40.0).widget();
        this.slider = !noSlider ? (WRandomBetweenSlider)this.add(new WRandomBetweenSlider(min, max, sliderMin, sliderMax, 0)).expandX().widget() : null;
        this.maxEdit = (WTextBox)this.add((WWidget)theme.textBox(String.valueOf(max), this::filter)).minWidth(40.0).widget();
        this.minEdit.action = () -> {
            try {
                int newMin = Integer.parseInt(this.minEdit.get());
                newMin = Math.max(absoluteMin, Math.min(absoluteMax, newMin));
                if (newMin > this.getMaxInt()) {
                    this.maxEdit.set(String.valueOf(newMin));
                }
                if (!noSlider && this.slider != null) {
                    this.slider.set(newMin, this.getMaxInt());
                }
                if (this.action != null) {
                    this.action.run();
                }
            }
            catch (NumberFormatException e) {
                this.minEdit.set(String.valueOf(this.getMinInt()));
            }
        };
        this.maxEdit.action = () -> {
            try {
                int newMax = Integer.parseInt(this.maxEdit.get());
                newMax = Math.max(absoluteMin, Math.min(absoluteMax, newMax));
                if (newMax < this.getMinInt()) {
                    this.minEdit.set(String.valueOf(newMax));
                }
                if (!noSlider && this.slider != null) {
                    this.slider.set(this.getMinInt(), newMax);
                }
                if (this.action != null) {
                    this.action.run();
                }
            }
            catch (NumberFormatException e) {
                this.maxEdit.set(String.valueOf(this.getMaxInt()));
            }
        };
        if (this.slider != null) {
            this.slider.action = () -> {
                this.minEdit.set(String.valueOf((int)this.slider.getMin()));
                this.maxEdit.set(String.valueOf((int)this.slider.getMax()));
                if (this.action != null) {
                    this.action.run();
                }
            };
        }
    }

    public void set(int min, int max) {
        this.minEdit.set(String.valueOf(min));
        this.maxEdit.set(String.valueOf(max));
        if (this.slider != null) {
            this.slider.set(min, max);
        }
    }

    public int getMinInt() {
        try {
            return Integer.parseInt(this.minEdit.get());
        }
        catch (NumberFormatException e) {
            return this.absoluteMin;
        }
    }

    public int getMaxInt() {
        try {
            return Integer.parseInt(this.maxEdit.get());
        }
        catch (NumberFormatException e) {
            return this.absoluteMax;
        }
    }

    private boolean filter(String text, char c) {
        boolean good;
        boolean validate = true;
        if (c == '-' && !text.contains("-")) {
            good = true;
            validate = false;
        } else {
            good = Character.isDigit(c);
        }
        if (good && validate) {
            try {
                Integer.parseInt(text + c);
            }
            catch (NumberFormatException ignored) {
                good = false;
            }
        }
        return good;
    }
}

