/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.gui.widgets;

import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorGuiTheme;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorWidget;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_3532;

public class WRandomBetweenSlider
extends WWidget
implements MeteorWidget {
    public Runnable action;
    public Runnable actionOnRelease;
    private double valueMin;
    private double valueMax;
    private final double min;
    private final double max;
    private final int decimalPlaces;
    private boolean draggingMin = false;
    private boolean draggingMax = false;
    private boolean minHandleMouseOver = false;
    private boolean maxHandleMouseOver = false;
    private double valueMinAtDragStart;
    private double valueMaxAtDragStart;

    public WRandomBetweenSlider(double valueMin, double valueMax, double min, double max, int decimalPlaces) {
        this.valueMin = class_3532.method_15350((double)valueMin, (double)min, (double)max);
        this.valueMax = class_3532.method_15350((double)valueMax, (double)min, (double)max);
        this.min = min;
        this.max = max;
        this.decimalPlaces = decimalPlaces;
    }

    protected double handleSize() {
        return this.theme.textHeight();
    }

    protected void onCalculateSize() {
        double s = this.handleSize();
        this.width = s * 6.0;
        this.height = s;
    }

    public void setMin(double min) {
        if (min > this.valueMax) {
            min = this.valueMax;
        }
        if (min < this.min) {
            min = this.min;
        }
        this.valueMin = min;
    }

    public void setMax(double max) {
        if (max < this.valueMin) {
            max = this.valueMin;
        }
        if (max > this.max) {
            max = this.max;
        }
        this.valueMax = max;
    }

    public void set(double min, double max) {
        this.setMin(min);
        this.setMax(max);
    }

    public double getMin() {
        return this.valueMin;
    }

    public double getMax() {
        return this.valueMax;
    }

    private double getMinHandlePos() {
        double valuePercentage = (this.valueMin - this.min) / (this.max - this.min);
        return valuePercentage * (this.width - this.handleSize());
    }

    private double getMaxHandlePos() {
        double valuePercentage = (this.valueMax - this.min) / (this.max - this.min);
        return valuePercentage * (this.width - this.handleSize());
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button, boolean used) {
        if (this.mouseOver && !used) {
            double distToMax;
            this.valueMinAtDragStart = this.valueMin;
            this.valueMaxAtDragStart = this.valueMax;
            double handleSize = this.handleSize();
            double minHandleX = this.x + handleSize / 2.0 + this.getMinHandlePos();
            double maxHandleX = this.x + handleSize / 2.0 + this.getMaxHandlePos();
            double distToMin = Math.abs(mouseX - minHandleX);
            if (distToMin <= (distToMax = Math.abs(mouseX - maxHandleX)) && distToMin <= handleSize / 2.0) {
                this.draggingMin = true;
                return true;
            }
            if (distToMax <= handleSize / 2.0) {
                this.draggingMax = true;
                return true;
            }
            double clickValue = (mouseX - (this.x + handleSize / 2.0)) / (this.width - handleSize) * (this.max - this.min) + this.min;
            if (Math.abs(clickValue - this.valueMin) <= Math.abs(clickValue - this.valueMax)) {
                this.setMin(clickValue);
                this.draggingMin = true;
            } else {
                this.setMax(clickValue);
                this.draggingMax = true;
            }
            if (this.action != null) {
                this.action.run();
            }
            return true;
        }
        return false;
    }

    public void onMouseMoved(double mouseX, double mouseY, double lastMouseX, double lastMouseY) {
        double handleSize = this.handleSize();
        double minHandleX = this.x + handleSize / 2.0 + this.getMinHandlePos();
        double maxHandleX = this.x + handleSize / 2.0 + this.getMaxHandlePos();
        this.minHandleMouseOver = Math.abs(mouseX - minHandleX) <= handleSize / 2.0 && mouseY >= this.y && mouseY <= this.y + this.height;
        this.maxHandleMouseOver = Math.abs(mouseX - maxHandleX) <= handleSize / 2.0 && mouseY >= this.y && mouseY <= this.y + this.height;
        boolean mouseOverX = mouseX >= this.x + handleSize / 2.0 && mouseX <= this.x + handleSize / 2.0 + this.width - handleSize;
        boolean bl = this.mouseOver = mouseOverX && mouseY >= this.y && mouseY <= this.y + this.height;
        if ((this.draggingMin || this.draggingMax) && mouseOverX) {
            double valueWidth = mouseX - (this.x + handleSize / 2.0);
            valueWidth = class_3532.method_15350((double)valueWidth, (double)0.0, (double)(this.width - handleSize));
            double newValue = valueWidth / (this.width - handleSize) * (this.max - this.min) + this.min;
            if (this.draggingMin) {
                this.setMin(newValue);
            } else {
                this.setMax(newValue);
            }
            if (this.action != null) {
                this.action.run();
            }
        }
    }

    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        if (this.draggingMin || this.draggingMax) {
            if ((this.valueMin != this.valueMinAtDragStart || this.valueMax != this.valueMaxAtDragStart) && this.actionOnRelease != null) {
                this.actionOnRelease.run();
            }
            this.draggingMin = false;
            this.draggingMax = false;
            return true;
        }
        return false;
    }

    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        double handleSize = this.handleSize();
        double minHandlePos = this.getMinHandlePos();
        double maxHandlePos = this.getMaxHandlePos();
        this.renderBar(renderer, minHandlePos, maxHandlePos, handleSize);
        this.renderHandles(renderer, minHandlePos, maxHandlePos, handleSize);
    }

    private void renderBar(GuiRenderer renderer, double minHandlePos, double maxHandlePos, double handleSize) {
        double rightStart;
        double rightWidth;
        double activeWidth;
        MeteorGuiTheme theme = this.theme();
        double s = theme.scale(3.0);
        double barX = this.x + handleSize / 2.0;
        double barY = this.y + this.height / 2.0 - s / 2.0;
        double barWidth = this.width - handleSize;
        if (minHandlePos > 0.0) {
            renderer.quad(barX, barY, minHandlePos, s, (Color)theme.sliderRight.get());
        }
        if ((activeWidth = maxHandlePos - minHandlePos) > 0.0) {
            renderer.quad(barX + minHandlePos, barY, activeWidth, s, (Color)theme.sliderLeft.get());
        }
        if ((rightWidth = barWidth - (rightStart = maxHandlePos)) > 0.0) {
            renderer.quad(barX + rightStart, barY, rightWidth, s, (Color)theme.sliderRight.get());
        }
    }

    private void renderHandles(GuiRenderer renderer, double minHandlePos, double maxHandlePos, double handleSize) {
        MeteorGuiTheme theme = this.theme();
        SettingColor minColor = theme.sliderHandle.get(this.draggingMin, this.minHandleMouseOver);
        renderer.quad(this.x + minHandlePos, this.y, handleSize, handleSize, GuiRenderer.CIRCLE, (Color)minColor);
        SettingColor maxColor = theme.sliderHandle.get(this.draggingMax, this.maxHandleMouseOver);
        renderer.quad(this.x + maxHandlePos, this.y, handleSize, handleSize, GuiRenderer.CIRCLE, (Color)maxColor);
    }

    public String toString() {
        if (this.decimalPlaces == 0) {
            return String.format("%.0f - %.0f", this.valueMin, this.valueMax);
        }
        return String.format("%." + this.decimalPlaces + "f - %." + this.decimalPlaces + "f", this.valueMin, this.valueMax);
    }
}

