/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.utils.render.color.Color;

public class WTextBox
extends WWidget {
    private final String text;
    private final GuiTheme theme;
    private List<String> wrappedLines;

    public WTextBox(GuiTheme theme, String text) {
        this.text = text;
        this.theme = theme;
        this.wrappedLines = new ArrayList<String>();
        this.wrapText();
    }

    private void wrapText() {
        this.wrappedLines.clear();
        String[] words = this.text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        double availableWidth = this.getAvailableWidth();
        if (availableWidth <= 0.0) {
            this.wrappedLines.add(this.text);
            return;
        }
        for (String word : words) {
            Object testLine = currentLine.length() > 0 ? String.valueOf(currentLine) + " " + word : word;
            double testWidth = this.theme.textWidth((String)testLine);
            if (testWidth > availableWidth) {
                if (currentLine.length() > 0) {
                    this.wrappedLines.add(currentLine.toString());
                    currentLine = new StringBuilder(word);
                    continue;
                }
                this.wrappedLines.add(word);
                continue;
            }
            currentLine = new StringBuilder((String)testLine);
        }
        if (currentLine.length() > 0) {
            this.wrappedLines.add(currentLine.toString());
        }
    }

    private double getAvailableWidth() {
        if (this.parent != null && this.parent.parent != null && this.parent.parent.parent != null && this.parent.parent.parent.width > 0.0) {
            return this.parent.parent.parent.width * 0.995;
        }
        if (this.parent != null && this.parent.parent != null && this.parent.parent.width > 0.0) {
            return this.parent.parent.width * 0.995;
        }
        if (this.parent != null && this.parent.width > 0.0) {
            return this.parent.width * 0.995;
        }
        return 0.0;
    }

    protected void onCalculateSize() {
        double availableWidth = this.getAvailableWidth();
        if (availableWidth > 0.0) {
            int oldLineCount = this.wrappedLines.size();
            this.wrapText();
            if (oldLineCount != this.wrappedLines.size()) {
                this.invalidate();
            }
        }
        this.width = 0.0;
        this.height = this.theme.textHeight() * (double)this.wrappedLines.size();
    }

    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        double currentY = this.y;
        double parentX = this.parent != null ? this.parent.x : this.x;
        for (String line : this.wrappedLines) {
            renderer.text(line, parentX - 5.0, currentY, Color.LIGHT_GRAY, false);
            currentY += this.theme.textHeight();
        }
    }
}

