/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.mixins;

import com.nnpg.glazed.gui.widgets.WRandomBetweenDoubleEdit;
import com.nnpg.glazed.gui.widgets.WRandomBetweenIntEdit;
import com.nnpg.glazed.gui.widgets.WTextBox;
import com.nnpg.glazed.mixins.DefaultSettingsWidgetFactoryAccessor;
import com.nnpg.glazed.settings.RandomBetweenDoubleSetting;
import com.nnpg.glazed.settings.RandomBetweenIntSetting;
import com.nnpg.glazed.settings.TextDisplaySetting;
import com.nnpg.glazed.utils.RandomBetweenDouble;
import com.nnpg.glazed.utils.RandomBetweenInt;
import meteordevelopment.meteorclient.gui.DefaultSettingsWidgetFactory;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DefaultSettingsWidgetFactory.class})
public class DefaultSettingsWidgetFactoryMixin {
    @Inject(method={"<init>(Lmeteordevelopment/meteorclient/gui/GuiTheme;)V"}, at={@At(value="TAIL")})
    private void addRandomBetweenFactories(GuiTheme theme, CallbackInfo ci) {
        DefaultSettingsWidgetFactory factory = (DefaultSettingsWidgetFactory)this;
        DefaultSettingsWidgetFactoryAccessor accessor = (DefaultSettingsWidgetFactoryAccessor)factory;
        accessor.getFactories().put(RandomBetweenIntSetting.class, (table, setting) -> this.randomBetweenIntW(table, (RandomBetweenIntSetting)setting, theme));
        accessor.getFactories().put(RandomBetweenDoubleSetting.class, (table, setting) -> this.randomBetweenDoubleW(table, (RandomBetweenDoubleSetting)setting, theme));
        accessor.getFactories().put(TextDisplaySetting.class, (table, setting) -> this.textDisplayW(table, (TextDisplaySetting)setting, theme));
    }

    private void randomBetweenIntW(WTable table, RandomBetweenIntSetting setting, GuiTheme theme) {
        WRandomBetweenIntEdit edit = new WRandomBetweenIntEdit(theme, ((RandomBetweenInt)setting.get()).min, ((RandomBetweenInt)setting.get()).max, setting.absoluteMin, setting.absoluteMax, setting.sliderMin, setting.sliderMax, setting.noSlider);
        table.add((WWidget)edit).expandX();
        edit.action = () -> {
            if (!setting.set(new RandomBetweenInt(edit.getMinInt(), edit.getMaxInt()))) {
                edit.set(((RandomBetweenInt)setting.get()).min, ((RandomBetweenInt)setting.get()).max);
            }
        };
        WButton reset = (WButton)table.add((WWidget)theme.button(GuiRenderer.RESET)).widget();
        reset.action = () -> {
            setting.reset();
            edit.set(((RandomBetweenInt)setting.get()).min, ((RandomBetweenInt)setting.get()).max);
        };
    }

    private void randomBetweenDoubleW(WTable table, RandomBetweenDoubleSetting setting, GuiTheme theme) {
        WRandomBetweenDoubleEdit edit = new WRandomBetweenDoubleEdit(theme, ((RandomBetweenDouble)setting.get()).min, ((RandomBetweenDouble)setting.get()).max, setting.absoluteMin, setting.absoluteMax, setting.sliderMin, setting.sliderMax, setting.noSlider);
        table.add((WWidget)edit).expandX();
        edit.action = () -> {
            if (!setting.set(new RandomBetweenDouble(edit.getMin(), edit.getMax()))) {
                edit.set(((RandomBetweenDouble)setting.get()).min, ((RandomBetweenDouble)setting.get()).max);
            }
        };
        WButton reset = (WButton)table.add((WWidget)theme.button(GuiRenderer.RESET)).widget();
        reset.action = () -> {
            setting.reset();
            edit.set(((RandomBetweenDouble)setting.get()).min, ((RandomBetweenDouble)setting.get()).max);
        };
    }

    private void textDisplayW(WTable table, TextDisplaySetting setting, GuiTheme theme) {
        WTextBox textBox = new WTextBox(theme, (String)setting.get());
        table.add((WWidget)textBox).expandCellX();
        table.add((WWidget)theme.label(""));
    }
}

