/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2666;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;

public class BedrockVoidESP
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final SettingGroup sgPerformance;
    private final Setting<Integer> minVoidSize;
    private final Setting<Boolean> showEsp;
    private final Setting<Boolean> showTracers;
    private final Setting<Boolean> chatFeedback;
    private final Setting<Integer> maxMessagesPerMinute;
    private final Setting<SettingColor> espColor;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> tracerColor;
    private final Setting<Boolean> useThreading;
    private final Setting<Integer> threadPoolSize;
    private static final List<Integer> OVERWORLD_Y_LEVELS = List.of(Integer.valueOf(-64), Integer.valueOf(-63), Integer.valueOf(-62), Integer.valueOf(-61), Integer.valueOf(-60));
    private static final List<Integer> NETHER_FLOOR_Y_LEVELS = List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4));
    private static final List<Integer> NETHER_ROOF_Y_LEVELS = List.of(Integer.valueOf(123), Integer.valueOf(124), Integer.valueOf(125), Integer.valueOf(126), Integer.valueOf(127));
    private String currentDimension;
    private final Set<class_2338> voidBlocks;
    private ExecutorService threadPool;
    private long lastMinuteStart;
    private int messagesThisMinute;

    public BedrockVoidESP() {
        super(GlazedAddon.esp, "BedrockVoidESP", "Finds voids in bedrock layers. Useful for indicating placeswhere spawners may be un-raidable if located there.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.sgPerformance = this.settings.createGroup("Performance");
        this.minVoidSize = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-void-size")).description("Minimum number of blocks to consider an area a void.")).defaultValue((Object)2)).min(1).sliderMax(50).onChanged(this::onSettingChanged)).build());
        this.showEsp = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-esp")).description("Show the void ESP.")).defaultValue((Object)true)).build());
        this.showTracers = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-tracers")).description("Show tracers to the voids.")).defaultValue((Object)false)).build());
        this.chatFeedback = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-feedback")).description("Announce voids in chat")).defaultValue((Object)true)).build());
        this.maxMessagesPerMinute = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-messages-per-minute")).description("Maximum void messages per minute (0 = unlimited)")).defaultValue((Object)10)).min(0).max(60).sliderRange(0, 60).visible(() -> this.chatFeedback.get())).build());
        this.espColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("esp-color")).description("Color of the void ESP.")).defaultValue(new SettingColor(240, 85, 80, 128)).visible(() -> this.showEsp.get())).build());
        this.shapeMode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("Shape mode of the void ESP.")).defaultValue((Object)ShapeMode.Both)).visible(() -> this.showEsp.get())).build());
        this.tracerColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("Color of the void tracers.")).defaultValue(new SettingColor(255, 0, 0, 255)).visible(() -> this.showTracers.get())).build());
        this.useThreading = this.sgPerformance.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-threading")).description("Use multi-threading for chunk scanning (better performance)")).defaultValue((Object)true)).build());
        this.threadPoolSize = this.sgPerformance.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("thread-pool-size")).description("Number of threads to use for scanning")).defaultValue((Object)4)).min(1).max(8).sliderRange(1, 8).visible(() -> this.useThreading.get())).build());
        this.voidBlocks = ConcurrentHashMap.newKeySet();
        this.lastMinuteStart = 0L;
        this.messagesThisMinute = 0;
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        this.currentDimension = this.mc.field_1687.method_27983().method_29177().toString();
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            this.threadPool = Executors.newFixedThreadPool((Integer)this.threadPoolSize.get());
        }
        this.voidBlocks.clear();
        this.lastMinuteStart = 0L;
        this.messagesThisMinute = 0;
        for (class_2791 chunk : Utils.chunks()) {
            if (!(chunk instanceof class_2818)) continue;
            class_2818 worldChunk = (class_2818)chunk;
            if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
                this.threadPool.submit(() -> this.scanChunk(worldChunk));
                continue;
            }
            this.scanChunk(worldChunk);
        }
    }

    public void onDeactivate() {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdownNow();
            this.threadPool = null;
        }
        this.voidBlocks.clear();
    }

    @EventHandler
    private void onChunkLoad(ChunkDataEvent event) {
        class_2818 class_28182 = event.chunk();
        if (class_28182 instanceof class_2818) {
            class_2818 worldChunk = class_28182;
            if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
                this.threadPool.submit(() -> this.scanChunk(worldChunk));
            } else {
                this.scanChunk(worldChunk);
            }
        }
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        class_2338 pos = event.pos;
        class_2680 state = event.newState;
        List<Integer> yLevels = this.getYLevelsForDimension();
        if (!yLevels.contains(pos.method_10264())) {
            return;
        }
        class_1923 chunkPos = new class_1923(pos);
        class_2818 chunk = this.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180);
        if (chunk instanceof class_2818) {
            class_2818 worldChunk = chunk;
            if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
                this.threadPool.submit(() -> this.scanChunk(worldChunk));
            } else {
                this.scanChunk(worldChunk);
            }
        }
    }

    @EventHandler
    private void onReceivePacket(PacketEvent.Receive event) {
        class_2596 class_25962 = event.packet;
        if (class_25962 instanceof class_2666) {
            class_2666 packet = (class_2666)class_25962;
            class_1923 chunkPos = packet.comp_1726();
            this.voidBlocks.removeIf(blockPos -> new class_1923(blockPos).equals((Object)chunkPos));
        }
    }

    private void scanChunk(class_2818 chunk) {
        if (this.mc.field_1687 == null || chunk == null) {
            return;
        }
        class_1923 chunkPos = chunk.method_12004();
        this.voidBlocks.removeIf(blockPos -> new class_1923(blockPos).equals((Object)chunkPos));
        List<Integer> yLevels = this.getYLevelsForDimension();
        if (yLevels.isEmpty()) {
            return;
        }
        this.findVoidsInChunk(chunk, yLevels);
    }

    private List<Integer> getYLevelsForDimension() {
        return switch (this.currentDimension) {
            case "minecraft:overworld" -> OVERWORLD_Y_LEVELS;
            case "minecraft:the_nether" -> {
                ArrayList<Integer> levels = new ArrayList<Integer>();
                levels.addAll(NETHER_FLOOR_Y_LEVELS);
                levels.addAll(NETHER_ROOF_Y_LEVELS);
                yield levels;
            }
            default -> Collections.emptyList();
        };
    }

    private void findVoidsInChunk(class_2818 chunk, List<Integer> yLevels) {
        class_1923 chunkPos = chunk.method_12004();
        int startX = chunkPos.method_8326();
        int startZ = chunkPos.method_8328();
        HashSet<class_2338> processed = new HashSet<class_2338>();
        for (int y : yLevels) {
            for (int dx = 0; dx < 16; ++dx) {
                for (int dz = 0; dz < 16; ++dz) {
                    List<class_2338> group;
                    class_2338 pos = new class_2338(startX + dx, y, startZ + dz);
                    if (processed.contains(pos) || BedrockVoidESP.isBedrock(this.getBlockState(pos)) || (group = this.floodFillVoid(pos, yLevels, processed)).size() < (Integer)this.minVoidSize.get() || !this.isVoidEnclosed(group)) continue;
                    this.voidBlocks.addAll(group);
                    if (group.isEmpty()) continue;
                    class_2338 firstBlock = group.get(0);
                    this.sendVoidMessage("\u00a75[\u00a7dBedrockVoidESP\u00a75] \u00a7bVoid found\u00a75: \u00a7b" + group.size() + " blocks at " + firstBlock.method_23854());
                }
            }
        }
    }

    private List<class_2338> floodFillVoid(class_2338 start, List<Integer> yLevels, Set<class_2338> processed) {
        ArrayList<class_2338> group = new ArrayList<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.offer(start);
        while (!queue.isEmpty() && group.size() < 200) {
            class_2338 current = (class_2338)queue.poll();
            if (processed.contains(current) || BedrockVoidESP.isBedrock(this.getBlockState(current)) || !yLevels.contains(current.method_10264())) continue;
            processed.add(current);
            group.add(current);
            for (class_2350 dir : class_2350.values()) {
                class_2338 neighbor = current.method_10093(dir);
                if (processed.contains(neighbor)) continue;
                queue.offer(neighbor);
            }
        }
        return group;
    }

    private boolean isVoidEnclosed(List<class_2338> group) {
        for (class_2338 pos : group) {
            for (class_2350 dir : class_2350.values()) {
                class_2338 neighbor = pos.method_10093(dir);
                if (group.contains(neighbor) || BedrockVoidESP.isBedrock(this.getBlockState(neighbor))) continue;
                return false;
            }
        }
        return true;
    }

    private class_2680 getBlockState(class_2338 pos) {
        if (this.mc.field_1687 == null) {
            return class_2246.field_9987.method_9564();
        }
        return this.mc.field_1687.method_8320(pos);
    }

    private void onSettingChanged(Integer value) {
        if (this.isActive() && this.mc.field_1687 != null) {
            this.voidBlocks.clear();
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
                    this.threadPool.submit(() -> this.scanChunk(worldChunk));
                    continue;
                }
                this.scanChunk(worldChunk);
            }
        }
    }

    private static boolean isBedrock(class_2680 state) {
        return state.method_26204() == class_2246.field_9987;
    }

    private void sendVoidMessage(String message) {
        int maxMessages;
        if (!((Boolean)this.chatFeedback.get()).booleanValue()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long currentMinute = currentTime / 60000L;
        if (currentMinute != this.lastMinuteStart) {
            this.lastMinuteStart = currentMinute;
            this.messagesThisMinute = 0;
        }
        if ((maxMessages = ((Integer)this.maxMessagesPerMinute.get()).intValue()) == 0 || this.messagesThisMinute < maxMessages) {
            this.info(message, new Object[0]);
            ++this.messagesThisMinute;
        }
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        Color color;
        if (((Boolean)this.showEsp.get()).booleanValue()) {
            color = (Color)this.espColor.get();
            for (class_2338 pos : this.voidBlocks) {
                event.renderer.box(pos, color, color, (ShapeMode)this.shapeMode.get(), 0);
            }
        }
        if (((Boolean)this.showTracers.get()).booleanValue()) {
            color = (Color)this.tracerColor.get();
            class_243 camera = this.mc.field_1773.method_19418().method_19326();
            for (class_2338 pos : this.voidBlocks) {
                class_243 blockCenter = class_243.method_24953((class_2382)pos);
                event.renderer.line(camera.field_1352, camera.field_1351, camera.field_1350, blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350, color);
            }
        }
    }
}

