/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_4481;

public class BeehiveESP
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<SettingColor> beehiveColor;
    private final Setting<ShapeMode> beehiveShapeMode;
    private final Setting<Boolean> tracers;
    private final Setting<SettingColor> tracerColor;
    private final Setting<Boolean> beehiveChat;
    private final SettingGroup sgFiltering;
    private final Setting<Boolean> includeLevel0;
    private final Setting<Boolean> includeLevel1;
    private final Setting<Boolean> includeLevel2;
    private final Setting<Boolean> includeLevel3;
    private final Setting<Boolean> includeLevel4;
    private final Setting<Boolean> includeLevel5;
    private final SettingGroup sgHiveTypes;
    private final Setting<Boolean> includeBeehives;
    private final Setting<Boolean> includeBeeNests;
    private final SettingGroup sgRange;
    private final Setting<Integer> minY;
    private final Setting<Integer> maxY;
    private final SettingGroup sgThreading;
    private final Setting<Boolean> useThreading;
    private final Setting<Integer> threadPoolSize;
    private final Setting<Boolean> limitChatSpam;
    private final Set<class_2338> beehivePositions;
    private ExecutorService threadPool;

    public BeehiveESP() {
        super(GlazedAddon.esp, "BeehiveESP", "ESP for beehives and bee nests when full of honey with threading and tracer support.");
        this.sgGeneral = this.settings.createGroup("General");
        this.beehiveColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("beehive-color")).description("Full beehive box color")).defaultValue(new SettingColor(255, 215, 0, 100)).build());
        this.beehiveShapeMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("Beehive box render mode")).defaultValue((Object)ShapeMode.Both)).build());
        this.tracers = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tracers")).description("Draw tracers to full beehives")).defaultValue((Object)false)).build());
        this.tracerColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("Beehive tracer color")).defaultValue(new SettingColor(255, 215, 0, 200)).visible(() -> this.tracers.get())).build());
        this.beehiveChat = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-feedback")).description("Announce full beehives in chat")).defaultValue((Object)true)).build());
        this.sgFiltering = this.settings.createGroup("Honey Levels");
        this.includeLevel0 = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("level-0")).description("Include empty beehives (0% honey)")).defaultValue((Object)false)).build());
        this.includeLevel1 = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("level-1")).description("Include beehives with 20% honey")).defaultValue((Object)false)).build());
        this.includeLevel2 = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("level-2")).description("Include beehives with 40% honey")).defaultValue((Object)false)).build());
        this.includeLevel3 = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("level-3")).description("Include beehives with 60% honey")).defaultValue((Object)false)).build());
        this.includeLevel4 = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("level-4")).description("Include beehives with 80% honey")).defaultValue((Object)false)).build());
        this.includeLevel5 = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("level-5")).description("Include full beehives (100% honey - harvestable)")).defaultValue((Object)true)).build());
        this.sgHiveTypes = this.settings.createGroup("Hive Types");
        this.includeBeehives = this.sgHiveTypes.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("beehives")).description("Include crafted beehives")).defaultValue((Object)true)).build());
        this.includeBeeNests = this.sgHiveTypes.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("bee-nests")).description("Include natural bee nests")).defaultValue((Object)true)).build());
        this.sgRange = this.settings.createGroup("Range");
        this.minY = this.sgRange.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-y")).description("Minimum Y level to scan for beehives")).defaultValue((Object)50)).min(-64).max(128).sliderRange(-64, 128).build());
        this.maxY = this.sgRange.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-y")).description("Maximum Y level to scan for beehives")).defaultValue((Object)200)).min(-64).max(320).sliderRange(-64, 320).build());
        this.sgThreading = this.settings.createGroup("Threading");
        this.useThreading = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-threading")).description("Use multi-threading for chunk scanning (better performance)")).defaultValue((Object)true)).build());
        this.threadPoolSize = this.sgThreading.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("thread-pool-size")).description("Number of threads to use for scanning")).defaultValue((Object)2)).min(1).max(8).sliderRange(1, 8).visible(() -> this.useThreading.get())).build());
        this.limitChatSpam = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("limit-chat-spam")).description("Reduce chat spam when using threading")).defaultValue((Object)true)).visible(() -> this.useThreading.get())).build());
        this.beehivePositions = ConcurrentHashMap.newKeySet();
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            this.threadPool = Executors.newFixedThreadPool((Integer)this.threadPoolSize.get());
        }
        this.beehivePositions.clear();
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.threadPool.submit(() -> this.scanChunkForBeehives(worldChunk));
            }
        } else {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.scanChunkForBeehives(worldChunk);
            }
        }
    }

    public void onDeactivate() {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            this.threadPool = null;
        }
        this.beehivePositions.clear();
    }

    @EventHandler
    private void onChunkLoad(ChunkDataEvent event) {
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(() -> this.scanChunkForBeehives(event.chunk()));
        } else {
            this.scanChunkForBeehives(event.chunk());
        }
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        class_2338 pos = event.pos;
        class_2680 state = event.newState;
        Runnable updateTask = () -> {
            boolean isBeehive = this.isValidBeehive(state, pos.method_10264());
            if (isBeehive) {
                boolean wasAdded = this.beehivePositions.add(pos);
                if (wasAdded && ((Boolean)this.beehiveChat.get()).booleanValue() && (!((Boolean)this.useThreading.get()).booleanValue() || !((Boolean)this.limitChatSpam.get()).booleanValue())) {
                    int honeyLevel = this.getHoneyLevel(state);
                    String hiveType = this.getHiveTypeName(state);
                    String honeyDescription = this.getHoneyLevelDescription(honeyLevel);
                    this.info("\u00a7e[\u00a76Beehive ESP\u00a7e] \u00a76" + hiveType + " " + honeyDescription + " at " + pos.method_23854(), new Object[0]);
                }
            } else {
                this.beehivePositions.remove(pos);
            }
        };
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(updateTask);
        } else {
            updateTask.run();
        }
    }

    private void scanChunkForBeehives(class_2818 chunk) {
        class_1923 cpos = chunk.method_12004();
        int xStart = cpos.method_8326();
        int zStart = cpos.method_8328();
        int yMin = Math.max(chunk.method_31607(), (Integer)this.minY.get());
        int yMax = Math.min(chunk.method_31607() + chunk.method_31605(), (Integer)this.maxY.get());
        HashSet<class_2338> chunkBeehives = new HashSet<class_2338>();
        int foundCount = 0;
        for (int x = xStart; x < xStart + 16; ++x) {
            for (int z = zStart; z < zStart + 16; ++z) {
                for (int y = yMin; y < yMax; ++y) {
                    class_2338 pos2 = new class_2338(x, y, z);
                    class_2680 state = chunk.method_8320(pos2);
                    if (!this.isValidBeehive(state, y)) continue;
                    chunkBeehives.add(pos2);
                    ++foundCount;
                }
            }
        }
        this.beehivePositions.removeIf(pos -> {
            class_1923 blockChunk = new class_1923(pos);
            return blockChunk.equals((Object)cpos) && !chunkBeehives.contains(pos);
        });
        int newBlocks = 0;
        for (class_2338 pos3 : chunkBeehives) {
            if (!this.beehivePositions.add(pos3)) continue;
            ++newBlocks;
        }
        if (((Boolean)this.beehiveChat.get()).booleanValue() && foundCount > 0) {
            if (((Boolean)this.useThreading.get()).booleanValue() && ((Boolean)this.limitChatSpam.get()).booleanValue()) {
                if (newBlocks > 0) {
                    this.info("\u00a7e[\u00a76Beehive ESP\u00a7e] \u00a76Chunk " + cpos.field_9181 + "," + cpos.field_9180 + "\u00a7e: \u00a76" + newBlocks + " new beehives found", new Object[0]);
                }
            } else {
                for (class_2338 pos4 : chunkBeehives) {
                    if (this.beehivePositions.contains(pos4)) continue;
                    class_2680 state = chunk.method_8320(pos4);
                    int honeyLevel = this.getHoneyLevel(state);
                    String hiveType = this.getHiveTypeName(state);
                    String honeyDescription = this.getHoneyLevelDescription(honeyLevel);
                    this.info("\u00a7e[\u00a76Beehive ESP\u00a7e] \u00a76" + hiveType + " " + honeyDescription + " at " + pos4.method_23854(), new Object[0]);
                }
            }
        }
    }

    private boolean isValidBeehive(class_2680 state, int y) {
        boolean isBeeNest;
        if (y < (Integer)this.minY.get() || y > (Integer)this.maxY.get()) {
            return false;
        }
        boolean isBeehive = (Boolean)this.includeBeehives.get() != false && state.method_27852(class_2246.field_20422);
        boolean bl = isBeeNest = (Boolean)this.includeBeeNests.get() != false && state.method_27852(class_2246.field_20421);
        if (!isBeehive && !isBeeNest) {
            return false;
        }
        int honeyLevel = this.getHoneyLevel(state);
        if (((Boolean)this.includeLevel0.get()).booleanValue() && honeyLevel == 0) {
            return true;
        }
        if (((Boolean)this.includeLevel1.get()).booleanValue() && honeyLevel == 1) {
            return true;
        }
        if (((Boolean)this.includeLevel2.get()).booleanValue() && honeyLevel == 2) {
            return true;
        }
        if (((Boolean)this.includeLevel3.get()).booleanValue() && honeyLevel == 3) {
            return true;
        }
        if (((Boolean)this.includeLevel4.get()).booleanValue() && honeyLevel == 4) {
            return true;
        }
        return (Boolean)this.includeLevel5.get() != false && honeyLevel == 5;
    }

    private int getHoneyLevel(class_2680 state) {
        if (state.method_27852(class_2246.field_20422) || state.method_27852(class_2246.field_20421)) {
            return (Integer)state.method_11654((class_2769)class_4481.field_20420);
        }
        return -1;
    }

    private String getHiveTypeName(class_2680 state) {
        if (state.method_27852(class_2246.field_20422)) {
            return "Beehive";
        }
        if (state.method_27852(class_2246.field_20421)) {
            return "Bee Nest";
        }
        return "Hive";
    }

    private String getHoneyLevelDescription(int honeyLevel) {
        switch (honeyLevel) {
            case 0: {
                return "(Empty - 0%)";
            }
            case 1: {
                return "(20% Honey)";
            }
            case 2: {
                return "(40% Honey)";
            }
            case 3: {
                return "(60% Honey)";
            }
            case 4: {
                return "(80% Honey)";
            }
            case 5: {
                return "(Full - 100% - HARVESTABLE)";
            }
        }
        return "(Unknown Level)";
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_243 playerPos = this.mc.field_1724.method_30950(event.tickDelta);
        Color side = new Color((Color)this.beehiveColor.get());
        Color outline = new Color((Color)this.beehiveColor.get());
        Color tracerColorValue = new Color((Color)this.tracerColor.get());
        int renderDistance = (Integer)this.mc.field_1690.method_42503().method_41753() * 16;
        for (class_2338 pos : this.beehivePositions) {
            class_243 startPos;
            Color levelAdjustedSide;
            if (!this.isWithinRenderDistance(playerPos, pos, renderDistance)) continue;
            class_2680 state = this.mc.field_1687.method_8320(pos);
            int honeyLevel = this.getHoneyLevel(state);
            float intensity = (float)(honeyLevel + 1) / 6.0f;
            event.renderer.box(pos, levelAdjustedSide, switch (honeyLevel) {
                case 0 -> {
                    levelAdjustedSide = new Color((int)((float)side.r * 0.2f), (int)((float)side.g * 0.2f), (int)((float)side.b * 0.2f), side.a);
                    yield new Color((int)((float)outline.r * 0.2f), (int)((float)outline.g * 0.2f), (int)((float)outline.b * 0.2f), outline.a);
                }
                case 1 -> {
                    levelAdjustedSide = new Color((int)((float)side.r * 0.4f), (int)((float)side.g * 0.4f), (int)((float)side.b * 0.4f), side.a);
                    yield new Color((int)((float)outline.r * 0.4f), (int)((float)outline.g * 0.4f), (int)((float)outline.b * 0.4f), outline.a);
                }
                case 2 -> {
                    levelAdjustedSide = new Color((int)((float)side.r * 0.6f), (int)((float)side.g * 0.6f), (int)((float)side.b * 0.6f), side.a);
                    yield new Color((int)((float)outline.r * 0.6f), (int)((float)outline.g * 0.6f), (int)((float)outline.b * 0.6f), outline.a);
                }
                case 3 -> {
                    levelAdjustedSide = new Color((int)((float)side.r * 0.8f), (int)((float)side.g * 0.8f), (int)((float)side.b * 0.8f), side.a);
                    yield new Color((int)((float)outline.r * 0.8f), (int)((float)outline.g * 0.8f), (int)((float)outline.b * 0.8f), outline.a);
                }
                case 4 -> {
                    levelAdjustedSide = side;
                    yield outline;
                }
                case 5 -> {
                    levelAdjustedSide = new Color(Math.min(255, (int)((float)side.r * 1.3f)), Math.min(255, (int)((float)side.g * 1.3f)), Math.min(255, (int)((float)side.b * 1.1f)), side.a);
                    yield new Color(Math.min(255, (int)((float)outline.r * 1.3f)), Math.min(255, (int)((float)outline.g * 1.3f)), Math.min(255, (int)((float)outline.b * 1.1f)), outline.a);
                }
                default -> {
                    levelAdjustedSide = side;
                    yield outline;
                }
            }, (ShapeMode)this.beehiveShapeMode.get(), 0);
            if (!((Boolean)this.tracers.get()).booleanValue()) continue;
            class_243 blockCenter = class_243.method_24953((class_2382)pos);
            if (this.mc.field_1690.method_31044().method_31034()) {
                class_243 lookDirection = this.mc.field_1724.method_5720();
                startPos = new class_243(playerPos.field_1352 + lookDirection.field_1352 * 0.5, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()) + lookDirection.field_1351 * 0.5, playerPos.field_1350 + lookDirection.field_1350 * 0.5);
            } else {
                startPos = new class_243(playerPos.field_1352, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), playerPos.field_1350);
            }
            event.renderer.line(startPos.field_1352, startPos.field_1351, startPos.field_1350, blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350, tracerColorValue);
        }
    }

    private boolean isWithinRenderDistance(class_243 playerPos, class_2338 blockPos, int renderDistance) {
        double dz;
        double dx = playerPos.field_1352 - (double)blockPos.method_10263() - 0.5;
        double horizontalDistance = Math.sqrt(dx * dx + (dz = playerPos.field_1350 - (double)blockPos.method_10260() - 0.5) * dz);
        return horizontalDistance <= (double)renderDistance;
    }
}

