/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.MeteorToast;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2661;
import net.minecraft.class_368;

public class BlockNotifier
extends Module {
    private final SettingGroup sg_general;
    private final SettingGroup sg_notifications;
    private final SettingGroup sg_webhook;
    private final SettingGroup sg_render;
    private final Setting<List<class_2248>> blocks_to_find;
    private final Setting<Mode> notification_mode;
    private final Setting<Boolean> disconnect_on_find;
    private final Setting<Boolean> webhook_enabled;
    private final Setting<String> webhook_url;
    private final Setting<Boolean> self_ping;
    private final Setting<String> discord_id;
    private final Setting<Boolean> show_esp;
    private final Setting<SettingColor> esp_color;
    private final Setting<ShapeMode> shape_mode;
    private final Setting<Boolean> show_tracers;
    private final Setting<SettingColor> tracer_color;
    private final Setting<Boolean> only_render_new;
    private final Setting<Double> render_distance;
    private final Set<class_1923> processed_chunks;
    private final Set<class_2338> found_block_positions;
    private final Set<class_2338> new_found_blocks;
    private final Map<class_2338, class_2248> block_type_map;
    private final HttpClient http_client;
    private int total_blocks_found;

    public BlockNotifier() {
        super(GlazedAddon.esp, "Block Notifier", "Notifies when specific blocks are detected with multiple notification options and visual ESP.");
        this.sg_general = this.settings.getDefaultGroup();
        this.sg_notifications = this.settings.createGroup("Notifications");
        this.sg_webhook = this.settings.createGroup("Webhook");
        this.sg_render = this.settings.createGroup("Render");
        this.blocks_to_find = this.sg_general.add((Setting)((BlockListSetting.Builder)((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("blocks-to-find")).description("Blocks to notify when found.")).defaultValue(Collections.emptyList())).build());
        this.notification_mode = this.sg_notifications.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("notification-mode")).description("The mode to use for notifications.")).defaultValue((Object)Mode.Both)).build());
        this.disconnect_on_find = this.sg_notifications.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disconnect-on-find")).description("Disconnect when a block is found.")).defaultValue((Object)false)).build());
        this.webhook_enabled = this.sg_webhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("webhook-enabled")).description("Enable webhook notifications.")).defaultValue((Object)false)).build());
        this.webhook_url = this.sg_webhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL.")).defaultValue((Object)"")).visible(() -> (Boolean)this.webhook_enabled.get())).build());
        this.self_ping = this.sg_webhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("self-ping")).description("Ping yourself in the webhook message.")).defaultValue((Object)false)).visible(() -> (Boolean)this.webhook_enabled.get())).build());
        this.discord_id = this.sg_webhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("discord-id")).description("Your Discord user ID for pinging.")).defaultValue((Object)"")).visible(() -> (Boolean)this.webhook_enabled.get() != false && (Boolean)this.self_ping.get() != false)).build());
        this.show_esp = this.sg_render.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-esp")).description("Highlight found blocks with ESP boxes.")).defaultValue((Object)true)).build());
        this.esp_color = this.sg_render.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("esp-color")).description("Color for the ESP boxes")).defaultValue(new SettingColor(255, 165, 0, 100)).visible(() -> (Boolean)this.show_esp.get())).build());
        this.shape_mode = this.sg_render.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("Rendering mode for the ESP boxes")).defaultValue((Object)ShapeMode.Both)).visible(() -> (Boolean)this.show_esp.get())).build());
        this.show_tracers = this.sg_render.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-tracers")).description("Draw tracer lines to found blocks")).defaultValue((Object)true)).build());
        this.tracer_color = this.sg_render.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("Color for the tracer lines")).defaultValue(new SettingColor(255, 165, 0, 200)).visible(() -> (Boolean)this.show_tracers.get())).build());
        this.only_render_new = this.sg_render.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-render-new")).description("Only render ESP/tracers for newly discovered blocks")).defaultValue((Object)false)).build());
        this.render_distance = this.sg_render.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("render-distance")).description("Maximum distance to render ESP/tracers (0 = unlimited)")).defaultValue(0.0).min(0.0).max(500.0).sliderMax(200.0).build());
        this.processed_chunks = new HashSet<class_1923>();
        this.found_block_positions = new HashSet<class_2338>();
        this.new_found_blocks = new HashSet<class_2338>();
        this.block_type_map = new HashMap<class_2338, class_2248>();
        this.http_client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        this.total_blocks_found = 0;
    }

    public void onActivate() {
        this.processed_chunks.clear();
        this.found_block_positions.clear();
        this.new_found_blocks.clear();
        this.block_type_map.clear();
        this.total_blocks_found = 0;
        this.info("BlockNotifier activated!", new Object[0]);
    }

    public void onDeactivate() {
        this.info("BlockNotifier deactivated. Found %d blocks total this session.", new Object[]{this.total_blocks_found});
    }

    @EventHandler
    private void on_chunk_data(ChunkDataEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        class_1923 chunk_pos = event.chunk().method_12004();
        if (this.processed_chunks.contains(chunk_pos)) {
            return;
        }
        HashMap<class_2248, Integer> found_blocks = new HashMap<class_2248, Integer>();
        HashMap<class_2248, List> block_positions = new HashMap<class_2248, List>();
        boolean has_target_blocks = false;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = this.mc.field_1687.method_31607(); y < this.mc.field_1687.method_31605(); ++y) {
                    class_2338 pos = new class_2338(chunk_pos.method_8326() + x, y, chunk_pos.method_8328() + z);
                    class_2248 block = this.mc.field_1687.method_8320(pos).method_26204();
                    if (!((List)this.blocks_to_find.get()).contains(block)) continue;
                    found_blocks.put(block, found_blocks.getOrDefault(block, 0) + 1);
                    block_positions.computeIfAbsent(block, k -> new ArrayList()).add(pos);
                    if (!this.found_block_positions.contains(pos)) {
                        this.found_block_positions.add(pos);
                        this.new_found_blocks.add(pos);
                        this.block_type_map.put(pos, block);
                    }
                    has_target_blocks = true;
                    ++this.total_blocks_found;
                }
            }
        }
        if (has_target_blocks) {
            this.processed_chunks.add(chunk_pos);
            this.handle_blocks_found(chunk_pos, found_blocks);
        }
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null || !((Boolean)this.show_esp.get()).booleanValue() && !((Boolean)this.show_tracers.get()).booleanValue()) {
            return;
        }
        class_243 playerPos = this.mc.field_1724.method_30950(event.tickDelta);
        Color sideColor = new Color((Color)this.esp_color.get());
        Color lineColor = new Color((Color)this.esp_color.get());
        Color tracerColorValue = new Color((Color)this.tracer_color.get());
        double maxDistance = (Double)this.render_distance.get();
        for (class_2338 pos : this.found_block_positions) {
            class_243 startPos;
            double distance;
            if (((Boolean)this.only_render_new.get()).booleanValue() && !this.new_found_blocks.contains(pos) || maxDistance > 0.0 && (distance = playerPos.method_1022(class_243.method_24953((class_2382)pos))) > maxDistance) continue;
            if (((Boolean)this.show_esp.get()).booleanValue()) {
                event.renderer.box(pos, sideColor, lineColor, (ShapeMode)this.shape_mode.get(), 0);
            }
            if (!((Boolean)this.show_tracers.get()).booleanValue()) continue;
            class_243 blockCenter = class_243.method_24953((class_2382)pos);
            if (this.mc.field_1690.method_31044().method_31034()) {
                class_243 lookDirection = this.mc.field_1724.method_5720();
                startPos = new class_243(playerPos.field_1352 + lookDirection.field_1352 * 0.5, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()) + lookDirection.field_1351 * 0.5, playerPos.field_1350 + lookDirection.field_1350 * 0.5);
            } else {
                startPos = new class_243(playerPos.field_1352, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), playerPos.field_1350);
            }
            event.renderer.line(startPos.field_1352, startPos.field_1351, startPos.field_1350, blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350, tracerColorValue);
        }
    }

    private void handle_blocks_found(class_1923 chunk_pos, Map<class_2248, Integer> found_blocks) {
        String message = this.build_notification_message(chunk_pos, found_blocks);
        String detection_reason = this.build_detection_reason(found_blocks);
        switch (((Mode)((Object)this.notification_mode.get())).ordinal()) {
            case 0: {
                this.info(message, new Object[0]);
                break;
            }
            case 1: {
                this.show_toast_notification(message, found_blocks);
                break;
            }
            case 2: {
                this.info(message, new Object[0]);
                this.show_toast_notification(message, found_blocks);
            }
        }
        if (((Boolean)this.webhook_enabled.get()).booleanValue() && !((String)this.webhook_url.get()).trim().isEmpty()) {
            this.send_webhook_notification(chunk_pos, found_blocks, detection_reason);
        }
        if (((Boolean)this.disconnect_on_find.get()).booleanValue()) {
            this.handle_disconnection(chunk_pos, found_blocks);
        }
    }

    private String build_notification_message(class_1923 chunk_pos, Map<class_2248, Integer> found_blocks) {
        StringBuilder msg = new StringBuilder();
        if (found_blocks.size() == 1) {
            Map.Entry<class_2248, Integer> entry = found_blocks.entrySet().iterator().next();
            class_2248 block = entry.getKey();
            int count = entry.getValue();
            if (count == 1) {
                msg.append("Target block found: ").append(block.method_9518().getString());
            } else {
                msg.append("Target blocks found: ").append(block.method_9518().getString()).append(" x").append(count);
            }
        } else {
            msg.append("Target blocks found: ");
            ArrayList<String> block_list = new ArrayList<String>();
            int total = 0;
            for (Map.Entry<class_2248, Integer> entry : found_blocks.entrySet()) {
                class_2248 block = entry.getKey();
                int count = entry.getValue();
                total += count;
                if (count == 1) {
                    block_list.add(block.method_9518().getString());
                    continue;
                }
                block_list.add(String.format("%s x%d", block.method_9518().getString(), count));
            }
            msg.append(String.join((CharSequence)", ", block_list));
            msg.append(String.format(" (%d total)", total));
        }
        int center_x = chunk_pos.field_9181 * 16 + 8;
        int center_z = chunk_pos.field_9180 * 16 + 8;
        msg.append(" at chunk ").append(center_x).append(", ").append(center_z);
        return msg.toString();
    }

    private String build_detection_reason(Map<class_2248, Integer> found_blocks) {
        if (found_blocks.size() == 1) {
            Map.Entry<class_2248, Integer> entry = found_blocks.entrySet().iterator().next();
            return String.format("%s detected in chunk", entry.getKey().method_9518().getString());
        }
        return String.format("%d different target block types found", found_blocks.size());
    }

    private void show_toast_notification(String message, Map<class_2248, Integer> found_blocks) {
        try {
            class_2248 first_block = found_blocks.keySet().iterator().next();
            MeteorToast toast = new MeteorToast(new class_1799((class_1935)first_block.method_8389()).method_7909(), this.title, message);
            this.mc.method_1566().method_1999((class_368)toast);
        }
        catch (Exception e) {
            this.info(message, new Object[0]);
        }
    }

    private void send_webhook_notification(class_1923 chunk_pos, Map<class_2248, Integer> found_blocks, String detection_reason) {
        String url = ((String)this.webhook_url.get()).trim();
        if (url.isEmpty()) {
            this.warning("Webhook URL not configured!", new Object[0]);
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String server_info = this.mc.method_1558() != null ? this.mc.method_1558().field_3761 : "Unknown Server";
                String message_content = "";
                if (((Boolean)this.self_ping.get()).booleanValue() && !((String)this.discord_id.get()).trim().isEmpty()) {
                    message_content = String.format("<@%s>", ((String)this.discord_id.get()).trim());
                }
                int center_x = chunk_pos.field_9181 * 16 + 8;
                int center_z = chunk_pos.field_9180 * 16 + 8;
                StringBuilder items_breakdown = new StringBuilder();
                int total_items = 0;
                for (Map.Entry entry : found_blocks.entrySet()) {
                    String block_name = ((class_2248)entry.getKey()).method_9518().getString();
                    int count = (Integer)entry.getValue();
                    items_breakdown.append(String.format("\u2022 %s: x%d\\n", block_name, count));
                    total_items += count;
                }
                String description = String.format("Target blocks detected in chunk at %d, %d!", center_x, center_z);
                String json_payload = String.format("{\"content\":\"%s\",\"username\":\"Block Notifier\",\"avatar_url\":\"https://i.imgur.com/OL2y1cr.png\",\"embeds\":[{\"title\":\"\ud83c\udfaf Block Notifier Alert\",\"description\":\"%s\",\"color\":%d,\"fields\":[{\"name\":\"Detection Reason\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Total Items Found\",\"value\":\"%d\",\"inline\":false},{\"name\":\"Items Breakdown\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Coordinates\",\"value\":\"%d, %d\",\"inline\":true},{\"name\":\"Server\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Time\",\"value\":\"<t:%d:R>\",\"inline\":true}],\"footer\":{\"text\":\"Block Notifier\"}}]}", message_content.replace("\"", "\\\""), description.replace("\"", "\\\""), 3447003, detection_reason.replace("\"", "\\\""), total_items, items_breakdown.toString().replace("\"", "\\\""), center_x, center_z, server_info.replace("\"", "\\\""), System.currentTimeMillis() / 1000L);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json_payload)).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.http_client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 204) {
                    this.info("Webhook notification sent successfully", new Object[0]);
                } else {
                    this.error("Webhook failed with status: " + response.statusCode(), new Object[0]);
                }
            }
            catch (IOException | InterruptedException e) {
                this.error("Failed to send webhook: " + e.getMessage(), new Object[0]);
            }
        });
    }

    private void handle_disconnection(class_1923 chunk_pos, Map<class_2248, Integer> found_blocks) {
        int center_x = chunk_pos.field_9181 * 16 + 8;
        int center_z = chunk_pos.field_9180 * 16 + 8;
        this.info("TARGET BLOCKS FOUND! Disconnecting...", new Object[0]);
        this.toggle();
        if (this.mc.field_1724 != null) {
            String first_block_name = found_blocks.keySet().iterator().next().method_9518().getString();
            this.mc.field_1724.field_3944.method_52781(new class_2661((class_2561)class_2561.method_43470((String)String.format("TARGET BLOCKS FOUND: %s at %d, %d!", first_block_name, center_x, center_z))));
        }
    }

    public String getInfoString() {
        return String.valueOf(this.total_blocks_found);
    }

    public int get_detected_block_count() {
        return this.total_blocks_found;
    }

    public Set<class_1923> get_processed_chunks() {
        return new HashSet<class_1923>(this.processed_chunks);
    }

    public Set<class_2338> get_found_block_positions() {
        return new HashSet<class_2338>(this.found_block_positions);
    }

    public Set<class_2338> get_new_found_blocks() {
        return new HashSet<class_2338>(this.new_found_blocks);
    }

    public static enum Mode {
        Chat,
        Toast,
        Both;

    }
}

