/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.MeteorToast;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3610;
import net.minecraft.class_368;

public class ChunkFinder
extends Module {
    private final SettingGroup sgDetection;
    private final SettingGroup sgRender;
    private final SettingGroup sgBlockHighlight;
    private final SettingGroup sgPerformance;
    private final SettingGroup sgNotifications;
    private final Setting<Boolean> detectDeepslate;
    private final Setting<Boolean> detectCobbledDeepslate;
    private final Setting<Boolean> detectRotatedDeepslate;
    private final Setting<Boolean> detectEndStone;
    private final Setting<Boolean> ignoreExposed;
    private final Setting<Boolean> ignoreTrialChambers;
    private final Setting<Integer> trialChamberThreshold;
    private final Setting<Integer> deepslateThreshold;
    private final Setting<Integer> cobbledDeepslateThreshold;
    private final Setting<Integer> rotatedDeepslateThreshold;
    private final Setting<Integer> endStoneThreshold;
    private final Setting<Double> renderY;
    private final Setting<ShapeMode> renderMode;
    private final Setting<SettingColor> chunkColor;
    private final Setting<Double> thickness;
    private final Setting<Boolean> highlightBlocks;
    private final Setting<Integer> maxBlocksToRender;
    private final Setting<ShapeMode> blockRenderMode;
    private final Setting<SettingColor> deepslateBlockColor;
    private final Setting<SettingColor> cobbledDeepslateBlockColor;
    private final Setting<SettingColor> rotatedDeepslateBlockColor;
    private final Setting<SettingColor> endStoneBlockColor;
    private final Setting<Boolean> useMultiThreading;
    private final Setting<Integer> threadCount;
    private final Setting<Integer> scanInterval;
    private final Setting<Integer> maxConcurrentScans;
    private final Setting<Integer> cleanupInterval;
    private final Setting<Mode> notificationMode;
    private final Setting<Boolean> playSound;
    private final Setting<Boolean> chatAlerts;
    private final Setting<Boolean> trialChamberAlerts;
    private final Setting<Integer> maxAlerts;
    private final Set<class_1923> flaggedChunks;
    private final ConcurrentHashMap<class_1923, ChunkAnalysis> chunkData;
    private final Set<class_1923> scannedChunks;
    private final ConcurrentHashMap<class_1923, Long> notificationTimes;
    private final Queue<Long> recentAlerts;
    private final AtomicLong activeScanCount;
    private final Map<class_2338, SuspiciousBlock> suspiciousBlocks;
    private ExecutorService scannerPool;
    private volatile boolean shouldScan;
    private long lastCleanup;

    public ChunkFinder() {
        super(GlazedAddon.esp, "ChunkFinder", "ChunkFinderV4");
        this.sgDetection = this.settings.createGroup("Detection");
        this.sgRender = this.settings.createGroup("Render");
        this.sgBlockHighlight = this.settings.createGroup("Block Highlighting");
        this.sgPerformance = this.settings.createGroup("Performance");
        this.sgNotifications = this.settings.createGroup("Notifications");
        this.detectDeepslate = this.sgDetection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("detect-deepslate")).description("Find deepslate blocks")).defaultValue((Object)false)).build());
        this.detectCobbledDeepslate = this.sgDetection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("detect-cobbled-deepslate")).description("Find cobbled deepslate blocks")).defaultValue((Object)true)).build());
        this.detectRotatedDeepslate = this.sgDetection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("detect-rotated-deepslate")).description("Find rotated deepslate blocks")).defaultValue((Object)true)).build());
        this.detectEndStone = this.sgDetection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("detect-end-stone")).description("Find end stone blocks (disabled in The End dimension)")).defaultValue((Object)true)).build());
        this.ignoreExposed = this.sgDetection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-exposed")).description("Ignore suspicious blocks that are exposed to air or fluid (treats water/lava like air)")).defaultValue((Object)true)).build());
        this.ignoreTrialChambers = this.sgDetection.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-trial-chambers")).description("Ignore chunks containing trial chambers (based on waxed copper blocks and tuff bricks)")).defaultValue((Object)true)).build());
        this.trialChamberThreshold = this.sgDetection.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("trial-chamber-threshold")).description("Minimum waxed copper or tuff brick blocks to identify a trial chamber")).defaultValue((Object)50)).range(1, 50).sliderRange(1, 50).visible(() -> this.ignoreTrialChambers.get())).build());
        this.deepslateThreshold = this.sgDetection.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("deepslate-threshold")).description("Min deepslate to flag chunk")).defaultValue((Object)1)).range(1, 15).sliderRange(1, 15).visible(() -> this.detectDeepslate.get())).build());
        this.cobbledDeepslateThreshold = this.sgDetection.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("cobbled-deepslate-threshold")).description("Min cobbled deepslate to flag chunk")).defaultValue((Object)4)).range(1, 15).sliderRange(1, 15).visible(() -> this.detectCobbledDeepslate.get())).build());
        this.rotatedDeepslateThreshold = this.sgDetection.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("rotated-threshold")).description("Min rotated deepslate to flag chunk")).defaultValue((Object)3)).range(1, 20).sliderRange(1, 20).visible(() -> this.detectRotatedDeepslate.get())).build());
        this.endStoneThreshold = this.sgDetection.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("end-stone-threshold")).description("Min end stone count to flag chunk")).defaultValue((Object)2)).range(1, 15).sliderRange(1, 15).visible(() -> this.detectEndStone.get())).build());
        this.renderY = this.sgRender.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("render-height")).description("Height to render chunk highlights")).defaultValue(64.0).range(-64.0, 320.0).sliderRange(-64.0, 320.0).build());
        this.renderMode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("render-mode")).description("How to render highlighted chunks")).defaultValue((Object)ShapeMode.Both)).build());
        this.chunkColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("chunk-color")).description("Color for suspicious chunks")).defaultValue(new SettingColor(255, 215, 0, 120)).build());
        this.thickness = this.sgRender.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("thickness")).description("Thickness of highlight box")).defaultValue(0.3).range(0.1, 2.0).sliderRange(0.1, 2.0).build());
        this.highlightBlocks = this.sgBlockHighlight.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("highlight-blocks")).description("Highlight individual suspicious blocks")).defaultValue((Object)true)).build());
        this.maxBlocksToRender = this.sgBlockHighlight.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-blocks-render")).description("Maximum number of blocks to highlight (performance)")).defaultValue((Object)200)).range(50, 1000).sliderRange(50, 1000).visible(() -> this.highlightBlocks.get())).build());
        this.blockRenderMode = this.sgBlockHighlight.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("block-render-mode")).description("How to render individual blocks")).defaultValue((Object)ShapeMode.Lines)).visible(() -> this.highlightBlocks.get())).build());
        this.deepslateBlockColor = this.sgBlockHighlight.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("deepslate-color")).description("Color for deepslate blocks")).defaultValue(new SettingColor(100, 100, 100, 200)).visible(() -> this.highlightBlocks.get())).build());
        this.cobbledDeepslateBlockColor = this.sgBlockHighlight.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("cobbled-deepslate-color")).description("Color for cobbled deepslate blocks")).defaultValue(new SettingColor(80, 80, 80, 200)).visible(() -> this.highlightBlocks.get())).build());
        this.rotatedDeepslateBlockColor = this.sgBlockHighlight.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("rotated-deepslate-color")).description("Color for rotated deepslate blocks")).defaultValue(new SettingColor(120, 0, 120, 200)).visible(() -> this.highlightBlocks.get())).build());
        this.endStoneBlockColor = this.sgBlockHighlight.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("end-stone-color")).description("Color for end stone blocks")).defaultValue(new SettingColor(255, 255, 200, 200)).visible(() -> this.highlightBlocks.get())).build());
        this.useMultiThreading = this.sgPerformance.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("threading")).description("Use background threads for scanning")).defaultValue((Object)true)).build());
        this.threadCount = this.sgPerformance.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("thread-count")).description("Number of worker threads")).defaultValue((Object)Math.max(1, Runtime.getRuntime().availableProcessors() / 2))).range(1, 4).sliderRange(1, 4).visible(() -> this.useMultiThreading.get())).build());
        this.scanInterval = this.sgPerformance.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("scan-delay")).description("Milliseconds between scans")).defaultValue((Object)100)).range(50, 2000).sliderRange(50, 2000).build());
        this.maxConcurrentScans = this.sgPerformance.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-concurrent-scans")).description("Max chunks scanned simultaneously")).defaultValue((Object)3)).range(1, 8).sliderRange(1, 8).build());
        this.cleanupInterval = this.sgPerformance.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("cleanup-interval")).description("Seconds between distant chunk cleanup")).defaultValue((Object)30)).range(15, 300).sliderRange(15, 300).build());
        this.notificationMode = this.sgNotifications.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("notification-mode")).description("How to notify when suspicious chunks are detected")).defaultValue((Object)Mode.Both)).build());
        this.playSound = this.sgNotifications.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sound-alerts")).description("Play sound when suspicious chunks or blocks are found")).defaultValue((Object)true)).build());
        this.chatAlerts = this.sgNotifications.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-alerts")).description("Send chat notifications for suspicious chunks or blocks")).defaultValue((Object)true)).build());
        this.trialChamberAlerts = this.sgNotifications.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("trial-chamber-alerts")).description("Send chat notifications for trial chambers")).defaultValue((Object)false)).build());
        this.maxAlerts = this.sgNotifications.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-alerts")).description("Max alerts per minute")).defaultValue((Object)5)).range(1, 20).sliderRange(1, 20).build());
        this.flaggedChunks = ConcurrentHashMap.newKeySet();
        this.chunkData = new ConcurrentHashMap();
        this.scannedChunks = ConcurrentHashMap.newKeySet();
        this.notificationTimes = new ConcurrentHashMap();
        this.recentAlerts = new ConcurrentLinkedQueue<Long>();
        this.activeScanCount = new AtomicLong(0L);
        this.suspiciousBlocks = new ConcurrentHashMap<class_2338, SuspiciousBlock>();
        this.shouldScan = false;
        this.lastCleanup = 0L;
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        this.clearAll();
        this.shouldScan = true;
        this.lastCleanup = System.currentTimeMillis();
        if (((Boolean)this.useMultiThreading.get()).booleanValue()) {
            this.scannerPool = Executors.newFixedThreadPool((Integer)this.threadCount.get(), r -> {
                Thread t = new Thread(r, "ChunkFinder-Worker");
                t.setDaemon(true);
                t.setPriority(4);
                return t;
            });
            this.startInitialScan();
        } else {
            this.startInitialScan();
        }
    }

    public void onDeactivate() {
        this.shouldScan = false;
        if (this.scannerPool != null) {
            this.scannerPool.shutdownNow();
            this.scannerPool = null;
        }
        this.clearAll();
    }

    private void clearAll() {
        this.flaggedChunks.clear();
        this.chunkData.clear();
        this.scannedChunks.clear();
        this.notificationTimes.clear();
        this.recentAlerts.clear();
        this.suspiciousBlocks.clear();
        this.activeScanCount.set(0L);
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        while (!this.recentAlerts.isEmpty() && now - this.recentAlerts.peek() > 60000L) {
            this.recentAlerts.poll();
        }
        if (now - this.lastCleanup > (long)((Integer)this.cleanupInterval.get()).intValue() * 1000L) {
            this.performCleanup();
            this.lastCleanup = now;
        }
    }

    @EventHandler
    private void onChunkLoad(ChunkDataEvent event) {
        if (!this.shouldScan || this.activeScanCount.get() >= (long)((Integer)this.maxConcurrentScans.get()).intValue()) {
            return;
        }
        class_1923 pos = event.chunk().method_12004();
        if (!this.scannedChunks.contains(pos)) {
            this.scheduleChunkScan((class_2791)event.chunk());
        }
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        if (!this.shouldScan) {
            return;
        }
        class_2338 blockPos = event.pos;
        if (blockPos.method_10264() < 0 || blockPos.method_10264() > 128) {
            return;
        }
        class_2680 newState = event.newState;
        if (this.isRelevantBlock(newState) || newState.method_26215()) {
            class_1923 chunkPos = new class_1923(blockPos);
            class_2818 chunk = this.mc.field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180);
            this.scheduleChunkScan((class_2791)chunk);
        }
    }

    private boolean isRelevantBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        return block == class_2246.field_28888 || block == class_2246.field_29031 || block == class_2246.field_28892 || block == class_2246.field_28900 || block == class_2246.field_28896 || block == class_2246.field_28904 || block == class_2246.field_10471 || block == class_2246.field_27133 || block == class_2246.field_33407 || block == class_2246.field_47035;
    }

    private void startInitialScan() {
        Runnable initialScanTask = () -> {
            try {
                for (class_2791 chunk : Utils.chunks()) {
                    if (this.shouldScan) {
                        if (!(chunk instanceof class_2818)) continue;
                        class_2818 worldChunk = (class_2818)chunk;
                        if (this.activeScanCount.get() < (long)((Integer)this.maxConcurrentScans.get()).intValue()) {
                            if (((Boolean)this.useMultiThreading.get()).booleanValue() && this.scannerPool != null) {
                                this.scannerPool.submit(() -> this.analyzeChunk(worldChunk));
                            } else {
                                this.analyzeChunk(worldChunk);
                            }
                        }
                        Thread.sleep(((Integer)this.scanInterval.get()).intValue());
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        if (((Boolean)this.useMultiThreading.get()).booleanValue() && this.scannerPool != null) {
            this.scannerPool.submit(initialScanTask);
        } else {
            new Thread(initialScanTask, "ChunkFinder-Initial").start();
        }
    }

    private void scheduleChunkScan(class_2791 chunk) {
        if (!(chunk instanceof class_2818)) {
            return;
        }
        class_2818 worldChunk = (class_2818)chunk;
        if (this.activeScanCount.get() >= (long)((Integer)this.maxConcurrentScans.get()).intValue()) {
            return;
        }
        Runnable scanTask = () -> {
            try {
                Thread.sleep((Integer)this.scanInterval.get() / 2);
                this.analyzeChunk(worldChunk);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        if (((Boolean)this.useMultiThreading.get()).booleanValue() && this.scannerPool != null) {
            this.scannerPool.submit(scanTask);
        } else {
            new Thread(scanTask, "ChunkFinder-Scan").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeChunk(class_2818 chunk) {
        if (!this.shouldScan || chunk == null) {
            return;
        }
        class_1923 pos = chunk.method_12004();
        if (this.scannedChunks.contains(pos)) {
            return;
        }
        this.activeScanCount.incrementAndGet();
        try {
            this.scannedChunks.add(pos);
            int minY = 0;
            int maxY = Math.min(chunk.method_31607() + chunk.method_31605(), 128);
            ChunkAnalysis analysis = new ChunkAnalysis();
            this.scanChunkSections(chunk, analysis, minY, maxY);
            this.chunkData.put(pos, analysis);
            this.evaluateChunk(pos, analysis);
        }
        finally {
            this.activeScanCount.decrementAndGet();
        }
    }

    private void scanChunkSections(class_2818 chunk, ChunkAnalysis analysis, int minY, int maxY) {
        class_2826[] sections = chunk.method_12006();
        for (int sectionIndex = 0; sectionIndex < sections.length; ++sectionIndex) {
            if (!this.shouldScan) {
                return;
            }
            class_2826 section = sections[sectionIndex];
            if (section == null || section.method_38292()) continue;
            int sectionY = chunk.method_31607() + sectionIndex * 16;
            int startY = Math.max(0, minY - sectionY);
            int endY = Math.min(15, maxY - sectionY);
            if (startY > 15 || endY < 0) continue;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = startY; y <= endY; ++y) {
                        if (!this.shouldScan) {
                            return;
                        }
                        class_2680 state = section.method_12254(x, y, z);
                        int worldY = sectionY + y;
                        class_2338 blockPos = new class_2338(chunk.method_12004().method_8326() + x, worldY, chunk.method_12004().method_8328() + z);
                        this.analyzeBlock(blockPos, state, worldY, analysis);
                    }
                }
            }
        }
    }

    private void analyzeBlock(class_2338 blockPos, class_2680 state, int worldY, ChunkAnalysis analysis) {
        SuspiciousBlockType blockType = null;
        if (((Boolean)this.ignoreTrialChambers.get()).booleanValue() && this.isTrialChamberBlock(state)) {
            ++analysis.trialChamberCount;
        }
        boolean exposed = false;
        if (((Boolean)this.ignoreExposed.get()).booleanValue()) {
            exposed = this.isExposedToAirOrFluid(blockPos);
        }
        if (((Boolean)this.detectDeepslate.get()).booleanValue() && this.isNormalDeepslate(state) && !exposed && !this.isInLargeDeepslateLine(blockPos, worldY)) {
            ++analysis.deepslateCount;
            blockType = SuspiciousBlockType.DEEPSLATE;
        }
        if (((Boolean)this.detectRotatedDeepslate.get()).booleanValue() && this.isRotatedDeepslateBlock(state) && !exposed) {
            ++analysis.rotatedDeepslateCount;
            blockType = SuspiciousBlockType.ROTATED_DEEPSLATE;
        }
        if (((Boolean)this.detectCobbledDeepslate.get()).booleanValue() && this.isCobbledDeepslate(state) && !exposed) {
            ++analysis.cobbledDeepslateCount;
            blockType = SuspiciousBlockType.COBBLED_DEEPSLATE;
        }
        if (((Boolean)this.detectEndStone.get()).booleanValue() && this.isEndStone(state) && this.mc.field_1687.method_27983() != class_1937.field_25181 && !exposed) {
            ++analysis.endStoneCount;
            blockType = SuspiciousBlockType.END_STONE;
        }
        if (blockType != null && ((Boolean)this.highlightBlocks.get()).booleanValue()) {
            this.suspiciousBlocks.put(blockPos, new SuspiciousBlock(blockType, System.currentTimeMillis()));
        }
    }

    private boolean isValidBlockPos(class_2338 pos) {
        return pos.method_10264() >= this.mc.field_1687.method_31607() && pos.method_10264() < this.mc.field_1687.method_31605();
    }

    private boolean isExposedToAirOrFluid(class_2338 pos) {
        if (this.mc.field_1687 == null) {
            return false;
        }
        for (class_2350 dir : class_2350.values()) {
            class_2338 offset = pos.method_10093(dir);
            if (!this.isValidBlockPos(offset)) continue;
            class_2680 neighbor = this.mc.field_1687.method_8320(offset);
            if (neighbor.method_26215()) {
                return true;
            }
            class_3610 f = neighbor.method_26227();
            if (f == null || f.method_15769()) continue;
            return true;
        }
        return false;
    }

    private boolean isInLargeDeepslateLine(class_2338 pos, int worldY) {
        class_2338 prev;
        class_2338 next;
        int i;
        class_2338 prev2;
        class_2338 next2;
        int i2;
        if (this.mc.field_1687 == null) {
            return false;
        }
        int lineThreshold = worldY > -8 ? 50 : 20;
        int xCount = 1;
        for (i2 = 1; i2 < lineThreshold && this.isValidBlockPos(next2 = pos.method_10079(class_2350.field_11034, i2)) && this.isNormalDeepslate(this.mc.field_1687.method_8320(next2)); ++i2) {
            ++xCount;
        }
        for (i2 = 1; i2 < lineThreshold && this.isValidBlockPos(prev2 = pos.method_10079(class_2350.field_11039, i2)) && this.isNormalDeepslate(this.mc.field_1687.method_8320(prev2)); ++i2) {
            ++xCount;
        }
        if (xCount >= lineThreshold) {
            return true;
        }
        int zCount = 1;
        for (i = 1; i < lineThreshold && this.isValidBlockPos(next = pos.method_10079(class_2350.field_11035, i)) && this.isNormalDeepslate(this.mc.field_1687.method_8320(next)); ++i) {
            ++zCount;
        }
        for (i = 1; i < lineThreshold && this.isValidBlockPos(prev = pos.method_10079(class_2350.field_11043, i)) && this.isNormalDeepslate(this.mc.field_1687.method_8320(prev)); ++i) {
            ++zCount;
        }
        if (zCount >= lineThreshold) {
            return true;
        }
        if (worldY > 0) {
            class_2338 down;
            class_2338 up;
            int i3;
            int yCount = 1;
            for (i3 = 1; i3 < lineThreshold && this.isValidBlockPos(up = pos.method_10079(class_2350.field_11036, i3)) && this.isNormalDeepslate(this.mc.field_1687.method_8320(up)); ++i3) {
                ++yCount;
            }
            for (i3 = 1; i3 < lineThreshold && this.isValidBlockPos(down = pos.method_10079(class_2350.field_11033, i3)) && this.isNormalDeepslate(this.mc.field_1687.method_8320(down)); ++i3) {
                ++yCount;
            }
            if (yCount >= lineThreshold) {
                return true;
            }
        }
        return false;
    }

    private void evaluateChunk(class_1923 pos, ChunkAnalysis analysis) {
        if (((Boolean)this.ignoreTrialChambers.get()).booleanValue() && analysis.trialChamberCount >= (Integer)this.trialChamberThreshold.get()) {
            if (((Boolean)this.trialChamberAlerts.get()).booleanValue() && this.mc.field_1724 != null) {
                String message = String.format("ChunkFinder [%d, %d] - Trial chamber detected - Copper/Tuff blocks: %d", pos.field_9181, pos.field_9180, analysis.trialChamberCount);
                this.notifyTrialChamber(message);
            }
            this.flaggedChunks.remove(pos);
            this.notificationTimes.remove(pos);
            return;
        }
        boolean suspicious = false;
        StringBuilder reasons = new StringBuilder();
        if (((Boolean)this.detectDeepslate.get()).booleanValue() && analysis.deepslateCount >= (Integer)this.deepslateThreshold.get()) {
            suspicious = true;
            reasons.append("Deepslate[").append(analysis.deepslateCount).append("] ");
        }
        if (((Boolean)this.detectCobbledDeepslate.get()).booleanValue() && analysis.cobbledDeepslateCount >= (Integer)this.cobbledDeepslateThreshold.get()) {
            suspicious = true;
            reasons.append("CobbledDeepslate[").append(analysis.cobbledDeepslateCount).append("] ");
        }
        if (((Boolean)this.detectRotatedDeepslate.get()).booleanValue() && analysis.rotatedDeepslateCount >= (Integer)this.rotatedDeepslateThreshold.get()) {
            suspicious = true;
            reasons.append("RotatedDeepslate[").append(analysis.rotatedDeepslateCount).append("] ");
        }
        if (((Boolean)this.detectEndStone.get()).booleanValue() && analysis.endStoneCount >= (Integer)this.endStoneThreshold.get()) {
            suspicious = true;
            reasons.append("EndStone[").append(analysis.endStoneCount).append("] ");
        }
        if (suspicious) {
            if (this.flaggedChunks.add(pos)) {
                this.notifyChunkFound(pos, reasons.toString().trim());
            }
        } else {
            this.flaggedChunks.remove(pos);
            this.notificationTimes.remove(pos);
        }
    }

    private boolean isNormalDeepslate(class_2680 state) {
        class_2248 block = state.method_26204();
        if (block != class_2246.field_28888 || !state.method_28498((class_2769)class_2741.field_12496)) {
            return false;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496);
        return axis == class_2350.class_2351.field_11052;
    }

    private boolean isCobbledDeepslate(class_2680 state) {
        return state.method_26204() == class_2246.field_29031;
    }

    private boolean isRotatedDeepslateBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        if (block != class_2246.field_28888 || !state.method_28498((class_2769)class_2741.field_12496)) {
            return false;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496);
        return axis != class_2350.class_2351.field_11052;
    }

    private boolean isEndStone(class_2680 state) {
        return state.method_26204() == class_2246.field_10471;
    }

    private boolean isTrialChamberBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        return block == class_2246.field_27133 || block == class_2246.field_33407 || block == class_2246.field_47035;
    }

    private void notifyChunkFound(class_1923 pos, String details) {
        long now = System.currentTimeMillis();
        if (this.recentAlerts.size() >= (Integer)this.maxAlerts.get()) {
            return;
        }
        Long lastNotification = this.notificationTimes.get(pos);
        if (lastNotification != null && now - lastNotification < 45000L) {
            return;
        }
        String message = String.format("ChunkFinder [%d, %d] - Suspicious chunk detected - %s", pos.field_9181, pos.field_9180, details);
        this.mc.execute(() -> {
            switch (((Mode)((Object)((Object)this.notificationMode.get()))).ordinal()) {
                case 0: {
                    if (!((Boolean)this.chatAlerts.get()).booleanValue() || this.mc.field_1724 == null) break;
                    this.mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
                    break;
                }
                case 1: {
                    this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8106, "ChunkFinder", message));
                    break;
                }
                case 2: {
                    if (((Boolean)this.chatAlerts.get()).booleanValue() && this.mc.field_1724 != null) {
                        this.mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
                    }
                    this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8106, "ChunkFinder", message));
                }
            }
            if (((Boolean)this.playSound.get()).booleanValue()) {
                this.mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)1.5f));
            }
            this.recentAlerts.offer(now);
            this.notificationTimes.put(pos, now);
        });
    }

    private void notifyTrialChamber(String message) {
        long now = System.currentTimeMillis();
        if (this.recentAlerts.size() >= (Integer)this.maxAlerts.get()) {
            return;
        }
        String[] parts = message.split(" - ", 2);
        String coordsPart = parts[0].replace("ChunkFinder ", "");
        String detailsPart = parts.length > 1 ? parts[1] : "";
        this.mc.execute(() -> {
            switch (((Mode)((Object)((Object)this.notificationMode.get()))).ordinal()) {
                case 0: {
                    if (!((Boolean)this.trialChamberAlerts.get()).booleanValue() || this.mc.field_1724 == null) break;
                    this.mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
                    break;
                }
                case 1: {
                    this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8106, "ChunkFinder", String.format("%s - %s", coordsPart, detailsPart)));
                    break;
                }
                case 2: {
                    if (((Boolean)this.trialChamberAlerts.get()).booleanValue() && this.mc.field_1724 != null) {
                        this.mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
                    }
                    this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8106, "ChunkFinder", String.format("%s - %s", coordsPart, detailsPart)));
                }
            }
            if (((Boolean)this.playSound.get()).booleanValue()) {
                this.mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)1.5f));
            }
            this.recentAlerts.offer(now);
        });
    }

    private void performCleanup() {
        if (this.mc.field_1724 == null) {
            return;
        }
        int viewDist = (Integer)this.mc.field_1690.method_42503().method_41753();
        int playerChunkX = (int)this.mc.field_1724.method_23317() / 16;
        int playerChunkZ = (int)this.mc.field_1724.method_23321() / 16;
        this.flaggedChunks.removeIf(pos -> {
            boolean tooFar;
            int dx = Math.abs(pos.field_9181 - playerChunkX);
            int dz = Math.abs(pos.field_9180 - playerChunkZ);
            boolean bl = tooFar = dx > viewDist + 5 || dz > viewDist + 5;
            if (tooFar) {
                this.chunkData.remove(pos);
                this.notificationTimes.remove(pos);
            }
            return tooFar;
        });
        this.scannedChunks.removeIf(pos -> {
            int dx = Math.abs(pos.field_9181 - playerChunkX);
            int dz = Math.abs(pos.field_9180 - playerChunkZ);
            return dx > viewDist + 3 || dz > viewDist + 3;
        });
        this.suspiciousBlocks.entrySet().removeIf(entry -> {
            class_2338 blockPos = (class_2338)entry.getKey();
            double distance = this.mc.field_1724.method_19538().method_1022(class_243.method_24953((class_2382)blockPos));
            return distance > (double)(viewDist * 16 + 80);
        });
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (!this.flaggedChunks.isEmpty()) {
            Color highlight = new Color((Color)this.chunkColor.get());
            int rendered = 0;
            for (class_1923 pos : this.flaggedChunks) {
                if (rendered++ > 50) break;
                this.renderChunkHighlight(event, pos, highlight);
            }
        }
        if (((Boolean)this.highlightBlocks.get()).booleanValue()) {
            this.renderSuspiciousBlocks(event);
        }
    }

    private void renderChunkHighlight(Render3DEvent event, class_1923 pos, Color color) {
        int startX = pos.method_8326();
        int startZ = pos.method_8328();
        int endX = pos.method_8327();
        int endZ = pos.method_8329();
        double y = (Double)this.renderY.get();
        double h = (Double)this.thickness.get();
        class_238 box = new class_238((double)startX, y, (double)startZ, (double)(endX + 1), y + h, (double)(endZ + 1));
        event.renderer.box(box, color, color, (ShapeMode)this.renderMode.get(), 0);
    }

    private void renderSuspiciousBlocks(Render3DEvent event) {
        int rendered = 0;
        for (Map.Entry<class_2338, SuspiciousBlock> entry : this.suspiciousBlocks.entrySet()) {
            Color blockColor;
            if (rendered >= (Integer)this.maxBlocksToRender.get()) break;
            class_2338 pos = entry.getKey();
            SuspiciousBlock suspiciousBlock = entry.getValue();
            double distance = this.mc.field_1724.method_19538().method_1022(class_243.method_24953((class_2382)pos));
            if (distance > (double)((Integer)this.mc.field_1690.method_42503().method_41753() * 16) || (blockColor = this.getColorForBlockType(suspiciousBlock.type)) == null) continue;
            class_238 box = new class_238(pos);
            event.renderer.box(box, blockColor, blockColor, (ShapeMode)this.blockRenderMode.get(), 0);
            ++rendered;
        }
    }

    private Color getColorForBlockType(SuspiciousBlockType type) {
        return switch (type.ordinal()) {
            case 0 -> new Color((Color)this.deepslateBlockColor.get());
            case 1 -> new Color((Color)this.cobbledDeepslateBlockColor.get());
            case 2 -> new Color((Color)this.rotatedDeepslateBlockColor.get());
            case 3 -> new Color((Color)this.endStoneBlockColor.get());
            default -> null;
        };
    }

    public String getInfoString() {
        if (((Boolean)this.highlightBlocks.get()).booleanValue()) {
            return String.format("C:%d B:%d", this.flaggedChunks.size(), this.suspiciousBlocks.size());
        }
        return String.valueOf(this.flaggedChunks.size());
    }

    public static enum Mode {
        Chat,
        Toast,
        Both;

    }

    private static class ChunkAnalysis {
        int deepslateCount = 0;
        int cobbledDeepslateCount = 0;
        int rotatedDeepslateCount = 0;
        int endStoneCount = 0;
        int trialChamberCount = 0;

        private ChunkAnalysis() {
        }
    }

    private static enum SuspiciousBlockType {
        DEEPSLATE,
        COBBLED_DEEPSLATE,
        ROTATED_DEEPSLATE,
        END_STONE;

    }

    private static class SuspiciousBlock {
        final SuspiciousBlockType type;
        final long detectedTime;

        SuspiciousBlock(SuspiciousBlockType type, long detectedTime) {
            this.type = type;
            this.detectedTime = detectedTime;
        }
    }
}

