/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;

public class DeepslateESP
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<SettingColor> deepslateColor;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<Boolean> tracers;
    private final Setting<SettingColor> tracerColor;
    private final Setting<Boolean> chatFeedback;
    private final SettingGroup sgFiltering;
    private final Setting<Integer> minY;
    private final Setting<Integer> maxY;
    private final SettingGroup sgThreading;
    private final Setting<Boolean> useThreading;
    private final Setting<Integer> threadPoolSize;
    private final Setting<Boolean> limitChatSpam;
    private final Set<class_2338> deepslatePositions;
    private ExecutorService threadPool;

    public DeepslateESP() {
        super(GlazedAddon.esp, "DeepslateESP", "ESP for deepslate blocks with threading and tracer support.");
        this.sgGeneral = this.settings.createGroup("General");
        this.deepslateColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("esp-color")).description("Deepslate box color")).defaultValue(new SettingColor(0, 200, 255, 100)).build());
        this.shapeMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("Deepslate box render mode")).defaultValue((Object)ShapeMode.Both)).build());
        this.tracers = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tracers")).description("Draw tracers to deepslate blocks")).defaultValue((Object)false)).build());
        this.tracerColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("Deepslate tracer color")).defaultValue(new SettingColor(0, 200, 255, 200)).visible(() -> this.tracers.get())).build());
        this.chatFeedback = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-feedback")).description("Announce deepslate in chat")).defaultValue((Object)true)).build());
        this.sgFiltering = this.settings.createGroup("Filtering");
        this.minY = this.sgFiltering.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-y")).description("Minimum Y level to scan for deepslate")).defaultValue((Object)8)).min(-64).max(128).sliderRange(-64, 128).build());
        this.maxY = this.sgFiltering.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-y")).description("Maximum Y level to scan for deepslate")).defaultValue((Object)128)).min(-64).max(320).sliderRange(-64, 320).build());
        this.sgThreading = this.settings.createGroup("Threading");
        this.useThreading = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-threading")).description("Use multi-threading for chunk scanning (better performance)")).defaultValue((Object)true)).build());
        this.threadPoolSize = this.sgThreading.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("thread-pool-size")).description("Number of threads to use for scanning")).defaultValue((Object)2)).min(1).max(8).sliderRange(1, 8).visible(() -> this.useThreading.get())).build());
        this.limitChatSpam = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("limit-chat-spam")).description("Reduce chat spam when using threading")).defaultValue((Object)true)).visible(() -> this.useThreading.get())).build());
        this.deepslatePositions = ConcurrentHashMap.newKeySet();
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            this.threadPool = Executors.newFixedThreadPool((Integer)this.threadPoolSize.get());
        }
        this.deepslatePositions.clear();
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.threadPool.submit(() -> this.scanChunk(worldChunk));
            }
        } else {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.scanChunk(worldChunk);
            }
        }
    }

    public void onDeactivate() {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            this.threadPool = null;
        }
        this.deepslatePositions.clear();
    }

    @EventHandler
    private void onChunkLoad(ChunkDataEvent event) {
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(() -> this.scanChunk(event.chunk()));
        } else {
            this.scanChunk(event.chunk());
        }
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        class_2338 pos = event.pos;
        class_2680 state = event.newState;
        Runnable updateTask = () -> {
            boolean isDeepslate = this.isDeepslateInRange(state, pos.method_10264());
            if (isDeepslate) {
                boolean wasAdded = this.deepslatePositions.add(pos);
                if (wasAdded && ((Boolean)this.chatFeedback.get()).booleanValue() && (!((Boolean)this.useThreading.get()).booleanValue() || !((Boolean)this.limitChatSpam.get()).booleanValue())) {
                    this.info("\u00a75[\u00a7dDeepslateESP\u00a75] \u00a7bDeepslateESP\u00a75: \u00a7bDeepslate at " + pos.method_23854(), new Object[0]);
                }
            } else {
                this.deepslatePositions.remove(pos);
            }
        };
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(updateTask);
        } else {
            updateTask.run();
        }
    }

    private void scanChunk(class_2818 chunk) {
        class_1923 cpos = chunk.method_12004();
        int xStart = cpos.method_8326();
        int zStart = cpos.method_8328();
        int yMin = Math.max(chunk.method_31607(), (Integer)this.minY.get());
        int yMax = Math.min(chunk.method_31607() + chunk.method_31605(), (Integer)this.maxY.get());
        HashSet<class_2338> chunkDeepslate = new HashSet<class_2338>();
        int foundCount = 0;
        for (int x = xStart; x < xStart + 16; ++x) {
            for (int z = zStart; z < zStart + 16; ++z) {
                for (int y = yMin; y < yMax; ++y) {
                    class_2338 pos2 = new class_2338(x, y, z);
                    if (!this.isDeepslateInRange(chunk.method_8320(pos2), y)) continue;
                    chunkDeepslate.add(pos2);
                    ++foundCount;
                }
            }
        }
        this.deepslatePositions.removeIf(pos -> {
            class_1923 blockChunk = new class_1923(pos);
            return blockChunk.equals((Object)cpos) && !chunkDeepslate.contains(pos);
        });
        int newBlocks = 0;
        for (class_2338 pos3 : chunkDeepslate) {
            if (!this.deepslatePositions.add(pos3)) continue;
            ++newBlocks;
        }
        if (((Boolean)this.chatFeedback.get()).booleanValue() && foundCount > 0) {
            if (((Boolean)this.useThreading.get()).booleanValue() && ((Boolean)this.limitChatSpam.get()).booleanValue()) {
                if (newBlocks > 0) {
                    this.info("\u00a75[\u00a7dDeepslateESP\u00a75] \u00a7bChunk " + cpos.field_9181 + "," + cpos.field_9180 + "\u00a75: \u00a7b" + newBlocks + " new deepslate blocks found", new Object[0]);
                }
            } else {
                for (class_2338 pos4 : chunkDeepslate) {
                    if (this.deepslatePositions.contains(pos4)) continue;
                    this.info("\u00a75[\u00a7dDeepslateESP\u00a75] \u00a7bDeepslateESP\u00a75: \u00a7bDeepslate at " + pos4.method_23854(), new Object[0]);
                }
            }
        }
    }

    private boolean isDeepslateInRange(class_2680 state, int y) {
        return y >= (Integer)this.minY.get() && y <= (Integer)this.maxY.get() && state.method_26204() == class_2246.field_28888;
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_243 playerPos = this.mc.field_1724.method_30950(event.tickDelta);
        Color side = new Color((Color)this.deepslateColor.get());
        Color outline = new Color((Color)this.deepslateColor.get());
        Color tracerColorValue = new Color((Color)this.tracerColor.get());
        for (class_2338 pos : this.deepslatePositions) {
            class_243 startPos;
            event.renderer.box(pos, side, outline, (ShapeMode)this.shapeMode.get(), 0);
            if (!((Boolean)this.tracers.get()).booleanValue()) continue;
            class_243 blockCenter = class_243.method_24953((class_2382)pos);
            if (this.mc.field_1690.method_31044().method_31034()) {
                class_243 lookDirection = this.mc.field_1724.method_5720();
                startPos = new class_243(playerPos.field_1352 + lookDirection.field_1352 * 0.5, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()) + lookDirection.field_1351 * 0.5, playerPos.field_1350 + lookDirection.field_1350 * 0.5);
            } else {
                startPos = new class_243(playerPos.field_1352, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), playerPos.field_1350);
            }
            event.renderer.line(startPos.field_1352, startPos.field_1351, startPos.field_1350, blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350, tracerColorValue);
        }
    }
}

