/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_5689;

public class DripstoneESP
extends Module {
    private final SettingGroup sgStalactite;
    private final Setting<SettingColor> stalactiteColor;
    private final Setting<ShapeMode> stalactiteShapeMode;
    private final Setting<Boolean> stalactiteTracers;
    private final Setting<SettingColor> stalactiteTracerColor;
    private final Setting<Boolean> stalactiteChat;
    private final Setting<Integer> stalactiteMinLength;
    private final SettingGroup sgStalagmite;
    private final Setting<SettingColor> stalagmiteColor;
    private final Setting<ShapeMode> stalagmiteShapeMode;
    private final Setting<Boolean> stalagmiteTracers;
    private final Setting<SettingColor> stalagmiteTracerColor;
    private final Setting<Boolean> stalagmiteChat;
    private final Setting<Integer> stalagmiteMinLength;
    private final SettingGroup sgThreading;
    private final Setting<Boolean> useThreading;
    private final Setting<Integer> threadPoolSize;
    private final Set<class_2338> longStalactiteBottoms;
    private final Set<class_2338> longStalagmiteTops;
    private ExecutorService threadPool;

    public DripstoneESP() {
        super(GlazedAddon.esp, "DripstoneESP", "ESP for long dripstone stalactites and stalagmites with threading support.");
        this.sgStalactite = this.settings.createGroup("Stalactite ESP");
        this.stalactiteColor = this.sgStalactite.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("esp-color")).description("Stalactite ESP box color")).defaultValue(new SettingColor(100, 255, 200, 100)).build());
        this.stalactiteShapeMode = this.sgStalactite.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("Stalactite box render mode")).defaultValue((Object)ShapeMode.Both)).build());
        this.stalactiteTracers = this.sgStalactite.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tracers")).description("Draw tracers to stalactites")).defaultValue((Object)false)).build());
        this.stalactiteTracerColor = this.sgStalactite.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("Stalactite tracer color")).defaultValue(new SettingColor(100, 255, 200, 200)).visible(() -> this.stalactiteTracers.get())).build());
        this.stalactiteChat = this.sgStalactite.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-feedback")).description("Announce long dripstone stalactites in chat")).defaultValue((Object)true)).build());
        this.stalactiteMinLength = this.sgStalactite.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-length")).description("Minimum length for stalactite to show ESP")).defaultValue((Object)4)).min(4).max(16).sliderRange(4, 16).build());
        this.sgStalagmite = this.settings.createGroup("Stalagmite ESP");
        this.stalagmiteColor = this.sgStalagmite.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("esp-color")).description("Stalagmite ESP box color")).defaultValue(new SettingColor(255, 150, 100, 100)).build());
        this.stalagmiteShapeMode = this.sgStalagmite.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("Stalagmite box render mode")).defaultValue((Object)ShapeMode.Both)).build());
        this.stalagmiteTracers = this.sgStalagmite.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tracers")).description("Draw tracers to stalagmites")).defaultValue((Object)false)).build());
        this.stalagmiteTracerColor = this.sgStalagmite.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("Stalagmite tracer color")).defaultValue(new SettingColor(255, 150, 100, 200)).visible(() -> this.stalagmiteTracers.get())).build());
        this.stalagmiteChat = this.sgStalagmite.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-feedback")).description("Announce long dripstone stalagmites in chat")).defaultValue((Object)true)).build());
        this.stalagmiteMinLength = this.sgStalagmite.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-length")).description("Minimum length for stalagmite to show ESP")).defaultValue((Object)8)).min(4).max(16).sliderRange(4, 16).build());
        this.sgThreading = this.settings.createGroup("Threading");
        this.useThreading = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-threading")).description("Use multi-threading for chunk scanning (better performance)")).defaultValue((Object)true)).build());
        this.threadPoolSize = this.sgThreading.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("thread-pool-size")).description("Number of threads to use for scanning")).defaultValue((Object)2)).min(1).max(8).sliderRange(1, 8).visible(() -> this.useThreading.get())).build());
        this.longStalactiteBottoms = ConcurrentHashMap.newKeySet();
        this.longStalagmiteTops = ConcurrentHashMap.newKeySet();
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            this.threadPool = Executors.newFixedThreadPool((Integer)this.threadPoolSize.get());
        }
        this.longStalactiteBottoms.clear();
        this.longStalagmiteTops.clear();
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.threadPool.submit(() -> this.scanChunk(worldChunk));
            }
        } else {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.scanChunk(worldChunk);
            }
        }
    }

    public void onDeactivate() {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            this.threadPool = null;
        }
        this.longStalactiteBottoms.clear();
        this.longStalagmiteTops.clear();
    }

    @EventHandler
    private void onChunkLoad(ChunkDataEvent event) {
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(() -> this.scanChunk(event.chunk()));
        } else {
            this.scanChunk(event.chunk());
        }
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        class_2338 pos = event.pos;
        class_2680 state = event.newState;
        Runnable scanTask = () -> {
            if (state.method_27852(class_2246.field_28048)) {
                for (int dx = -2; dx <= 2; ++dx) {
                    for (int dz = -2; dz <= 2; ++dz) {
                        for (int dy = -16; dy <= 16; ++dy) {
                            class_2338 scanPos = pos.method_10069(dx, dy, dz);
                            class_2680 scanState = this.mc.field_1687.method_8320(scanPos);
                            if (this.isDripstoneTipDown(scanState)) {
                                StalactiteInfo stalactiteInfo = this.getStalactiteInfo(scanPos);
                                if (stalactiteInfo != null && stalactiteInfo.length >= (Integer)this.stalactiteMinLength.get()) {
                                    if (this.longStalactiteBottoms.add(stalactiteInfo.bottomPos) && ((Boolean)this.stalactiteChat.get()).booleanValue()) {
                                        this.info("\u00a75[\u00a7dDripstone Esp\u00a75] \u00a73Dripstone Esp\u00a75: \u00a73Long stalactite at " + scanPos.method_23854() + " (length " + stalactiteInfo.length + ")", new Object[0]);
                                    }
                                } else if (stalactiteInfo != null) {
                                    this.longStalactiteBottoms.remove(stalactiteInfo.bottomPos);
                                }
                            }
                            if (!this.isDripstoneTipUp(scanState)) continue;
                            StalagmiteInfo stalagmiteInfo = this.getStalagmiteInfo(scanPos);
                            if (stalagmiteInfo != null && stalagmiteInfo.length >= (Integer)this.stalagmiteMinLength.get()) {
                                if (!this.longStalagmiteTops.add(stalagmiteInfo.topPos) || !((Boolean)this.stalagmiteChat.get()).booleanValue()) continue;
                                this.info("\u00a75[\u00a7dDripstoneUp\u00a75] \u00a76DripstoneUp\u00a75: \u00a76Long stalagmite at " + scanPos.method_23854() + " (length " + stalagmiteInfo.length + ")", new Object[0]);
                                continue;
                            }
                            if (stalagmiteInfo == null) continue;
                            this.longStalagmiteTops.remove(stalagmiteInfo.topPos);
                        }
                    }
                }
            } else {
                this.longStalagmiteTops.removeIf(topPos -> {
                    class_2680 topState = this.mc.field_1687.method_8320(topPos);
                    return !topState.method_27852(class_2246.field_28048) || !this.isDripstoneTipUp(topState);
                });
            }
        };
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(scanTask);
        } else {
            scanTask.run();
        }
    }

    private void scanChunk(class_2818 chunk) {
        this.scanChunkForStalactites(chunk);
        this.scanChunkForStalagmites(chunk);
    }

    private void scanChunkForStalactites(class_2818 chunk) {
        class_1923 cpos = chunk.method_12004();
        int xStart = cpos.method_8326();
        int zStart = cpos.method_8328();
        int yMin = chunk.method_31607();
        int yMax = yMin + chunk.method_31605();
        HashSet<class_2338> chunkBottoms = new HashSet<class_2338>();
        for (int x = xStart; x < xStart + 16; ++x) {
            for (int z = zStart; z < zStart + 16; ++z) {
                for (int y = yMin; y < yMax; ++y) {
                    StalactiteInfo info;
                    class_2338 pos2 = new class_2338(x, y, z);
                    class_2680 state = chunk.method_8320(pos2);
                    if (!this.isDripstoneTipDown(state) || (info = this.getStalactiteInfo(pos2)) == null || info.length < (Integer)this.stalactiteMinLength.get()) continue;
                    chunkBottoms.add(info.bottomPos);
                    if (this.longStalactiteBottoms.contains(info.bottomPos) || !((Boolean)this.stalactiteChat.get()).booleanValue()) continue;
                    this.info("\u00a75[\u00a7dDripstone\u00a75] \u00a73Dripstone\u00a75: \u00a73Long stalactite at " + pos2.method_23854() + " (length " + info.length + ")", new Object[0]);
                }
            }
        }
        this.longStalactiteBottoms.removeIf(pos -> {
            class_1923 tipChunk = new class_1923(pos);
            return tipChunk.equals((Object)cpos) && !chunkBottoms.contains(pos);
        });
        this.longStalactiteBottoms.addAll(chunkBottoms);
    }

    private void scanChunkForStalagmites(class_2818 chunk) {
        class_1923 cpos = chunk.method_12004();
        int xStart = cpos.method_8326();
        int zStart = cpos.method_8328();
        int yMin = chunk.method_31607();
        int yMax = yMin + chunk.method_31605();
        HashSet<class_2338> chunkTops = new HashSet<class_2338>();
        for (int x = xStart; x < xStart + 16; ++x) {
            for (int z = zStart; z < zStart + 16; ++z) {
                for (int y = yMin; y < yMax; ++y) {
                    int length;
                    class_2338 pos2 = new class_2338(x, y, z);
                    class_2680 state = chunk.method_8320(pos2);
                    if (!this.isDripstoneTipUp(state) || (length = this.getStalagmiteLength(pos2)) < (Integer)this.stalagmiteMinLength.get()) continue;
                    chunkTops.add(pos2);
                    if (this.longStalagmiteTops.contains(pos2) || !((Boolean)this.stalagmiteChat.get()).booleanValue()) continue;
                    this.info("\u00a75[\u00a7dDripstoneUp\u00a75] \u00a76DripstoneUp\u00a75: \u00a76Long stalagmite at " + pos2.method_23854() + " (length " + length + ")", new Object[0]);
                }
            }
        }
        this.longStalagmiteTops.removeIf(pos -> {
            class_1923 tipChunk = new class_1923(pos);
            return tipChunk.equals((Object)cpos) && !chunkTops.contains(pos);
        });
        this.longStalagmiteTops.addAll(chunkTops);
    }

    private boolean isDripstoneTipDown(class_2680 state) {
        return state.method_27852(class_2246.field_28048) && state.method_28498((class_2769)class_5689.field_28050) && state.method_11654((class_2769)class_5689.field_28050) == class_2350.field_11033;
    }

    private boolean isDripstoneTipUp(class_2680 state) {
        return state.method_27852(class_2246.field_28048) && state.method_28498((class_2769)class_5689.field_28050) && state.method_11654((class_2769)class_5689.field_28050) == class_2350.field_11036;
    }

    private StalactiteInfo getStalactiteInfo(class_2338 tipPos) {
        class_2350 tipDirection;
        class_2680 state;
        if (this.mc.field_1687 == null) {
            return null;
        }
        int length = 0;
        class_2338 currentPos = tipPos;
        class_2338 bottomPos = tipPos;
        while (currentPos.method_10264() >= this.mc.field_1687.method_31607() && (state = this.mc.field_1687.method_8320(currentPos)).method_27852(class_2246.field_28048) && state.method_28498((class_2769)class_5689.field_28050) && (tipDirection = (class_2350)state.method_11654((class_2769)class_5689.field_28050)) == class_2350.field_11033) {
            ++length;
            bottomPos = currentPos;
            currentPos = currentPos.method_10074();
        }
        return length > 0 ? new StalactiteInfo(length, bottomPos) : null;
    }

    private StalagmiteInfo getStalagmiteInfo(class_2338 tipPos) {
        class_2350 tipDirection;
        class_2680 state;
        if (this.mc.field_1687 == null) {
            return null;
        }
        int length = 0;
        class_2338 currentPos = tipPos;
        class_2338 topPos = tipPos;
        while (currentPos.method_10264() < 320 && (state = this.mc.field_1687.method_8320(currentPos)).method_27852(class_2246.field_28048) && state.method_28498((class_2769)class_5689.field_28050) && (tipDirection = (class_2350)state.method_11654((class_2769)class_5689.field_28050)) == class_2350.field_11036) {
            ++length;
            topPos = currentPos;
            currentPos = currentPos.method_10084();
        }
        return length > 0 ? new StalagmiteInfo(length, topPos) : null;
    }

    private int getStalagmiteLength(class_2338 tipPos) {
        StalagmiteInfo info = this.getStalagmiteInfo(tipPos);
        return info != null ? info.length : 0;
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_243 playerPos = this.mc.field_1724.method_30950(event.tickDelta);
        Color stalactiteSide = new Color((Color)this.stalactiteColor.get());
        Color stalactiteOutline = new Color((Color)this.stalactiteColor.get());
        Color stalactiteTracer = new Color((Color)this.stalactiteTracerColor.get());
        for (class_2338 pos : this.longStalactiteBottoms) {
            class_243 startPos;
            event.renderer.box(pos, stalactiteSide, stalactiteOutline, (ShapeMode)this.stalactiteShapeMode.get(), 0);
            if (!((Boolean)this.stalactiteTracers.get()).booleanValue()) continue;
            class_243 blockCenter = class_243.method_24953((class_2382)pos);
            if (this.mc.field_1690.method_31044().method_31034()) {
                class_243 lookDirection = this.mc.field_1724.method_5720();
                startPos = new class_243(playerPos.field_1352 + lookDirection.field_1352 * 0.5, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()) + lookDirection.field_1351 * 0.5, playerPos.field_1350 + lookDirection.field_1350 * 0.5);
            } else {
                startPos = new class_243(playerPos.field_1352, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), playerPos.field_1350);
            }
            event.renderer.line(startPos.field_1352, startPos.field_1351, startPos.field_1350, blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350, stalactiteTracer);
        }
        Color stalagmiteSide = new Color((Color)this.stalagmiteColor.get());
        Color stalagmiteOutline = new Color((Color)this.stalagmiteColor.get());
        Color stalagmiteTracer = new Color((Color)this.stalagmiteTracerColor.get());
        for (class_2338 pos : this.longStalagmiteTops) {
            class_243 startPos;
            event.renderer.box(pos, stalagmiteSide, stalagmiteOutline, (ShapeMode)this.stalagmiteShapeMode.get(), 0);
            if (!((Boolean)this.stalagmiteTracers.get()).booleanValue()) continue;
            class_243 blockCenter = class_243.method_24953((class_2382)pos);
            if (this.mc.field_1690.method_31044().method_31034()) {
                class_243 lookDirection = this.mc.field_1724.method_5720();
                startPos = new class_243(playerPos.field_1352 + lookDirection.field_1352 * 0.5, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()) + lookDirection.field_1351 * 0.5, playerPos.field_1350 + lookDirection.field_1350 * 0.5);
            } else {
                startPos = new class_243(playerPos.field_1352, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), playerPos.field_1350);
            }
            event.renderer.line(startPos.field_1352, startPos.field_1351, startPos.field_1350, blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350, stalagmiteTracer);
        }
    }

    private static class StalactiteInfo {
        final int length;
        final class_2338 bottomPos;

        StalactiteInfo(int length, class_2338 bottomPos) {
            this.length = length;
            this.bottomPos = bottomPos;
        }
    }

    private static class StalagmiteInfo {
        final int length;
        final class_2338 topPos;

        StalagmiteInfo(int length, class_2338 topPos) {
            this.length = length;
            this.topPos = topPos;
        }
    }
}

