/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.stream.StreamSupport;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1551;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class DrownedTridentESP
extends Module {
    private final SettingGroup sgRender;
    private final Setting<SettingColor> color;
    private final Setting<Double> lineWidth;
    private final Setting<RenderMode> mode;
    private final Setting<Boolean> tracers;
    private final Setting<SettingColor> tracerColor;

    public DrownedTridentESP() {
        super(GlazedAddon.esp, "drowned-trident-esp", "Highlights Drowned mobs holding tridents with optional tracers.");
        this.sgRender = this.settings.createGroup("Rendering");
        this.color = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("color")).description("Color of the ESP box and lines.")).defaultValue(new SettingColor(50, 255, 100, 200)).build());
        this.lineWidth = this.sgRender.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("line-width")).description("Thickness of the outline lines.")).defaultValue(1.5).min(0.5).sliderRange(0.5, 5.0).build());
        this.mode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("How the ESP should be rendered.")).defaultValue((Object)RenderMode.Both)).build());
        this.tracers = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tracers")).description("Draw tracers from the player to Drowned holding tridents.")).defaultValue((Object)true)).build());
        this.tracerColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("Color of the tracers.")).defaultValue(new SettingColor(255, 50, 50, 200)).visible(() -> this.tracers.get())).build());
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        class_243 playerPos = this.mc.field_1724.method_30950(event.tickDelta);
        StreamSupport.stream(this.mc.field_1687.method_18112().spliterator(), false).filter(entity -> entity instanceof class_1551).map(entity -> (class_1551)entity).filter(this::isHoldingTrident).forEach(drowned -> {
            class_238 box = drowned.method_5829();
            Color fillColor = new Color((Color)this.color.get());
            Color lineColor = new Color((Color)this.color.get());
            if (this.mode.get() == RenderMode.Box || this.mode.get() == RenderMode.Both) {
                event.renderer.box(box, fillColor, lineColor, ShapeMode.Sides, 0);
            }
            if (this.mode.get() == RenderMode.Lines || this.mode.get() == RenderMode.Both) {
                event.renderer.box(box, fillColor, lineColor, ShapeMode.Lines, 0);
            }
            if (((Boolean)this.tracers.get()).booleanValue()) {
                class_243 startPos;
                class_243 entityPos = drowned.method_19538().method_1031(0.0, (double)drowned.method_17682() / 2.0, 0.0);
                if (this.mc.field_1690.method_31044().method_31034()) {
                    class_243 lookDir = this.mc.field_1724.method_5720();
                    startPos = playerPos.method_1031(0.0, (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), 0.0).method_1019(lookDir.method_1021(0.5));
                } else {
                    startPos = playerPos.method_1031(0.0, (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), 0.0);
                }
                Color tracerCol = new Color((Color)this.tracerColor.get());
                event.renderer.line(startPos.field_1352, startPos.field_1351, startPos.field_1350, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, tracerCol);
            }
        });
    }

    private boolean isHoldingTrident(class_1551 drowned) {
        return drowned.method_5998(class_1268.field_5808).method_7909() == class_1802.field_8547 || drowned.method_5998(class_1268.field_5810).method_7909() == class_1802.field_8547;
    }

    public static enum RenderMode {
        Lines,
        Box,
        Both;

    }
}

