/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_640;
import net.minecraft.class_8646;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.class_9020;
import net.minecraft.class_9022;

public class FakeScoreboard
extends Module {
    private static final String SCOREBOARD_NAME = "glazed_custom";
    private class_266 customObjective;
    private class_266 originalObjective;
    private final class_310 mc = class_310.method_1551();
    private final List<String> teamNames = new ArrayList<String>();
    private long keyallStartTime = 0L;
    private long keyallInitialTime = 0L;
    private long lastMsUpdate = 0L;
    private int displayMs = 0;
    private int msChangeDirection = 1;
    private long lastScoreboardUpdate = 0L;
    private final SettingGroup sgStats = this.settings.getDefaultGroup();
    private final Setting<String> title = this.sgStats.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("title")).defaultValue((Object)"Overkill on top")).onChanged(s -> this.safeUpdate())).build());
    private final Setting<String> money = this.sgStats.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("money")).defaultValue((Object)"67")).onChanged(s -> this.safeUpdate())).build());
    private final Setting<String> shards = this.sgStats.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("shards")).defaultValue((Object)"67")).onChanged(s -> this.safeUpdate())).build());
    private final Setting<String> kills = this.sgStats.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("kills")).defaultValue((Object)"67")).onChanged(s -> this.safeUpdate())).build());
    private final Setting<String> deaths = this.sgStats.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("deaths")).defaultValue((Object)"67")).onChanged(s -> this.safeUpdate())).build());
    private final Setting<String> keyall = this.sgStats.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("keyall")).defaultValue((Object)"67")).onChanged(s -> this.safeUpdate())).build());
    private final Setting<String> playtime = this.sgStats.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("playtime")).defaultValue((Object)"6h 7m")).onChanged(s -> this.safeUpdate())).build());
    private final Setting<String> team = this.sgStats.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("team")).defaultValue((Object)"Overkill on top")).onChanged(s -> this.safeUpdate())).build());
    private final Setting<String> footer = this.sgStats.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("footer")).defaultValue((Object)" Overkill(67ms)")).onChanged(s -> this.safeUpdate())).build());

    public FakeScoreboard() {
        super(GlazedAddon.esp, "FakeScoreboard", "Custom scoreboard overlay for Overkill.");
    }

    private void safeUpdate() {
        if (this.isActive() && this.mc.field_1687 != null && this.mc.field_1724 != null) {
            this.updateScoreboard();
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (!this.isActive() || this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastScoreboardUpdate >= 1000L) {
            this.updateScoreboard();
            this.lastScoreboardUpdate = currentTime;
        }
    }

    public void onActivate() {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        class_269 scoreboard = this.mc.field_1687.method_8428();
        this.originalObjective = scoreboard.method_1189(class_8646.field_45157);
        this.keyallStartTime = System.currentTimeMillis();
        this.keyallInitialTime = 3599L;
        this.lastMsUpdate = System.currentTimeMillis();
        this.displayMs = 50 + (int)(Math.random() * 50.0);
        this.msChangeDirection = Math.random() < 0.5 ? 1 : -1;
        this.updateScoreboard();
    }

    public void onDeactivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        try {
            class_269 scoreboard = this.mc.field_1687.method_8428();
            this.cleanupTeams(scoreboard);
            if (this.customObjective != null) {
                try {
                    scoreboard.method_1194(this.customObjective);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.customObjective = null;
            }
            if (this.originalObjective != null) {
                try {
                    scoreboard.method_1158(class_8646.field_45157, this.originalObjective);
                }
                catch (Exception e) {
                    scoreboard.method_1158(class_8646.field_45157, null);
                }
            } else {
                scoreboard.method_1158(class_8646.field_45157, null);
            }
            this.originalObjective = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanupTeams(class_269 scoreboard) {
        for (String teamName : this.teamNames) {
            try {
                class_268 team = scoreboard.method_1153(teamName);
                if (team == null) continue;
                scoreboard.method_1191(team);
            }
            catch (Exception exception) {}
        }
        this.teamNames.clear();
    }

    public void updateScoreboard() {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        class_269 scoreboard = this.mc.field_1687.method_8428();
        this.cleanupTeams(scoreboard);
        if (this.customObjective != null) {
            scoreboard.method_1194(this.customObjective);
        }
        this.customObjective = scoreboard.method_1168(SCOREBOARD_NAME, class_274.field_1468, (class_2561)this.gradientTitle((String)this.title.get()), class_274.class_275.field_1472, false, (class_9022)class_9020.field_47557);
        scoreboard.method_1158(class_8646.field_45157, this.customObjective);
        List<class_5250> entries = this.generateEntriesText();
        for (int i = 0; i < entries.size(); ++i) {
            String teamName = "glazed_team_" + i;
            this.teamNames.add(teamName);
            class_268 t = scoreboard.method_1153(teamName);
            if (t != null) {
                scoreboard.method_1191(t);
            }
            t = scoreboard.method_1171(teamName);
            t.method_1138((class_2561)entries.get(i));
            String holderName = "\u00a7" + Integer.toHexString(i);
            class_9015 holder = class_9015.method_55422((String)holderName);
            scoreboard.method_1155(holder, this.customObjective);
            class_9014 score = scoreboard.method_1180(holder, this.customObjective);
            score.method_55410(entries.size() - i);
            scoreboard.method_1172(holderName, t);
        }
    }

    private int getRealPing() {
        if (this.mc.field_1724 == null || this.mc.method_1562() == null) {
            return 0;
        }
        class_640 entry = this.mc.method_1562().method_2871(this.mc.field_1724.method_5667());
        return entry != null ? entry.method_2959() : 0;
    }

    private String getKeyallTimer() {
        long elapsed = System.currentTimeMillis() - this.keyallStartTime;
        long elapsedSeconds = elapsed / 1000L;
        long remainingSeconds = Math.max(0L, this.keyallInitialTime - elapsedSeconds);
        long minutes = remainingSeconds / 60L;
        long seconds = remainingSeconds % 60L;
        return String.format("%dm %ds", minutes, seconds);
    }

    private String getFooterWithMs() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastMsUpdate > 2000L + (long)(Math.random() * 2000.0)) {
            int change = 1 + (int)(Math.random() * 5.0);
            this.displayMs += this.msChangeDirection * change;
            if (this.displayMs < 20) {
                this.displayMs = 20;
                this.msChangeDirection = 1;
            } else if (this.displayMs > 150) {
                this.displayMs = 150;
                this.msChangeDirection = -1;
            }
            if (Math.random() < 0.1) {
                this.msChangeDirection *= -1;
            }
            this.lastMsUpdate = currentTime;
        }
        String raw = (String)this.footer.get();
        int start = raw.indexOf(40);
        int end = raw.indexOf(41);
        if (start == -1 || end == -1 || end <= start) {
            return raw;
        }
        String region = raw.substring(0, start).trim();
        return region + "(" + this.displayMs + "ms)";
    }

    private List<class_5250> generateEntriesText() {
        return List.of(this.text(" "), this.colored("$ ", 65280).method_10852((class_2561)this.colored("Money: ", 0xFFFFFF)).method_10852((class_2561)this.colored((String)this.money.get(), 65280)), this.colored("\u2605 ", 10814460).method_10852((class_2561)this.colored("Shards: ", 0xFFFFFF)).method_10852((class_2561)this.colored((String)this.shards.get(), 10814460)), this.colored("\ud83d\udde1 ", 0xFF0000).method_10852((class_2561)this.colored("Kills: ", 0xFFFFFF)).method_10852((class_2561)this.colored((String)this.kills.get(), 0xFF0000)), this.colored("\u2620 ", 16545539).method_10852((class_2561)this.colored("Deaths: ", 0xFFFFFF)).method_10852((class_2561)this.colored((String)this.deaths.get(), 16545539)), this.colored("\u231b ", 41727).method_10852((class_2561)this.colored("Keyall: ", 0xFFFFFF)).method_10852((class_2561)this.colored(this.getKeyallTimer(), 41727)), this.colored("\u231a ", 16770560).method_10852((class_2561)this.colored("Playtime: ", 0xFFFFFF)).method_10852((class_2561)this.colored((String)this.playtime.get(), 16770560)), this.colored("\ud83e\ude93 ", 41727).method_10852((class_2561)this.colored("Team: ", 0xFFFFFF)).method_10852((class_2561)this.colored((String)this.team.get(), 41727)), this.text(" "), this.footerText());
    }

    private class_5250 footerText() {
        String raw = this.getFooterWithMs();
        int start = raw.indexOf(40);
        int end = raw.indexOf(41);
        if (start == -1 || end == -1 || end <= start) {
            return this.colored(raw, 0xA0A0A0);
        }
        String region = raw.substring(0, start).trim();
        String pingValue = raw.substring(start + 1, end).trim();
        return this.colored(region + " ", 0xA0A0A0).method_10852((class_2561)this.colored("(", 0xA0A0A0)).method_10852((class_2561)this.colored(pingValue, 41727)).method_10852((class_2561)this.colored(")", 0xA0A0A0));
    }

    private class_5250 colored(String text, int rgb) {
        return class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)rgb)));
    }

    private class_5250 text(String s) {
        return class_2561.method_43470((String)s);
    }

    private class_5250 gradientTitle(String text) {
        return this.gradient(text, 31993, 50937);
    }

    private class_5250 gradient(String text, int startColor, int endColor) {
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        class_5250 result = class_2561.method_43473();
        int len = Math.max(1, text.length());
        for (int i = 0; i < len; ++i) {
            float t = (float)i / (float)Math.max(len - 1, 1);
            int r = Math.round((float)startR + (float)(endR - startR) * t);
            int g = Math.round((float)startG + (float)(endG - startG) * t);
            int b = Math.round((float)startB + (float)(endB - startB) * t);
            result.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(i))).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)(r << 16 | g << 8 | b)))));
        }
        return result;
    }
}

