/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;

public class InvisESP
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgPlayers;
    private final SettingGroup sgMobs;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<Double> lineWidth;
    private final Setting<Double> fadeDistance;
    private final Setting<Boolean> onlyInvis;
    private final Setting<Boolean> showPlayers;
    private final Setting<SettingColor> playerColor;
    private final Setting<SettingColor> playerLineColor;
    private final Setting<Boolean> showSelf;
    private final Setting<Boolean> showMobs;
    private final Setting<SettingColor> mobColor;
    private final Setting<SettingColor> mobLineColor;
    private final Setting<Boolean> showPassive;
    private final Setting<Boolean> showHostile;

    public InvisESP() {
        super(Categories.Render, "InvisESP", "Shows 3D hitbox for invisible players and mobs");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgPlayers = this.settings.createGroup("Players");
        this.sgMobs = this.settings.createGroup("Mobs");
        this.shapeMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the box should be rendered")).defaultValue((Object)ShapeMode.Both)).build());
        this.lineWidth = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("line-width")).description("Thickness of the box lines")).defaultValue(2.0).min(0.1).max(10.0).sliderMax(5.0).visible(() -> this.shapeMode.get() != ShapeMode.Sides)).build());
        this.fadeDistance = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("fade-distance")).description("Distance at which boxes start to fade (0 = no fade)")).defaultValue(0.0).min(0.0).max(100.0).sliderMax(50.0).build());
        this.onlyInvis = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-invisible")).description("Only show hitboxes for invisible entities")).defaultValue((Object)true)).build());
        this.showPlayers = this.sgPlayers.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-players")).description("Show hitboxes for players")).defaultValue((Object)true)).build());
        this.playerColor = this.sgPlayers.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("player-color")).description("Color of player hitboxes")).defaultValue(new SettingColor(255, 0, 0, 100)).visible(() -> this.showPlayers.get())).build());
        this.playerLineColor = this.sgPlayers.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("player-line-color")).description("Color of player hitbox lines")).defaultValue(new SettingColor(255, 0, 0, 255)).visible(() -> (Boolean)this.showPlayers.get() != false && this.shapeMode.get() != ShapeMode.Sides)).build());
        this.showSelf = this.sgPlayers.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-self")).description("Show your own hitbox when invisible")).defaultValue((Object)false)).visible(() -> this.showPlayers.get())).build());
        this.showMobs = this.sgMobs.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-mobs")).description("Show hitboxes for mobs")).defaultValue((Object)true)).build());
        this.mobColor = this.sgMobs.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("mob-color")).description("Color of mob hitboxes")).defaultValue(new SettingColor(0, 255, 0, 100)).visible(() -> this.showMobs.get())).build());
        this.mobLineColor = this.sgMobs.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("mob-line-color")).description("Color of mob hitbox lines")).defaultValue(new SettingColor(0, 255, 0, 255)).visible(() -> (Boolean)this.showMobs.get() != false && this.shapeMode.get() != ShapeMode.Sides)).build());
        this.showPassive = this.sgMobs.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-passive")).description("Show hitboxes for passive mobs (animals)")).defaultValue((Object)false)).visible(() -> this.showMobs.get())).build());
        this.showHostile = this.sgMobs.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-hostile")).description("Show hitboxes for hostile mobs")).defaultValue((Object)true)).visible(() -> this.showMobs.get())).build());
    }

    public void onActivate() {
        this.info("Invisible hitboxes will now be displayed", new Object[0]);
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        for (class_1297 entity : this.mc.field_1687.method_18112()) {
            boolean isHostile;
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            if (entity == this.mc.field_1724 && !((Boolean)this.showSelf.get()).booleanValue() || ((Boolean)this.onlyInvis.get()).booleanValue() && !entity.method_5767()) continue;
            if (entity instanceof class_1657) {
                if (!((Boolean)this.showPlayers.get()).booleanValue()) continue;
                this.renderHitbox(event, entity, (SettingColor)this.playerColor.get(), (SettingColor)this.playerLineColor.get());
                continue;
            }
            if (!(entity instanceof class_1308)) continue;
            class_1308 mob = (class_1308)entity;
            if (!((Boolean)this.showMobs.get()).booleanValue()) continue;
            boolean bl = isHostile = mob.method_6510() || mob.method_5968() != null;
            if (isHostile && !((Boolean)this.showHostile.get()).booleanValue() || !isHostile && !((Boolean)this.showPassive.get()).booleanValue()) continue;
            this.renderHitbox(event, entity, (SettingColor)this.mobColor.get(), (SettingColor)this.mobLineColor.get());
        }
    }

    private void renderHitbox(Render3DEvent event, class_1297 entity, SettingColor fillColor, SettingColor lineColor) {
        class_238 box = entity.method_5829();
        double distance = this.mc.field_1724.method_5858(entity);
        double fadeStart = (Double)this.fadeDistance.get();
        Color finalFillColor = fillColor.copy();
        Color finalLineColor = lineColor.copy();
        if (fadeStart > 0.0 && distance > fadeStart * fadeStart) {
            double fadeFactor = Math.max(0.0, 1.0 - (Math.sqrt(distance) - fadeStart) / fadeStart);
            finalFillColor.a = (int)((double)fillColor.a * fadeFactor);
            finalLineColor.a = (int)((double)lineColor.a * fadeFactor);
        }
        event.renderer.box(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, finalFillColor, finalLineColor, (ShapeMode)this.shapeMode.get(), 0);
    }

    public String getInfoString() {
        int count = 0;
        if (this.mc.field_1687 != null) {
            for (class_1297 entity : this.mc.field_1687.method_18112()) {
                if (!(entity instanceof class_1309) || entity == this.mc.field_1724 && !((Boolean)this.showSelf.get()).booleanValue() || ((Boolean)this.onlyInvis.get()).booleanValue() && !entity.method_5767() || (!(entity instanceof class_1657) || !((Boolean)this.showPlayers.get()).booleanValue()) && (!(entity instanceof class_1308) || !((Boolean)this.showMobs.get()).booleanValue())) continue;
                ++count;
            }
        }
        return count + " entities";
    }
}

