/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.HashSet;
import java.util.Set;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2391;
import net.minecraft.class_2393;
import net.minecraft.class_2791;
import net.minecraft.class_2818;

public class KelpESP
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<SettingColor> kelpColor;
    private final Setting<ShapeMode> kelpShapeMode;
    private final Setting<Boolean> kelpChat;
    private final Set<class_1923> flaggedKelpChunks;

    public KelpESP() {
        super(GlazedAddon.esp, "KelpESP", "ESP for kelp chunks with suspicious patterns.");
        this.sgGeneral = this.settings.createGroup("General");
        this.kelpColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("esp-color")).description("Kelp ESP box color")).defaultValue(new SettingColor(0, 255, 0, 100)).build());
        this.kelpShapeMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("Kelp ESP box render mode")).defaultValue((Object)ShapeMode.Lines)).build());
        this.kelpChat = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-feedback")).description("Announce flagged kelp chunks in chat")).defaultValue((Object)true)).build());
        this.flaggedKelpChunks = new HashSet<class_1923>();
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        this.flaggedKelpChunks.clear();
        for (class_2791 chunk : Utils.chunks()) {
            if (!(chunk instanceof class_2818)) continue;
            class_2818 worldChunk = (class_2818)chunk;
            this.scanChunkForKelp(worldChunk);
        }
    }

    @EventHandler
    private void onChunkLoad(ChunkDataEvent event) {
        this.scanChunkForKelp(event.chunk());
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        class_2338 pos = event.pos;
        class_2791 chunk = this.mc.field_1687.method_22350(pos);
        if (chunk instanceof class_2818) {
            class_2818 worldChunk = (class_2818)chunk;
            this.scanChunkForKelp(worldChunk);
        }
    }

    private void scanChunkForKelp(class_2818 chunk) {
        class_1923 cpos = chunk.method_12004();
        this.flaggedKelpChunks.remove(cpos);
        int xStart = cpos.method_8326();
        int zStart = cpos.method_8328();
        int yMin = chunk.method_31607();
        int yMax = yMin + chunk.method_31605();
        int kelpColumns = 0;
        int kelpTopsAt62 = 0;
        for (int x = xStart; x < xStart + 16; ++x) {
            for (int z = zStart; z < zStart + 16; ++z) {
                int bottom = -1;
                int top = -1;
                for (int y = yMin; y < yMax; ++y) {
                    class_2248 block = chunk.method_8320(new class_2338(x, y, z)).method_26204();
                    if (!(block instanceof class_2393) && !(block instanceof class_2391)) continue;
                    if (bottom < 0) {
                        bottom = y;
                    }
                    top = y;
                }
                if (bottom < 0 || top - bottom + 1 < 8) continue;
                ++kelpColumns;
                if (top != 62) continue;
                ++kelpTopsAt62;
            }
        }
        if (kelpColumns >= 10 && (double)kelpTopsAt62 / (double)kelpColumns >= 0.6) {
            this.flaggedKelpChunks.add(cpos);
            if (((Boolean)this.kelpChat.get()).booleanValue()) {
                this.info("\u00a75[\u00a7dkelpEsp\u00a75] \u00a7akelpEsp\u00a75: \u00a7aChunk " + String.valueOf(cpos) + " flagged: " + kelpTopsAt62 + "/" + kelpColumns + " kelp tops at Y=62", new Object[0]);
            }
        }
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        Color side = new Color((Color)this.kelpColor.get());
        Color outline = new Color((Color)this.kelpColor.get());
        for (class_1923 pos : this.flaggedKelpChunks) {
            event.renderer.box((double)pos.method_8326(), 63.0, (double)pos.method_8328(), (double)(pos.method_8326() + 16), 63.0, (double)(pos.method_8328() + 16), side, outline, (ShapeMode)this.kelpShapeMode.get(), 0);
        }
    }
}

