/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2806;
import net.minecraft.class_2818;

public class LightESP
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final SettingGroup sgOptimization;
    private final Setting<Integer> chunkRadius;
    private final Setting<Integer> minY;
    private final Setting<Integer> maxY;
    private final Setting<Integer> minLightLevel;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<Boolean> thermalColors;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    private final Setting<Boolean> enableOptimization;
    private final Setting<Integer> optimizationInterval;
    private final Set<class_2338> blocksToSkip;
    private long lastOptimizationTime;

    public LightESP() {
        super(GlazedAddon.esp, "LightESP", "Highlights blocks with light levels above a threshold.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.sgOptimization = this.settings.createGroup("Optimization");
        this.chunkRadius = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("chunk-radius")).description("Radius of chunks to scan around the player.")).defaultValue((Object)2)).min(1).max(8).sliderMax(8).build());
        this.minY = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-y")).description("Minimum Y level to scan.")).defaultValue((Object)-63)).min(-64).max(319).sliderMin(-64).sliderMax(319).build());
        this.maxY = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-y")).description("Maximum Y level to scan.")).defaultValue((Object)0)).min(-64).max(319).sliderMin(-64).sliderMax(319).build());
        this.minLightLevel = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-light-level")).description("Minimum light level to display.")).defaultValue((Object)5)).min(0).max(15).sliderMax(15).build());
        this.shapeMode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue((Object)ShapeMode.Both)).build());
        this.thermalColors = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("thermal-colors")).description("Use thermal-style colors based on light level.")).defaultValue((Object)true)).build());
        this.sideColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("Side color (used when thermal colors are off).")).defaultValue(new SettingColor(255, 255, 0, 75)).visible(() -> (Boolean)this.thermalColors.get() == false)).build());
        this.lineColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("Line color (used when thermal colors are off).")).defaultValue(new SettingColor(255, 255, 0, 255)).visible(() -> (Boolean)this.thermalColors.get() == false)).build());
        this.enableOptimization = this.sgOptimization.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-optimization")).description("Remove weak light sources (level 6-7) that are likely propagated light.")).defaultValue((Object)true)).build());
        this.optimizationInterval = this.sgOptimization.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("optimization-interval")).description("How often to run optimization (in milliseconds).")).defaultValue((Object)1000)).min(100).max(5000).sliderMax(5000).visible(() -> this.enableOptimization.get())).build());
        this.blocksToSkip = ConcurrentHashMap.newKeySet();
        this.lastOptimizationTime = 0L;
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (((Boolean)this.enableOptimization.get()).booleanValue() && currentTime - this.lastOptimizationTime >= (long)((Integer)this.optimizationInterval.get()).intValue()) {
            this.optimizeWeakLights();
            this.lastOptimizationTime = currentTime;
        }
        class_1923 playerChunkPos = this.mc.field_1724.method_31476();
        ArrayList<class_2338> lightsToRender = new ArrayList<class_2338>();
        int radius = (Integer)this.chunkRadius.get();
        for (int chunkX = playerChunkPos.field_9181 - radius; chunkX <= playerChunkPos.field_9181 + radius; ++chunkX) {
            for (int chunkZ = playerChunkPos.field_9180 - radius; chunkZ <= playerChunkPos.field_9180 + radius; ++chunkZ) {
                class_2818 chunk = this.mc.field_1687.method_8497(chunkX, chunkZ);
                if (chunk == null || !chunk.method_12009().method_12165(class_2806.field_12803)) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = ((Integer)this.minY.get()).intValue(); y <= (Integer)this.maxY.get(); ++y) {
                            class_2338 pos = new class_2338(chunkX * 16 + x, y, chunkZ * 16 + z);
                            if (this.blocksToSkip.contains(pos)) continue;
                            int blockLight = this.mc.field_1687.method_8314(class_1944.field_9282, pos);
                            int skyLight = this.mc.field_1687.method_8314(class_1944.field_9284, pos);
                            if (blockLight < (Integer)this.minLightLevel.get() || blockLight <= skyLight) continue;
                            lightsToRender.add(pos);
                        }
                    }
                }
            }
        }
        this.renderLights(event, lightsToRender);
    }

    private void renderLights(Render3DEvent event, List<class_2338> lightPositions) {
        HashSet<class_2338> allLightPositions = new HashSet<class_2338>(lightPositions);
        for (class_2338 pos : lightPositions) {
            SettingColor lColor;
            SettingColor sColor;
            int lightLevel = this.mc.field_1687.method_8314(class_1944.field_9282, pos);
            if (lightLevel < 15 && !this.shouldRenderBlock(pos, allLightPositions)) continue;
            if (((Boolean)this.thermalColors.get()).booleanValue()) {
                float[] thermal = this.getThermalColor(lightLevel);
                sColor = new SettingColor((int)(thermal[0] * 255.0f), (int)(thermal[1] * 255.0f), (int)(thermal[2] * 255.0f), (int)(thermal[3] * 255.0f));
                lColor = new SettingColor((int)(thermal[0] * 255.0f), (int)(thermal[1] * 255.0f), (int)(thermal[2] * 255.0f), 255);
            } else {
                sColor = (SettingColor)this.sideColor.get();
                lColor = (SettingColor)this.lineColor.get();
            }
            event.renderer.box(pos, (Color)sColor, (Color)lColor, (ShapeMode)this.shapeMode.get(), 0);
        }
    }

    private boolean shouldRenderBlock(class_2338 pos, Set<class_2338> allLightPositions) {
        return !allLightPositions.contains(pos.method_10074()) || !allLightPositions.contains(pos.method_10084()) || !allLightPositions.contains(pos.method_10095()) || !allLightPositions.contains(pos.method_10072()) || !allLightPositions.contains(pos.method_10067()) || !allLightPositions.contains(pos.method_10078());
    }

    private float[] getThermalColor(int lightLevel) {
        float[] color = new float[4];
        color[3] = lightLevel <= 5 ? 0.25f + (float)lightLevel / 5.0f * 0.25f : (lightLevel <= 10 ? 0.3f + (float)(lightLevel - 5) / 5.0f * 0.3f : (lightLevel <= 14 ? 0.5f + (float)(lightLevel - 10) / 4.0f * 0.35f : 1.0f));
        if (lightLevel <= 5) {
            float intensity = (float)lightLevel / 5.0f;
            color[0] = intensity * 0.4f;
            color[1] = intensity * 0.4f;
            color[2] = intensity * 0.4f;
        } else if (lightLevel <= 10) {
            float intensity = (float)(lightLevel - 5) / 5.0f;
            color[0] = 0.7f + intensity * 0.3f;
            color[1] = intensity * 0.6f;
            color[2] = intensity * 0.1f;
        } else if (lightLevel <= 14) {
            float intensity = (float)(lightLevel - 10) / 4.0f;
            color[0] = 1.0f;
            color[1] = 0.7f + intensity * 0.25f;
            color[2] = 0.2f + intensity * 0.3f;
        } else {
            color[0] = 1.0f;
            color[1] = 1.0f;
            color[2] = 1.0f;
        }
        return color;
    }

    private void optimizeWeakLights() {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return;
        }
        this.clearOldCacheEntries();
        class_1923 playerChunkPos = this.mc.field_1724.method_31476();
        HashSet<class_2338> weakLightSources = new HashSet<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        int radius = (Integer)this.chunkRadius.get();
        for (int chunkX = playerChunkPos.field_9181 - radius; chunkX <= playerChunkPos.field_9181 + radius; ++chunkX) {
            for (int chunkZ = playerChunkPos.field_9180 - radius; chunkZ <= playerChunkPos.field_9180 + radius; ++chunkZ) {
                class_2818 chunk = this.mc.field_1687.method_8497(chunkX, chunkZ);
                if (chunk == null || !chunk.method_12009().method_12165(class_2806.field_12803)) continue;
                int startX = chunkX * 16;
                int startZ = chunkZ * 16;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = ((Integer)this.minY.get()).intValue(); y <= (Integer)this.maxY.get(); ++y) {
                            class_2338 pos = new class_2338(startX + x, y, startZ + z);
                            int blockLight = this.mc.field_1687.method_8314(class_1944.field_9282, pos);
                            int skyLight = this.mc.field_1687.method_8314(class_1944.field_9284, pos);
                            if (blockLight != 6 && blockLight != 7 || blockLight <= skyLight) continue;
                            weakLightSources.add(pos);
                        }
                    }
                }
            }
        }
        for (class_2338 weakSource : weakLightSources) {
            int sourceLevel;
            int requiredLevel;
            if (visited.contains(weakSource) || this.hasHigherLevelLightIn3x3Area(weakSource, requiredLevel = (sourceLevel = this.mc.field_1687.method_8314(class_1944.field_9282, weakSource)) + 1)) continue;
            this.propagateDeletionWithLevelFilter(weakSource, visited, sourceLevel);
        }
    }

    private boolean hasHigherLevelLightIn3x3Area(class_2338 centerPos, int requiredLevel) {
        for (int x = centerPos.method_10263() - 1; x <= centerPos.method_10263() + 1; ++x) {
            for (int y = Math.max((Integer)this.minY.get(), centerPos.method_10264() - 1); y <= Math.min((Integer)this.maxY.get(), centerPos.method_10264() + 1); ++y) {
                for (int z = centerPos.method_10260() - 1; z <= centerPos.method_10260() + 1; ++z) {
                    if (x == centerPos.method_10263() && y == centerPos.method_10264() && z == centerPos.method_10260()) continue;
                    class_2338 checkPos = new class_2338(x, y, z);
                    int blockLight = this.mc.field_1687.method_8314(class_1944.field_9282, checkPos);
                    int skyLight = this.mc.field_1687.method_8314(class_1944.field_9284, checkPos);
                    if (blockLight < requiredLevel || blockLight <= skyLight) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void propagateDeletionWithLevelFilter(class_2338 startPos, Set<class_2338> visited, int maxLevel) {
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(startPos);
        visited.add(startPos);
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            this.blocksToSkip.add(current);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        class_2338 neighbor;
                        if (dx == 0 && dy == 0 && dz == 0 || Math.abs(dx) + Math.abs(dy) + Math.abs(dz) > 1 || visited.contains(neighbor = current.method_10069(dx, dy, dz)) || this.blocksToSkip.contains(neighbor)) continue;
                        int neighborLight = this.mc.field_1687.method_8314(class_1944.field_9282, neighbor);
                        int neighborSkyLight = this.mc.field_1687.method_8314(class_1944.field_9284, neighbor);
                        if (neighborLight < (Integer)this.minLightLevel.get() || neighborLight <= neighborSkyLight || neighborLight > maxLevel) continue;
                        visited.add(neighbor);
                        queue.add(neighbor);
                    }
                }
            }
        }
    }

    private void clearOldCacheEntries() {
        if (this.mc.field_1724 == null) {
            this.blocksToSkip.clear();
            return;
        }
        class_1923 playerChunk = this.mc.field_1724.method_31476();
        this.blocksToSkip.removeIf(pos -> {
            class_1923 posChunk = new class_1923(pos);
            return Math.abs(posChunk.field_9181 - playerChunk.field_9181) > 3 || Math.abs(posChunk.field_9180 - playerChunk.field_9180) > 3;
        });
    }
}

