/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;

public class PistonESP
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<SettingColor> pistonColor;
    private final Setting<SettingColor> stickyPistonColor;
    private final Setting<ShapeMode> pistonShapeMode;
    private final Setting<Boolean> tracers;
    private final Setting<SettingColor> tracerColor;
    private final Setting<Boolean> pistonChat;
    private final SettingGroup sgFiltering;
    private final Setting<Boolean> includeRegularPistons;
    private final Setting<Boolean> includeStickyPistons;
    private final Setting<Boolean> includeExtendedPistons;
    private final SettingGroup sgRange;
    private final Setting<Integer> minY;
    private final Setting<Integer> maxY;
    private final SettingGroup sgThreading;
    private final Setting<Boolean> useThreading;
    private final Setting<Integer> threadPoolSize;
    private final Setting<Boolean> limitChatSpam;
    private final Set<class_2338> regularPistonPositions;
    private final Set<class_2338> stickyPistonPositions;
    private final Set<class_2338> pistonHeadPositions;
    private ExecutorService threadPool;

    public PistonESP() {
        super(GlazedAddon.esp, "PistonESP", "ESP for pistons and sticky pistons with threading and tracer support.");
        this.sgGeneral = this.settings.createGroup("General");
        this.pistonColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("piston-color")).description("Regular piston box color")).defaultValue(new SettingColor(255, 100, 100, 100)).build());
        this.stickyPistonColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("sticky-piston-color")).description("Sticky piston box color")).defaultValue(new SettingColor(100, 255, 100, 100)).build());
        this.pistonShapeMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("Piston box render mode")).defaultValue((Object)ShapeMode.Both)).build());
        this.tracers = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tracers")).description("Draw tracers to pistons")).defaultValue((Object)false)).build());
        this.tracerColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("Piston tracer color")).defaultValue(new SettingColor(255, 255, 255, 200)).visible(() -> this.tracers.get())).build());
        this.pistonChat = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-feedback")).description("Announce pistons in chat")).defaultValue((Object)true)).build());
        this.sgFiltering = this.settings.createGroup("Piston Types");
        this.includeRegularPistons = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("regular-pistons")).description("Include regular pistons")).defaultValue((Object)true)).build());
        this.includeStickyPistons = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sticky-pistons")).description("Include sticky pistons")).defaultValue((Object)true)).build());
        this.includeExtendedPistons = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("extended-pistons")).description("Include extended piston heads")).defaultValue((Object)false)).build());
        this.sgRange = this.settings.createGroup("Range");
        this.minY = this.sgRange.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-y")).description("Minimum Y level to scan for pistons")).defaultValue((Object)-64)).min(-64).max(128).sliderRange(-64, 128).build());
        this.maxY = this.sgRange.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-y")).description("Maximum Y level to scan for pistons")).defaultValue((Object)320)).min(-64).max(320).sliderRange(-64, 320).build());
        this.sgThreading = this.settings.createGroup("Threading");
        this.useThreading = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-threading")).description("Use multi-threading for chunk scanning (better performance)")).defaultValue((Object)true)).build());
        this.threadPoolSize = this.sgThreading.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("thread-pool-size")).description("Number of threads to use for scanning")).defaultValue((Object)2)).min(1).max(8).sliderRange(1, 8).visible(() -> this.useThreading.get())).build());
        this.limitChatSpam = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("limit-chat-spam")).description("Reduce chat spam when using threading")).defaultValue((Object)true)).visible(() -> this.useThreading.get())).build());
        this.regularPistonPositions = ConcurrentHashMap.newKeySet();
        this.stickyPistonPositions = ConcurrentHashMap.newKeySet();
        this.pistonHeadPositions = ConcurrentHashMap.newKeySet();
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            this.threadPool = Executors.newFixedThreadPool((Integer)this.threadPoolSize.get());
        }
        this.regularPistonPositions.clear();
        this.stickyPistonPositions.clear();
        this.pistonHeadPositions.clear();
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.threadPool.submit(() -> this.scanChunkForPistons(worldChunk));
            }
        } else {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.scanChunkForPistons(worldChunk);
            }
        }
    }

    public void onDeactivate() {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            this.threadPool = null;
        }
        this.regularPistonPositions.clear();
        this.stickyPistonPositions.clear();
        this.pistonHeadPositions.clear();
    }

    @EventHandler
    private void onChunkLoad(ChunkDataEvent event) {
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(() -> this.scanChunkForPistons(event.chunk()));
        } else {
            this.scanChunkForPistons(event.chunk());
        }
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        class_2338 pos = event.pos;
        class_2680 state = event.newState;
        Runnable updateTask = () -> {
            PistonType pistonType = this.getPistonType(state, pos.method_10264());
            this.regularPistonPositions.remove(pos);
            this.stickyPistonPositions.remove(pos);
            this.pistonHeadPositions.remove(pos);
            if (pistonType != PistonType.NONE) {
                boolean wasAdded = false;
                String blockType = "";
                switch (pistonType.ordinal()) {
                    case 1: {
                        wasAdded = this.regularPistonPositions.add(pos);
                        blockType = "Regular Piston";
                        break;
                    }
                    case 2: {
                        wasAdded = this.stickyPistonPositions.add(pos);
                        blockType = "Sticky Piston";
                        break;
                    }
                    case 3: {
                        wasAdded = this.pistonHeadPositions.add(pos);
                        blockType = "Piston Head";
                    }
                }
                if (wasAdded && ((Boolean)this.pistonChat.get()).booleanValue() && (!((Boolean)this.useThreading.get()).booleanValue() || !((Boolean)this.limitChatSpam.get()).booleanValue())) {
                    this.info("\u00a7c[\u00a76Piston ESP\u00a7c] \u00a76" + blockType + " at " + pos.method_23854(), new Object[0]);
                }
            }
        };
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(updateTask);
        } else {
            updateTask.run();
        }
    }

    private void scanChunkForPistons(class_2818 chunk) {
        class_1923 cpos = chunk.method_12004();
        int xStart = cpos.method_8326();
        int zStart = cpos.method_8328();
        int yMin = Math.max(chunk.method_31607(), (Integer)this.minY.get());
        int yMax = Math.min(chunk.method_31607() + chunk.method_31605(), (Integer)this.maxY.get());
        HashSet<class_2338> chunkRegularPistons = new HashSet<class_2338>();
        HashSet<class_2338> chunkStickyPistons = new HashSet<class_2338>();
        HashSet<class_2338> chunkPistonHeads = new HashSet<class_2338>();
        int foundCount = 0;
        for (int x = xStart; x < xStart + 16; ++x) {
            for (int z = zStart; z < zStart + 16; ++z) {
                for (int y = yMin; y < yMax; ++y) {
                    class_2338 pos2 = new class_2338(x, y, z);
                    class_2680 state = chunk.method_8320(pos2);
                    PistonType pistonType = this.getPistonType(state, y);
                    if (pistonType == PistonType.NONE) continue;
                    switch (pistonType.ordinal()) {
                        case 1: {
                            chunkRegularPistons.add(pos2);
                            break;
                        }
                        case 2: {
                            chunkStickyPistons.add(pos2);
                            break;
                        }
                        case 3: {
                            chunkPistonHeads.add(pos2);
                        }
                    }
                    ++foundCount;
                }
            }
        }
        this.regularPistonPositions.removeIf(pos -> {
            class_1923 blockChunk = new class_1923(pos);
            return blockChunk.equals((Object)cpos) && !chunkRegularPistons.contains(pos);
        });
        this.stickyPistonPositions.removeIf(pos -> {
            class_1923 blockChunk = new class_1923(pos);
            return blockChunk.equals((Object)cpos) && !chunkStickyPistons.contains(pos);
        });
        this.pistonHeadPositions.removeIf(pos -> {
            class_1923 blockChunk = new class_1923(pos);
            return blockChunk.equals((Object)cpos) && !chunkPistonHeads.contains(pos);
        });
        int newBlocks = 0;
        for (class_2338 pos3 : chunkRegularPistons) {
            if (!this.regularPistonPositions.add(pos3)) continue;
            ++newBlocks;
        }
        for (class_2338 pos4 : chunkStickyPistons) {
            if (!this.stickyPistonPositions.add(pos4)) continue;
            ++newBlocks;
        }
        for (class_2338 pos5 : chunkPistonHeads) {
            if (!this.pistonHeadPositions.add(pos5)) continue;
            ++newBlocks;
        }
        if (((Boolean)this.pistonChat.get()).booleanValue() && foundCount > 0) {
            if (((Boolean)this.useThreading.get()).booleanValue() && ((Boolean)this.limitChatSpam.get()).booleanValue()) {
                if (newBlocks > 0) {
                    this.info("\u00a7c[\u00a76Piston ESP\u00a7c] \u00a76Chunk " + cpos.field_9181 + "," + cpos.field_9180 + "\u00a7c: \u00a76" + newBlocks + " new pistons found", new Object[0]);
                }
            } else {
                for (class_2338 pos6 : chunkRegularPistons) {
                    if (this.regularPistonPositions.contains(pos6)) continue;
                    this.info("\u00a7c[\u00a76Piston ESP\u00a7c] \u00a76Regular Piston at " + pos6.method_23854(), new Object[0]);
                }
                for (class_2338 pos7 : chunkStickyPistons) {
                    if (this.stickyPistonPositions.contains(pos7)) continue;
                    this.info("\u00a7c[\u00a76Piston ESP\u00a7c] \u00a76Sticky Piston at " + pos7.method_23854(), new Object[0]);
                }
                for (class_2338 pos8 : chunkPistonHeads) {
                    if (this.pistonHeadPositions.contains(pos8)) continue;
                    this.info("\u00a7c[\u00a76Piston ESP\u00a7c] \u00a76Piston Head at " + pos8.method_23854(), new Object[0]);
                }
            }
        }
    }

    private PistonType getPistonType(class_2680 state, int y) {
        if (y < (Integer)this.minY.get() || y > (Integer)this.maxY.get()) {
            return PistonType.NONE;
        }
        if (((Boolean)this.includeRegularPistons.get()).booleanValue() && state.method_27852(class_2246.field_10560)) {
            return PistonType.REGULAR_PISTON;
        }
        if (((Boolean)this.includeStickyPistons.get()).booleanValue() && state.method_27852(class_2246.field_10615)) {
            return PistonType.STICKY_PISTON;
        }
        if (((Boolean)this.includeExtendedPistons.get()).booleanValue() && state.method_27852(class_2246.field_10379)) {
            return PistonType.PISTON_HEAD;
        }
        return PistonType.NONE;
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_243 playerPos = this.mc.field_1724.method_30950(event.tickDelta);
        Color regularPistonSide = new Color((Color)this.pistonColor.get());
        Color regularPistonOutline = new Color((Color)this.pistonColor.get());
        Color stickyPistonSide = new Color((Color)this.stickyPistonColor.get());
        Color stickyPistonOutline = new Color((Color)this.stickyPistonColor.get());
        Color tracerColorValue = new Color((Color)this.tracerColor.get());
        int renderDistance = (Integer)this.mc.field_1690.method_42503().method_41753() * 16;
        for (class_2338 pos : this.regularPistonPositions) {
            if (!this.isWithinRenderDistance(playerPos, pos, renderDistance)) continue;
            event.renderer.box(pos, regularPistonSide, regularPistonOutline, (ShapeMode)this.pistonShapeMode.get(), 0);
            if (!((Boolean)this.tracers.get()).booleanValue()) continue;
            this.renderTracer(event, playerPos, pos, tracerColorValue);
        }
        for (class_2338 pos : this.stickyPistonPositions) {
            if (!this.isWithinRenderDistance(playerPos, pos, renderDistance)) continue;
            event.renderer.box(pos, stickyPistonSide, stickyPistonOutline, (ShapeMode)this.pistonShapeMode.get(), 0);
            if (!((Boolean)this.tracers.get()).booleanValue()) continue;
            this.renderTracer(event, playerPos, pos, tracerColorValue);
        }
        Color pistonHeadSide = new Color((((SettingColor)this.pistonColor.get()).r + ((SettingColor)this.stickyPistonColor.get()).r) / 2, (((SettingColor)this.pistonColor.get()).g + ((SettingColor)this.stickyPistonColor.get()).g) / 2, (((SettingColor)this.pistonColor.get()).b + ((SettingColor)this.stickyPistonColor.get()).b) / 2, ((SettingColor)this.pistonColor.get()).a);
        Color pistonHeadOutline = new Color(pistonHeadSide);
        for (class_2338 pos : this.pistonHeadPositions) {
            if (!this.isWithinRenderDistance(playerPos, pos, renderDistance)) continue;
            event.renderer.box(pos, pistonHeadSide, pistonHeadOutline, (ShapeMode)this.pistonShapeMode.get(), 0);
            if (!((Boolean)this.tracers.get()).booleanValue()) continue;
            this.renderTracer(event, playerPos, pos, tracerColorValue);
        }
    }

    private boolean isWithinRenderDistance(class_243 playerPos, class_2338 blockPos, int renderDistance) {
        double dz;
        double dx = playerPos.field_1352 - (double)blockPos.method_10263() - 0.5;
        double horizontalDistance = Math.sqrt(dx * dx + (dz = playerPos.field_1350 - (double)blockPos.method_10260() - 0.5) * dz);
        return horizontalDistance <= (double)renderDistance;
    }

    private void renderTracer(Render3DEvent event, class_243 playerPos, class_2338 pos, Color tracerColorValue) {
        class_243 startPos;
        class_243 blockCenter = class_243.method_24953((class_2382)pos);
        if (this.mc.field_1690.method_31044().method_31034()) {
            class_243 lookDirection = this.mc.field_1724.method_5720();
            startPos = new class_243(playerPos.field_1352 + lookDirection.field_1352 * 0.5, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()) + lookDirection.field_1351 * 0.5, playerPos.field_1350 + lookDirection.field_1350 * 0.5);
        } else {
            startPos = new class_243(playerPos.field_1352, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), playerPos.field_1350);
        }
        event.renderer.line(startPos.field_1352, startPos.field_1351, startPos.field_1350, blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350, tracerColorValue);
    }

    private static enum PistonType {
        NONE,
        REGULAR_PISTON,
        STICKY_PISTON,
        PISTON_HEAD;

    }
}

