/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.List;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_243;
import net.minecraft.class_5498;
import net.minecraft.class_742;

public class SkeletonESP
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<SettingColor> color;
    private final Setting<Boolean> distanceColors;
    private final Setting<Double> verticalOffset;
    private final Setting<Double> forwardOffset;
    private final Setting<Double> horizontalOffset;

    public SkeletonESP() {
        super(GlazedAddon.esp, "skeleton-esp", "Renders player skeletons inside players with correct offsets & rotation (no legs).");
        this.sgGeneral = this.settings.createGroup("General");
        this.color = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("color")).description("Color of the skeleton ESP")).defaultValue(new SettingColor(255, 255, 255, 255)).build());
        this.distanceColors = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("distance-colors")).description("Change skeleton color based on distance")).defaultValue((Object)false)).build());
        this.verticalOffset = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("vertical-offset")).description("Fixed vertical offset for skeleton placement.")).defaultValue(1.35).min(1.0).max(1.6).sliderRange(1.0, 1.6).build());
        this.forwardOffset = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("forward-offset")).description("Forward/back offset of skeleton from chest center.")).defaultValue(0.0).min(-0.3).max(0.3).sliderRange(-0.3, 0.3).build());
        this.horizontalOffset = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("horizontal-offset")).description("Horizontal width of shoulders/arms.")).defaultValue(0.25).min(0.0).max(0.5).sliderRange(0.0, 0.5).build());
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        List players = this.mc.field_1687.method_18456();
        for (class_742 player : players) {
            if (this.mc.field_1690.method_31044() == class_5498.field_26664 && player == this.mc.field_1724) continue;
            class_243 basePos = player.method_30950(event.tickDelta);
            Color skeletonColor = (Boolean)this.distanceColors.get() != false ? this.getColorFromDistance(basePos) : new Color((Color)this.color.get());
            double yawRad = Math.toRadians(-player.field_6283);
            class_243 chestBase = basePos.method_1031(0.0, ((Double)this.verticalOffset.get()).doubleValue(), 0.0);
            if (player.method_5715()) {
                chestBase = chestBase.method_1031(0.0, -0.2, 0.0);
            }
            class_243 forwardVec = new class_243(0.0, 0.0, ((Double)this.forwardOffset.get()).doubleValue()).method_1024((float)yawRad);
            chestBase = chestBase.method_1019(forwardVec);
            class_243 leftShoulder = chestBase.method_1019(new class_243(-((Double)this.horizontalOffset.get()).doubleValue(), 0.0, 0.0).method_1024((float)yawRad));
            class_243 rightShoulder = chestBase.method_1019(new class_243(((Double)this.horizontalOffset.get()).doubleValue(), 0.0, 0.0).method_1024((float)yawRad));
            class_243 leftArmEnd = leftShoulder.method_1031(0.0, -0.6, 0.0);
            class_243 rightArmEnd = rightShoulder.method_1031(0.0, -0.6, 0.0);
            class_243 spineStart = basePos.method_1019(forwardVec);
            class_243 spineEnd = chestBase;
            class_243 headTop = chestBase.method_1031(0.0, 0.25, 0.0);
            event.renderer.line(spineStart.field_1352, spineStart.field_1351, spineStart.field_1350, spineEnd.field_1352, spineEnd.field_1351, spineEnd.field_1350, skeletonColor);
            event.renderer.line(leftShoulder.field_1352, leftShoulder.field_1351, leftShoulder.field_1350, rightShoulder.field_1352, rightShoulder.field_1351, rightShoulder.field_1350, skeletonColor);
            event.renderer.line(leftShoulder.field_1352, leftShoulder.field_1351, leftShoulder.field_1350, leftArmEnd.field_1352, leftArmEnd.field_1351, leftArmEnd.field_1350, skeletonColor);
            event.renderer.line(rightShoulder.field_1352, rightShoulder.field_1351, rightShoulder.field_1350, rightArmEnd.field_1352, rightArmEnd.field_1351, rightArmEnd.field_1350, skeletonColor);
            event.renderer.line(spineEnd.field_1352, spineEnd.field_1351, spineEnd.field_1350, headTop.field_1352, headTop.field_1351, headTop.field_1350, skeletonColor);
        }
    }

    private Color getColorFromDistance(class_243 pos) {
        int g;
        int r;
        double distance = this.mc.field_1724.method_19538().method_1022(pos);
        double percent = Math.min(1.0, distance / 60.0);
        if (percent < 0.33) {
            r = (int)(percent / 0.33 * 255.0);
            g = 255;
        } else if (percent < 0.66) {
            r = 255;
            g = 255 - (int)((percent - 0.33) / 0.33 * 90.0);
        } else {
            r = 255;
            g = 165 - (int)((percent - 0.66) / 0.34 * 165.0);
        }
        return new Color(r, g, 0, 255);
    }
}

