/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3830;

public class SweetBerryESP
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<SettingColor> berryColor;
    private final Setting<ShapeMode> berryShapeMode;
    private final Setting<Boolean> tracers;
    private final Setting<SettingColor> tracerColor;
    private final Setting<Boolean> berryChat;
    private final SettingGroup sgFiltering;
    private final Setting<Boolean> includeAge0;
    private final Setting<Boolean> includeAge1;
    private final Setting<Boolean> includeAge2;
    private final Setting<Boolean> includeAge3;
    private final SettingGroup sgRange;
    private final Setting<Integer> minY;
    private final Setting<Integer> maxY;
    private final SettingGroup sgThreading;
    private final Setting<Boolean> useThreading;
    private final Setting<Integer> threadPoolSize;
    private final Setting<Boolean> limitChatSpam;
    private final Set<class_2338> berryPositions;
    private ExecutorService threadPool;

    public SweetBerryESP() {
        super(GlazedAddon.esp, "SweetBerryESP", "ESP for sweet berry bushes at specific growth ages with threading and tracer support.");
        this.sgGeneral = this.settings.createGroup("General");
        this.berryColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("berry-color")).description("Sweet berry bush box color")).defaultValue(new SettingColor(220, 20, 60, 100)).build());
        this.berryShapeMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("Sweet berry bush box render mode")).defaultValue((Object)ShapeMode.Both)).build());
        this.tracers = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tracers")).description("Draw tracers to sweet berry bushes")).defaultValue((Object)false)).build());
        this.tracerColor = this.sgGeneral.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("tracer-color")).description("Sweet berry bush tracer color")).defaultValue(new SettingColor(220, 20, 60, 200)).visible(() -> this.tracers.get())).build());
        this.berryChat = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-feedback")).description("Announce sweet berry bushes in chat")).defaultValue((Object)true)).build());
        this.sgFiltering = this.settings.createGroup("Berry Ages");
        this.includeAge0 = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("age-0")).description("Include age 0 berry bushes (just planted)")).defaultValue((Object)false)).build());
        this.includeAge1 = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("age-1")).description("Include age 1 berry bushes (growing)")).defaultValue((Object)false)).build());
        this.includeAge2 = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("age-2")).description("Include age 2 berry bushes (harvestable - few berries)")).defaultValue((Object)true)).build());
        this.includeAge3 = this.sgFiltering.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("age-3")).description("Include age 3 berry bushes (fully grown - many berries)")).defaultValue((Object)true)).build());
        this.sgRange = this.settings.createGroup("Range");
        this.minY = this.sgRange.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("min-y")).description("Minimum Y level to scan for sweet berry bushes")).defaultValue((Object)50)).min(-64).max(128).sliderRange(-64, 128).build());
        this.maxY = this.sgRange.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("max-y")).description("Maximum Y level to scan for sweet berry bushes")).defaultValue((Object)128)).min(-64).max(320).sliderRange(-64, 320).build());
        this.sgThreading = this.settings.createGroup("Threading");
        this.useThreading = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-threading")).description("Use multi-threading for chunk scanning (better performance)")).defaultValue((Object)true)).build());
        this.threadPoolSize = this.sgThreading.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("thread-pool-size")).description("Number of threads to use for scanning")).defaultValue((Object)2)).min(1).max(8).sliderRange(1, 8).visible(() -> this.useThreading.get())).build());
        this.limitChatSpam = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("limit-chat-spam")).description("Reduce chat spam when using threading")).defaultValue((Object)true)).visible(() -> this.useThreading.get())).build());
        this.berryPositions = ConcurrentHashMap.newKeySet();
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            this.threadPool = Executors.newFixedThreadPool((Integer)this.threadPoolSize.get());
        }
        this.berryPositions.clear();
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.threadPool.submit(() -> this.scanChunkForBerries(worldChunk));
            }
        } else {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.scanChunkForBerries(worldChunk);
            }
        }
    }

    public void onDeactivate() {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            this.threadPool = null;
        }
        this.berryPositions.clear();
    }

    @EventHandler
    private void onChunkLoad(ChunkDataEvent event) {
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(() -> this.scanChunkForBerries(event.chunk()));
        } else {
            this.scanChunkForBerries(event.chunk());
        }
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        class_2338 pos = event.pos;
        class_2680 state = event.newState;
        Runnable updateTask = () -> {
            boolean isBerry = this.isSweetBerryBush(state, pos.method_10264());
            if (isBerry) {
                boolean wasAdded = this.berryPositions.add(pos);
                if (wasAdded && ((Boolean)this.berryChat.get()).booleanValue() && (!((Boolean)this.useThreading.get()).booleanValue() || !((Boolean)this.limitChatSpam.get()).booleanValue())) {
                    int age = this.getBerryAge(state);
                    String ageDescription = this.getBerryAgeDescription(age);
                    this.info("\u00a7c[\u00a76Sweet Berry ESP\u00a7c] \u00a76" + ageDescription + " at " + pos.method_23854(), new Object[0]);
                }
            } else {
                this.berryPositions.remove(pos);
            }
        };
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(updateTask);
        } else {
            updateTask.run();
        }
    }

    private void scanChunkForBerries(class_2818 chunk) {
        class_1923 cpos = chunk.method_12004();
        int xStart = cpos.method_8326();
        int zStart = cpos.method_8328();
        int yMin = Math.max(chunk.method_31607(), (Integer)this.minY.get());
        int yMax = Math.min(chunk.method_31607() + chunk.method_31605(), (Integer)this.maxY.get());
        HashSet<class_2338> chunkBerries = new HashSet<class_2338>();
        int foundCount = 0;
        for (int x = xStart; x < xStart + 16; ++x) {
            for (int z = zStart; z < zStart + 16; ++z) {
                for (int y = yMin; y < yMax; ++y) {
                    class_2338 pos2 = new class_2338(x, y, z);
                    class_2680 state = chunk.method_8320(pos2);
                    if (!this.isSweetBerryBush(state, y)) continue;
                    chunkBerries.add(pos2);
                    ++foundCount;
                }
            }
        }
        this.berryPositions.removeIf(pos -> {
            class_1923 blockChunk = new class_1923(pos);
            return blockChunk.equals((Object)cpos) && !chunkBerries.contains(pos);
        });
        int newBlocks = 0;
        for (class_2338 pos3 : chunkBerries) {
            if (!this.berryPositions.add(pos3)) continue;
            ++newBlocks;
        }
        if (((Boolean)this.berryChat.get()).booleanValue() && foundCount > 0) {
            if (((Boolean)this.useThreading.get()).booleanValue() && ((Boolean)this.limitChatSpam.get()).booleanValue()) {
                if (newBlocks > 0) {
                    this.info("\u00a7c[\u00a76Sweet Berry ESP\u00a7c] \u00a76Chunk " + cpos.field_9181 + "," + cpos.field_9180 + "\u00a7c: \u00a76" + newBlocks + " new berry bushes found", new Object[0]);
                }
            } else {
                for (class_2338 pos4 : chunkBerries) {
                    if (this.berryPositions.contains(pos4)) continue;
                    class_2680 state = chunk.method_8320(pos4);
                    int age = this.getBerryAge(state);
                    String ageDescription = this.getBerryAgeDescription(age);
                    this.info("\u00a7c[\u00a76Sweet Berry ESP\u00a7c] \u00a76" + ageDescription + " at " + pos4.method_23854(), new Object[0]);
                }
            }
        }
    }

    private boolean isSweetBerryBush(class_2680 state, int y) {
        if (y < (Integer)this.minY.get() || y > (Integer)this.maxY.get()) {
            return false;
        }
        if (!state.method_27852(class_2246.field_16999)) {
            return false;
        }
        int age = this.getBerryAge(state);
        if (((Boolean)this.includeAge0.get()).booleanValue() && age == 0) {
            return true;
        }
        if (((Boolean)this.includeAge1.get()).booleanValue() && age == 1) {
            return true;
        }
        if (((Boolean)this.includeAge2.get()).booleanValue() && age == 2) {
            return true;
        }
        return (Boolean)this.includeAge3.get() != false && age == 3;
    }

    private int getBerryAge(class_2680 state) {
        if (state.method_27852(class_2246.field_16999)) {
            return (Integer)state.method_11654((class_2769)class_3830.field_17000);
        }
        return -1;
    }

    private String getBerryAgeDescription(int age) {
        switch (age) {
            case 0: {
                return "Planted Berry Bush (Age 0)";
            }
            case 1: {
                return "Growing Berry Bush (Age 1)";
            }
            case 2: {
                return "Harvestable Berry Bush (Age 2)";
            }
            case 3: {
                return "Fully Grown Berry Bush (Age 3)";
            }
        }
        return "Sweet Berry Bush";
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_243 playerPos = this.mc.field_1724.method_30950(event.tickDelta);
        Color side = new Color((Color)this.berryColor.get());
        Color outline = new Color((Color)this.berryColor.get());
        Color tracerColorValue = new Color((Color)this.tracerColor.get());
        int renderDistance = (Integer)this.mc.field_1690.method_42503().method_41753() * 16;
        for (class_2338 pos : this.berryPositions) {
            class_243 startPos;
            Color ageAdjustedSide;
            if (!this.isWithinRenderDistance(playerPos, pos, renderDistance)) continue;
            class_2680 state = this.mc.field_1687.method_8320(pos);
            int age = this.getBerryAge(state);
            event.renderer.box(pos, ageAdjustedSide, switch (age) {
                case 0 -> {
                    ageAdjustedSide = new Color(side.r / 4, side.g / 4, side.b / 4, side.a);
                    yield new Color(outline.r / 4, outline.g / 4, outline.b / 4, outline.a);
                }
                case 1 -> {
                    ageAdjustedSide = new Color(side.r / 2, side.g / 2, side.b / 2, side.a);
                    yield new Color(outline.r / 2, outline.g / 2, outline.b / 2, outline.a);
                }
                case 2 -> {
                    ageAdjustedSide = side;
                    yield outline;
                }
                case 3 -> {
                    ageAdjustedSide = new Color(Math.min(255, (int)((double)side.r * 1.2)), Math.min(255, (int)((double)side.g * 1.2)), Math.min(255, (int)((double)side.b * 1.2)), side.a);
                    yield new Color(Math.min(255, (int)((double)outline.r * 1.2)), Math.min(255, (int)((double)outline.g * 1.2)), Math.min(255, (int)((double)outline.b * 1.2)), outline.a);
                }
                default -> {
                    ageAdjustedSide = side;
                    yield outline;
                }
            }, (ShapeMode)this.berryShapeMode.get(), 0);
            if (!((Boolean)this.tracers.get()).booleanValue()) continue;
            class_243 blockCenter = class_243.method_24953((class_2382)pos);
            if (this.mc.field_1690.method_31044().method_31034()) {
                class_243 lookDirection = this.mc.field_1724.method_5720();
                startPos = new class_243(playerPos.field_1352 + lookDirection.field_1352 * 0.5, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()) + lookDirection.field_1351 * 0.5, playerPos.field_1350 + lookDirection.field_1350 * 0.5);
            } else {
                startPos = new class_243(playerPos.field_1352, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), playerPos.field_1350);
            }
            event.renderer.line(startPos.field_1352, startPos.field_1351, startPos.field_1350, blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350, tracerColorValue);
        }
    }

    private boolean isWithinRenderDistance(class_243 playerPos, class_2338 blockPos, int renderDistance) {
        double dz;
        double dx = playerPos.field_1352 - (double)blockPos.method_10263() - 0.5;
        double horizontalDistance = Math.sqrt(dx * dx + (dz = playerPos.field_1350 - (double)blockPos.method_10260() - 0.5) * dz);
        return horizontalDistance <= (double)renderDistance;
    }
}

