/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import com.nnpg.glazed.VersionUtil;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.MeteorToast;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_368;

public class VillagerESP
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final SettingGroup sgwebhook;
    private final Setting<DetectionMode> detectionMode;
    private final Setting<Boolean> showTracers;
    private final Setting<SettingColor> villagerTracerColor;
    private final Setting<SettingColor> zombieVillagerTracerColor;
    private final Setting<Boolean> enableWebhook;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;
    private final Setting<Boolean> enableDisconnect;
    private final Setting<Mode> notificationMode;
    private final Setting<Boolean> toggleOnFind;
    private final Set<Integer> detectedVillagers;
    private final HttpClient httpClient;

    public VillagerESP() {
        super(GlazedAddon.esp, "VillagerESP", "Detects villagers and zombie villagers in the world");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.sgwebhook = this.settings.createGroup("Webhook");
        this.detectionMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Detection Mode")).description("What type of villagers to detect")).defaultValue((Object)DetectionMode.Both)).build());
        this.showTracers = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Show Tracers")).description("Draw tracer lines to villagers")).defaultValue((Object)true)).build());
        this.villagerTracerColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("Villager Tracer Color")).description("Color of the tracer lines for regular villagers")).defaultValue(new SettingColor(0, 255, 0, 127)).visible(() -> (Boolean)this.showTracers.get() != false && (this.detectionMode.get() == DetectionMode.Villagers || this.detectionMode.get() == DetectionMode.Both))).build());
        this.zombieVillagerTracerColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("Zombie Villager Tracer Color")).description("Color of the tracer lines for zombie villagers")).defaultValue(new SettingColor(255, 0, 0, 127)).visible(() -> (Boolean)this.showTracers.get() != false && (this.detectionMode.get() == DetectionMode.ZombieVillagers || this.detectionMode.get() == DetectionMode.Both))).build());
        this.enableWebhook = this.sgwebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Webhook")).description("Send webhook notifications when villagers are detected")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgwebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Webhook URL")).description("Discord webhook URL")).defaultValue((Object)"")).visible(() -> this.enableWebhook.get())).build());
        this.selfPing = this.sgwebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Self Ping")).description("Ping yourself in the webhook message")).defaultValue((Object)false)).visible(() -> this.enableWebhook.get())).build());
        this.discordId = this.sgwebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Discord ID")).description("Your Discord user ID for pinging")).defaultValue((Object)"")).visible(() -> (Boolean)this.enableWebhook.get() != false && (Boolean)this.selfPing.get() != false)).build());
        this.enableDisconnect = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Disconnect")).description("Automatically disconnect when villagers are detected")).defaultValue((Object)false)).build());
        this.notificationMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("notification-mode")).description("How to notify when villagers are detected")).defaultValue((Object)Mode.Both)).build());
        this.toggleOnFind = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Toggle when found")).description("Automatically toggles the module when villagers are detected")).defaultValue((Object)false)).build());
        this.detectedVillagers = new HashSet<Integer>();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        HashSet<Integer> currentVillagers = new HashSet<Integer>();
        int villagerCount = 0;
        int zombieVillagerCount = 0;
        for (class_1297 entity : this.mc.field_1687.method_18112()) {
            boolean shouldDetect = false;
            Color tracerColor = null;
            if (entity instanceof class_1646 && (this.detectionMode.get() == DetectionMode.Villagers || this.detectionMode.get() == DetectionMode.Both)) {
                shouldDetect = true;
                tracerColor = new Color((Color)this.villagerTracerColor.get());
                ++villagerCount;
            } else if (entity instanceof class_1641 && (this.detectionMode.get() == DetectionMode.ZombieVillagers || this.detectionMode.get() == DetectionMode.Both)) {
                shouldDetect = true;
                tracerColor = new Color((Color)this.zombieVillagerTracerColor.get());
                ++zombieVillagerCount;
            }
            if (!shouldDetect) continue;
            currentVillagers.add(entity.method_5628());
            if (!((Boolean)this.showTracers.get()).booleanValue()) continue;
            double x = VersionUtil.getPrevX(entity) + (entity.method_23317() - VersionUtil.getPrevX(entity)) * (double)event.tickDelta;
            double y = VersionUtil.getPrevY(entity) + (entity.method_23318() - VersionUtil.getPrevY(entity)) * (double)event.tickDelta;
            double z = VersionUtil.getPrevZ(entity) + (entity.method_23321() - VersionUtil.getPrevZ(entity)) * (double)event.tickDelta;
            double height = entity.method_5829().field_1325 - entity.method_5829().field_1322;
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, x, y += height / 2.0, z, tracerColor);
        }
        if (!currentVillagers.isEmpty() && !currentVillagers.equals(this.detectedVillagers)) {
            HashSet newVillagers = new HashSet(currentVillagers);
            newVillagers.removeAll(this.detectedVillagers);
            if (!newVillagers.isEmpty()) {
                this.detectedVillagers.addAll(newVillagers);
                this.handleVillagerDetection(villagerCount, zombieVillagerCount);
            }
        } else if (currentVillagers.isEmpty()) {
            this.detectedVillagers.clear();
        }
    }

    private void handleVillagerDetection(int villagerCount, int zombieVillagerCount) {
        String message = this.buildDetectionMessage(villagerCount, zombieVillagerCount);
        switch (((Mode)((Object)this.notificationMode.get())).ordinal()) {
            case 0: {
                this.info("(highlight)%s", new Object[]{message});
                break;
            }
            case 1: {
                this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8687, this.title, message));
                break;
            }
            case 2: {
                this.info("(highlight)%s", new Object[]{message});
                this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8687, this.title, message));
            }
        }
        if (((Boolean)this.enableWebhook.get()).booleanValue()) {
            this.sendWebhookNotification(villagerCount, zombieVillagerCount);
        }
        if (((Boolean)this.toggleOnFind.get()).booleanValue()) {
            this.toggle();
        }
        if (((Boolean)this.enableDisconnect.get()).booleanValue()) {
            this.disconnectFromServer(message);
        }
    }

    private String buildDetectionMessage(int villagerCount, int zombieVillagerCount) {
        int totalCount = villagerCount + zombieVillagerCount;
        if (this.detectionMode.get() == DetectionMode.Villagers) {
            return villagerCount == 1 ? "Villager detected!" : String.format("%d villagers detected!", villagerCount);
        }
        if (this.detectionMode.get() == DetectionMode.ZombieVillagers) {
            return zombieVillagerCount == 1 ? "Zombie villager detected!" : String.format("%d zombie villagers detected!", zombieVillagerCount);
        }
        if (villagerCount > 0 && zombieVillagerCount > 0) {
            return String.format("%d villagers and %d zombie villagers detected!", villagerCount, zombieVillagerCount);
        }
        if (villagerCount > 0) {
            return villagerCount == 1 ? "Villager detected!" : String.format("%d villagers detected!", villagerCount);
        }
        return zombieVillagerCount == 1 ? "Zombie villager detected!" : String.format("%d zombie villagers detected!", zombieVillagerCount);
    }

    private void sendWebhookNotification(int villagerCount, int zombieVillagerCount) {
        String url = ((String)this.webhookUrl.get()).trim();
        if (url.isEmpty()) {
            this.warning("Webhook URL not configured!", new Object[0]);
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String serverInfo = this.mc.method_1558() != null ? this.mc.method_1558().field_3761 : "Unknown Server";
                String messageContent = "";
                if (((Boolean)this.selfPing.get()).booleanValue() && !((String)this.discordId.get()).trim().isEmpty()) {
                    messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
                }
                String description = this.buildDetectionMessage(villagerCount, zombieVillagerCount);
                String coordinates = "Unknown";
                if (this.mc.field_1724 != null) {
                    coordinates = String.format("X: %.0f, Y: %.0f, Z: %.0f", this.mc.field_1724.method_23317(), this.mc.field_1724.method_23318(), this.mc.field_1724.method_23321());
                }
                StringBuilder fieldsBuilder = new StringBuilder();
                fieldsBuilder.append(String.format("{\"name\":\"Server\",\"value\":\"%s\",\"inline\":true},", serverInfo.replace("\"", "\\\"")));
                if (villagerCount > 0) {
                    fieldsBuilder.append(String.format("{\"name\":\"Villagers\",\"value\":\"%d\",\"inline\":true},", villagerCount));
                }
                if (zombieVillagerCount > 0) {
                    fieldsBuilder.append(String.format("{\"name\":\"Zombie Villagers\",\"value\":\"%d\",\"inline\":true},", zombieVillagerCount));
                }
                fieldsBuilder.append(String.format("{\"name\":\"Coordinates\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Time\",\"value\":\"<t:%d:R>\",\"inline\":true}", coordinates.replace("\"", "\\\""), System.currentTimeMillis() / 1000L));
                String jsonPayload = String.format("{\"content\":\"%s\",\"username\":\"VillagerESP\",\"avatar_url\":\"https://i.imgur.com/OL2y1cr.png\",\"embeds\":[{\"title\":\"\ud83c\udfd8\ufe0f Villager Alert\",\"description\":\"%s\",\"color\":65280,\"thumbnail\":{\"url\":\"https://i.imgur.com/OL2y1cr.png\"},\"fields\":[%s],\"footer\":{\"text\":\"Sent by Overkill\"}}]}", messageContent.replace("\"", "\\\""), description.replace("\"", "\\\""), fieldsBuilder.toString());
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 204) {
                    this.info("Webhook notification sent successfully", new Object[0]);
                } else {
                    this.error("Webhook failed with status: " + response.statusCode(), new Object[0]);
                }
            }
            catch (IOException | InterruptedException e) {
                this.error("Failed to send webhook: " + e.getMessage(), new Object[0]);
            }
        });
    }

    private void disconnectFromServer(String reason) {
        if (this.mc.field_1687 != null && this.mc.method_1562() != null) {
            this.mc.method_1562().method_48296().method_10747((class_2561)class_2561.method_43470((String)reason));
            this.info("Disconnected from server - " + reason, new Object[0]);
        }
    }

    public void onActivate() {
        this.detectedVillagers.clear();
    }

    public void onDeactivate() {
        this.detectedVillagers.clear();
    }

    public String getInfoString() {
        return this.detectedVillagers.isEmpty() ? null : String.valueOf(this.detectedVillagers.size());
    }

    public static enum DetectionMode {
        Villagers("Villagers"),
        ZombieVillagers("Zombie Villagers"),
        Both("Both");

        private final String name;

        private DetectionMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Mode {
        Chat,
        Toast,
        Both;

    }
}

