/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.BlockUpdateEvent;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;

public class VineESP
extends Module {
    private final SettingGroup sgRender;
    private final SettingGroup sgRange;
    private final SettingGroup sgThreading;
    private final Setting<SettingColor> espColor;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<Boolean> showTracers;
    private final Setting<SettingColor> tracerColor;
    private final Setting<Boolean> chatFeedback;
    private final Setting<Integer> minVineLength;
    private final Setting<Integer> minY;
    private final Setting<Integer> maxY;
    private final Setting<Boolean> useThreading;
    private final Setting<Integer> threadPoolSize;
    private final Setting<Boolean> limitChatSpam;
    private final Set<class_2338> groundedVines;
    private ExecutorService threadPool;

    public VineESP() {
        super(GlazedAddon.esp, "Vine ESP", "ESP for vines that touch the ground.");
        this.sgRender = this.settings.getDefaultGroup();
        this.sgRange = this.settings.createGroup("Range");
        this.sgThreading = this.settings.createGroup("Threading");
        this.espColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("ESP Color")).description("Color for the ESP boxes")).defaultValue(new SettingColor(0, 255, 0, 100)).build());
        this.shapeMode = this.sgRender.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Shape Mode")).description("Rendering mode for the ESP boxes")).defaultValue((Object)ShapeMode.Both)).build());
        this.showTracers = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Show Tracers")).description("Draw tracer lines to grounded vines")).defaultValue((Object)true)).build());
        this.tracerColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("Tracer Color")).description("Color for the tracer lines")).defaultValue(new SettingColor(0, 255, 0, 200)).visible(() -> this.showTracers.get())).build());
        this.chatFeedback = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Chat Feedback")).description("Announce vine detections in chat")).defaultValue((Object)true)).build());
        this.minVineLength = this.sgRender.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Min Vine Length")).description("Minimum vine length to highlight")).defaultValue((Object)20)).min(15).max(35).sliderMax(35).build());
        this.minY = this.sgRange.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Min Y")).description("Minimum Y level to scan for vines")).defaultValue((Object)-64)).min(-64).max(128).sliderRange(-64, 128).build());
        this.maxY = this.sgRange.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Max Y")).description("Maximum Y level to scan for vines")).defaultValue((Object)320)).min(-64).max(320).sliderRange(-64, 320).build());
        this.useThreading = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable Threading")).description("Use multi-threading for chunk scanning (better performance)")).defaultValue((Object)true)).build());
        this.threadPoolSize = this.sgThreading.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("Thread Pool Size")).description("Number of threads to use for scanning")).defaultValue((Object)2)).min(1).max(8).sliderRange(1, 8).visible(() -> this.useThreading.get())).build());
        this.limitChatSpam = this.sgThreading.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Limit Chat Spam")).description("Reduce chat spam when using threading")).defaultValue((Object)true)).visible(() -> this.useThreading.get())).build());
        this.groundedVines = ConcurrentHashMap.newKeySet();
    }

    public void onActivate() {
        if (this.mc.field_1687 == null) {
            return;
        }
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            this.threadPool = Executors.newFixedThreadPool((Integer)this.threadPoolSize.get());
        }
        this.groundedVines.clear();
        if (((Boolean)this.useThreading.get()).booleanValue()) {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.threadPool.submit(() -> this.scanChunk(worldChunk));
            }
        } else {
            for (class_2791 chunk : Utils.chunks()) {
                if (!(chunk instanceof class_2818)) continue;
                class_2818 worldChunk = (class_2818)chunk;
                this.scanChunk(worldChunk);
            }
        }
    }

    public void onDeactivate() {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            this.threadPool = null;
        }
        this.groundedVines.clear();
    }

    @EventHandler
    private void onChunkLoad(ChunkDataEvent event) {
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(() -> this.scanChunk(event.chunk()));
        } else {
            this.scanChunk(event.chunk());
        }
    }

    @EventHandler
    private void onBlockUpdate(BlockUpdateEvent event) {
        class_2338 pos = event.pos;
        class_2680 state = event.newState;
        Runnable updateTask = () -> {
            boolean isGrounded = this.isGroundedVine(state, pos);
            if (isGrounded) {
                boolean wasAdded = this.groundedVines.add(pos);
                if (wasAdded && ((Boolean)this.chatFeedback.get()).booleanValue() && (!((Boolean)this.useThreading.get()).booleanValue() || !((Boolean)this.limitChatSpam.get()).booleanValue())) {
                    this.info("\u00a7aVineESP\u00a7f: Found vine at \u00a7a%s", new Object[]{pos.method_23854()});
                }
            } else {
                this.groundedVines.remove(pos);
            }
        };
        if (((Boolean)this.useThreading.get()).booleanValue() && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.submit(updateTask);
        } else {
            updateTask.run();
        }
    }

    private void scanChunk(class_2818 chunk) {
        class_1923 cpos = chunk.method_12004();
        int xStart = cpos.method_8326();
        int zStart = cpos.method_8328();
        int yMin = Math.max(chunk.method_31607(), (Integer)this.minY.get());
        int yMax = Math.min(chunk.method_31607() + chunk.method_31605(), (Integer)this.maxY.get());
        HashSet<class_2338> chunkVines = new HashSet<class_2338>();
        int foundCount = 0;
        for (int x = xStart; x < xStart + 16; ++x) {
            for (int z = zStart; z < zStart + 16; ++z) {
                for (int y = yMin; y < yMax; ++y) {
                    class_2338 pos2 = new class_2338(x, y, z);
                    class_2680 state = chunk.method_8320(pos2);
                    if (!this.isGroundedVineChunk(chunk, pos2)) continue;
                    chunkVines.add(pos2);
                    ++foundCount;
                }
            }
        }
        this.groundedVines.removeIf(pos -> {
            class_1923 blockChunk = new class_1923(pos);
            return blockChunk.equals((Object)cpos) && !chunkVines.contains(pos);
        });
        int newVines = 0;
        for (class_2338 pos3 : chunkVines) {
            if (!this.groundedVines.add(pos3)) continue;
            ++newVines;
        }
        if (((Boolean)this.chatFeedback.get()).booleanValue() && foundCount > 0) {
            if (((Boolean)this.useThreading.get()).booleanValue() && ((Boolean)this.limitChatSpam.get()).booleanValue()) {
                if (newVines > 0) {
                    this.info("\u00a7aVineESP\u00a7f: Chunk %s,%s: \u00a7a%d new vines found", new Object[]{cpos.field_9181, cpos.field_9180, newVines});
                }
            } else {
                for (class_2338 pos4 : chunkVines) {
                    if (this.groundedVines.contains(pos4)) continue;
                    this.info("\u00a7aVineESP\u00a7f: Found vine at \u00a7a%s", new Object[]{pos4.method_23854()});
                }
            }
        }
    }

    private boolean isGroundedVine(class_2680 state, class_2338 pos) {
        if (!state.method_27852(class_2246.field_10597)) {
            return false;
        }
        if (pos.method_10264() < (Integer)this.minY.get() || pos.method_10264() > (Integer)this.maxY.get()) {
            return false;
        }
        class_2338 below = pos.method_10074();
        if (this.mc.field_1687 == null) {
            return false;
        }
        class_2680 belowState = this.mc.field_1687.method_8320(below);
        if (!belowState.method_26215() && belowState.method_26212((class_1922)this.mc.field_1687, below) && !belowState.method_27852(class_2246.field_10597)) {
            return this.getVineLength(pos) >= (Integer)this.minVineLength.get();
        }
        return false;
    }

    private boolean isGroundedVineChunk(class_2818 chunk, class_2338 pos) {
        if (!chunk.method_8320(pos).method_27852(class_2246.field_10597)) {
            return false;
        }
        if (pos.method_10264() < (Integer)this.minY.get() || pos.method_10264() > (Integer)this.maxY.get()) {
            return false;
        }
        class_2338 below = pos.method_10074();
        class_2680 belowState = chunk.method_8320(below);
        if (!belowState.method_26215() && belowState.method_26212((class_1922)this.mc.field_1687, below) && !belowState.method_27852(class_2246.field_10597)) {
            return this.getVineLengthChunk(chunk, pos) >= (Integer)this.minVineLength.get();
        }
        return false;
    }

    private int getVineLength(class_2338 start) {
        int length = 1;
        class_2338 current = start.method_10084();
        while (this.mc.field_1687 != null && this.mc.field_1687.method_8320(current).method_27852(class_2246.field_10597)) {
            ++length;
            current = current.method_10084();
        }
        return length;
    }

    private int getVineLengthChunk(class_2818 chunk, class_2338 start) {
        int length = 1;
        class_2338 current = start.method_10084();
        while (chunk.method_8320(current).method_27852(class_2246.field_10597)) {
            ++length;
            current = current.method_10084();
        }
        return length;
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_243 playerPos = this.mc.field_1724.method_30950(event.tickDelta);
        Color sideColor = new Color((Color)this.espColor.get());
        Color lineColor = new Color((Color)this.espColor.get());
        Color tracerColorValue = new Color((Color)this.tracerColor.get());
        for (class_2338 pos : this.groundedVines) {
            class_243 startPos;
            event.renderer.box(pos, sideColor, lineColor, (ShapeMode)this.shapeMode.get(), 0);
            if (!((Boolean)this.showTracers.get()).booleanValue()) continue;
            class_243 blockCenter = class_243.method_24953((class_2382)pos);
            if (this.mc.field_1690.method_31044().method_31034()) {
                class_243 lookDirection = this.mc.field_1724.method_5720();
                startPos = new class_243(playerPos.field_1352 + lookDirection.field_1352 * 0.5, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()) + lookDirection.field_1351 * 0.5, playerPos.field_1350 + lookDirection.field_1350 * 0.5);
            } else {
                startPos = new class_243(playerPos.field_1352, playerPos.field_1351 + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()), playerPos.field_1350);
            }
            event.renderer.line(startPos.field_1352, startPos.field_1351, startPos.field_1350, blockCenter.field_1352, blockCenter.field_1351, blockCenter.field_1350, tracerColorValue);
        }
    }
}

