/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.esp;

import com.nnpg.glazed.GlazedAddon;
import com.nnpg.glazed.VersionUtil;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.MeteorToast;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_368;
import net.minecraft.class_3989;

public class WanderingESP
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final SettingGroup sgwebhook;
    private final Setting<Boolean> showTracers;
    private final Setting<SettingColor> tracerColor;
    private final Setting<Boolean> enableWebhook;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;
    private final Setting<Boolean> enableDisconnect;
    private final Setting<Mode> notificationMode;
    private final Setting<Boolean> toggleOnFind;
    private final Set<Integer> detectedTraders;
    private final HttpClient httpClient;

    public WanderingESP() {
        super(GlazedAddon.esp, "WanderingESP", "Detects wandering traders in the world");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.sgwebhook = this.settings.createGroup("Webhook");
        this.showTracers = this.sgRender.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Show Tracers")).description("Draw tracer lines to wandering traders")).defaultValue((Object)true)).build());
        this.tracerColor = this.sgRender.add((Setting)((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("Tracer Color")).description("Color of the tracer lines")).defaultValue(new SettingColor(0, 255, 0, 127)).visible(() -> this.showTracers.get())).build());
        this.enableWebhook = this.sgwebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Webhook")).description("Send webhook notifications when wandering traders are detected")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgwebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Webhook URL")).description("Discord webhook URL")).defaultValue((Object)"")).visible(() -> this.enableWebhook.get())).build());
        this.selfPing = this.sgwebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Self Ping")).description("Ping yourself in the webhook message")).defaultValue((Object)false)).visible(() -> this.enableWebhook.get())).build());
        this.discordId = this.sgwebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Discord ID")).description("Your Discord user ID for pinging")).defaultValue((Object)"")).visible(() -> (Boolean)this.enableWebhook.get() != false && (Boolean)this.selfPing.get() != false)).build());
        this.enableDisconnect = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Disconnect")).description("Automatically disconnect when wandering traders are detected")).defaultValue((Object)false)).build());
        this.notificationMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("notification-mode")).description("How to notify when wandering traders are detected")).defaultValue((Object)Mode.Both)).build());
        this.toggleOnFind = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Toggle when found")).description("Automatically toggles the module when a wandering trader is detected")).defaultValue((Object)false)).build());
        this.detectedTraders = new HashSet<Integer>();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        HashSet<Integer> currentTraders = new HashSet<Integer>();
        for (class_1297 entity : this.mc.field_1687.method_18112()) {
            if (!(entity instanceof class_3989)) continue;
            class_3989 trader = (class_3989)entity;
            currentTraders.add(entity.method_5628());
            if (!((Boolean)this.showTracers.get()).booleanValue()) continue;
            double x = VersionUtil.getPrevX(entity) + (entity.method_23317() - VersionUtil.getPrevX(entity)) * (double)event.tickDelta;
            double y = VersionUtil.getPrevY(entity) + (entity.method_23318() - VersionUtil.getPrevY(entity)) * (double)event.tickDelta;
            double z = VersionUtil.getPrevZ(entity) + (entity.method_23321() - VersionUtil.getPrevZ(entity)) * (double)event.tickDelta;
            double height = trader.method_5829().field_1325 - trader.method_5829().field_1322;
            Color color = new Color((Color)this.tracerColor.get());
            event.renderer.line(RenderUtils.center.field_1352, RenderUtils.center.field_1351, RenderUtils.center.field_1350, x, y += height / 2.0, z, color);
        }
        if (!currentTraders.isEmpty() && !currentTraders.equals(this.detectedTraders)) {
            HashSet newTraders = new HashSet(currentTraders);
            newTraders.removeAll(this.detectedTraders);
            if (!newTraders.isEmpty()) {
                this.detectedTraders.addAll(newTraders);
                this.handleTraderDetection(newTraders.size());
            }
        } else if (currentTraders.isEmpty()) {
            this.detectedTraders.clear();
        }
    }

    private void handleTraderDetection(int traderCount) {
        String message = traderCount == 1 ? "Wandering trader detected!" : String.format("%d wandering traders detected!", traderCount);
        switch (((Mode)((Object)this.notificationMode.get())).ordinal()) {
            case 0: {
                this.info("(highlight)%s", new Object[]{message});
                break;
            }
            case 1: {
                this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8687, this.title, message));
                break;
            }
            case 2: {
                this.info("(highlight)%s", new Object[]{message});
                this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8687, this.title, message));
            }
        }
        if (((Boolean)this.enableWebhook.get()).booleanValue()) {
            this.sendWebhookNotification(traderCount);
        }
        if (((Boolean)this.toggleOnFind.get()).booleanValue()) {
            this.toggle();
        }
        if (((Boolean)this.enableDisconnect.get()).booleanValue()) {
            this.disconnectFromServer(message);
        }
    }

    private void sendWebhookNotification(int traderCount) {
        String url = ((String)this.webhookUrl.get()).trim();
        if (url.isEmpty()) {
            this.warning("Webhook URL not configured!", new Object[0]);
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String serverInfo = this.mc.method_1558() != null ? this.mc.method_1558().field_3761 : "Unknown Server";
                String messageContent = "";
                if (((Boolean)this.selfPing.get()).booleanValue() && !((String)this.discordId.get()).trim().isEmpty()) {
                    messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
                }
                String traderText = traderCount == 1 ? "trader" : "traders";
                String description = String.format("%d wandering %s detected!", traderCount, traderText);
                String coordinates = "Unknown";
                if (this.mc.field_1724 != null) {
                    coordinates = String.format("X: %.0f, Y: %.0f, Z: %.0f", this.mc.field_1724.method_23317(), this.mc.field_1724.method_23318(), this.mc.field_1724.method_23321());
                }
                String jsonPayload = String.format("{\"content\":\"%s\",\"username\":\"WanderingESP\",\"avatar_url\":\"https://i.imgur.com/OL2y1cr.png\",\"embeds\":[{\"title\":\"\ud83d\uded2 Wandering Trader Alert\",\"description\":\"%s\",\"color\":65280,\"thumbnail\":{\"url\":\"https://i.imgur.com/OL2y1cr.png\"},\"fields\":[{\"name\":\"Count\",\"value\":\"%d\",\"inline\":true},{\"name\":\"Server\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Coordinates\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Time\",\"value\":\"<t:%d:R>\",\"inline\":true}],\"footer\":{\"text\":\"Sent by Overkill\"}}]}", messageContent.replace("\"", "\\\""), description.replace("\"", "\\\""), traderCount, serverInfo.replace("\"", "\\\""), coordinates.replace("\"", "\\\""), System.currentTimeMillis() / 1000L);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 204) {
                    this.info("Webhook notification sent successfully", new Object[0]);
                } else {
                    this.error("Webhook failed with status: " + response.statusCode(), new Object[0]);
                }
            }
            catch (IOException | InterruptedException e) {
                this.error("Failed to send webhook: " + e.getMessage(), new Object[0]);
            }
        });
    }

    private void disconnectFromServer(String reason) {
        if (this.mc.field_1687 != null && this.mc.method_1562() != null) {
            this.mc.method_1562().method_48296().method_10747((class_2561)class_2561.method_43470((String)reason));
            this.info("Disconnected from server - " + reason, new Object[0]);
        }
    }

    public void onActivate() {
        this.detectedTraders.clear();
    }

    public void onDeactivate() {
        this.detectedTraders.clear();
    }

    public String getInfoString() {
        return this.detectedTraders.isEmpty() ? null : String.valueOf(this.detectedTraders.size());
    }

    public static enum Mode {
        Chat,
        Toast,
        Both;

    }
}

