/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import com.nnpg.glazed.VersionUtil;
import meteordevelopment.meteorclient.events.game.ReceiveMessageEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class AHSell
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<String> sellPrice;
    private final Setting<Integer> confirmDelay;
    private final Setting<Boolean> notifications;
    private final Setting<Boolean> enableFilter;
    private final Setting<class_1792> filterItem;
    private int delayCounter;
    private boolean awaitingConfirmation;
    private int currentSlot;

    public AHSell() {
        super(GlazedAddon.CATEGORY, "ah-sell", "Automatically sells all hotbar items using /ah sell.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sellPrice = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("sell-price")).description("The price to list each hotbar item for. Supports K/M/B.")).defaultValue((Object)"30k")).build());
        this.confirmDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("confirm-delay")).description("Delay in ticks before clicking the confirm button.")).defaultValue((Object)10)).min(0).max(100).sliderMax(20).build());
        this.notifications = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("notifications")).description("Show chat notifications.")).defaultValue((Object)true)).build());
        this.enableFilter = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-item-filter")).description("Only sell selected item type from the hotbar.")).defaultValue((Object)false)).build());
        this.filterItem = this.sgGeneral.add((Setting)((ItemSetting.Builder)((ItemSetting.Builder)((ItemSetting.Builder)new ItemSetting.Builder().name("filter-item")).description("Only this item will be sold when filter is enabled.")).defaultValue((Object)class_1802.field_8477)).build());
        this.delayCounter = 0;
        this.awaitingConfirmation = false;
        this.currentSlot = 0;
    }

    public void onActivate() {
        if (!this.isValidPrice((String)this.sellPrice.get())) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.error("Invalid price format: " + (String)this.sellPrice.get(), new Object[0]);
            }
            this.toggle();
            return;
        }
        if (!this.hasSellableItemsInHotbar()) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.error("No sellable items found in hotbar.", new Object[0]);
            }
            this.toggle();
            return;
        }
        this.currentSlot = 0;
        this.attemptSellCurrentSlot();
    }

    public void onDeactivate() {
        this.awaitingConfirmation = false;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        class_1707 handler;
        if (!this.awaitingConfirmation || this.mc.field_1724 == null) {
            return;
        }
        if (this.delayCounter > 0) {
            --this.delayCounter;
            return;
        }
        class_1703 screenHandler = this.mc.field_1724.field_7512;
        if (screenHandler instanceof class_1707 && (handler = (class_1707)screenHandler).method_17388() == 3) {
            class_1799 confirmButton = handler.method_7611(15).method_7677();
            if (!confirmButton.method_7960()) {
                this.mc.field_1761.method_2906(handler.field_7763, 15, 1, class_1713.field_7794, (class_1657)this.mc.field_1724);
                if (((Boolean)this.notifications.get()).booleanValue()) {
                    this.info("Sold item in hotbar slot " + this.currentSlot + ".", new Object[0]);
                }
            }
            this.awaitingConfirmation = false;
            this.moveToNextSlot();
        }
    }

    @EventHandler
    private void onChatMessage(ReceiveMessageEvent event) {
        String msg = event.getMessage().getString();
        if (msg.contains("You have too many listed items.")) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.warning("Sell limit reached! Disabling module.", new Object[0]);
            }
            this.toggle();
        }
    }

    private void attemptSellCurrentSlot() {
        if (this.currentSlot > 8) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.info("Finished processing hotbar. Disabling module.", new Object[0]);
            }
            this.toggle();
            return;
        }
        VersionUtil.setSelectedSlot(this.mc.field_1724, this.currentSlot);
        class_1799 stack = this.mc.field_1724.method_31548().method_5438(this.currentSlot);
        if (((Boolean)this.enableFilter.get()).booleanValue() && (stack.method_7960() || !stack.method_31574((class_1792)this.filterItem.get()))) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.info("Skipping slot " + this.currentSlot + " (does not match filter).", new Object[0]);
            }
            this.moveToNextSlot();
            return;
        }
        if (stack.method_7960()) {
            this.moveToNextSlot();
            return;
        }
        String price = ((String)this.sellPrice.get()).trim();
        double parsedPrice = this.parsePrice(price);
        if (parsedPrice <= 0.0) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.error("Invalid price format: " + price, new Object[0]);
            }
            this.toggle();
            return;
        }
        if (((Boolean)this.notifications.get()).booleanValue()) {
            this.info("Sending /ah sell %s for slot %d", new Object[]{this.formatPrice(parsedPrice), this.currentSlot});
        }
        this.mc.method_1562().method_45730("ah sell " + price);
        this.delayCounter = (Integer)this.confirmDelay.get();
        this.awaitingConfirmation = true;
    }

    private void moveToNextSlot() {
        ++this.currentSlot;
        this.attemptSellCurrentSlot();
    }

    private boolean hasSellableItemsInHotbar() {
        for (int slot = 0; slot <= 8; ++slot) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(slot);
            if (stack.method_7960()) continue;
            if (((Boolean)this.enableFilter.get()).booleanValue()) {
                if (!stack.method_31574((class_1792)this.filterItem.get())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isValidPrice(String priceStr) {
        return this.parsePrice(priceStr) > 0.0;
    }

    private double parsePrice(String priceStr) {
        if (priceStr == null || priceStr.isEmpty()) {
            return -1.0;
        }
        String cleaned = priceStr.trim().toUpperCase();
        double multiplier = 1.0;
        if (cleaned.endsWith("B")) {
            multiplier = 1.0E9;
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        } else if (cleaned.endsWith("M")) {
            multiplier = 1000000.0;
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        } else if (cleaned.endsWith("K")) {
            multiplier = 1000.0;
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        }
        try {
            return Double.parseDouble(cleaned) * multiplier;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    private String formatPrice(double price) {
        if (price >= 1.0E9) {
            return String.format("%.2fB", price / 1.0E9);
        }
        if (price >= 1000000.0) {
            return String.format("%.2fM", price / 1000000.0);
        }
        if (price >= 1000.0) {
            return String.format("%.2fK", price / 1000.0);
        }
        return String.format("%.2f", price);
    }
}

