/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.ItemSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_476;

public class AHSniper
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgWebhook;
    private final Setting<class_1792> snipingItem;
    private final Setting<String> targetItemName;
    private final Setting<String> maxPrice;
    private final Setting<PriceMode> priceMode;
    private final int refreshDelayTicks = 2;
    private final int buyDelayTicks = 0;
    private final int confirmDelayTicks = 5;
    private final int navigationDelayTicks = 0;
    private final Setting<Boolean> notifications;
    private final Setting<Boolean> autoConfirm;
    private final Setting<Boolean> webhookEnabled;
    private final Setting<String> webhookUrl;
    private final Setting<String> webhookUsername;
    private final Setting<String> webhookThumbnailUrl;
    private final Setting<Boolean> debugMode;
    private boolean waitingForConfirmation;
    private boolean itemPickedUp;
    private boolean purchaseAttempted;
    private String attemptedItemName;
    private double attemptedActualPrice;
    private int attemptedQuantity;
    private long purchaseTimestamp;
    private String attemptedSellerName;
    private int previousItemCount;
    private int inventoryCheckTicks;
    private final int MAX_INVENTORY_CHECK_TICKS = 50;
    private final int MIN_INVENTORY_CHECK_TICKS = 10;
    private int delayCounter;
    private boolean isProcessing;
    private boolean hasClickedBuy;
    private boolean hasClickedConfirm;
    private int confirmDelayCounter;
    private boolean waitingToConfirm;
    private int navigationDelayCounter;
    private boolean waitingToNavigate;
    private final HttpClient httpClient;

    public AHSniper() {
        super(GlazedAddon.CATEGORY, "AH-Sniper", "Automatically snipes items from auction house for cheap prices.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgWebhook = this.settings.createGroup("Discord Webhook");
        this.snipingItem = this.sgGeneral.add((Setting)((ItemSetting.Builder)((ItemSetting.Builder)((ItemSetting.Builder)new ItemSetting.Builder().name("sniping-item")).description("The item to snipe from auctions.")).defaultValue((Object)class_1802.field_8162)).build());
        this.targetItemName = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Item Name")).description("Name of the item to order")).defaultValue((Object)"diamonds")).build());
        this.maxPrice = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("max-price")).description("Maximum price to pay (supports K, M, B suffixes).")).defaultValue((Object)"1k")).build());
        this.priceMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("price-mode")).description("Whether max price is per individual item or per full stack.")).defaultValue((Object)PriceMode.PER_STACK)).build());
        this.refreshDelayTicks = 2;
        this.buyDelayTicks = 0;
        this.confirmDelayTicks = 5;
        this.navigationDelayTicks = 0;
        this.notifications = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("notifications")).description("Show chat notifications.")).defaultValue((Object)true)).build());
        this.autoConfirm = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-confirm")).description("Automatically confirm purchases in the confirmation GUI.")).defaultValue((Object)true)).build());
        this.webhookEnabled = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("webhook-enabled")).description("Enable Discord webhook notifications.")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL.")).defaultValue((Object)"")).visible(() -> this.webhookEnabled.get())).build());
        this.webhookUsername = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-username")).description("Username for webhook messages.")).defaultValue((Object)"AH Sniper Bot")).visible(() -> this.webhookEnabled.get())).build());
        this.webhookThumbnailUrl = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-thumbnail-url")).description("URL for the thumbnail image in webhook messages.")).defaultValue((Object)"")).visible(() -> this.webhookEnabled.get())).build());
        this.debugMode = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("debug-mode")).description("Enable debug logging for webhook issues.")).defaultValue((Object)false)).visible(() -> this.webhookEnabled.get())).build());
        this.waitingForConfirmation = false;
        this.itemPickedUp = false;
        this.purchaseAttempted = false;
        this.attemptedItemName = "";
        this.attemptedActualPrice = 0.0;
        this.attemptedQuantity = 0;
        this.purchaseTimestamp = 0L;
        this.attemptedSellerName = "Unknown";
        this.previousItemCount = 0;
        this.inventoryCheckTicks = 0;
        this.MAX_INVENTORY_CHECK_TICKS = 50;
        this.MIN_INVENTORY_CHECK_TICKS = 10;
        this.delayCounter = 0;
        this.isProcessing = false;
        this.hasClickedBuy = false;
        this.hasClickedConfirm = false;
        this.confirmDelayCounter = 0;
        this.waitingToConfirm = false;
        this.navigationDelayCounter = 0;
        this.waitingToNavigate = false;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public void onActivate() {
        String modeDescription;
        double parsedPrice = this.parsePrice((String)this.maxPrice.get());
        if (parsedPrice == -1.0) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.error((String)"Invalid price format!", (Object[])new Object[0]);
            }
            this.toggle();
            return;
        }
        if (this.snipingItem.get() == class_1802.field_8162) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.error((String)"Please select an item to snipe!", (Object[])new Object[0]);
            }
            this.toggle();
            return;
        }
        this.delayCounter = 0;
        this.confirmDelayCounter = 0;
        this.navigationDelayCounter = 0;
        this.isProcessing = false;
        this.waitingForConfirmation = false;
        this.waitingToConfirm = false;
        this.waitingToNavigate = false;
        this.itemPickedUp = false;
        this.purchaseAttempted = false;
        this.inventoryCheckTicks = 0;
        this.previousItemCount = this.countItemInInventory();
        this.hasClickedBuy = false;
        this.hasClickedConfirm = false;
        int maxStackSize = ((class_1792)this.snipingItem.get()).method_7882();
        String string = modeDescription = this.priceMode.get() == PriceMode.PER_ITEM ? "per item" : "per stack";
        if (((Boolean)this.notifications.get()).booleanValue()) {
            this.info("\ud83c\udfaf Auction Sniper activated! Sniping %s for max %s (%s)", new Object[]{((class_1792)this.snipingItem.get()).method_63680().getString(), this.maxPrice.get(), modeDescription});
            this.info("\u23f1\ufe0f  Fixed Delays: Refresh=%d ticks, Buy=%d ticks, Confirm=%d ticks, Nav=%d ticks", new Object[]{2, 0, 5, 0});
        }
        if (((Boolean)this.debugMode.get()).booleanValue()) {
            this.info("Debug: Webhook enabled: " + String.valueOf(this.webhookEnabled.get()), new Object[0]);
            this.info("Debug: Webhook URL set: " + !((String)this.webhookUrl.get()).isEmpty(), new Object[0]);
            this.testWebhook();
        }
    }

    public void onDeactivate() {
        this.isProcessing = false;
        this.waitingForConfirmation = false;
        this.waitingToConfirm = false;
        this.waitingToNavigate = false;
        this.itemPickedUp = false;
        this.purchaseAttempted = false;
        this.inventoryCheckTicks = 0;
        this.hasClickedBuy = false;
        this.hasClickedConfirm = false;
        this.delayCounter = 0;
        this.confirmDelayCounter = 0;
        this.navigationDelayCounter = 0;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        class_1703 screenHandler;
        if (this.mc.field_1724 == null) {
            return;
        }
        if (this.delayCounter > 0) {
            --this.delayCounter;
            return;
        }
        if (this.confirmDelayCounter > 0) {
            --this.confirmDelayCounter;
            return;
        }
        if (this.navigationDelayCounter > 0) {
            --this.navigationDelayCounter;
            return;
        }
        if (this.purchaseAttempted) {
            ++this.inventoryCheckTicks;
            int currentItemCount = this.countItemInInventory();
            if (((Boolean)this.debugMode.get()).booleanValue() && this.inventoryCheckTicks == 10) {
                this.info("Debug: Checking inventory - Previous: %d, Current: %d", new Object[]{this.previousItemCount, currentItemCount});
            }
            if (this.inventoryCheckTicks >= 10) {
                if (currentItemCount > this.previousItemCount) {
                    int actualQuantity = currentItemCount - this.previousItemCount;
                    if (this.isItemInInventoryOrHotbar()) {
                        if (((Boolean)this.debugMode.get()).booleanValue()) {
                            this.info("Debug: Item found in inventory! Quantity: %d", new Object[]{actualQuantity});
                            this.info("Debug: Attempting to send webhook...", new Object[0]);
                        }
                        this.sendSuccessWebhook(this.attemptedItemName, this.attemptedActualPrice, actualQuantity, this.attemptedSellerName);
                        if (((Boolean)this.notifications.get()).booleanValue()) {
                            this.info("\u2705 Successfully sniped %dx %s!", new Object[]{actualQuantity, this.attemptedItemName});
                        }
                    } else if (((Boolean)this.notifications.get()).booleanValue()) {
                        ChatUtils.warning((String)"\u26a0\ufe0f Purchase attempted but item not found in inventory", (Object[])new Object[0]);
                    }
                    this.purchaseAttempted = false;
                    this.inventoryCheckTicks = 0;
                    this.previousItemCount = currentItemCount;
                    this.hasClickedBuy = false;
                    this.hasClickedConfirm = false;
                } else if (this.inventoryCheckTicks >= 50) {
                    if (((Boolean)this.notifications.get()).booleanValue()) {
                        ChatUtils.warning((String)"\u23f0 Purchase timeout - item was not acquired", (Object[])new Object[0]);
                    }
                    if (((Boolean)this.debugMode.get()).booleanValue()) {
                        this.info("Debug: Purchase timeout reached", new Object[0]);
                    }
                    this.purchaseAttempted = false;
                    this.inventoryCheckTicks = 0;
                    this.previousItemCount = currentItemCount;
                    this.hasClickedBuy = false;
                    this.hasClickedConfirm = false;
                }
            }
        }
        if (this.isConfirmationGUI(screenHandler = this.mc.field_1724.field_7512)) {
            this.handleConfirmationGUI((class_1707)screenHandler);
            return;
        }
        if (screenHandler instanceof class_1707) {
            class_1707 containerHandler = (class_1707)screenHandler;
            if (containerHandler.method_17388() == 6) {
                this.processSixRowAuction(containerHandler);
            } else if (containerHandler.method_17388() == 3) {
                this.processThreeRowAuction(containerHandler);
            }
        } else {
            this.openAuctionHouse();
        }
    }

    private void testWebhook() {
        if (!((Boolean)this.webhookEnabled.get()).booleanValue() || ((String)this.webhookUrl.get()).isEmpty()) {
            this.info("Debug: Cannot test webhook - not enabled or URL empty", new Object[0]);
            return;
        }
        String testPayload = this.createSimpleTestMessage();
        this.sendWebhookMessage(testPayload, "Test");
    }

    private String createSimpleTestMessage() {
        String playerName = this.mc.field_1724 != null ? this.mc.field_1724.method_5477().getString() : "Unknown";
        return String.format("{\n    \"content\": \"\ud83e\uddea **Webhook Test** - AH Sniper is working for **%s**!\",\n    \"username\": \"%s\"\n}\n", this.escapeJson(playerName), this.escapeJson((String)this.webhookUsername.get()));
    }

    private int countItemInInventory() {
        if (this.mc.field_1724 == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.mc.field_1724.method_31548().method_5439(); ++i) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (!stack.method_31574((class_1792)this.snipingItem.get())) continue;
            count += stack.method_7947();
        }
        return count;
    }

    private boolean isItemInInventoryOrHotbar() {
        class_1799 stack;
        int i;
        if (this.mc.field_1724 == null) {
            return false;
        }
        for (i = 9; i < 36; ++i) {
            stack = this.mc.field_1724.method_31548().method_5438(i);
            if (!stack.method_31574((class_1792)this.snipingItem.get()) || stack.method_7960()) continue;
            return true;
        }
        for (i = 0; i < 9; ++i) {
            stack = this.mc.field_1724.method_31548().method_5438(i);
            if (!stack.method_31574((class_1792)this.snipingItem.get()) || stack.method_7960()) continue;
            return true;
        }
        return false;
    }

    private boolean isConfirmationGUI(class_1703 screenHandler) {
        String titleText;
        class_476 screen;
        class_2561 title;
        if (!(screenHandler instanceof class_1707)) {
            return false;
        }
        class_1707 containerHandler = (class_1707)screenHandler;
        class_437 class_4372 = this.mc.field_1755;
        if (class_4372 instanceof class_476 && (title = (screen = (class_476)class_4372).method_25440()) != null && ((titleText = title.getString()).contains("\u1d04\u1d0f\u0274\ua730\u026a\u0280\u1d0d \u1d18\u1d1c\u0280\u1d04\u029c\u1d00\u0455\u1d07") || titleText.toLowerCase().contains("confirm purchase") || titleText.toLowerCase().contains("confirm") && titleText.toLowerCase().contains("purchase"))) {
            return true;
        }
        for (int i = 0; i < containerHandler.field_7761.size(); ++i) {
            class_1799 stack = containerHandler.method_7611(i).method_7677();
            if (stack.method_7960()) continue;
            class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.mc.field_1687);
            List tooltip = stack.method_7950(tooltipContext, (class_1657)this.mc.field_1724, (class_1836)class_1836.field_41070);
            for (class_2561 line : tooltip) {
                String text = line.getString().toLowerCase();
                if (!text.contains("confirm") || !text.contains("purchase")) continue;
                return true;
            }
        }
        return false;
    }

    private void handleConfirmationGUI(class_1707 handler) {
        if (!((Boolean)this.autoConfirm.get()).booleanValue()) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.info("Confirmation GUI detected but auto-confirm is disabled.", new Object[0]);
            }
            return;
        }
        if (this.hasClickedConfirm) {
            return;
        }
        if (!this.waitingToConfirm) {
            this.waitingToConfirm = true;
            this.confirmDelayCounter = 5;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.info("\u23f3 Confirmation GUI detected! Waiting %d ticks before confirming...", new Object[]{5});
            }
            return;
        }
        if (this.waitingToConfirm && this.confirmDelayCounter == 0) {
            this.mc.field_1761.method_2906(handler.field_7763, 15, 1, class_1713.field_7794, (class_1657)this.mc.field_1724);
            this.waitingForConfirmation = false;
            this.waitingToConfirm = false;
            this.itemPickedUp = false;
            this.hasClickedConfirm = true;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.info("\u2705 Purchase confirmed after delay!", new Object[0]);
            }
        }
    }

    private void openAuctionHouse() {
        String itemName = this.getFormattedItemName((class_1792)this.snipingItem.get());
        this.mc.method_1562().method_45730("ah " + String.valueOf(this.targetItemName));
        this.navigationDelayCounter = 0;
    }

    private void processSixRowAuction(class_1707 handler) {
        class_1799 recentlyListedButton = handler.method_7611(47).method_7677();
        if (!recentlyListedButton.method_7960()) {
            class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.mc.field_1687);
            List tooltip = recentlyListedButton.method_7950(tooltipContext, (class_1657)this.mc.field_1724, (class_1836)class_1836.field_41070);
            for (class_2561 line : tooltip) {
                String text = line.getString();
                if (!text.contains("Recently Listed") || !line.method_10866().toString().contains("white") && !text.contains("white")) continue;
                this.mc.field_1761.method_2906(handler.field_7763, 47, 1, class_1713.field_7794, (class_1657)this.mc.field_1724);
                this.navigationDelayCounter = 0;
                this.hasClickedBuy = false;
                return;
            }
        }
        for (int i = 0; i < 44; ++i) {
            class_1799 stack = handler.method_7611(i).method_7677();
            if (!stack.method_31574((class_1792)this.snipingItem.get())) continue;
            double currentItemPrice = this.getActualPrice(stack);
            if (!this.isValidAuctionItem(stack) || currentItemPrice == -1.0) continue;
            if (this.isProcessing) {
                if (this.hasClickedBuy) {
                    return;
                }
                this.mc.field_1761.method_2906(handler.field_7763, i, 1, class_1713.field_7794, (class_1657)this.mc.field_1724);
                this.isProcessing = false;
                this.hasClickedBuy = true;
                this.attemptedItemName = ((class_1792)this.snipingItem.get()).method_63680().getString();
                this.attemptedActualPrice = currentItemPrice;
                this.attemptedQuantity = stack.method_7947();
                this.attemptedSellerName = this.getSellerNameFromTooltip(stack);
                this.purchaseAttempted = true;
                this.purchaseTimestamp = System.currentTimeMillis();
                this.inventoryCheckTicks = 0;
                if (((Boolean)this.notifications.get()).booleanValue()) {
                    this.info("\ud83d\uded2 Attempting to buy %dx %s!", new Object[]{stack.method_7947(), this.attemptedItemName});
                }
                if (((Boolean)this.debugMode.get()).booleanValue()) {
                    this.info("Debug: Purchase attempt - Item: %s, Price: %s, Seller: %s", new Object[]{this.attemptedItemName, this.formatPrice(this.attemptedActualPrice), this.attemptedSellerName});
                }
                return;
            }
            this.isProcessing = true;
            this.delayCounter = 0;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                // empty if block
            }
            return;
        }
        this.mc.field_1761.method_2906(handler.field_7763, 49, 1, class_1713.field_7794, (class_1657)this.mc.field_1724);
        this.navigationDelayCounter = 2;
        this.hasClickedBuy = false;
        if (((Boolean)this.notifications.get()).booleanValue()) {
            this.info("\ud83d\udd04 Refreshing to next page in %d ticks...", new Object[]{2});
        }
    }

    private void processThreeRowAuction(class_1707 handler) {
        class_1799 auctionItem = handler.method_7611(13).method_7677();
        if (auctionItem.method_31574((class_1792)this.snipingItem.get())) {
            double currentItemPrice = this.getActualPrice(auctionItem);
            if (this.isValidAuctionItem(auctionItem) && currentItemPrice != -1.0) {
                if (this.hasClickedBuy) {
                    return;
                }
                this.mc.field_1761.method_2906(handler.field_7763, 15, 1, class_1713.field_7794, (class_1657)this.mc.field_1724);
                this.hasClickedBuy = true;
                this.attemptedItemName = auctionItem.method_7909().method_63680().getString();
                this.attemptedActualPrice = currentItemPrice;
                this.attemptedQuantity = auctionItem.method_7947();
                this.attemptedSellerName = this.getSellerNameFromTooltip(auctionItem);
                this.purchaseAttempted = true;
                this.purchaseTimestamp = System.currentTimeMillis();
                this.inventoryCheckTicks = 0;
                if (((Boolean)this.notifications.get()).booleanValue()) {
                    this.info("\u26a1 Buying %dx %s after delay!", new Object[]{auctionItem.method_7947(), this.attemptedItemName});
                }
                if (((Boolean)this.debugMode.get()).booleanValue()) {
                    this.info("Debug: Single item purchase - Item: %s, Price: %s, Seller: %s", new Object[]{this.attemptedItemName, this.formatPrice(this.attemptedActualPrice), this.attemptedSellerName});
                }
            }
        }
    }

    private double getActualPrice(class_1799 stack) {
        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.mc.field_1687);
        List tooltip = stack.method_7950(tooltipContext, (class_1657)this.mc.field_1724, (class_1836)class_1836.field_41070);
        return this.parseTooltipPrice(tooltip);
    }

    private String getSellerNameFromTooltip(class_1799 stack) {
        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.mc.field_1687);
        List tooltip = stack.method_7950(tooltipContext, (class_1657)this.mc.field_1724, (class_1836)class_1836.field_41070);
        Pattern sellerPattern = Pattern.compile("(?i)Seller:\\s*(\\w+)");
        for (class_2561 line : tooltip) {
            String text = line.getString();
            Matcher matcher = sellerPattern.matcher(text);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return "Unknown";
    }

    private void sendSuccessWebhook(String itemName, double actualPrice, int quantity, String sellerName) {
        if (!((Boolean)this.webhookEnabled.get()).booleanValue() || ((String)this.webhookUrl.get()).isEmpty()) {
            if (((Boolean)this.debugMode.get()).booleanValue()) {
                this.info("Debug: Webhook not sent - Enabled: %s, URL set: %s", new Object[]{this.webhookEnabled.get(), !((String)this.webhookUrl.get()).isEmpty()});
            }
            return;
        }
        if (((Boolean)this.debugMode.get()).booleanValue()) {
            this.info("Debug: Creating webhook payload...", new Object[0]);
        }
        String jsonPayload = this.createSuccessEmbed(itemName, actualPrice, quantity, sellerName);
        this.sendWebhookMessage(jsonPayload, "Success");
    }

    private void sendWebhookMessage(String jsonPayload, String messageType) {
        block8: {
            try {
                if (((Boolean)this.debugMode.get()).booleanValue()) {
                    this.info("Debug: Sending %s webhook request...", new Object[]{messageType});
                    this.info("Debug: Payload preview: %s", new Object[]{jsonPayload.substring(0, Math.min(jsonPayload.length(), 200)) + "..."});
                }
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create((String)this.webhookUrl.get())).header("Content-Type", "application/json").header("User-Agent", "AH-Sniper/1.0").timeout(Duration.ofSeconds(15L)).POST(HttpRequest.BodyPublishers.ofString(jsonPayload, StandardCharsets.UTF_8)).build();
                if (((Boolean)this.debugMode.get()).booleanValue()) {
                    try {
                        HttpResponse<String> response2 = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                        this.info("Debug: %s webhook sent - Status: %d", new Object[]{messageType, response2.statusCode()});
                        if (response2.statusCode() < 200 || response2.statusCode() >= 300) {
                            ChatUtils.error((String)"%s webhook failed - Status: %d", (Object[])new Object[]{messageType, response2.statusCode()});
                            this.info("Debug: Response body: %s", new Object[]{response2.body()});
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        ChatUtils.error((String)"%s webhook error: %s", (Object[])new Object[]{messageType, e.getMessage()});
                        e.printStackTrace();
                    }
                    break block8;
                }
                CompletableFuture<HttpResponse<String>> responseFuture = this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
                responseFuture.whenComplete((response, throwable) -> {
                    if (throwable != null) {
                        if (((Boolean)this.notifications.get()).booleanValue()) {
                            ChatUtils.error((String)"%s webhook error: %s", (Object[])new Object[]{messageType, throwable.getMessage()});
                        }
                        System.err.println(messageType + " webhook error: " + throwable.getMessage());
                    } else {
                        System.out.println(messageType + " webhook sent - Status: " + response.statusCode());
                        if (response.statusCode() < 200 || response.statusCode() >= 300) {
                            if (((Boolean)this.notifications.get()).booleanValue()) {
                                ChatUtils.error((String)"%s webhook failed - Status: %d", (Object[])new Object[]{messageType, response.statusCode()});
                            }
                            System.err.println(messageType + " webhook failed - Response: " + (String)response.body());
                        }
                    }
                });
            }
            catch (Exception e) {
                if (((Boolean)this.debugMode.get()).booleanValue() || ((Boolean)this.notifications.get()).booleanValue()) {
                    ChatUtils.error((String)"%s webhook creation error: %s", (Object[])new Object[]{messageType, e.getMessage()});
                }
                System.err.println(messageType + " webhook creation error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private String createSuccessEmbed(String itemName, double actualPrice, int quantity, String sellerName) {
        String playerName = this.mc.field_1724 != null ? this.mc.field_1724.method_5477().getString() : "Unknown";
        long timestamp = System.currentTimeMillis() / 1000L;
        String maxPriceStr = this.formatPrice(this.parsePrice((String)this.maxPrice.get()));
        String actualPriceStr = this.formatPrice(actualPrice);
        String priceModeStr = ((PriceMode)((Object)this.priceMode.get())).toString();
        double maxPriceValue = this.parsePrice((String)this.maxPrice.get());
        double savings = maxPriceValue - actualPrice;
        String savingsStr = this.formatPrice(Math.abs(savings));
        String savingsPercentage = String.format("%.1f%%", savings / maxPriceValue * 100.0);
        String content = String.format("\ud83c\udfaf **%s** successfully sniped **%dx %s** for **%s**!", playerName, quantity, itemName, actualPriceStr);
        String thumbnailUrl = (String)this.webhookThumbnailUrl.get();
        if (thumbnailUrl.isEmpty()) {
            thumbnailUrl = "https://i.scdn.co/image/ab6761610000517415fda24afae244cbd5c2dfac";
        }
        return String.format("{\n    \"content\": \"%s\",\n    \"username\": \"%s\",\n    \"embeds\": [\n        {\n            \"title\": \"\ud83c\udfaf Auction Sniped Successfully!\",\n            \"color\": 65280,\n            \"fields\": [\n                {\n                    \"name\": \"\ud83d\udce6 Item\",\n                    \"value\": \"%s x%d\",\n                    \"inline\": true\n                },\n                {\n                    \"name\": \"\ud83d\udcb0 Purchase Price\",\n                    \"value\": \"%s (total)\",\n                    \"inline\": true\n                },\n                {\n                    \"name\": \"\ud83d\udcb5 Max Price\",\n                    \"value\": \"%s (%s)\",\n                    \"inline\": true\n                },\n                {\n                    \"name\": \"\ud83d\udcb8 Savings\",\n                    \"value\": \"%s (%s)\",\n                    \"inline\": true\n                },\n                {\n                    \"name\": \"\ud83c\udfea Seller\",\n                    \"value\": \"%s\",\n                    \"inline\": true\n                },\n                {\n                    \"name\": \"\u23f0 Time\",\n                    \"value\": \"<t:%d:R>\",\n                    \"inline\": true\n                }\n            ],\n            \"thumbnail\": {\n                \"url\": \"%s\"\n            },\n            \"footer\": {\n                \"text\": \"Auction Sniper Bot\"\n            },\n            \"timestamp\": \"%s\"\n        }\n    ]\n}\n", this.escapeJson(content), this.escapeJson((String)this.webhookUsername.get()), this.escapeJson(itemName), quantity, this.escapeJson(actualPriceStr), this.escapeJson(maxPriceStr), this.escapeJson(priceModeStr.toLowerCase()), this.escapeJson(savingsStr), this.escapeJson(savingsPercentage), this.escapeJson(sellerName), timestamp, this.escapeJson(thumbnailUrl), Instant.now().toString());
    }

    private String escapeJson(String str) {
        if (str == null) {
            return "";
        }
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private String formatPrice(double price) {
        if (price >= 1.0E9) {
            return String.format("%.1fB", price / 1.0E9);
        }
        if (price >= 1000000.0) {
            return String.format("%.1fM", price / 1000000.0);
        }
        if (price >= 1000.0) {
            return String.format("%.1fK", price / 1000.0);
        }
        return String.format("%.0f", price);
    }

    private boolean isValidAuctionItem(class_1799 stack) {
        if (stack.method_7960() || !stack.method_31574((class_1792)this.snipingItem.get())) {
            return false;
        }
        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.mc.field_1687);
        List tooltip = stack.method_7950(tooltipContext, (class_1657)this.mc.field_1724, (class_1836)class_1836.field_41070);
        double itemPrice = this.parseTooltipPrice(tooltip);
        double maxPriceValue = this.parsePrice((String)this.maxPrice.get());
        if (maxPriceValue == -1.0) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.error((String)"Invalid max price format!", (Object[])new Object[0]);
            }
            this.toggle();
            return false;
        }
        if (itemPrice == -1.0) {
            return false;
        }
        double comparisonPrice = this.priceMode.get() == PriceMode.PER_ITEM ? itemPrice / (double)stack.method_7947() : itemPrice;
        if (((Boolean)this.notifications.get()).booleanValue()) {
            String mode = this.priceMode.get() == PriceMode.PER_ITEM ? "per item" : "per stack";
            String priceStr = this.formatPrice(comparisonPrice);
            String maxStr = this.formatPrice(maxPriceValue);
            boolean willBuy = comparisonPrice <= maxPriceValue;
            this.info("\ud83d\udd0d Item: %dx %s | Price: %s (%s) | Max: %s | Will buy: %s", new Object[]{stack.method_7947(), stack.method_7909().method_63680().getString(), priceStr, mode, maxStr, willBuy ? "YES" : "NO"});
        }
        return comparisonPrice <= maxPriceValue;
    }

    private double parseTooltipPrice(List<class_2561> tooltip) {
        if (tooltip == null || tooltip.isEmpty()) {
            return -1.0;
        }
        Pattern[] pricePatterns = new Pattern[]{Pattern.compile("\\$([\\d,]+(?:\\.[\\d]+)?)([kmb])?", 2), Pattern.compile("(?i)price\\s*:\\s*([\\d,]+(?:\\.[\\d]+)?)([kmb])?", 2), Pattern.compile("(?i)buy\\s+for\\s*:\\s*([\\d,]+(?:\\.[\\d]+)?)([kmb])?", 2), Pattern.compile("([\\d,]+(?:\\.[\\d]+)?)([kmb])?\\s*coins?", 2), Pattern.compile("\\b([\\d,]+(?:\\.[\\d]+)?)([kmb])\\b", 2)};
        for (class_2561 line : tooltip) {
            String text = line.getString();
            for (Pattern pattern : pricePatterns) {
                Matcher matcher = pattern.matcher(text);
                if (!matcher.find()) continue;
                String numberStr = matcher.group(1).replace(",", "");
                String suffix = "";
                if (matcher.groupCount() >= 2 && matcher.group(2) != null) {
                    suffix = matcher.group(2).toLowerCase();
                }
                try {
                    double basePrice = Double.parseDouble(numberStr);
                    double multiplier = 1.0;
                    switch (suffix) {
                        case "k": {
                            multiplier = 1000.0;
                            break;
                        }
                        case "m": {
                            multiplier = 1000000.0;
                            break;
                        }
                        case "b": {
                            multiplier = 1.0E9;
                        }
                    }
                    return basePrice * multiplier;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return -1.0;
    }

    private double parsePrice(String priceStr) {
        if (priceStr == null || priceStr.isEmpty()) {
            return -1.0;
        }
        String cleaned = priceStr.trim().toLowerCase().replace(",", "");
        double multiplier = 1.0;
        if (cleaned.endsWith("b")) {
            multiplier = 1.0E9;
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        } else if (cleaned.endsWith("m")) {
            multiplier = 1000000.0;
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        } else if (cleaned.endsWith("k")) {
            multiplier = 1000.0;
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        }
        try {
            return Double.parseDouble(cleaned) * multiplier;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    private String getFormattedItemName(class_1792 item) {
        String translationKey = item.method_7876();
        String[] parts = translationKey.split("\\.");
        String itemName = parts[parts.length - 1];
        String[] words = itemName.replace("_", " ").split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }

    public static enum PriceMode {
        PER_ITEM("Per Item"),
        PER_STACK("Per Stack");

        private final String title;

        private PriceMode(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

