/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1802;

public class AutoPearlChain
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> switchBack;
    private final Setting<Integer> switchDelay;
    private final Setting<Double> teleportThreshold;
    private int prevSlot;
    private int switchCooldown;
    private boolean waitingForTeleport;
    private double lastX;
    private double lastY;
    private double lastZ;

    public AutoPearlChain() {
        super(GlazedAddon.CATEGORY, "auto-pearl-chain", "Chains pearls after teleport detection.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.switchBack = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("switch-back")).description("Switch back to previous slot after throwing.")).defaultValue((Object)true)).build());
        this.switchDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("switch-delay")).description("Delay before switching back (ticks).")).defaultValue((Object)4)).min(0).sliderMax(20).build());
        this.teleportThreshold = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("teleport-threshold")).description("Minimum distance change to detect teleport.")).defaultValue(5.0).min(0.1).sliderMax(20.0).build());
        this.prevSlot = -1;
        this.switchCooldown = 0;
        this.waitingForTeleport = false;
    }

    public void onActivate() {
        this.reset();
        if (this.mc.field_1724 != null) {
            this.lastX = this.mc.field_1724.method_23317();
            this.lastY = this.mc.field_1724.method_23318();
            this.lastZ = this.mc.field_1724.method_23321();
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1761 == null) {
            return;
        }
        if (!this.waitingForTeleport) {
            int pearlSlot = this.findPearlSlot();
            if (pearlSlot == -1) {
                return;
            }
            this.prevSlot = this.mc.field_1724.method_31548().field_7545;
            this.mc.field_1724.method_31548().method_61496(pearlSlot);
            this.mc.field_1761.method_2919((class_1657)this.mc.field_1724, class_1268.field_5808);
            this.mc.field_1724.method_6104(class_1268.field_5808);
            this.waitingForTeleport = true;
            this.switchCooldown = 0;
        } else {
            double dz;
            double dy;
            double dx = this.mc.field_1724.method_23317() - this.lastX;
            double dist = Math.sqrt(dx * dx + (dy = this.mc.field_1724.method_23318() - this.lastY) * dy + (dz = this.mc.field_1724.method_23321() - this.lastZ) * dz);
            if (dist >= (Double)this.teleportThreshold.get()) {
                if (((Boolean)this.switchBack.get()).booleanValue()) {
                    if (this.switchCooldown < (Integer)this.switchDelay.get()) {
                        ++this.switchCooldown;
                        return;
                    }
                    if (this.prevSlot != -1) {
                        this.mc.field_1724.method_31548().method_61496(this.prevSlot);
                    }
                }
                this.lastX = this.mc.field_1724.method_23317();
                this.lastY = this.mc.field_1724.method_23318();
                this.lastZ = this.mc.field_1724.method_23321();
                this.waitingForTeleport = false;
            }
        }
    }

    private int findPearlSlot() {
        for (int i = 0; i < 9; ++i) {
            if (this.mc.field_1724.method_31548().method_5438(i).method_7909() != class_1802.field_8634) continue;
            return i;
        }
        return -1;
    }

    private void reset() {
        this.waitingForTeleport = false;
        this.switchCooldown = 0;
        this.prevSlot = -1;
    }
}

