/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;

public class AutoShellOrder
extends Module {
    private final class_310 mc = class_310.method_1551();
    private Stage stage = Stage.NONE;
    private long stageStart = 0L;
    private static final long WAIT_TIME_MS = 50L;
    private int shellMoveIndex = 0;
    private long lastShellMoveTime = 0L;
    private int exitCount = 0;
    private int finalExitCount = 0;
    private long finalExitStart = 0L;
    private String targetPlayer = "";
    private boolean isTargetingActive = false;
    private final SettingGroup sgGeneral = this.settings.getDefaultGroup();
    private final SettingGroup sgTargeting = this.settings.createGroup("Player Targeting");
    private final Setting<String> minPrice = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("min-price")).description("Minimum price to deliver shells for (supports K, M, B suffixes).")).defaultValue((Object)"50")).build());
    private final Setting<Boolean> notifications = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("notifications")).description("Show detailed price checking notifications.")).defaultValue((Object)true)).build());
    private final Setting<Boolean> speedMode = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("speed-mode")).description("Maximum speed mode - removes most delays (may be unstable).")).defaultValue((Object)true)).build());
    private final Setting<Boolean> enableTargeting = this.sgTargeting.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-targeting")).description("Enable targeting a specific player (ignores minimum price).")).defaultValue((Object)false)).build());
    private final Setting<String> targetPlayerName = this.sgTargeting.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("target-player")).description("Specific player name to target for orders.")).defaultValue((Object)"")).visible(() -> (Boolean)this.enableTargeting.get())).build());
    private final Setting<Boolean> targetOnlyMode = this.sgTargeting.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("target-only-mode")).description("Only look for orders from the targeted player, ignore all others.")).defaultValue((Object)false)).visible(() -> (Boolean)this.enableTargeting.get())).build());

    public AutoShellOrder() {
        super(GlazedAddon.CATEGORY, "AutoShellOrder", "Automatically buys shulker shells and sells them in orders with player targeting");
    }

    public void onActivate() {
        double parsedPrice = this.parsePrice((String)this.minPrice.get());
        if (parsedPrice == -1.0 && !((Boolean)this.enableTargeting.get()).booleanValue()) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.error((String)"Invalid minimum price format!", (Object[])new Object[0]);
            }
            this.toggle();
            return;
        }
        this.updateTargetPlayer();
        this.stage = Stage.SHOP;
        this.stageStart = System.currentTimeMillis();
        this.shellMoveIndex = 0;
        this.lastShellMoveTime = 0L;
        this.exitCount = 0;
        this.finalExitCount = 0;
        if (((Boolean)this.notifications.get()).booleanValue()) {
            String modeInfo = this.isTargetingActive ? String.format(" | Targeting: %s", this.targetPlayer) : "";
            this.info("\ud83d\ude80 FAST AutoShellOrder activated! Minimum: %s%s", this.minPrice.get(), modeInfo);
        }
    }

    public void onDeactivate() {
        this.stage = Stage.NONE;
    }

    private void updateTargetPlayer() {
        this.targetPlayer = "";
        this.isTargetingActive = false;
        if (((Boolean)this.enableTargeting.get()).booleanValue() && !((String)this.targetPlayerName.get()).trim().isEmpty()) {
            this.targetPlayer = ((String)this.targetPlayerName.get()).trim();
            this.isTargetingActive = true;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.info("\ud83c\udfaf Targeting enabled for player: %s", this.targetPlayer);
            }
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        switch (this.stage.ordinal()) {
            case 14: {
                ChatUtils.sendPlayerMsg((String)("/orders " + this.targetPlayer));
                this.stage = Stage.ORDERS;
                this.stageStart = now;
                if (!((Boolean)this.notifications.get()).booleanValue()) break;
                this.info("\ud83d\udd0d Checking orders for: %s", this.targetPlayer);
                break;
            }
            case 1: {
                ChatUtils.sendPlayerMsg((String)"/shop");
                this.stage = Stage.SHOP_END;
                this.stageStart = now;
                break;
            }
            case 2: {
                class_437 class_4372 = this.mc.field_1755;
                if (!(class_4372 instanceof class_476)) break;
                class_476 screen = (class_476)class_4372;
                class_1703 handler = screen.method_17577();
                for (class_1735 slot : handler.field_7761) {
                    class_1799 stack = slot.method_7677();
                    if (stack.method_7960() || !this.isEndStone(stack)) continue;
                    this.mc.field_1761.method_2906(handler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    this.stage = Stage.SHOP_SHELL;
                    this.stageStart = now;
                    return;
                }
                break;
            }
            case 3: {
                class_437 handler = this.mc.field_1755;
                if (!(handler instanceof class_476)) break;
                class_476 screen = (class_476)handler;
                handler = screen.method_17577();
                for (class_1735 slot : handler.field_7761) {
                    class_1799 stack = slot.method_7677();
                    if (stack.method_7960() || !this.isShell(stack)) continue;
                    this.mc.field_1761.method_2906(handler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    this.stage = Stage.SHOP_CONFIRM;
                    this.stageStart = now;
                    return;
                }
                break;
            }
            case 8: {
                class_437 handler = this.mc.field_1755;
                if (!(handler instanceof class_476)) break;
                class_476 screen = (class_476)handler;
                handler = screen.method_17577();
                for (class_1735 slot : handler.field_7761) {
                    double orderPrice;
                    class_1799 stack = slot.method_7677();
                    if (stack.method_7960() || !this.isShell(stack) || !((orderPrice = this.getOrderPrice(stack)) >= this.parsePrice((String)this.minPrice.get()))) continue;
                    this.mc.field_1761.method_2906(handler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    this.stage = Stage.ORDERS_SELECT;
                    this.stageStart = now;
                    if (((Boolean)this.notifications.get()).booleanValue()) {
                        this.info("\u2705 Found shell order: %s", this.formatPrice(orderPrice));
                    }
                    return;
                }
                break;
            }
        }
    }

    private boolean isShell(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8815;
    }

    private boolean isEndStone(class_1799 stack) {
        return stack.method_7909() == class_1802.field_20399;
    }

    private double getOrderPrice(class_1799 stack) {
        if (stack.method_7960()) {
            return -1.0;
        }
        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.mc.field_1687);
        List tooltip = stack.method_7950(tooltipContext, (class_1657)this.mc.field_1724, (class_1836)class_1836.field_41070);
        return this.parseTooltipPrice(tooltip);
    }

    private double parseTooltipPrice(List<class_2561> tooltip) {
        if (tooltip == null || tooltip.isEmpty()) {
            return -1.0;
        }
        Pattern pattern = Pattern.compile("\\$([\\d,]+)");
        for (class_2561 line : tooltip) {
            Matcher matcher = pattern.matcher(line.getString());
            if (!matcher.find()) continue;
            try {
                return Double.parseDouble(matcher.group(1).replace(",", ""));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1.0;
    }

    private double parsePrice(String priceStr) {
        try {
            return Double.parseDouble(priceStr.replace(",", ""));
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    private String formatPrice(double price) {
        if (price >= 1000000.0) {
            return String.format("$%.1fM", price / 1000000.0);
        }
        if (price >= 1000.0) {
            return String.format("$%.1fK", price / 1000.0);
        }
        return String.format("$%.0f", price);
    }

    public void info(String message, Object ... args) {
        if (((Boolean)this.notifications.get()).booleanValue()) {
            ChatUtils.info((String)String.format(message, args), (Object[])new Object[0]);
        }
    }

    private static enum Stage {
        NONE,
        SHOP,
        SHOP_END,
        SHOP_SHELL,
        SHOP_CONFIRM,
        SHOP_CHECK_FULL,
        SHOP_EXIT,
        WAIT,
        ORDERS,
        ORDERS_SELECT,
        ORDERS_EXIT,
        ORDERS_CONFIRM,
        ORDERS_FINAL_EXIT,
        CYCLE_PAUSE,
        TARGET_ORDERS;

    }
}

