/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;

public class AutoTotemOrder
extends Module {
    private final class_310 mc = class_310.method_1551();
    private Stage stage = Stage.NONE;
    private long stageStart = 0L;
    private static final long WAIT_TIME_MS = 50L;
    private int shulkerMoveIndex = 0;
    private long lastShulkerMoveTime = 0L;
    private int exitCount = 0;
    private int finalExitCount = 0;
    private long finalExitStart = 0L;
    private int bulkBuyCount = 0;
    private static final int MAX_BULK_BUY = 5;
    private String targetPlayer = "";
    private boolean isTargetingActive = false;
    private final SettingGroup sgGeneral = this.settings.getDefaultGroup();
    private final SettingGroup sgTargeting = this.settings.createGroup("Player Targeting");
    private final Setting<String> minPrice = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("min-price")).description("Minimum price to deliver totems for (supports K, M, B suffixes).")).defaultValue((Object)"850")).build());
    private final Setting<Boolean> notifications = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("notifications")).description("Show detailed price checking notifications.")).defaultValue((Object)true)).build());
    private final Setting<Boolean> speedMode = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("speed-mode")).description("Maximum speed mode - removes most delays (may be unstable).")).defaultValue((Object)true)).build());
    private final Setting<Boolean> enableTargeting = this.sgTargeting.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-targeting")).description("Enable targeting a specific player (ignores minimum price).")).defaultValue((Object)false)).build());
    private final Setting<String> targetPlayerName = this.sgTargeting.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("target-player")).description("Specific player name to target for orders.")).defaultValue((Object)"")).visible(() -> (Boolean)this.enableTargeting.get())).build());
    private final Setting<Boolean> targetOnlyMode = this.sgTargeting.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("target-only-mode")).description("Only look for orders from the targeted player, ignore all others.")).defaultValue((Object)false)).visible(() -> (Boolean)this.enableTargeting.get())).build());

    public AutoTotemOrder() {
        super(GlazedAddon.CATEGORY, "AutoTotemOrder", "Automatically buys totems and sells them in orders for profit with player targeting");
    }

    public void onActivate() {
        double parsedPrice = this.parsePrice((String)this.minPrice.get());
        if (parsedPrice == -1.0 && !((Boolean)this.enableTargeting.get()).booleanValue()) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.error((String)"Invalid minimum price format!", (Object[])new Object[0]);
            }
            this.toggle();
            return;
        }
        this.updateTargetPlayer();
        this.stage = Stage.SHOP;
        this.stageStart = System.currentTimeMillis();
        this.shulkerMoveIndex = 0;
        this.lastShulkerMoveTime = 0L;
        this.exitCount = 0;
        this.finalExitCount = 0;
        this.bulkBuyCount = 0;
        if (((Boolean)this.notifications.get()).booleanValue()) {
            String modeInfo = this.isTargetingActive ? String.format(" | Targeting: %s", this.targetPlayer) : "";
            this.info("\ud83d\ude80 FAST AutoTotemOrder activated! Minimum: %s%s", this.minPrice.get(), modeInfo);
        }
    }

    public void onDeactivate() {
        this.stage = Stage.NONE;
    }

    private void updateTargetPlayer() {
        this.targetPlayer = "";
        this.isTargetingActive = false;
        if (((Boolean)this.enableTargeting.get()).booleanValue() && !((String)this.targetPlayerName.get()).trim().isEmpty()) {
            this.targetPlayer = ((String)this.targetPlayerName.get()).trim();
            this.isTargetingActive = true;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                this.info("\ud83c\udfaf Targeting enabled for player: %s", this.targetPlayer);
            }
        } else if (((Boolean)this.notifications.get()).booleanValue() && ((Boolean)this.enableTargeting.get()).booleanValue()) {
            this.info("\u26a0\ufe0f Targeting disabled - no player name provided", new Object[0]);
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        switch (this.stage.ordinal()) {
            case 14: {
                ChatUtils.sendPlayerMsg((String)("/orders " + this.targetPlayer));
                this.stage = Stage.ORDERS;
                this.stageStart = now;
                if (!((Boolean)this.notifications.get()).booleanValue()) break;
                this.info("\ud83d\udd0d Checking orders for: %s", this.targetPlayer);
                break;
            }
            case 1: {
                ChatUtils.sendPlayerMsg((String)"/shop");
                this.stage = Stage.SHOP_GEAR;
                this.stageStart = now;
                break;
            }
            case 2: {
                class_437 class_4372 = this.mc.field_1755;
                if (!(class_4372 instanceof class_476)) break;
                class_476 screen = (class_476)class_4372;
                class_1703 handler = screen.method_17577();
                for (class_1735 slot : handler.field_7761) {
                    class_1799 stack = slot.method_7677();
                    if (stack.method_7960() || !this.isTotemOfUndying(stack)) continue;
                    this.mc.field_1761.method_2906(handler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    this.stage = Stage.SHOP_TOTEM;
                    this.stageStart = now;
                    this.bulkBuyCount = 0;
                    return;
                }
                if (now - this.stageStart <= (long)((Boolean)this.speedMode.get() != false ? 1000 : 3000)) break;
                this.mc.field_1724.method_7346();
                this.stage = Stage.SHOP;
                this.stageStart = now;
                break;
            }
            case 3: {
                class_437 handler = this.mc.field_1755;
                if (!(handler instanceof class_476)) break;
                class_476 screen = (class_476)handler;
                handler = screen.method_17577();
                boolean foundTotem = false;
                for (class_1735 slot : handler.field_7761) {
                    class_1799 stack = slot.method_7677();
                    if (stack.method_7960() || !this.isTotemOfUndying(stack)) continue;
                    int clickCount = (Boolean)this.speedMode.get() != false ? 10 : 5;
                    for (int i = 0; i < clickCount; ++i) {
                        this.mc.field_1761.method_2906(handler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    }
                    foundTotem = true;
                    ++this.bulkBuyCount;
                    break;
                }
                if (foundTotem) {
                    this.stage = Stage.SHOP_CONFIRM;
                    this.stageStart = now;
                    return;
                }
                if (now - this.stageStart <= (long)((Boolean)this.speedMode.get() != false ? 500 : 1500)) break;
                this.mc.field_1724.method_7346();
                this.stage = Stage.SHOP;
                this.stageStart = now;
                break;
            }
            case 4: {
                class_437 handler = this.mc.field_1755;
                if (!(handler instanceof class_476)) break;
                class_476 screen = (class_476)handler;
                handler = screen.method_17577();
                boolean foundGreen = false;
                for (class_1735 slot : handler.field_7761) {
                    class_1799 stack = slot.method_7677();
                    if (stack.method_7960() || !this.isGreenGlass(stack)) continue;
                    for (int i = 0; i < ((Boolean)this.speedMode.get() != false ? 3 : 2); ++i) {
                        this.mc.field_1761.method_2906(handler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    }
                    foundGreen = true;
                    break;
                }
                if (foundGreen) {
                    this.stage = Stage.SHOP_CHECK_FULL;
                    this.stageStart = now;
                    return;
                }
                if (now - this.stageStart <= (long)((Boolean)this.speedMode.get() != false ? 200 : 800)) break;
                this.stage = Stage.SHOP_TOTEM;
                this.stageStart = now;
                break;
            }
            case 5: {
                if (now - this.stageStart <= (long)((Boolean)this.speedMode.get() != false ? 100 : 200)) break;
                if (this.isInventoryFull()) {
                    this.mc.field_1724.method_7346();
                    this.stage = Stage.SHOP_EXIT;
                    this.stageStart = now;
                    break;
                }
                if (now - this.stageStart <= (long)((Boolean)this.speedMode.get() != false ? 200 : 400)) break;
                this.stage = Stage.SHOP_TOTEM;
                this.stageStart = now;
                break;
            }
            case 6: {
                if (this.mc.field_1755 == null) {
                    this.stage = Stage.WAIT;
                    this.stageStart = now;
                }
                if (now - this.stageStart <= (long)((Boolean)this.speedMode.get() != false ? 1000 : 5000)) break;
                this.mc.field_1724.method_7346();
                this.stage = Stage.SHOP;
                this.stageStart = now;
                break;
            }
            case 7: {
                long waitTime;
                long l = waitTime = (Boolean)this.speedMode.get() != false ? 25L : 50L;
                if (now - this.stageStart < waitTime) break;
                if (this.isTargetingActive && !this.targetPlayer.isEmpty()) {
                    this.stage = Stage.TARGET_ORDERS;
                } else {
                    ChatUtils.sendPlayerMsg((String)"/orders totem");
                    this.stage = Stage.ORDERS;
                }
                this.stageStart = now;
                break;
            }
            case 8: {
                class_437 handler = this.mc.field_1755;
                if (!(handler instanceof class_476)) break;
                class_476 screen = (class_476)handler;
                handler = screen.method_17577();
                boolean foundOrder = false;
                if (((Boolean)this.speedMode.get()).booleanValue() && now - this.stageStart < 200L) {
                    return;
                }
                for (class_1735 slot : handler.field_7761) {
                    double minPriceValue;
                    double orderPrice;
                    boolean isTargetedOrder;
                    class_1799 stack = slot.method_7677();
                    if (stack.method_7960() || !this.isTotemOfUndying(stack) || !this.isPurple(stack)) continue;
                    boolean shouldTakeOrder = false;
                    String orderPlayer = this.getOrderPlayerName(stack);
                    boolean bl = isTargetedOrder = this.isTargetingActive && orderPlayer != null && orderPlayer.equalsIgnoreCase(this.targetPlayer);
                    if (isTargetedOrder) {
                        shouldTakeOrder = true;
                        if (((Boolean)this.notifications.get()).booleanValue()) {
                            orderPrice = this.getOrderPrice(stack);
                            this.info("\ud83c\udfaf Found TARGET order from %s: %s", orderPlayer, orderPrice > 0.0 ? this.formatPrice(orderPrice) : "Unknown price");
                        }
                    } else if (!((Boolean)this.targetOnlyMode.get()).booleanValue() && (orderPrice = this.getOrderPrice(stack)) >= (minPriceValue = this.parsePrice((String)this.minPrice.get()))) {
                        shouldTakeOrder = true;
                        if (((Boolean)this.notifications.get()).booleanValue()) {
                            this.info("\u2705 Found order: %s", this.formatPrice(orderPrice));
                        }
                    }
                    if (!shouldTakeOrder) continue;
                    this.mc.field_1761.method_2906(handler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    this.stage = Stage.ORDERS_SELECT;
                    this.stageStart = now + (long)((Boolean)this.speedMode.get() != false ? 100 : 50);
                    this.shulkerMoveIndex = 0;
                    this.lastShulkerMoveTime = 0L;
                    foundOrder = true;
                    if (((Boolean)this.notifications.get()).booleanValue()) {
                        this.info("\ud83d\udd04 Selected order, preparing to transfer items...", new Object[0]);
                    }
                    return;
                }
                if (foundOrder || now - this.stageStart <= (long)((Boolean)this.speedMode.get() != false ? 3000 : 5000)) break;
                this.mc.field_1724.method_7346();
                this.stage = Stage.SHOP;
                this.stageStart = now;
                break;
            }
            case 9: {
                long moveDelay;
                class_437 handler = this.mc.field_1755;
                if (!(handler instanceof class_476)) break;
                class_476 screen = (class_476)handler;
                handler = screen.method_17577();
                if (this.shulkerMoveIndex >= 36) {
                    this.mc.field_1724.method_7346();
                    this.stage = Stage.ORDERS_CONFIRM;
                    this.stageStart = now;
                    this.shulkerMoveIndex = 0;
                    return;
                }
                long l = moveDelay = (Boolean)this.speedMode.get() != false ? 10L : 100L;
                if (now - this.lastShulkerMoveTime < moveDelay) break;
                int batchSize = (Boolean)this.speedMode.get() != false ? 3 : 1;
                for (int batch = 0; batch < batchSize && this.shulkerMoveIndex < 36; ++batch) {
                    class_1799 stack = this.mc.field_1724.method_31548().method_5438(this.shulkerMoveIndex);
                    if (this.isTotemOfUndying(stack)) {
                        int playerSlotId = -1;
                        for (class_1735 slot : handler.field_7761) {
                            if (slot.field_7871 != this.mc.field_1724.method_31548() || slot.method_34266() != this.shulkerMoveIndex) continue;
                            playerSlotId = slot.field_7874;
                            break;
                        }
                        if (playerSlotId != -1) {
                            this.mc.field_1761.method_2906(handler.field_7763, playerSlotId, 0, class_1713.field_7794, (class_1657)this.mc.field_1724);
                        }
                    }
                    ++this.shulkerMoveIndex;
                }
                this.lastShulkerMoveTime = now;
                break;
            }
            case 10: {
                if (this.mc.field_1755 != null) break;
                ++this.exitCount;
                if (this.exitCount < 2) {
                    this.mc.field_1724.method_7346();
                    this.stageStart = now;
                    break;
                }
                this.exitCount = 0;
                this.stage = Stage.ORDERS_CONFIRM;
                this.stageStart = now;
                break;
            }
            case 11: {
                class_437 handler = this.mc.field_1755;
                if (!(handler instanceof class_476)) break;
                class_476 screen = (class_476)handler;
                handler = screen.method_17577();
                for (class_1735 slot : handler.field_7761) {
                    class_1799 stack = slot.method_7677();
                    if (stack.method_7960() || !this.isGreenGlass(stack)) continue;
                    for (int i = 0; i < ((Boolean)this.speedMode.get() != false ? 15 : 5); ++i) {
                        this.mc.field_1761.method_2906(handler.field_7763, slot.field_7874, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    }
                    this.stage = Stage.ORDERS_FINAL_EXIT;
                    this.stageStart = now;
                    this.finalExitCount = 0;
                    this.finalExitStart = now;
                    if (((Boolean)this.notifications.get()).booleanValue()) {
                        this.info("\u2705 Order completed! Going back to shop to buy more totems...", new Object[0]);
                    }
                    return;
                }
                if (now - this.stageStart <= (long)((Boolean)this.speedMode.get() != false ? 2000 : 5000)) break;
                this.mc.field_1724.method_7346();
                this.stage = Stage.SHOP;
                this.stageStart = now;
                break;
            }
            case 12: {
                long exitDelay;
                long l = exitDelay = (Boolean)this.speedMode.get() != false ? 50L : 200L;
                if (this.finalExitCount == 0) {
                    if (System.currentTimeMillis() - this.finalExitStart < exitDelay) break;
                    this.mc.field_1724.method_7346();
                    ++this.finalExitCount;
                    this.finalExitStart = System.currentTimeMillis();
                    break;
                }
                if (this.finalExitCount == 1) {
                    if (System.currentTimeMillis() - this.finalExitStart < exitDelay) break;
                    this.mc.field_1724.method_7346();
                    ++this.finalExitCount;
                    this.finalExitStart = System.currentTimeMillis();
                    break;
                }
                this.finalExitCount = 0;
                this.stage = Stage.CYCLE_PAUSE;
                this.stageStart = System.currentTimeMillis();
                break;
            }
            case 13: {
                long cycleWait;
                long l = cycleWait = (Boolean)this.speedMode.get() != false ? 10L : 25L;
                if (now - this.stageStart < cycleWait) break;
                this.updateTargetPlayer();
                this.stage = Stage.SHOP;
                this.stageStart = now;
                break;
            }
        }
    }

    private String getOrderPlayerName(class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.mc.field_1687);
        List tooltip = stack.method_7950(tooltipContext, (class_1657)this.mc.field_1724, (class_1836)class_1836.field_41070);
        for (class_2561 line : tooltip) {
            Pattern[] namePatterns;
            String text = line.getString();
            for (Pattern pattern : namePatterns = new Pattern[]{Pattern.compile("(?i)player\\s*:\\s*([a-zA-Z0-9_]+)"), Pattern.compile("(?i)from\\s*:\\s*([a-zA-Z0-9_]+)"), Pattern.compile("(?i)by\\s*:\\s*([a-zA-Z0-9_]+)"), Pattern.compile("(?i)seller\\s*:\\s*([a-zA-Z0-9_]+)"), Pattern.compile("(?i)owner\\s*:\\s*([a-zA-Z0-9_]+)"), Pattern.compile("\\b([a-zA-Z0-9_]{3,16})\\b")}) {
                String playerName;
                Matcher matcher = pattern.matcher(text);
                if (!matcher.find() || (playerName = matcher.group(1)).length() < 3 || playerName.length() > 16 || !playerName.matches("[a-zA-Z0-9_]+")) continue;
                return playerName;
            }
        }
        return null;
    }

    private double getOrderPrice(class_1799 stack) {
        if (stack.method_7960()) {
            return -1.0;
        }
        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.mc.field_1687);
        List tooltip = stack.method_7950(tooltipContext, (class_1657)this.mc.field_1724, (class_1836)class_1836.field_41070);
        return this.parseTooltipPrice(tooltip);
    }

    private double parseTooltipPrice(List<class_2561> tooltip) {
        if (tooltip == null || tooltip.isEmpty()) {
            return -1.0;
        }
        Pattern[] pricePatterns = new Pattern[]{Pattern.compile("\\$([\\d,]+(?:\\.[\\d]+)?)([kmb])?", 2), Pattern.compile("(?i)price\\s*:\\s*([\\d,]+(?:\\.[\\d]+)?)([kmb])?", 2), Pattern.compile("(?i)pay\\s*:\\s*([\\d,]+(?:\\.[\\d]+)?)([kmb])?", 2), Pattern.compile("(?i)reward\\s*:\\s*([\\d,]+(?:\\.[\\d]+)?)([kmb])?", 2), Pattern.compile("([\\d,]+(?:\\.[\\d]+)?)([kmb])?\\s*coins?", 2), Pattern.compile("\\b([\\d,]+(?:\\.[\\d]+)?)([kmb])\\b", 2)};
        for (class_2561 line : tooltip) {
            String text = line.getString();
            for (Pattern pattern : pricePatterns) {
                Matcher matcher = pattern.matcher(text);
                if (!matcher.find()) continue;
                String numberStr = matcher.group(1).replace(",", "");
                String suffix = "";
                if (matcher.groupCount() >= 2 && matcher.group(2) != null) {
                    suffix = matcher.group(2).toLowerCase();
                }
                try {
                    double basePrice = Double.parseDouble(numberStr);
                    double multiplier = 1.0;
                    switch (suffix) {
                        case "k": {
                            multiplier = 1000.0;
                            break;
                        }
                        case "m": {
                            multiplier = 1000000.0;
                            break;
                        }
                        case "b": {
                            multiplier = 1.0E9;
                        }
                    }
                    return basePrice * multiplier;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return -1.0;
    }

    private double parsePrice(String priceStr) {
        if (priceStr == null || priceStr.isEmpty()) {
            return -1.0;
        }
        String cleaned = priceStr.trim().toLowerCase().replace(",", "");
        double multiplier = 1.0;
        if (cleaned.endsWith("b")) {
            multiplier = 1.0E9;
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        } else if (cleaned.endsWith("m")) {
            multiplier = 1000000.0;
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        } else if (cleaned.endsWith("k")) {
            multiplier = 1000.0;
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        }
        try {
            return Double.parseDouble(cleaned) * multiplier;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    private String formatPrice(double price) {
        if (price >= 1.0E9) {
            return String.format("$%.1fB", price / 1.0E9);
        }
        if (price >= 1000000.0) {
            return String.format("$%.1fM", price / 1000000.0);
        }
        if (price >= 1000.0) {
            return String.format("$%.1fK", price / 1000.0);
        }
        return String.format("$%.0f", price);
    }

    private boolean isTotemOfUndying(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8288;
    }

    private boolean isShulkerBox(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909().method_63680().getString().toLowerCase(Locale.ROOT).contains("shulker box");
    }

    private boolean isPurple(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8288;
    }

    private boolean isGreenGlass(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8581 || stack.method_7909() == class_1802.field_8656;
    }

    private boolean isInventoryFull() {
        for (int i = 9; i <= 35; ++i) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (!stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public void info(String message, Object ... args) {
        if (((Boolean)this.notifications.get()).booleanValue()) {
            ChatUtils.info((String)String.format(message, args), (Object[])new Object[0]);
        }
    }

    private static enum Stage {
        NONE,
        SHOP,
        SHOP_GEAR,
        SHOP_TOTEM,
        SHOP_CONFIRM,
        SHOP_CHECK_FULL,
        SHOP_EXIT,
        WAIT,
        ORDERS,
        ORDERS_SELECT,
        ORDERS_EXIT,
        ORDERS_CONFIRM,
        ORDERS_FINAL_EXIT,
        CYCLE_PAUSE,
        TARGET_ORDERS;

    }
}

