/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1802;
import net.minecraft.class_465;

public class CrateBuyer
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<ItemType> WhatToBuy;
    private final Setting<Integer> delay;
    private int tickCounter;
    private int warningCooldown;
    private int currentStep;
    private int currentItemIndex;
    private boolean hasClickedOnce;
    private static final int HELMET_SLOT = 10;
    private static final int CHESTPLATE_SLOT = 11;
    private static final int LEGGINGS_SLOT = 12;
    private static final int BOOTS_SLOT = 13;
    private static final int SWORD_SLOT = 14;
    private static final int PICKAXE_SLOT = 15;
    private static final int SHOVEL_SLOT = 16;
    private static final int CONFIRM_SLOT_DEFAULT = 15;
    private static final int CONFIRM_SLOT_SHOVEL = 15;

    public CrateBuyer() {
        super(GlazedAddon.CATEGORY, "CrateBuyer", "Automatically buys items from the common crate");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.WhatToBuy = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("Item Type")).description("What item to buy from the crates")).defaultValue((Object)ItemType.All)).build());
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("Delay between clicks in ticks.")).defaultValue((Object)5)).min(5).max(20).sliderMax(20).build());
        this.tickCounter = 0;
        this.warningCooldown = 0;
        this.currentStep = 0;
        this.currentItemIndex = 0;
        this.hasClickedOnce = false;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1761 == null) {
            return;
        }
        if (this.warningCooldown > 0) {
            --this.warningCooldown;
        }
        if (!(this.mc.field_1755 instanceof class_465)) {
            if (this.isActive() && this.warningCooldown == 0) {
                this.warning("You need to be on the crate screen to use this module.", new Object[0]);
                this.warningCooldown = 20;
            }
            return;
        }
        class_465 screen = (class_465)this.mc.field_1755;
        if (!this.hasClickedOnce && !this.isValidCrateScreen(screen)) {
            if (this.warningCooldown == 0) {
                this.warning("This doesn't appear to be a valid crate screen. Closing screen.", new Object[0]);
                this.warningCooldown = 20;
                this.mc.method_1507(null);
            }
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter < (Integer)this.delay.get()) {
            return;
        }
        this.tickCounter = 0;
        if (this.WhatToBuy.get() == ItemType.All) {
            this.handleAllItems(screen);
        } else {
            this.handleSingleItem(screen);
        }
    }

    private boolean isValidCrateScreen(class_465<?> screen) {
        int i;
        for (i = 0; i <= 9; ++i) {
            if (screen.method_17577().method_7611(i).method_7677().method_31574(class_1802.field_8871)) continue;
            return false;
        }
        for (i = 17; i <= 26; ++i) {
            if (screen.method_17577().method_7611(i).method_7677().method_31574(class_1802.field_8871)) continue;
            return false;
        }
        return true;
    }

    private void handleAllItems(class_465<?> screen) {
        ItemType[] items = new ItemType[]{ItemType.Helmet, ItemType.Chestplate, ItemType.Leggings, ItemType.Boots, ItemType.Sword, ItemType.Pickaxe, ItemType.Shovel};
        if (this.currentStep == 0) {
            int itemSlot = this.getItemSlot(items[this.currentItemIndex]);
            this.mc.field_1761.method_2906(screen.method_17577().field_7763, itemSlot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.hasClickedOnce = true;
            this.currentStep = 1;
        } else {
            int confirmSlot = this.getConfirmSlot(items[this.currentItemIndex]);
            this.mc.field_1761.method_2906(screen.method_17577().field_7763, confirmSlot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.currentStep = 0;
            ++this.currentItemIndex;
            if (this.currentItemIndex >= items.length) {
                this.currentItemIndex = 0;
            }
        }
    }

    private void handleSingleItem(class_465<?> screen) {
        if (this.currentStep == 0) {
            int itemSlot = this.getItemSlot((ItemType)((Object)this.WhatToBuy.get()));
            this.mc.field_1761.method_2906(screen.method_17577().field_7763, itemSlot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.hasClickedOnce = true;
            this.currentStep = 1;
        } else {
            int confirmSlot = this.getConfirmSlot((ItemType)((Object)this.WhatToBuy.get()));
            this.mc.field_1761.method_2906(screen.method_17577().field_7763, confirmSlot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.currentStep = 0;
        }
    }

    private int getItemSlot(ItemType itemType) {
        switch (itemType.ordinal()) {
            case 1: {
                return 10;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 13;
            }
            case 5: {
                return 14;
            }
            case 6: {
                return 15;
            }
            case 7: {
                return 16;
            }
        }
        return 10;
    }

    private int getConfirmSlot(ItemType itemType) {
        if (itemType == ItemType.Shovel) {
            return 15;
        }
        return 15;
    }

    public void onActivate() {
        this.tickCounter = 0;
        this.warningCooldown = 0;
        this.currentStep = 0;
        this.currentItemIndex = 0;
        this.hasClickedOnce = false;
        this.info("CrateBuyer activated. Mode: " + ((ItemType)((Object)this.WhatToBuy.get())).toString(), new Object[0]);
    }

    public void onDeactivate() {
        this.currentStep = 0;
        this.currentItemIndex = 0;
        this.hasClickedOnce = false;
    }

    public static enum ItemType {
        All,
        Helmet,
        Chestplate,
        Leggings,
        Boots,
        Sword,
        Pickaxe,
        Shovel;

    }
}

