/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.meteor.KeyEvent;
import meteordevelopment.meteorclient.events.meteor.MouseButtonEvent;
import meteordevelopment.meteorclient.events.meteor.MouseScrollEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.ChunkOcclusionEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.movement.GUIMove;
import meteordevelopment.meteorclient.utils.misc.input.Input;
import meteordevelopment.meteorclient.utils.misc.input.KeyAction;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2663;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5498;
import net.minecraft.class_761;
import net.minecraft.class_8143;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class FreecamV2
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Double> speed;
    private final Setting<Double> speedScrollSensitivity;
    private final Setting<Boolean> allowMining;
    private final Setting<Boolean> toggleOnDamage;
    private final Setting<Boolean> toggleOnDeath;
    private final Setting<Boolean> toggleOnLog;
    private final Setting<Boolean> reloadChunks;
    private final Setting<Boolean> renderHands;
    private final Setting<Boolean> rotate;
    private final Setting<Boolean> staticView;
    public final Vector3d pos;
    public final Vector3d prevPos;
    private class_5498 perspective;
    private double speedValue;
    public float yaw;
    public float pitch;
    public float lastYaw;
    public float lastPitch;
    private double fovScale;
    private boolean bobView;
    private boolean forward;
    private boolean backward;
    private boolean right;
    private boolean left;
    private boolean up;
    private boolean down;

    public FreecamV2() {
        super(GlazedAddon.CATEGORY, "freecam-v2", "Allows the camera to move away from the player while still allowing mining and interaction.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.speed = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("speed")).description("Your speed while in freecam.")).defaultValue(1.0).min(0.0).onChanged(val -> {
            this.speedValue = val;
        })).build());
        this.speedScrollSensitivity = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("speed-scroll-sensitivity")).description("Allows you to change speed value using scroll wheel. 0 to disable.")).defaultValue(1.0).min(0.0).sliderMax(2.0).build());
        this.allowMining = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("allow-mining")).description("Allows you to mine and interact while in freecam.")).defaultValue((Object)true)).build());
        this.toggleOnDamage = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("toggle-on-damage")).description("Disables freecam when you take damage.")).defaultValue((Object)false)).build());
        this.toggleOnDeath = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("toggle-on-death")).description("Disables freecam when you die.")).defaultValue((Object)false)).build());
        this.toggleOnLog = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("toggle-on-log")).description("Disables freecam when you disconnect from a server.")).defaultValue((Object)true)).build());
        this.reloadChunks = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("reload-chunks")).description("Disables cave culling.")).defaultValue((Object)true)).build());
        this.renderHands = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-hands")).description("Whether or not to render your hands in freecam.")).defaultValue((Object)true)).build());
        this.rotate = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Rotates to the block or entity you are looking at.")).defaultValue((Object)false)).build());
        this.staticView = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("static")).description("Disables settings that move the view.")).defaultValue((Object)true)).build());
        this.pos = new Vector3d();
        this.prevPos = new Vector3d();
    }

    public void onActivate() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            this.toggle();
        } else {
            this.fovScale = ((Integer)mc.field_1690.method_41808().method_41753()).intValue();
            this.bobView = (Boolean)mc.field_1690.method_42448().method_41753();
            if (((Boolean)this.staticView.get()).booleanValue()) {
                mc.field_1690.method_41808().method_41748((Object)0);
                mc.field_1690.method_42448().method_41748((Object)false);
            }
            this.yaw = mc.field_1724.method_36454();
            this.pitch = mc.field_1724.method_36455();
            this.perspective = mc.field_1690.method_31044();
            this.speedValue = (Double)this.speed.get();
            class_243 playerPos = mc.field_1724.method_19538();
            this.pos.set(playerPos.field_1352, playerPos.field_1351, playerPos.field_1350);
            this.prevPos.set(playerPos.field_1352, playerPos.field_1351, playerPos.field_1350);
            if (this.perspective == class_5498.field_26665) {
                this.yaw += 180.0f;
                this.pitch *= -1.0f;
            }
            this.lastYaw = this.yaw;
            this.lastPitch = this.pitch;
            this.forward = Input.isPressed((class_304)mc.field_1690.field_1894);
            this.backward = Input.isPressed((class_304)mc.field_1690.field_1881);
            this.right = Input.isPressed((class_304)mc.field_1690.field_1849);
            this.left = Input.isPressed((class_304)mc.field_1690.field_1913);
            this.up = Input.isPressed((class_304)mc.field_1690.field_1903);
            this.down = Input.isPressed((class_304)mc.field_1690.field_1832);
            this.unpress();
            if (((Boolean)this.reloadChunks.get()).booleanValue()) {
                mc.field_1769.method_3279();
            }
            this.info("FreecamV2 enabled - Mining and interaction " + ((Boolean)this.allowMining.get() != false ? "allowed" : "disabled"), new Object[0]);
        }
    }

    public void onDeactivate() {
        class_310 mc = class_310.method_1551();
        if (((Boolean)this.reloadChunks.get()).booleanValue()) {
            mc.execute(() -> ((class_761)mc.field_1769).method_3279());
        }
        mc.field_1690.method_31043(this.perspective);
        if (((Boolean)this.staticView.get()).booleanValue()) {
            mc.field_1690.method_41808().method_41748((Object)((int)this.fovScale));
            mc.field_1690.method_42448().method_41748((Object)this.bobView);
        }
        this.info("FreecamV2 disabled", new Object[0]);
    }

    @EventHandler
    private void onOpenScreen(OpenScreenEvent event) {
        this.unpress();
        this.prevPos.set((Vector3dc)this.pos);
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
    }

    private void unpress() {
        class_310 mc = class_310.method_1551();
        mc.field_1690.field_1894.method_23481(false);
        mc.field_1690.field_1881.method_23481(false);
        mc.field_1690.field_1849.method_23481(false);
        mc.field_1690.field_1913.method_23481(false);
        mc.field_1690.field_1903.method_23481(false);
        mc.field_1690.field_1832.method_23481(false);
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        class_310 mc = class_310.method_1551();
        if (!this.perspective.method_31034()) {
            mc.field_1690.method_31043(class_5498.field_26664);
        }
        double yawRad = Math.toRadians(this.yaw);
        class_243 forward = new class_243(-Math.sin(yawRad), 0.0, Math.cos(yawRad));
        double rightYawRad = Math.toRadians(this.yaw + 90.0f);
        class_243 right = new class_243(-Math.sin(rightYawRad), 0.0, Math.cos(rightYawRad));
        double velX = 0.0;
        double velY = 0.0;
        double velZ = 0.0;
        if (((Boolean)this.rotate.get()).booleanValue() && mc.field_1692 != null) {
            class_1297 target = mc.field_1692;
            class_243 targetPos = target.method_19538().method_1031(0.0, (double)target.method_18381(target.method_18376()), 0.0);
            Rotations.rotate((double)Rotations.getYaw((class_243)targetPos), (double)Rotations.getPitch((class_243)targetPos), (int)0, null);
        } else if (((Boolean)this.rotate.get()).booleanValue() && mc.field_1765 != null) {
            class_243 hitPos = mc.field_1765.method_17784();
            Rotations.rotate((double)Rotations.getYaw((class_243)hitPos), (double)Rotations.getPitch((class_243)hitPos), (int)0, null);
        }
        double s = 0.5;
        if (Input.isPressed((class_304)mc.field_1690.field_1867)) {
            s = 1.0;
        }
        boolean a = false;
        if (this.forward) {
            velX += forward.field_1352 * s * this.speedValue;
            velZ += forward.field_1350 * s * this.speedValue;
            a = true;
        }
        if (this.backward) {
            velX -= forward.field_1352 * s * this.speedValue;
            velZ -= forward.field_1350 * s * this.speedValue;
            a = true;
        }
        boolean b = false;
        if (this.right) {
            velX += right.field_1352 * s * this.speedValue;
            velZ += right.field_1350 * s * this.speedValue;
            b = true;
        }
        if (this.left) {
            velX -= right.field_1352 * s * this.speedValue;
            velZ -= right.field_1350 * s * this.speedValue;
            b = true;
        }
        if (a && b) {
            double diagonal = 1.0 / Math.sqrt(2.0);
            velX *= diagonal;
            velZ *= diagonal;
        }
        if (this.up) {
            velY += s * this.speedValue;
        }
        if (this.down) {
            velY -= s * this.speedValue;
        }
        this.prevPos.set((Vector3dc)this.pos);
        this.pos.set(this.pos.x + velX, this.pos.y + velY, this.pos.z + velZ);
    }

    @EventHandler(priority=100)
    public void onKey(KeyEvent event) {
        class_310 mc = class_310.method_1551();
        if (!Input.isKeyPressed((int)292) && !this.checkGuiMove()) {
            boolean cancel;
            boolean bl = cancel = (Boolean)this.allowMining.get() == false;
            if (mc.field_1690.field_1894.method_1417(event.key, 0)) {
                boolean bl2 = this.forward = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1894.method_23481(false);
                }
            } else if (mc.field_1690.field_1881.method_1417(event.key, 0)) {
                boolean bl3 = this.backward = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1881.method_23481(false);
                }
            } else if (mc.field_1690.field_1849.method_1417(event.key, 0)) {
                boolean bl4 = this.right = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1849.method_23481(false);
                }
            } else if (mc.field_1690.field_1913.method_1417(event.key, 0)) {
                boolean bl5 = this.left = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1913.method_23481(false);
                }
            } else if (mc.field_1690.field_1903.method_1417(event.key, 0)) {
                boolean bl6 = this.up = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1903.method_23481(false);
                }
            } else if (mc.field_1690.field_1832.method_1417(event.key, 0)) {
                boolean bl7 = this.down = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1832.method_23481(false);
                }
            } else {
                cancel = false;
            }
            if (cancel) {
                event.cancel();
            }
        }
    }

    @EventHandler(priority=100)
    private void onMouseButton(MouseButtonEvent event) {
        class_310 mc = class_310.method_1551();
        if (!this.checkGuiMove()) {
            boolean cancel;
            boolean bl = cancel = (Boolean)this.allowMining.get() == false;
            if (mc.field_1690.field_1894.method_1433(event.button)) {
                boolean bl2 = this.forward = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1894.method_23481(false);
                }
            } else if (mc.field_1690.field_1881.method_1433(event.button)) {
                boolean bl3 = this.backward = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1881.method_23481(false);
                }
            } else if (mc.field_1690.field_1849.method_1433(event.button)) {
                boolean bl4 = this.right = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1849.method_23481(false);
                }
            } else if (mc.field_1690.field_1913.method_1433(event.button)) {
                boolean bl5 = this.left = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1913.method_23481(false);
                }
            } else if (mc.field_1690.field_1903.method_1433(event.button)) {
                boolean bl6 = this.up = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1903.method_23481(false);
                }
            } else if (mc.field_1690.field_1832.method_1433(event.button)) {
                boolean bl7 = this.down = event.action != KeyAction.Release;
                if (!((Boolean)this.allowMining.get()).booleanValue()) {
                    mc.field_1690.field_1832.method_23481(false);
                }
            } else {
                cancel = false;
            }
            if (cancel) {
                event.cancel();
            }
        }
    }

    @EventHandler(priority=-100)
    private void onMouseScroll(MouseScrollEvent event) {
        class_310 mc = class_310.method_1551();
        if ((Double)this.speedScrollSensitivity.get() > 0.0 && mc.field_1755 == null) {
            this.speedValue += event.value * 0.25 * (Double)this.speedScrollSensitivity.get() * this.speedValue;
            if (this.speedValue < 0.1) {
                this.speedValue = 0.1;
            }
            event.cancel();
        }
    }

    @EventHandler
    private void onChunkOcclusion(ChunkOcclusionEvent event) {
        event.cancel();
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        if (((Boolean)this.toggleOnLog.get()).booleanValue()) {
            this.toggle();
        }
    }

    @EventHandler
    private void onPacketReceive(PacketEvent.Receive event) {
        if (event.packet instanceof class_2663) {
            class_2663 packet = (class_2663)event.packet;
            class_1297 entity = packet.method_11469((class_1937)class_310.method_1551().field_1687);
            if (entity == class_310.method_1551().field_1724 && ((Boolean)this.toggleOnDeath.get()).booleanValue()) {
                this.toggle();
                this.info("Toggled off because you died.", new Object[0]);
            }
        } else if (event.packet instanceof class_8143 && class_310.method_1551().field_1724 != null && ((Boolean)this.toggleOnDamage.get()).booleanValue()) {
            this.toggle();
            this.info("Toggled off because you took damage.", new Object[0]);
        }
    }

    private boolean checkGuiMove() {
        class_310 mc = class_310.method_1551();
        GUIMove guiMove = (GUIMove)Modules.get().get(GUIMove.class);
        if (mc.field_1755 != null && !guiMove.isActive()) {
            return true;
        }
        return mc.field_1755 != null && guiMove.isActive() && guiMove.skip();
    }

    public void changeLookDirection(double deltaX, double deltaY) {
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
        this.yaw += (float)deltaX;
        this.pitch += (float)deltaY;
        this.pitch = class_3532.method_15363((float)this.pitch, (float)-90.0f, (float)90.0f);
    }

    public boolean renderHands() {
        return !this.isActive() || (Boolean)this.renderHands.get() != false;
    }

    public boolean allowMining() {
        return (Boolean)this.allowMining.get();
    }

    public double getX(float tickDelta) {
        return class_3532.method_16436((double)tickDelta, (double)this.prevPos.x, (double)this.pos.x);
    }

    public double getY(float tickDelta) {
        return class_3532.method_16436((double)tickDelta, (double)this.prevPos.y, (double)this.pos.y);
    }

    public double getZ(float tickDelta) {
        return class_3532.method_16436((double)tickDelta, (double)this.prevPos.z, (double)this.pos.z);
    }

    public double getYaw(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastYaw, (float)this.yaw);
    }

    public double getPitch(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastPitch, (float)this.pitch);
    }
}

