/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.ModuleListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringListSetting;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.render.MeteorToast;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_368;

public class PlayerDetection
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgwhitelist;
    private final SettingGroup sgwebhook;
    private final SettingGroup sgPanicPay;
    private static final Set<String> PERMANENT_WHITELIST = new HashSet<String>(Arrays.asList("FreeCamera"));
    private final Setting<List<String>> userWhitelist;
    private final Setting<List<Module>> modulesToToggle;
    private final Setting<Boolean> enableWebhook;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;
    private final Setting<Boolean> enableDisconnect;
    private final Setting<Mode> notificationMode;
    private final Setting<Boolean> toggleonplayer;
    private final Setting<Boolean> enablePanicPay;
    private final Setting<String> panicPayTarget;
    private final Setting<String> panicPayAmount;
    private final Set<String> detectedPlayers;
    private final HttpClient httpClient;

    public PlayerDetection() {
        super(GlazedAddon.CATEGORY, "PlayerDetection", "Detects when players are in the world");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgwhitelist = this.settings.createGroup("Whitelist");
        this.sgwebhook = this.settings.createGroup("Webhook");
        this.sgPanicPay = this.settings.createGroup("Panic Pay");
        this.userWhitelist = this.sgwhitelist.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("User Whitelist")).description("List of player names to ignore")).defaultValue(new ArrayList())).build());
        this.modulesToToggle = this.sgGeneral.add((Setting)((ModuleListSetting.Builder)((ModuleListSetting.Builder)((ModuleListSetting.Builder)new ModuleListSetting.Builder().name("Modules To Toggle")).description("Select modules to toggle when a non-whitelisted player is detected")).defaultValue(new ArrayList())).build());
        this.enableWebhook = this.sgwebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Webhook")).description("Send webhook notifications when players are detected")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgwebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Webhook URL")).description("Discord webhook URL")).defaultValue((Object)"")).visible(() -> this.enableWebhook.get())).build());
        this.selfPing = this.sgwebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Self Ping")).description("Ping yourself in the webhook message")).defaultValue((Object)false)).visible(() -> this.enableWebhook.get())).build());
        this.discordId = this.sgwebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Discord ID")).description("Your Discord user ID for pinging")).defaultValue((Object)"")).visible(() -> (Boolean)this.enableWebhook.get() != false && (Boolean)this.selfPing.get() != false)).build());
        this.enableDisconnect = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Disconnect")).description("Automatically disconnect when players are detected")).defaultValue((Object)true)).build());
        this.notificationMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("notification-mode")).description("How to notify when players are detected")).defaultValue((Object)Mode.Both)).build());
        this.toggleonplayer = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Toggle when a player is detected")).description("Automatically toggles THIS module when a player is detected")).defaultValue((Object)true)).build());
        this.enablePanicPay = this.sgPanicPay.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Enable Panic Pay")).description("Automatically send specified amount of money to target player when non-whitelisted player detected")).defaultValue((Object)false)).build());
        this.panicPayTarget = this.sgPanicPay.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Target Player")).description("Player to send money to when panic pay is triggered")).defaultValue((Object)"")).visible(() -> this.enablePanicPay.get())).build());
        this.panicPayAmount = this.sgPanicPay.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Amount")).description("Amount of money to send (e.g., 1000, 500.50)")).defaultValue((Object)"")).visible(() -> this.enablePanicPay.get())).build());
        this.detectedPlayers = new HashSet<String>();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        HashSet<String> currentPlayers = new HashSet<String>();
        String currentPlayerName = this.mc.field_1724.method_7334().getName();
        HashSet<String> fullWhitelist = new HashSet<String>(PERMANENT_WHITELIST);
        fullWhitelist.addAll((Collection)this.userWhitelist.get());
        for (class_1657 player : this.mc.field_1687.method_18456()) {
            String playerName;
            if (player == this.mc.field_1724 || (playerName = player.method_7334().getName()).equals(currentPlayerName) || fullWhitelist.contains(playerName)) continue;
            currentPlayers.add(playerName);
        }
        if (!currentPlayers.isEmpty() && !currentPlayers.equals(this.detectedPlayers)) {
            this.detectedPlayers.clear();
            this.detectedPlayers.addAll(currentPlayers);
            this.handlePlayerDetection(currentPlayers);
        } else if (currentPlayers.isEmpty()) {
            this.detectedPlayers.clear();
        }
    }

    private void handlePlayerDetection(Set<String> players) {
        String playerList = String.join((CharSequence)", ", players);
        switch (((Mode)((Object)this.notificationMode.get())).ordinal()) {
            case 0: {
                this.info("Player(s) detected: (highlight)%s", new Object[]{playerList});
                break;
            }
            case 1: {
                this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8575, this.title, "Player Detected!"));
                break;
            }
            case 2: {
                this.info("Player(s) detected: (highlight)%s", new Object[]{playerList});
                this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8575, this.title, "Player Detected!"));
            }
        }
        ChatUtils.sendPlayerMsg((String)"#stop");
        for (Module m : (List)this.modulesToToggle.get()) {
            m.toggle();
            this.info("Toggled module: (highlight)%s", new Object[]{m.title});
        }
        if (((Boolean)this.enablePanicPay.get()).booleanValue()) {
            String target = ((String)this.panicPayTarget.get()).trim();
            String amount = ((String)this.panicPayAmount.get()).trim();
            if (!target.isEmpty() && !amount.isEmpty()) {
                String payCommand = String.format("/pay %s %s", target, amount);
                ChatUtils.sendPlayerMsg((String)payCommand);
                this.info("Panic pay executed: sent %s to %s", new Object[]{amount, target});
            } else if (target.isEmpty()) {
                this.warning("Panic pay target not set!", new Object[0]);
            } else if (amount.isEmpty()) {
                this.warning("Panic pay amount not set!", new Object[0]);
            }
        }
        if (((Boolean)this.enableWebhook.get()).booleanValue()) {
            this.sendWebhookNotification(players);
        }
        if (((Boolean)this.toggleonplayer.get()).booleanValue()) {
            this.toggle();
        }
        if (((Boolean)this.enableDisconnect.get()).booleanValue()) {
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(500L);
                    this.disconnectFromServer(playerList);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
    }

    private void sendWebhookNotification(Set<String> players) {
        String url = ((String)this.webhookUrl.get()).trim();
        if (url.isEmpty()) {
            this.warning("Webhook URL not configured!", new Object[0]);
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String playerList = String.join((CharSequence)", ", players);
                String serverInfo = this.mc.method_1558() != null ? this.mc.method_1558().field_3761 : "Unknown Server";
                String messageContent = "";
                if (((Boolean)this.selfPing.get()).booleanValue() && !((String)this.discordId.get()).trim().isEmpty()) {
                    messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
                }
                String panicPayInfo = "";
                if (((Boolean)this.enablePanicPay.get()).booleanValue() && !((String)this.panicPayTarget.get()).trim().isEmpty() && !((String)this.panicPayAmount.get()).trim().isEmpty()) {
                    panicPayInfo = String.format(",{\"name\":\"Panic Pay\",\"value\":\"Activated - Target: %s, Amount: %s\",\"inline\":true}", ((String)this.panicPayTarget.get()).trim().replace("\"", "\\\""), ((String)this.panicPayAmount.get()).trim().replace("\"", "\\\""));
                }
                String jsonPayload = String.format("{\"content\":\"%s\",\"embeds\":[{\"title\":\"\ud83d\udea8 Player Detection Alert\",\"description\":\"Player(s) detected on server!\",\"color\":15158332,\"fields\":[{\"name\":\"Players\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Server\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Time\",\"value\":\"<t:%d:R>\",\"inline\":true}%s],\"footer\":{\"text\":\"Sent by Overkill\"}}]}", messageContent.replace("\"", "\\\""), playerList.replace("\"", "\\\""), serverInfo.replace("\"", "\\\""), System.currentTimeMillis() / 1000L, panicPayInfo);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 204) {
                    this.info("Webhook notification sent successfully", new Object[0]);
                } else {
                    this.error("Webhook failed with status: " + response.statusCode(), new Object[0]);
                }
            }
            catch (IOException | InterruptedException e) {
                this.error("Failed to send webhook: " + e.getMessage(), new Object[0]);
            }
        });
    }

    private void disconnectFromServer(String playerList) {
        if (this.mc.field_1687 != null && this.mc.method_1562() != null) {
            String reason = "Player(s) detected: " + playerList;
            this.mc.method_1562().method_48296().method_10747((class_2561)class_2561.method_43470((String)reason));
            this.info("Disconnected from server - " + reason, new Object[0]);
        }
    }

    public void onActivate() {
        this.detectedPlayers.clear();
    }

    public void onDeactivate() {
        this.detectedPlayers.clear();
    }

    public String getInfoString() {
        return this.detectedPlayers.isEmpty() ? null : String.valueOf(this.detectedPlayers.size());
    }

    public static enum Mode {
        Chat,
        Toast,
        Both;

    }
}

