/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import meteordevelopment.meteorclient.events.world.ChunkDataEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StorageBlockListSetting;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.render.MeteorToast;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2609;
import net.minecraft.class_2611;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_2661;
import net.minecraft.class_368;
import net.minecraft.class_3719;

public class RTPNetherBaseFinder
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgWebhook;
    private final Setting<List<class_2591<?>>> storageBlocks;
    private final Setting<Integer> minimumStorageCount;
    private final Setting<Boolean> criticalSpawner;
    private final Setting<Integer> rtpInterval;
    private final Setting<Boolean> disconnectOnBaseFind;
    private final Setting<Boolean> sendNotifications;
    private final Setting<Mode> notificationMode;
    private final Setting<Boolean> enableWebhook;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;
    public List<NetherStashChunk> foundStashes;
    private final Set<class_1923> processedChunks;
    private long lastRtpTime;
    private final HttpClient httpClient;

    public RTPNetherBaseFinder() {
        super(GlazedAddon.CATEGORY, "RTPNetherBaseFinder", "Continuously RTPs to the Nether and searches for stashes.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgWebhook = this.settings.createGroup("Webhook");
        this.storageBlocks = this.sgGeneral.add((Setting)((StorageBlockListSetting.Builder)((StorageBlockListSetting.Builder)new StorageBlockListSetting.Builder().name("storage-blocks")).description("Storage blocks to search for in the Nether.")).defaultValue(StorageBlockListSetting.STORAGE_BLOCKS).build());
        this.minimumStorageCount = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("minimum-storage-count")).description("Minimum storage blocks in a chunk to count as a stash.")).defaultValue((Object)4)).min(1).sliderMin(1).sliderMax(100).build());
        this.criticalSpawner = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("critical-spawner")).description("Mark chunk as stash even if only a single spawner is found.")).defaultValue((Object)true)).build());
        this.rtpInterval = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("rtp-interval")).description("Interval between /rtp nether commands in seconds.")).defaultValue((Object)10)).min(5).sliderMin(5).sliderMax(60).build());
        this.disconnectOnBaseFind = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disconnect-on-base-find")).description("Automatically disconnect when a Nether base is found.")).defaultValue((Object)true)).build());
        this.sendNotifications = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("notifications")).description("Sends Minecraft notifications when new Nether stashes are found.")).defaultValue((Object)true)).build());
        this.notificationMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("notification-mode")).description("The mode to use for notifications.")).defaultValue((Object)Mode.Both)).visible(() -> this.sendNotifications.get())).build());
        this.enableWebhook = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("webhook")).description("Send webhook notifications when Nether stashes are found.")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL.")).defaultValue((Object)"")).visible(() -> this.enableWebhook.get())).build());
        this.selfPing = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("self-ping")).description("Ping yourself in the webhook message.")).defaultValue((Object)false)).visible(() -> this.enableWebhook.get())).build());
        this.discordId = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("discord-id")).description("Your Discord user ID for pinging.")).defaultValue((Object)"")).visible(() -> (Boolean)this.enableWebhook.get() != false && (Boolean)this.selfPing.get() != false)).build());
        this.foundStashes = new ArrayList<NetherStashChunk>();
        this.processedChunks = new HashSet<class_1923>();
        this.lastRtpTime = 0L;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public void onActivate() {
        this.foundStashes.clear();
        this.processedChunks.clear();
        this.lastRtpTime = 0L;
        this.info("Started RTP Nether Base Finder", new Object[0]);
    }

    public void onDeactivate() {
        this.processedChunks.clear();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            if (this.isActive()) {
                this.toggle();
            }
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRtpTime >= (long)((Integer)this.rtpInterval.get()).intValue() * 1000L) {
            ChatUtils.sendPlayerMsg((String)"/rtp nether");
            this.lastRtpTime = currentTime;
        }
    }

    @EventHandler
    private void onChunkData(ChunkDataEvent event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        class_1923 chunkPos = event.chunk().method_12004();
        if (this.processedChunks.contains(chunkPos)) {
            return;
        }
        NetherStashChunk chunk = new NetherStashChunk(chunkPos);
        boolean hasSpawner = false;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 10; y < 128; ++y) {
                    if (this.mc.field_1687.method_8320(new class_2338(chunkPos.method_8326() + x, y, chunkPos.method_8328() + z)).method_26204() != class_2246.field_10260) continue;
                    ++chunk.spawners;
                    hasSpawner = true;
                }
            }
        }
        for (class_2586 blockEntity : event.chunk().method_12214().values()) {
            class_2591 type = blockEntity.method_11017();
            if (!((List)this.storageBlocks.get()).contains(type)) continue;
            if (blockEntity instanceof class_2595) {
                ++chunk.chests;
                continue;
            }
            if (blockEntity instanceof class_3719) {
                ++chunk.barrels;
                continue;
            }
            if (blockEntity instanceof class_2627) {
                ++chunk.shulkers;
                continue;
            }
            if (blockEntity instanceof class_2611) {
                ++chunk.enderChests;
                continue;
            }
            if (blockEntity instanceof class_2609) {
                ++chunk.furnaces;
                continue;
            }
            if (blockEntity instanceof class_2601) {
                ++chunk.dispensersDroppers;
                continue;
            }
            if (!(blockEntity instanceof class_2614)) continue;
            ++chunk.hoppers;
        }
        boolean isStash = false;
        boolean isCriticalSpawner = false;
        Object detectionReason = "";
        if (((Boolean)this.criticalSpawner.get()).booleanValue() && hasSpawner) {
            isStash = true;
            isCriticalSpawner = true;
            detectionReason = "Spawner(s) detected (Critical mode)";
        } else if (chunk.getTotalNonSpawner() >= (Integer)this.minimumStorageCount.get()) {
            isStash = true;
            detectionReason = "Storage threshold reached (" + chunk.getTotalNonSpawner() + " blocks)";
        }
        if (isStash) {
            this.processedChunks.add(chunkPos);
            NetherStashChunk prevChunk = null;
            int existingIndex = this.foundStashes.indexOf(chunk);
            if (existingIndex < 0) {
                this.foundStashes.add(chunk);
            } else {
                prevChunk = this.foundStashes.set(existingIndex, chunk);
            }
            if (!(!((Boolean)this.sendNotifications.get()).booleanValue() || chunk.equals(prevChunk) && chunk.countsEqual(prevChunk))) {
                String stashType = isCriticalSpawner ? "Nether spawner base" : "Nether stash";
                switch (((Mode)((Object)this.notificationMode.get())).ordinal()) {
                    case 0: {
                        this.info("Found %s at (highlight)%s(default), (highlight)%s(default). %s", new Object[]{stashType, chunk.x, chunk.z, detectionReason});
                        break;
                    }
                    case 1: {
                        MeteorToast toast = new MeteorToast(class_1802.field_8729, this.title, "Found " + stashType.substring(0, 1).toUpperCase() + stashType.substring(1) + "!");
                        this.mc.method_1566().method_1999((class_368)toast);
                        break;
                    }
                    case 2: {
                        this.info("Found %s at (highlight)%s(default), (highlight)%s(default). %s", new Object[]{stashType, chunk.x, chunk.z, detectionReason});
                        MeteorToast toast = new MeteorToast(class_1802.field_8729, this.title, "Found " + stashType.substring(0, 1).toUpperCase() + stashType.substring(1) + "!");
                        this.mc.method_1566().method_1999((class_368)toast);
                    }
                }
            }
            if (!(!((Boolean)this.enableWebhook.get()).booleanValue() || chunk.equals(prevChunk) && chunk.countsEqual(prevChunk))) {
                this.sendWebhookNotification(chunk, isCriticalSpawner, (String)detectionReason);
            }
            if (((Boolean)this.disconnectOnBaseFind.get()).booleanValue()) {
                this.disconnectPlayer(isCriticalSpawner ? "Nether spawner base" : "Nether stash", chunk);
            }
        }
    }

    private void disconnectPlayer(String stashType, NetherStashChunk chunk) {
        this.info("Disconnecting due to " + stashType + " found at " + chunk.x + ", " + chunk.z, new Object[0]);
        this.toggle();
        Executors.newSingleThreadScheduledExecutor().schedule(() -> {
            if (this.mc.field_1724 != null) {
                this.mc.field_1724.field_3944.method_52781(new class_2661((class_2561)class_2561.method_43470((String)("NETHER STASH FOUND AT " + chunk.x + ", " + chunk.z + "!"))));
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private void sendWebhookNotification(NetherStashChunk chunk, boolean isCriticalSpawner, String detectionReason) {
        String url = ((String)this.webhookUrl.get()).trim();
        if (url.isEmpty()) {
            this.warning("Webhook URL not configured!", new Object[0]);
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String serverInfo = this.mc.method_1558() != null ? this.mc.method_1558().field_3761 : "Unknown Server";
                String messageContent = "";
                if (((Boolean)this.selfPing.get()).booleanValue() && !((String)this.discordId.get()).trim().isEmpty()) {
                    messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
                }
                String stashType = isCriticalSpawner ? "Nether Spawner Base" : "Nether Stash";
                String description = String.format("%s found at Nether coordinates %d, %d!", stashType, chunk.x, chunk.z);
                StringBuilder itemsFound = new StringBuilder();
                int totalItems = chunk.appendItemCounts(itemsFound, isCriticalSpawner);
                String jsonPayload = String.format("{\"content\":\"%s\",\"username\":\"RTP Nether-Stashfinder\",\"embeds\":[{\"title\":\"\ud83d\udd25 Nether Stashfinder Alert\",\"description\":\"%s\",\"color\":%d,\"fields\":[{\"name\":\"Detection Reason\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Total Items Found\",\"value\":\"%d\",\"inline\":false},{\"name\":\"Items Breakdown\",\"value\":\"%s\",\"inline\":false},{\"name\":\"Nether Coordinates\",\"value\":\"%d, %d\",\"inline\":true},{\"name\":\"Server\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Time\",\"value\":\"<t:%d:R>\",\"inline\":true}],\"footer\":{\"text\":\"RTP Nether-Stashfinder\"}}]}", messageContent.replace("\"", "\\\""), description.replace("\"", "\\\""), isCriticalSpawner ? 0xFF5858 : 16509190, detectionReason.replace("\"", "\\\""), totalItems, itemsFound.toString().replace("\"", "\\\""), chunk.x, chunk.z, serverInfo.replace("\"", "\\\""), System.currentTimeMillis() / 1000L);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).timeout(Duration.ofSeconds(30L)).build();
                this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException | InterruptedException e) {
                this.error("Failed to send webhook: " + e.getMessage(), new Object[0]);
            }
        });
    }

    public String getInfoString() {
        return String.valueOf(this.foundStashes.size());
    }

    public static enum Mode {
        Chat,
        Toast,
        Both;

    }

    public static class NetherStashChunk {
        public class_1923 chunkPos;
        public int x;
        public int z;
        public int chests;
        public int barrels;
        public int shulkers;
        public int enderChests;
        public int furnaces;
        public int dispensersDroppers;
        public int hoppers;
        public int spawners;

        public NetherStashChunk(class_1923 chunkPos) {
            this.chunkPos = chunkPos;
            this.x = chunkPos.field_9181 * 16 + 8;
            this.z = chunkPos.field_9180 * 16 + 8;
        }

        public int getTotalNonSpawner() {
            return this.chests + this.barrels + this.shulkers + this.enderChests + this.furnaces + this.dispensersDroppers + this.hoppers;
        }

        public boolean countsEqual(NetherStashChunk c) {
            if (c == null) {
                return false;
            }
            return this.chests == c.chests && this.barrels == c.barrels && this.shulkers == c.shulkers && this.enderChests == c.enderChests && this.furnaces == c.furnaces && this.dispensersDroppers == c.dispensersDroppers && this.hoppers == c.hoppers && this.spawners == c.spawners;
        }

        public int appendItemCounts(StringBuilder sb, boolean includeSpawner) {
            int total = 0;
            if (this.chests > 0) {
                sb.append("Chests: ").append(this.chests).append("\\n");
                total += this.chests;
            }
            if (this.barrels > 0) {
                sb.append("Barrels: ").append(this.barrels).append("\\n");
                total += this.barrels;
            }
            if (this.shulkers > 0) {
                sb.append("Shulker Boxes: ").append(this.shulkers).append("\\n");
                total += this.shulkers;
            }
            if (this.enderChests > 0) {
                sb.append("Ender Chests: ").append(this.enderChests).append("\\n");
                total += this.enderChests;
            }
            if (this.furnaces > 0) {
                sb.append("Furnaces: ").append(this.furnaces).append("\\n");
                total += this.furnaces;
            }
            if (this.dispensersDroppers > 0) {
                sb.append("Dispensers/Droppers: ").append(this.dispensersDroppers).append("\\n");
                total += this.dispensersDroppers;
            }
            if (this.hoppers > 0) {
                sb.append("Hoppers: ").append(this.hoppers).append("\\n");
                total += this.hoppers;
            }
            if (includeSpawner && this.spawners > 0) {
                sb.append("Spawners: Present\\n");
            }
            return total;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NetherStashChunk)) {
                return false;
            }
            NetherStashChunk c = (NetherStashChunk)o;
            return Objects.equals(this.chunkPos, c.chunkPos);
        }

        public int hashCode() {
            return Objects.hash(this.chunkPos);
        }
    }
}

