/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.WindowScreen;
import meteordevelopment.meteorclient.gui.widgets.WLabel;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.input.WTextBox;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2708;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_7924;

public class RTPer
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgCoordinates;
    private final SettingGroup sgBiome;
    private final SettingGroup sgWebhook;
    private final Setting<RTPMode> rtpMode;
    private final Setting<Integer> targetX;
    private final Setting<Integer> targetZ;
    private final Setting<String> distance;
    private final Setting<MinecraftBiome> targetBiome;
    private final Setting<RTPRegion> rtpRegion;
    private final Setting<Boolean> disconnectOnReach;
    private final Setting<Integer> rtpDelay;
    private final Setting<Boolean> webhookEnabled;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;
    private int tickTimer;
    private boolean isRtping;
    private int rtpAttempts;
    private class_2338 lastRtpPos;
    private double lastReportedDistance;
    private int targetDistanceBlocks;
    private boolean biomeFound;
    private final HttpClient httpClient;

    public RTPer() {
        super(GlazedAddon.CATEGORY, "RTPer", "RTP to specific coordinates or find specific biomes.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgCoordinates = this.settings.createGroup("Coordinates");
        this.sgBiome = this.settings.createGroup("Biome");
        this.sgWebhook = this.settings.createGroup("Webhook");
        this.rtpMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("rtp-mode")).description("RTP mode: Coordinates or Biome.")).defaultValue((Object)RTPMode.COORDINATES)).build());
        this.targetX = this.sgCoordinates.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-x")).description("Target X coordinate.")).defaultValue((Object)0)).visible(() -> this.rtpMode.get() == RTPMode.COORDINATES)).build());
        this.targetZ = this.sgCoordinates.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-z")).description("Target Z coordinate.")).defaultValue((Object)0)).visible(() -> this.rtpMode.get() == RTPMode.COORDINATES)).build());
        this.distance = this.sgCoordinates.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("distance")).description("Distance to get within (supports k/m, e.g., 10k = 10000, 1.5m = 1500000).")).defaultValue((Object)"1000")).visible(() -> this.rtpMode.get() == RTPMode.COORDINATES)).build());
        this.targetBiome = this.sgBiome.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("target-biome")).description("Target biome to find.")).defaultValue((Object)MinecraftBiome.PLAINS)).visible(() -> false)).build());
        this.rtpRegion = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("rtp-region")).description("RTP region to use.")).defaultValue((Object)RTPRegion.WEST)).build());
        this.disconnectOnReach = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disconnect-on-reach")).description("Disconnect when reaching the target coordinates or finding the target biome.")).defaultValue((Object)true)).build());
        this.rtpDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("rtp-delay")).description("Delay between RTP attempts in seconds.")).defaultValue((Object)15)).min(11).max(20).sliderMin(11).sliderMax(20).build());
        this.webhookEnabled = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("webhook-enabled")).description("Enable webhook notifications.")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL.")).defaultValue((Object)"")).visible(() -> this.webhookEnabled.get())).build());
        this.selfPing = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("self-ping")).description("Ping yourself in the webhook message.")).defaultValue((Object)false)).visible(() -> this.webhookEnabled.get())).build());
        this.discordId = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("discord-id")).description("Your Discord user ID for pinging.")).defaultValue((Object)"")).visible(() -> (Boolean)this.webhookEnabled.get() != false && (Boolean)this.selfPing.get() != false)).build());
        this.tickTimer = 0;
        this.isRtping = false;
        this.rtpAttempts = 0;
        this.lastRtpPos = null;
        this.lastReportedDistance = -1.0;
        this.targetDistanceBlocks = 1000;
        this.biomeFound = false;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public void onActivate() {
        this.tickTimer = 0;
        this.isRtping = false;
        this.rtpAttempts = 0;
        this.lastRtpPos = null;
        this.lastReportedDistance = -1.0;
        this.biomeFound = false;
        if (this.rtpMode.get() == RTPMode.COORDINATES) {
            this.targetDistanceBlocks = this.parseDistance();
        }
        if (this.mc.field_1724 == null) {
            return;
        }
        if (this.rtpMode.get() == RTPMode.COORDINATES) {
            double currentDist = this.getCurrentDistance();
            this.info("RTPer started - target: (%d, %d)", new Object[]{this.targetX.get(), this.targetZ.get()});
            this.info("Distance: %s -> %d blocks", new Object[]{this.distance.get(), this.targetDistanceBlocks});
            this.info("Current: %.1f blocks away", new Object[]{currentDist});
            if (currentDist <= (double)this.targetDistanceBlocks) {
                this.info("Already close enough!", new Object[0]);
                this.toggle();
            }
        } else {
            this.info("RTPer started - Biome Finder mode", new Object[0]);
            this.info("Target biome: %s", new Object[]{((MinecraftBiome)((Object)this.targetBiome.get())).getDisplayName()});
        }
        if (this.rtpMode.get() == RTPMode.COORDINATES && (this.rtpRegion.get() == RTPRegion.NETHER || this.rtpRegion.get() == RTPRegion.END)) {
            this.warning("Using %s region with coordinate mode - make sure your coordinates are valid for this dimension!", new Object[]{((RTPRegion)((Object)this.rtpRegion.get())).getCommandPart()});
        }
    }

    public void onDeactivate() {
        if (this.rtpMode.get() == RTPMode.COORDINATES) {
            this.info("Stopped after %d attempts", new Object[]{this.rtpAttempts});
        } else {
            this.info("Biome finder stopped after %d attempts", new Object[]{this.rtpAttempts});
        }
        this.isRtping = false;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        if (this.rtpMode.get() == RTPMode.COORDINATES) {
            this.handleCoordinatesMode();
        } else {
            this.handleBiomeMode();
        }
        ++this.tickTimer;
        if (this.isRtping && this.tickTimer >= (Integer)this.rtpDelay.get() * 20) {
            this.isRtping = false;
        }
        if (this.tickTimer >= (Integer)this.rtpDelay.get() * 20 && !this.isRtping) {
            this.performRTP();
            this.tickTimer = 0;
        }
    }

    private void handleCoordinatesMode() {
        double currentDistance = this.getCurrentDistance();
        if (this.isNearTarget(currentDistance)) {
            this.info("Done! %.1f blocks away (target: %d)", new Object[]{currentDistance, this.targetDistanceBlocks});
            if (((Boolean)this.webhookEnabled.get()).booleanValue()) {
                this.sendWebhook("Target Reached!", String.format("Got to %d, %d in %s\\nDistance: %.1f/%d blocks\\nAttempts: %d", this.targetX.get(), this.targetZ.get(), ((RTPRegion)((Object)this.rtpRegion.get())).getCommandPart(), currentDistance, this.targetDistanceBlocks, this.rtpAttempts), 65280);
            }
            if (((Boolean)this.disconnectOnReach.get()).booleanValue()) {
                this.info("Disconnecting...", new Object[0]);
                if (this.mc.field_1687 != null) {
                    this.mc.field_1687.method_8525();
                }
            }
            this.toggle();
            return;
        }
        if (this.tickTimer % 100 == 0 && Math.abs(currentDistance - this.lastReportedDistance) > 100.0) {
            this.info("Distance: %.1f blocks", new Object[]{currentDistance});
            this.lastReportedDistance = currentDistance;
        }
    }

    private void handleBiomeMode() {
        if (this.biomeFound) {
            this.info("Target biome found: %s", new Object[]{((MinecraftBiome)((Object)this.targetBiome.get())).getDisplayName()});
            if (((Boolean)this.webhookEnabled.get()).booleanValue()) {
                this.sendWebhook("Biome Found!", String.format("Found %s biome in %s!\\nAttempts: %d\\nPosition: %d, %d, %d", ((MinecraftBiome)((Object)this.targetBiome.get())).getDisplayName(), ((RTPRegion)((Object)this.rtpRegion.get())).getCommandPart(), this.rtpAttempts, this.mc.field_1724.method_24515().method_10263(), this.mc.field_1724.method_24515().method_10264(), this.mc.field_1724.method_24515().method_10260()), 65280);
            }
            if (((Boolean)this.disconnectOnReach.get()).booleanValue()) {
                this.info("Disconnecting...", new Object[0]);
                this.disconnectWithMessage("Glazed: found requested biome");
            }
            this.toggle();
            return;
        }
        if (this.isInTargetBiome()) {
            this.biomeFound = true;
            return;
        }
        if (this.tickTimer % 100 == 0) {
            String currentBiome = this.getCurrentBiome();
            this.info("Current biome: %s", new Object[]{currentBiome});
        }
    }

    private boolean isInTargetBiome() {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return false;
        }
        class_2338 pos = this.mc.field_1724.method_24515();
        String biomeId = this.getBiomeIdAt(pos);
        if (biomeId == null) {
            return false;
        }
        return biomeId.equals(((MinecraftBiome)((Object)this.targetBiome.get())).getId());
    }

    private String getCurrentBiome() {
        if (this.mc.field_1687 == null || this.mc.field_1724 == null) {
            return "Unknown";
        }
        class_2338 pos = this.mc.field_1724.method_24515();
        String biomeId = this.getBiomeIdAt(pos);
        if (biomeId == null) {
            return "Unknown";
        }
        for (MinecraftBiome minecraftBiome : MinecraftBiome.values()) {
            if (!minecraftBiome.getId().equals(biomeId)) continue;
            return minecraftBiome.getDisplayName();
        }
        return this.toDisplayName(biomeId);
    }

    private String getBiomeIdAt(class_2338 pos) {
        if (this.mc.field_1687 == null) {
            return null;
        }
        class_1959 biome = (class_1959)this.mc.field_1687.method_23753(pos).comp_349();
        if (biome == null) {
            return null;
        }
        class_2960 id = this.mc.field_1687.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        return id != null ? id.toString() : null;
    }

    private String toDisplayName(String id) {
        if (id == null || id.isEmpty()) {
            return "Unknown";
        }
        String raw = id.contains(":") ? id.substring(id.indexOf(":") + 1) : id;
        String[] parts = raw.split("_");
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            if (p.isEmpty()) continue;
            b.append(Character.toUpperCase(p.charAt(0)));
            if (p.length() > 1) {
                b.append(p.substring(1));
            }
            if (i >= parts.length - 1) continue;
            b.append(' ');
        }
        return b.toString();
    }

    private void disconnectWithMessage(String message) {
        block6: {
            try {
                if (this.mc != null) {
                    if (this.mc.method_1562() != null && this.mc.method_1562().method_48296() != null) {
                        this.mc.method_1562().method_48296().method_10747((class_2561)class_2561.method_43470((String)message));
                        return;
                    }
                    if (this.mc.field_1724 != null && this.mc.field_1724.field_3944 != null && this.mc.field_1724.field_3944.method_48296() != null) {
                        this.mc.field_1724.field_3944.method_48296().method_10747((class_2561)class_2561.method_43470((String)message));
                        return;
                    }
                    if (this.mc.field_1687 != null) {
                        this.mc.field_1687.method_8525();
                    }
                }
            }
            catch (Exception ignored) {
                if (this.mc == null || this.mc.field_1687 == null) break block6;
                this.mc.field_1687.method_8525();
            }
        }
    }

    @EventHandler
    private void onPacketReceive(PacketEvent.Receive event) {
        if (event.packet instanceof class_2708 && this.mc.field_1724 != null) {
            this.isRtping = false;
            class_2338 currentPos = this.mc.field_1724.method_24515();
            if (this.lastRtpPos == null || !currentPos.equals((Object)this.lastRtpPos)) {
                ++this.rtpAttempts;
                this.lastRtpPos = currentPos;
                if (this.rtpMode.get() == RTPMode.COORDINATES) {
                    double distance = this.getCurrentDistance();
                    this.info("RTP %d done - pos: (%d, %d, %d) dist: %.1f", new Object[]{this.rtpAttempts, currentPos.method_10263(), currentPos.method_10264(), currentPos.method_10260(), distance});
                    if (this.lastReportedDistance > 0.0) {
                        double diff = this.lastReportedDistance - distance;
                        if (diff > 0.0) {
                            this.info("Better by %.1f blocks", new Object[]{diff});
                        } else if (diff < -1000.0) {
                            this.info("Worse by %.1f blocks", new Object[]{Math.abs(diff)});
                        }
                    }
                    this.lastReportedDistance = distance;
                } else {
                    String biome = this.getCurrentBiome();
                    this.info("RTP %d done - pos: (%d, %d, %d) biome: %s", new Object[]{this.rtpAttempts, currentPos.method_10263(), currentPos.method_10264(), currentPos.method_10260(), biome});
                    if (this.isInTargetBiome()) {
                        this.biomeFound = true;
                    }
                }
            }
        }
    }

    private void performRTP() {
        if (this.mc.field_1724 == null) {
            return;
        }
        this.isRtping = true;
        ChatUtils.sendPlayerMsg((String)("/rtp " + ((RTPRegion)((Object)this.rtpRegion.get())).getCommandPart()));
        if (this.rtpMode.get() == RTPMode.COORDINATES) {
            double currentDistance = this.getCurrentDistance();
            this.info("Attempting RTP (%s) - current: %.1f blocks", new Object[]{((RTPRegion)((Object)this.rtpRegion.get())).getCommandPart(), currentDistance});
        } else {
            this.info("Attempting RTP (%s) - searching for %s biome", new Object[]{((RTPRegion)((Object)this.rtpRegion.get())).getCommandPart(), ((MinecraftBiome)((Object)this.targetBiome.get())).getDisplayName()});
        }
    }

    private boolean isNearTarget() {
        return this.isNearTarget(this.getCurrentDistance());
    }

    private boolean isNearTarget(double currentDistance) {
        return currentDistance <= (double)this.targetDistanceBlocks;
    }

    private double getCurrentDistance() {
        if (this.mc.field_1724 == null) {
            return Double.MAX_VALUE;
        }
        class_2338 pos = this.mc.field_1724.method_24515();
        double dx = pos.method_10263() - (Integer)this.targetX.get();
        double dz = pos.method_10260() - (Integer)this.targetZ.get();
        return Math.sqrt(dx * dx + dz * dz);
    }

    private int parseDistance() {
        String dist = ((String)this.distance.get()).toLowerCase().trim();
        if (dist.isEmpty()) {
            this.error("Empty distance, using 1000", new Object[0]);
            return 1000;
        }
        try {
            if (dist.endsWith("k")) {
                String num = dist.substring(0, dist.length() - 1).trim();
                if (num.isEmpty()) {
                    this.error("Bad format: '%s', using 1000", new Object[]{dist});
                    return 1000;
                }
                double val = Double.parseDouble(num);
                return (int)(val * 1000.0);
            }
            if (dist.endsWith("m")) {
                String num = dist.substring(0, dist.length() - 1).trim();
                if (num.isEmpty()) {
                    this.error("Bad format: '%s', using 1000", new Object[]{dist});
                    return 1000;
                }
                double val = Double.parseDouble(num);
                return (int)(val * 1000000.0);
            }
            return Integer.parseInt(dist);
        }
        catch (NumberFormatException e) {
            this.error("Can't parse '%s': %s, using 1000", new Object[]{dist, e.getMessage()});
            return 1000;
        }
    }

    private void sendWebhook(String title, String description, int color) {
        if (!((Boolean)this.webhookEnabled.get()).booleanValue() || ((String)this.webhookUrl.get()).isEmpty()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String serverInfo = this.mc.method_1558() != null ? this.mc.method_1558().field_3761 : "Unknown Server";
                String messageContent = "";
                if (((Boolean)this.selfPing.get()).booleanValue() && !((String)this.discordId.get()).trim().isEmpty()) {
                    messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
                }
                String timestamp = LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                String jsonPayload = String.format("{\n    \"content\": \"%s\",\n    \"username\": \"RTPer Webhook\",\n    \"avatar_url\": \"https://i.imgur.com/OL2y1cr.png\",\n    \"embeds\": [{\n        \"title\": \"\ud83c\udfaf RTPer Alert\",\n        \"description\": \"%s\",\n        \"color\": %d,\n        \"fields\": [\n            {\n                \"name\": \"Status\",\n                \"value\": \"%s\",\n                \"inline\": true\n            },\n            {\n                \"name\": \"Server\",\n                \"value\": \"%s\",\n                \"inline\": true\n            },\n            {\n                \"name\": \"Time\",\n                \"value\": \"<t:%d:R>\",\n                \"inline\": true\n            }\n        ],\n        \"footer\": {\n            \"text\": \"RTPer by Glazed\"\n        },\n        \"timestamp\": \"%sZ\"\n    }]\n}", messageContent.replace("\"", "\\\""), description.replace("\"", "\\\"").replace("\\n", "\\n"), color, title.replace("\"", "\\\""), serverInfo.replace("\"", "\\\""), System.currentTimeMillis() / 1000L, timestamp);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create((String)this.webhookUrl.get())).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 204) {
                    this.info("Webhook sent successfully", new Object[0]);
                } else {
                    this.error("Webhook failed with status: %d", new Object[]{response.statusCode()});
                }
            }
            catch (IOException | InterruptedException e) {
                this.error("Webhook error: %s", new Object[]{e.getMessage()});
            }
        });
    }

    public WWidget getWidget(GuiTheme theme) {
        WTable table = theme.table();
        table.add((WWidget)theme.label("Biome Picker:"));
        WLabel current = (WLabel)table.add((WWidget)theme.label(((MinecraftBiome)((Object)this.targetBiome.get())).getDisplayName())).expandX().widget();
        WButton open = (WButton)table.add((WWidget)theme.button("Select")).widget();
        open.action = () -> {
            if (this.rtpMode.get() == RTPMode.BIOME) {
                this.mc.method_1507((class_437)new BiomePickerScreen(theme, current));
            }
        };
        table.row();
        return table;
    }

    public static enum RTPMode {
        COORDINATES("Coordinates"),
        BIOME("Biome");

        private final String displayName;

        private RTPMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum MinecraftBiome {
        PLAINS("Plains", "minecraft:plains"),
        SUNFLOWER_PLAINS("Sunflower Plains", "minecraft:sunflower_plains"),
        SNOWY_PLAINS("Snowy Plains", "minecraft:snowy_plains"),
        FOREST("Forest", "minecraft:forest"),
        FLOWER_FOREST("Flower Forest", "minecraft:flower_forest"),
        BIRCH_FOREST("Birch Forest", "minecraft:birch_forest"),
        OLD_GROWTH_BIRCH_FOREST("Old Growth Birch Forest", "minecraft:old_growth_birch_forest"),
        DARK_FOREST("Dark Forest", "minecraft:dark_forest"),
        OAK_AND_BIRCH_FOREST("Oak and Birch Forest", "minecraft:oak_and_birch_forest"),
        TAIGA("Taiga", "minecraft:taiga"),
        SNOWY_TAIGA("Snowy Taiga", "minecraft:snowy_taiga"),
        OLD_GROWTH_SPRUCE_TAIGA("Old Growth Spruce Taiga", "minecraft:old_growth_spruce_taiga"),
        OLD_GROWTH_PINE_TAIGA("Old Growth Pine Taiga", "minecraft:old_growth_pine_taiga"),
        JUNGLE("Jungle", "minecraft:jungle"),
        SPARSE_JUNGLE("Sparse Jungle", "minecraft:sparse_jungle"),
        BAMBOO_JUNGLE("Bamboo Jungle", "minecraft:bamboo_jungle"),
        DESERT("Desert", "minecraft:desert"),
        SAVANNA("Savanna", "minecraft:savanna"),
        SAVANNA_PLATEAU("Savanna Plateau", "minecraft:savanna_plateau"),
        WINDSWEPT_SAVANNA("Windswept Savanna", "minecraft:windswept_savanna"),
        BADLANDS("Badlands", "minecraft:badlands"),
        ERODED_BADLANDS("Eroded Badlands", "minecraft:eroded_badlands"),
        WOODED_BADLANDS("Wooded Badlands", "minecraft:wooded_badlands"),
        SWAMP("Swamp", "minecraft:swamp"),
        MANGROVE_SWAMP("Mangrove Swamp", "minecraft:mangrove_swamp"),
        BEACH("Beach", "minecraft:beach"),
        SNOWY_SLOPES("Snowy Slopes", "minecraft:snowy_slopes"),
        JAGGED_PEAKS("Jagged Peaks", "minecraft:jagged_peaks"),
        FROZEN_PEAKS("Frozen Peaks", "minecraft:frozen_peaks"),
        STONY_PEAKS("Stony Peaks", "minecraft:stony_peaks"),
        OCEAN("Ocean", "minecraft:ocean"),
        WARM_OCEAN("Warm Ocean", "minecraft:warm_ocean"),
        LUKEWARM_OCEAN("Lukewarm Ocean", "minecraft:lukewarm_ocean"),
        COLD_OCEAN("Cold Ocean", "minecraft:cold_ocean"),
        FROZEN_OCEAN("Frozen Ocean", "minecraft:frozen_ocean"),
        DEEP_OCEAN("Deep Ocean", "minecraft:deep_ocean"),
        DEEP_WARM_OCEAN("Deep Warm Ocean", "minecraft:deep_warm_ocean"),
        DEEP_LUKEWARM_OCEAN("Deep Lukewarm Ocean", "minecraft:deep_lukewarm_ocean"),
        DEEP_COLD_OCEAN("Deep Cold Ocean", "minecraft:deep_cold_ocean"),
        DEEP_FROZEN_OCEAN("Deep Frozen Ocean", "minecraft:deep_frozen_ocean"),
        RIVER("River", "minecraft:river"),
        FROZEN_RIVER("Frozen River", "minecraft:frozen_river"),
        MUSHROOM_FIELDS("Mushroom Fields", "minecraft:mushroom_fields"),
        DRIPSTONE_CAVES("Dripstone Caves", "minecraft:dripstone_caves"),
        LUSH_CAVES("Lush Caves", "minecraft:lush_caves"),
        DEEP_DARK("Deep Dark", "minecraft:deep_dark"),
        NETHER_WASTES("Nether Wastes", "minecraft:nether_wastes"),
        SOUL_SAND_VALLEY("Soul Sand Valley", "minecraft:soul_sand_valley"),
        CRIMSON_FOREST("Crimson Forest", "minecraft:crimson_forest"),
        WARPED_FOREST("Warped Forest", "minecraft:warped_forest"),
        BASALT_DELTAS("Basalt Deltas", "minecraft:basalt_deltas"),
        THE_END("The End", "minecraft:the_end"),
        END_HIGHLANDS("End Highlands", "minecraft:end_highlands"),
        END_MIDLANDS("End Midlands", "minecraft:end_midlands"),
        SMALL_END_ISLANDS("Small End Islands", "minecraft:small_end_islands"),
        END_BARRENS("End Barrens", "minecraft:end_barrens"),
        CAVES("Caves", "minecraft:caves"),
        GROVE("Grove", "minecraft:grove"),
        MEADOW("Meadow", "minecraft:meadow"),
        CHERRY_GROVE("Cherry Grove", "minecraft:cherry_grove");

        private final String displayName;
        private final String id;

        private MinecraftBiome(String displayName, String id) {
            this.displayName = displayName;
            this.id = id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum RTPRegion {
        ASIA("asia"),
        EAST("east"),
        EU_CENTRAL("eu central"),
        EU_WEST("eu west"),
        OCEANIA("oceania"),
        WEST("west"),
        NETHER("nether"),
        END("end");

        private final String commandPart;

        private RTPRegion(String commandPart) {
            this.commandPart = commandPart;
        }

        public String getCommandPart() {
            return this.commandPart;
        }
    }

    private class BiomePickerScreen
    extends WindowScreen {
        private WTable listTable;
        private WTextBox searchBox;
        private final WLabel currentLabel;

        public BiomePickerScreen(GuiTheme theme, WLabel currentLabel) {
            super(theme, "Select Biome");
            this.currentLabel = currentLabel;
        }

        public void initWidgets() {
            this.searchBox = (WTextBox)this.add((WWidget)this.theme.textBox("")).expandX().widget();
            this.searchBox.setFocused(true);
            this.searchBox.action = this::reloadList;
            this.add((WWidget)this.theme.horizontalSeparator()).expandX();
            this.listTable = (WTable)this.add((WWidget)this.theme.table()).expandX().widget();
            this.reloadList();
        }

        private void reloadList() {
            this.listTable.clear();
            String query = this.searchBox.get().trim().toLowerCase();
            for (MinecraftBiome biome : MinecraftBiome.values()) {
                String name = biome.getDisplayName();
                if (!query.isEmpty() && !name.toLowerCase().contains(query)) continue;
                this.listTable.add((WWidget)this.theme.label(name)).expandX();
                WButton select = (WButton)this.listTable.add((WWidget)this.theme.button("Use")).widget();
                select.action = () -> {
                    RTPer.this.targetBiome.set((Object)biome);
                    if (this.currentLabel != null) {
                        this.currentLabel.set(biome.getDisplayName());
                    }
                    RTPer.this.mc.method_1507(null);
                };
                this.listTable.row();
            }
        }
    }
}

