/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WVerticalList;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.MeteorToast;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_368;

public class RainNoti
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgWebhook;
    private final Setting<Boolean> sendNotifications;
    private final Setting<Mode> notificationMode;
    private final Setting<Boolean> enableWebhook;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;
    private boolean wasRaining;
    private final HttpClient httpClient;

    public RainNoti() {
        super(GlazedAddon.CATEGORY, "rain-noti", "Notifies when it starts raining in-game.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgWebhook = this.settings.createGroup("Webhook");
        this.sendNotifications = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("notifications")).description("Send in-game notifications when it starts raining.")).defaultValue((Object)true)).build());
        this.notificationMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("notification-mode")).description("The mode to use for notifications.")).defaultValue((Object)Mode.Both)).visible(() -> this.sendNotifications.get())).build());
        this.enableWebhook = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("webhook")).description("Send webhook notifications when it starts raining")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL")).defaultValue((Object)"")).visible(() -> this.enableWebhook.get())).build());
        this.selfPing = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("self-ping")).description("Ping yourself in the webhook message")).defaultValue((Object)false)).visible(() -> this.enableWebhook.get())).build());
        this.discordId = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("discord-id")).description("Your Discord user ID for pinging")).defaultValue((Object)"")).visible(() -> (Boolean)this.enableWebhook.get() != false && (Boolean)this.selfPing.get() != false)).build());
        this.wasRaining = false;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.mc.field_1687 == null) {
            return;
        }
        boolean raining = this.mc.field_1687.method_8419();
        if (raining && !this.wasRaining) {
            this.notifyRainStart();
        }
        this.wasRaining = raining;
    }

    private void notifyRainStart() {
        if (((Boolean)this.sendNotifications.get()).booleanValue()) {
            switch (((Mode)((Object)this.notificationMode.get())).ordinal()) {
                case 0: {
                    this.info("It has started raining!", new Object[0]);
                    break;
                }
                case 1: {
                    this.mc.method_1566().method_1999((class_368)new MeteorToast(null, "Weather Alert", "It has started raining!"));
                    break;
                }
                case 2: {
                    this.info("It has started raining!", new Object[0]);
                    this.mc.method_1566().method_1999((class_368)new MeteorToast(null, "Weather Alert", "It has started raining!"));
                }
            }
        }
        if (((Boolean)this.enableWebhook.get()).booleanValue()) {
            this.sendWebhookNotification();
        }
    }

    private void sendWebhookNotification() {
        String url = ((String)this.webhookUrl.get()).trim();
        if (url.isEmpty()) {
            this.warning("Webhook URL not configured!", new Object[0]);
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                String messageContent = "";
                if (((Boolean)this.selfPing.get()).booleanValue() && !((String)this.discordId.get()).trim().isEmpty()) {
                    messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
                }
                String serverInfo = this.mc.method_1558() != null ? this.mc.method_1558().field_3761 : "Singleplayer";
                String jsonPayload = String.format("{\"content\":\"%s\",\"username\":\"RainNoti\",\"avatar_url\":\"https://i.imgur.com/OL2y1cr.png\",\"embeds\":[{\"title\":\"\ud83c\udf27 Rain Started!\",\"description\":\"It has started raining in-game.\",\"color\":3447003,\"fields\":[{\"name\":\"Server\",\"value\":\"%s\",\"inline\":true},{\"name\":\"Time\",\"value\":\"<t:%d:R>\",\"inline\":true}],\"footer\":{\"text\":\"RainNoti\"}}]}", messageContent, serverInfo, System.currentTimeMillis() / 1000L);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).timeout(Duration.ofSeconds(30L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 204) {
                    this.info("Webhook notification sent successfully", new Object[0]);
                } else {
                    this.error("Webhook failed with status: " + response.statusCode(), new Object[0]);
                }
            }
            catch (Exception e) {
                this.error("Failed to send webhook: " + e.getMessage(), new Object[0]);
            }
        });
    }

    public WWidget getWidget(GuiTheme theme) {
        WVerticalList list = theme.verticalList();
        WButton reset = (WButton)list.add((WWidget)theme.button("Reset Raining State")).widget();
        reset.action = () -> {
            this.wasRaining = false;
            this.info("Rain state reset.", new Object[0]);
        };
        return list;
    }

    public static enum Mode {
        Chat,
        Toast,
        Both;

    }
}

