/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2846;

public class ShopBuyer
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Integer> delay;
    private final Setting<ItemType> itemToBuy;
    private final Setting<Boolean> autoDrop;
    private int delayCounter;
    private boolean inPvpCategory;
    private boolean inBuyingScreen;

    public ShopBuyer() {
        super(GlazedAddon.CATEGORY, "ShopBuyer", "Automatically buys selected items from PVP shop category.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("Delay between actions in ticks.")).defaultValue((Object)15)).min(1).max(100).build());
        this.itemToBuy = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("item")).description("Select which item to buy from PVP category.")).defaultValue((Object)ItemType.Obsidian)).build());
        this.autoDrop = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-drop")).description("Automatically drop purchased items.")).defaultValue((Object)true)).build());
        this.delayCounter = 0;
        this.inPvpCategory = false;
        this.inBuyingScreen = false;
    }

    public void onActivate() {
        this.delayCounter = 0;
        this.inPvpCategory = false;
        this.inBuyingScreen = false;
    }

    public void onDeactivate() {
        this.delayCounter = 0;
        this.inPvpCategory = false;
        this.inBuyingScreen = false;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        if (this.delayCounter > 0) {
            --this.delayCounter;
            return;
        }
        class_1703 currentScreenHandler = this.mc.field_1724.field_7512;
        if (!(currentScreenHandler instanceof class_1707)) {
            ChatUtils.sendPlayerMsg((String)"/shop");
            this.delayCounter = (Integer)this.delay.get();
            this.resetState();
            return;
        }
        class_1707 containerHandler = (class_1707)currentScreenHandler;
        int rows = containerHandler.method_17388();
        this.updateScreenState(currentScreenHandler, rows);
        if (rows == 3) {
            if (this.isBuyingScreen(currentScreenHandler)) {
                this.handleBuyingScreen(currentScreenHandler);
                return;
            }
            if (this.isPvpCategoryScreen(currentScreenHandler)) {
                this.handlePvpCategory(currentScreenHandler);
                return;
            }
            if (this.isMainShopScreen(currentScreenHandler)) {
                this.handleMainShop(currentScreenHandler);
                return;
            }
        }
        this.resetState();
    }

    private void updateScreenState(class_1703 handler, int rows) {
        if (this.isBuyingScreen(handler)) {
            this.inBuyingScreen = true;
        } else if (this.isPvpCategoryScreen(handler)) {
            this.inPvpCategory = true;
            this.inBuyingScreen = false;
        } else if (this.isMainShopScreen(handler)) {
            this.inPvpCategory = false;
            this.inBuyingScreen = false;
        }
    }

    private boolean isMainShopScreen(class_1703 handler) {
        return handler.method_7611(13).method_7677().method_31574(class_1802.field_8288) && !this.isBuyingScreen(handler);
    }

    private boolean isPvpCategoryScreen(class_1703 handler) {
        return handler.method_7611(9).method_7677().method_31574(class_1802.field_8281) || handler.method_7611(10).method_7677().method_31574(class_1802.field_8301) || handler.method_7611(11).method_7677().method_31574(class_1802.field_23141) || handler.method_7611(12).method_7677().method_31574(class_1802.field_8801);
    }

    private boolean isBuyingScreen(class_1703 handler) {
        for (int i = 0; i < handler.field_7761.size(); ++i) {
            if (!handler.method_7611(i).method_7677().method_31574(class_1802.field_8581)) continue;
            return true;
        }
        return false;
    }

    private void handleMainShop(class_1703 handler) {
        this.mc.field_1761.method_2906(handler.field_7763, 13, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
        this.delayCounter = (Integer)this.delay.get();
        this.inPvpCategory = true;
    }

    private void handlePvpCategory(class_1703 handler) {
        ItemType selectedItem = (ItemType)((Object)this.itemToBuy.get());
        int slot = this.getItemSlot(selectedItem);
        if (slot != -1 && this.isCorrectItemInSlot(handler, slot, selectedItem)) {
            this.clickItem(handler, slot);
        }
    }

    private int getItemSlot(ItemType itemType) {
        switch (itemType.ordinal()) {
            case 0: {
                return 9;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 13;
            }
            case 5: {
                return 14;
            }
            case 6: {
                return 15;
            }
            case 7: {
                return 16;
            }
            case 8: {
                return 17;
            }
        }
        return -1;
    }

    private boolean isCorrectItemInSlot(class_1703 handler, int slot, ItemType itemType) {
        switch (itemType.ordinal()) {
            case 0: {
                return handler.method_7611(slot).method_7677().method_31574(class_1802.field_8281);
            }
            case 1: {
                return handler.method_7611(slot).method_7677().method_31574(class_1802.field_8301);
            }
            case 2: {
                return handler.method_7611(slot).method_7677().method_31574(class_1802.field_23141);
            }
            case 3: {
                return handler.method_7611(slot).method_7677().method_31574(class_1802.field_8801);
            }
            case 4: {
                return handler.method_7611(slot).method_7677().method_31574(class_1802.field_8288);
            }
            case 5: {
                return handler.method_7611(slot).method_7677().method_31574(class_1802.field_8634);
            }
            case 6: {
                return handler.method_7611(slot).method_7677().method_31574(class_1802.field_8463);
            }
            case 7: {
                return handler.method_7611(slot).method_7677().method_31574(class_1802.field_8287);
            }
            case 8: {
                return handler.method_7611(slot).method_7677().method_31574(class_1802.field_8087);
            }
        }
        return false;
    }

    private void handleBuyingScreen(class_1703 handler) {
        int i;
        for (i = 0; i < handler.field_7761.size(); ++i) {
            if (!handler.method_7611(i).method_7677().method_31574(class_1802.field_8581) || handler.method_7611(i).method_7677().method_7947() != 64) continue;
            this.mc.field_1761.method_2906(handler.field_7763, i, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.delayCounter = (Integer)this.delay.get();
            return;
        }
        for (i = 0; i < handler.field_7761.size(); ++i) {
            if (!handler.method_7611(i).method_7677().method_31574(class_1802.field_8581)) continue;
            this.mc.field_1761.method_2906(handler.field_7763, i, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.delayCounter = (Integer)this.delay.get();
            if (((Boolean)this.autoDrop.get()).booleanValue()) {
                this.mc.field_1724.field_3944.method_52787((class_2596)new class_2846(class_2846.class_2847.field_12970, class_2338.field_10980, class_2350.field_11033));
            }
            this.resetState();
            return;
        }
    }

    private void clickItem(class_1703 handler, int slot) {
        this.mc.field_1761.method_2906(handler.field_7763, slot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
        this.delayCounter = (Integer)this.delay.get();
        this.inBuyingScreen = true;
    }

    private void resetState() {
        this.inPvpCategory = false;
        this.inBuyingScreen = false;
    }

    public static enum ItemType {
        Obsidian,
        EndCrystal,
        RespawnAnchor,
        Glowstone,
        TotemOfUndying,
        EnderPearl,
        GoldenApple,
        ExperienceBottle,
        SlowFallingArrow;

    }
}

