/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2496;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_476;

public class SpawnerOrder
extends Module {
    private final class_310 mc = class_310.method_1551();
    private State currentState = State.INVENTORY_CHECK;
    private int tickCounter = 0;
    private int waitCounter = 0;
    private class_2338 targetSpawner = null;
    private final List<class_2338> spawners = new ArrayList<class_2338>();
    private int spawnerIndex = 0;
    private int itemIndex = 0;
    private final List<String> itemsToSellReference = Arrays.asList("bones", "arrows");
    private int currentSpawnerPageCounter = 0;
    private final SettingGroup sgGeneral = this.settings.getDefaultGroup();
    private final Setting<String> dropDelayMinutes = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("drop-delay-minutes")).description("Minutes between cycles.")).defaultValue((Object)"5")).build());
    private final Setting<Integer> actionDelaySetting = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("action-delay-ticks")).description("Delay between each action.")).defaultValue((Object)20)).min(1).max(200).build());
    private final Setting<Boolean> notifications = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("notifications")).description("Show notifications")).defaultValue((Object)true)).build());
    private final Setting<Integer> spawnerPagesToProcess = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("spawner-pages-to-process")).description("Number of pages to proces.")).defaultValue((Object)1)).min(1).max(10).build());
    private long lastDropTime = 0L;

    public SpawnerOrder() {
        super(GlazedAddon.CATEGORY, "Spawner-Order", "Order All Spawner Loot.");
    }

    private boolean isGreenGlass(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8581 || stack.method_7909() == class_1802.field_8656;
    }

    private int getDropDelayMinutes() {
        try {
            return Integer.parseInt((String)this.dropDelayMinutes.get());
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    private List<String> getAvailableItemsToSell() {
        ArrayList<String> availableItems = new ArrayList<String>();
        boolean hasBones = false;
        boolean hasArrows = false;
        for (int i = 0; i < this.mc.field_1724.method_31548().method_5439(); ++i) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (stack.method_7960()) continue;
            String itemName = stack.method_7909().method_63680().getString().toLowerCase();
            if (itemName.contains("bone")) {
                hasBones = true;
            }
            if (!itemName.contains("arrow")) continue;
            hasArrows = true;
        }
        if (hasBones) {
            availableItems.add("bones");
        }
        if (hasArrows) {
            availableItems.add("arrows");
        }
        return availableItems;
    }

    public void onActivate() {
        this.currentState = State.INVENTORY_CHECK;
        this.tickCounter = 0;
        this.lastDropTime = System.currentTimeMillis();
        this.spawners.clear();
        this.spawnerIndex = 0;
        this.itemIndex = 0;
        this.targetSpawner = null;
        this.currentSpawnerPageCounter = 0;
        if (((Boolean)this.notifications.get()).booleanValue()) {
            ChatUtils.info((String)"SpawnerOrder activated", (Object[])new Object[0]);
        }
    }

    public void onDeactivate() {
        if (this.mc.field_1755 != null) {
            this.mc.field_1724.method_7346();
        }
        this.mc.field_1724.method_36457(0.0f);
        if (((Boolean)this.notifications.get()).booleanValue()) {
            ChatUtils.info((String)"SpawnerOrder deactivated", (Object[])new Object[0]);
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        ++this.tickCounter;
        ++this.waitCounter;
        if (this.tickCounter >= (Integer)this.actionDelaySetting.get() && this.hasItemsToSell() && this.currentState != State.ORDER_COMMAND && this.currentState != State.OPENING_ORDER && this.currentState != State.CLICKING_SLOT0 && this.currentState != State.DEPOSITING_ITEMS && this.currentState != State.WAITING_CONFIRM_GUI && this.currentState != State.CONFIRMING_SALE && this.currentState != State.CLOSING_ORDER) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
            this.currentState = State.ORDER_COMMAND;
            this.itemIndex = 0;
            this.tickCounter = 0;
            return;
        }
        if (this.shouldStartNewCycle()) {
            this.startNewCycle();
            return;
        }
        if (this.tickCounter >= (Integer)this.actionDelaySetting.get()) {
            this.executeCurrentState();
            this.tickCounter = 0;
        }
    }

    private boolean shouldStartNewCycle() {
        long dropInterval;
        if (this.currentState != State.WAITING_CYCLE) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long timeSinceLastDrop = currentTime - this.lastDropTime;
        return timeSinceLastDrop >= (dropInterval = (long)(this.getDropDelayMinutes() * 60) * 1000L);
    }

    private void startNewCycle() {
        this.currentState = State.INVENTORY_CHECK;
        this.tickCounter = 0;
        this.waitCounter = 0;
        this.spawners.clear();
        this.spawnerIndex = 0;
        this.itemIndex = 0;
        this.targetSpawner = null;
        this.lastDropTime = System.currentTimeMillis();
        this.currentSpawnerPageCounter = 0;
        if (((Boolean)this.notifications.get()).booleanValue()) {
            ChatUtils.info((String)"Starting new spawner cycle...", (Object[])new Object[0]);
        }
    }

    private void executeCurrentState() {
        switch (this.currentState.ordinal()) {
            case 0: {
                this.handleInventoryCheck();
                break;
            }
            case 1: {
                this.handleScanning();
                break;
            }
            case 2: {
                this.handleMoving();
                break;
            }
            case 3: {
                this.handleOpening();
                break;
            }
            case 4: {
                this.handleDropping();
                break;
            }
            case 5: {
                this.handleWaitingClose();
                break;
            }
            case 6: {
                this.handleClosingGui();
                break;
            }
            case 7: {
                this.handleOrderCommand();
                break;
            }
            case 8: {
                this.handleOpeningOrder();
                break;
            }
            case 9: {
                this.handleClickingSlot0();
                break;
            }
            case 10: {
                this.handleDepositingItems();
                break;
            }
            case 11: {
                this.handleWaitingConfirmGui();
                break;
            }
            case 12: {
                this.handleConfirmingSale();
                break;
            }
            case 13: {
                this.handleClosingOrder();
                break;
            }
            case 14: {
                this.handleWaitingCycle();
            }
        }
    }

    private void handleInventoryCheck() {
        if (this.hasItemsToSell()) {
            this.currentState = State.ORDER_COMMAND;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
        } else {
            this.currentState = State.SCANNING;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
        }
    }

    private boolean hasItemsToSell() {
        for (int i = 0; i < this.mc.field_1724.method_31548().method_5439(); ++i) {
            String itemName;
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (stack.method_7960() || !(itemName = stack.method_7909().method_63680().getString().toLowerCase()).contains("bone") && !itemName.contains("arrow")) continue;
            return true;
        }
        return false;
    }

    private void handleScanning() {
        this.scanForSpawners();
        if (this.spawners.isEmpty()) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.error((String)"No spawners found.", (Object[])new Object[0]);
            }
            this.currentState = this.hasItemsToSell() ? State.ORDER_COMMAND : State.WAITING_CYCLE;
            return;
        }
        this.targetSpawner = this.spawners.get(0);
        this.spawnerIndex = 0;
        this.currentState = State.MOVING;
        if (((Boolean)this.notifications.get()).booleanValue()) {
            ChatUtils.info((String)"", (Object[])new Object[0]);
        }
    }

    private void handleMoving() {
        if (this.targetSpawner == null) {
            this.currentState = State.SCANNING;
            return;
        }
        double distance = this.mc.field_1724.method_19538().method_1022(class_243.method_24953((class_2382)this.targetSpawner));
        if (distance <= 4.5) {
            this.currentState = State.OPENING;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
        }
    }

    private void handleOpening() {
        if (this.mc.field_1755 instanceof class_476) {
            this.currentState = State.DROPPING;
            this.currentSpawnerPageCounter = 0;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
            return;
        }
        if (this.targetSpawner != null) {
            this.interactWithBlock(this.targetSpawner);
        }
    }

    private void handleDropping() {
        class_437 class_4372 = this.mc.field_1755;
        if (!(class_4372 instanceof class_476)) {
            this.currentState = State.OPENING;
            return;
        }
        class_476 screen = (class_476)class_4372;
        this.mc.field_1724.method_36457(90.0f);
        class_1703 handler = screen.method_17577();
        if (handler.field_7761.size() > 50) {
            this.mc.field_1761.method_2906(handler.field_7763, 50, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            ++this.currentSpawnerPageCounter;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
            if (this.currentSpawnerPageCounter < (Integer)this.spawnerPagesToProcess.get()) {
                if (handler.field_7761.size() > 53) {
                    this.mc.field_1761.method_2906(handler.field_7763, 53, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    if (((Boolean)this.notifications.get()).booleanValue()) {
                        ChatUtils.info((String)"", (Object[])new Object[0]);
                    }
                    this.currentState = State.DROPPING;
                    this.waitCounter = 0;
                } else {
                    if (((Boolean)this.notifications.get()).booleanValue()) {
                        ChatUtils.warning((String)"", (Object[])new Object[0]);
                    }
                    this.currentState = State.CLOSING_GUI;
                    this.waitCounter = 0;
                }
            } else {
                if (((Boolean)this.notifications.get()).booleanValue()) {
                    ChatUtils.info((String)"", (Object[])new Object[0]);
                }
                this.currentState = State.WAITING_CLOSE;
                this.waitCounter = 0;
            }
        } else {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.warning((String)"", (Object[])new Object[0]);
            }
            this.currentState = State.CLOSING_GUI;
            this.waitCounter = 0;
        }
    }

    private void handleWaitingClose() {
        if (this.waitCounter >= 10) {
            this.currentState = State.CLOSING_GUI;
        }
    }

    private void handleClosingGui() {
        if (this.mc.field_1755 != null) {
            this.mc.field_1724.method_7346();
        }
        this.mc.field_1724.method_36457(0.0f);
        ++this.spawnerIndex;
        if (this.spawnerIndex < this.spawners.size()) {
            this.targetSpawner = this.spawners.get(this.spawnerIndex);
            this.currentState = State.MOVING;
            this.waitCounter = 0;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
        } else {
            this.currentState = State.ORDER_COMMAND;
            this.waitCounter = 0;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
        }
    }

    private void handleOrderCommand() {
        List<String> currentItemsToSell = this.getAvailableItemsToSell();
        if (this.itemIndex >= currentItemsToSell.size()) {
            if (this.hasItemsToSell()) {
                this.itemIndex = 0;
                ChatUtils.info((String)"", (Object[])new Object[0]);
            } else {
                this.currentState = State.WAITING_CYCLE;
                if (((Boolean)this.notifications.get()).booleanValue()) {
                    ChatUtils.info((String)("Cycle completed! Next cycle in " + (String)this.dropDelayMinutes.get() + " minutes"), (Object[])new Object[0]);
                }
            }
            return;
        }
        String item = currentItemsToSell.get(this.itemIndex);
        ChatUtils.sendPlayerMsg((String)("/order " + item));
        this.currentState = State.OPENING_ORDER;
        this.waitCounter = 0;
        if (((Boolean)this.notifications.get()).booleanValue()) {
            ChatUtils.info((String)"", (Object[])new Object[0]);
        }
    }

    private void handleOpeningOrder() {
        if (this.mc.field_1755 instanceof class_476) {
            this.currentState = State.CLICKING_SLOT0;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
        }
    }

    private void handleClickingSlot0() {
        class_437 class_4372 = this.mc.field_1755;
        if (!(class_4372 instanceof class_476)) {
            this.currentState = State.ORDER_COMMAND;
            return;
        }
        class_476 screen = (class_476)class_4372;
        class_1703 handler = screen.method_17577();
        if (handler.field_7761.size() > 0) {
            this.mc.field_1761.method_2906(handler.field_7763, 0, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.currentState = State.DEPOSITING_ITEMS;
            this.waitCounter = 0;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
        }
    }

    private void handleDepositingItems() {
        class_437 class_4372 = this.mc.field_1755;
        if (!(class_4372 instanceof class_476)) {
            if (this.waitCounter > 20) {
                this.currentState = State.WAITING_CONFIRM_GUI;
            }
            return;
        }
        class_476 screen = (class_476)class_4372;
        class_1703 handler = screen.method_17577();
        List<String> currentItemsToSell = this.getAvailableItemsToSell();
        String item = currentItemsToSell.get(this.itemIndex);
        String itemSingular = item.replace("s", "");
        boolean depositedItems = false;
        int itemsDeposited = 0;
        for (int i = 0; i < handler.field_7761.size(); ++i) {
            class_1735 slot = (class_1735)handler.field_7761.get(i);
            if (slot.field_7871 != this.mc.field_1724.method_31548() || slot.method_7677().method_7960() || !slot.method_7677().method_7909().method_63680().getString().toLowerCase().contains(itemSingular)) continue;
            this.mc.field_1761.method_2906(handler.field_7763, i, 0, class_1713.field_7794, (class_1657)this.mc.field_1724);
            depositedItems = true;
            ++itemsDeposited;
        }
        if (depositedItems) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
            this.mc.field_1724.method_7346();
            this.currentState = State.WAITING_CONFIRM_GUI;
            this.waitCounter = 0;
        } else if (this.waitCounter > 40) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
            this.mc.field_1724.method_7346();
            this.currentState = State.WAITING_CONFIRM_GUI;
            this.waitCounter = 0;
        }
    }

    private void handleWaitingConfirmGui() {
        class_437 class_4372 = this.mc.field_1755;
        if (class_4372 instanceof class_476) {
            class_1799 stack;
            class_476 screen = (class_476)class_4372;
            class_1703 handler = screen.method_17577();
            if (handler.field_7761.size() > 15 && this.isGreenGlass(stack = handler.method_7611(15).method_7677())) {
                this.currentState = State.CONFIRMING_SALE;
                if (((Boolean)this.notifications.get()).booleanValue()) {
                    ChatUtils.info((String)"", (Object[])new Object[0]);
                }
                return;
            }
        }
        if (this.waitCounter > 100) {
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
            this.currentState = State.CLOSING_ORDER;
        }
    }

    private void handleConfirmingSale() {
        class_1799 stack;
        class_437 class_4372 = this.mc.field_1755;
        if (!(class_4372 instanceof class_476)) {
            this.currentState = State.CLOSING_ORDER;
            return;
        }
        class_476 screen = (class_476)class_4372;
        class_1703 handler = screen.method_17577();
        if (handler.field_7761.size() > 15 && this.isGreenGlass(stack = handler.method_7611(15).method_7677())) {
            this.mc.field_1761.method_2906(handler.field_7763, 15, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
            this.currentState = State.CLOSING_ORDER;
            this.waitCounter = 0;
            return;
        }
        if (((Boolean)this.notifications.get()).booleanValue()) {
            ChatUtils.warning((String)"", (Object[])new Object[0]);
        }
        this.currentState = State.CLOSING_ORDER;
    }

    private void handleClosingOrder() {
        List<String> currentItemsToSell;
        if (this.mc.field_1755 != null) {
            this.mc.field_1724.method_7346();
        }
        if (this.itemIndex < (currentItemsToSell = this.getAvailableItemsToSell()).size()) {
            String completedItem = currentItemsToSell.get(this.itemIndex);
            ChatUtils.info((String)"", (Object[])new Object[0]);
        }
        ++this.itemIndex;
        if (this.itemIndex < currentItemsToSell.size()) {
            this.currentState = State.ORDER_COMMAND;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
        } else if (this.hasItemsToSell()) {
            this.itemIndex = 0;
            this.currentState = State.ORDER_COMMAND;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
        } else {
            this.currentState = State.WAITING_CYCLE;
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)("Cycle completed! Next cycle in " + (String)this.dropDelayMinutes.get() + " minutes"), (Object[])new Object[0]);
            }
            if (this.mc.field_1755 != null) {
                this.mc.field_1724.method_7346();
                this.mc.field_1724.method_7346();
                if (((Boolean)this.notifications.get()).booleanValue()) {
                    ChatUtils.info((String)"", (Object[])new Object[0]);
                }
            }
        }
    }

    private void handleWaitingCycle() {
        if (this.mc.field_1755 != null) {
            this.mc.field_1724.method_7346();
            this.mc.field_1724.method_7346();
            if (((Boolean)this.notifications.get()).booleanValue()) {
                ChatUtils.info((String)"", (Object[])new Object[0]);
            }
        }
    }

    private void scanForSpawners() {
        this.spawners.clear();
        class_2338 playerPos = this.mc.field_1724.method_24515();
        int radius = 5;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = playerPos.method_10069(x, y, z);
                    class_2248 block = this.mc.field_1687.method_8320(pos).method_26204();
                    if (!(block instanceof class_2496)) continue;
                    this.spawners.add(pos);
                }
            }
        }
    }

    private void interactWithBlock(class_2338 pos) {
        try {
            class_3965 hitResult = new class_3965(class_243.method_24953((class_2382)pos), this.mc.field_1724.method_5735().method_10153(), pos, false);
            this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, hitResult);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getInfoString() {
        if (!this.isActive()) {
            return null;
        }
        long timeRemainingSeconds = ((long)(this.getDropDelayMinutes() * 60) * 1000L - (System.currentTimeMillis() - this.lastDropTime)) / 1000L;
        if (timeRemainingSeconds < 0L) {
            timeRemainingSeconds = 0L;
        }
        Object spawnerInfo = "";
        if (this.currentState == State.DROPPING || this.currentState == State.OPENING || this.currentState == State.MOVING || this.currentState == State.WAITING_CLOSE) {
            spawnerInfo = " | Spawner Page: " + this.currentSpawnerPageCounter + "/" + String.valueOf(this.spawnerPagesToProcess.get());
        }
        return this.currentState.name().replace("_", " ") + (String)spawnerInfo + " | Next cycle in: " + timeRemainingSeconds + "s";
    }

    private static enum State {
        INVENTORY_CHECK,
        SCANNING,
        MOVING,
        OPENING,
        DROPPING,
        WAITING_CLOSE,
        CLOSING_GUI,
        ORDER_COMMAND,
        OPENING_ORDER,
        CLICKING_SLOT0,
        DEPOSITING_ITEMS,
        WAITING_CONFIRM_GUI,
        CONFIRMING_SALE,
        CLOSING_ORDER,
        WAITING_CYCLE;

    }
}

