/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringListSetting;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.misc.AutoReconnect;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_742;

public class SpawnerProtect
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgWhitelist;
    private final SettingGroup sgWebhook;
    private final Setting<Boolean> webhook;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;
    private final Setting<Integer> spawnerRange;
    private final Setting<Integer> delaySeconds;
    private final Setting<Integer> emergencyDistance;
    private final Setting<Boolean> enableWhitelist;
    private final Setting<List<String>> whitelistPlayers;
    private State currentState;
    private String detectedPlayer;
    private long detectionTime;
    private boolean spawnersMinedSuccessfully;
    private boolean itemsDepositedSuccessfully;
    private int tickCounter;
    private boolean chestOpened;
    private int transferDelayCounter;
    private int lastProcessedSlot;
    private boolean sneaking;
    private class_2338 currentTarget;
    private int recheckDelay;
    private int confirmDelay;
    private boolean waiting;
    private boolean isMiningCycle;
    private int miningCycleTimer;
    private final int MINING_DURATION = 80;
    private final int PAUSE_DURATION = 20;
    private class_2338 targetChest;
    private int chestOpenAttempts;
    private boolean emergencyDisconnect;
    private String emergencyReason;
    private class_1937 trackedWorld;
    private int worldChangeCount;
    private final int PLAYER_COUNT_THRESHOLD = 3;

    public SpawnerProtect() {
        super(GlazedAddon.CATEGORY, "SpawnerProtect", "Breaks spawners and puts them in your inv when a player is detected");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgWhitelist = this.settings.createGroup("Whitelist");
        this.sgWebhook = this.settings.createGroup("Webhook");
        this.webhook = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("webhook")).description("Enable webhook notifications")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL for notifications")).defaultValue((Object)"")).visible(() -> this.webhook.get())).build());
        this.selfPing = this.sgWebhook.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("self-ping")).description("Ping yourself in the webhook message")).defaultValue((Object)false)).visible(() -> this.webhook.get())).build());
        this.discordId = this.sgWebhook.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("discord-id")).description("Your Discord user ID for pinging")).defaultValue((Object)"")).visible(() -> (Boolean)this.webhook.get() != false && (Boolean)this.selfPing.get() != false)).build());
        this.spawnerRange = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("spawner-range")).description("Range to check for remaining spawners")).defaultValue((Object)16)).min(1).max(50).sliderMax(50).build());
        this.delaySeconds = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("recheck-delay-seconds")).description("Delay in seconds before rechecking for spawners")).defaultValue((Object)1)).min(1).sliderMax(10).build());
        this.emergencyDistance = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("emergency-distance")).description("Distance in blocks where player triggers immediate disconnect")).defaultValue((Object)7)).min(1).max(20).sliderMax(20).build());
        this.enableWhitelist = this.sgWhitelist.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-whitelist")).description("Enable player whitelist (whitelisted players won't trigger protection)")).defaultValue((Object)false)).build());
        this.whitelistPlayers = this.sgWhitelist.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("whitelisted-players")).description("List of player names to ignore")).defaultValue(new ArrayList())).visible(() -> this.enableWhitelist.get())).build());
        this.currentState = State.IDLE;
        this.detectedPlayer = "";
        this.detectionTime = 0L;
        this.spawnersMinedSuccessfully = false;
        this.itemsDepositedSuccessfully = false;
        this.tickCounter = 0;
        this.chestOpened = false;
        this.transferDelayCounter = 0;
        this.lastProcessedSlot = -1;
        this.sneaking = false;
        this.currentTarget = null;
        this.recheckDelay = 0;
        this.confirmDelay = 0;
        this.waiting = false;
        this.isMiningCycle = true;
        this.miningCycleTimer = 0;
        this.MINING_DURATION = 80;
        this.PAUSE_DURATION = 20;
        this.targetChest = null;
        this.chestOpenAttempts = 0;
        this.emergencyDisconnect = false;
        this.emergencyReason = "";
        this.trackedWorld = null;
        this.worldChangeCount = 0;
        this.PLAYER_COUNT_THRESHOLD = 3;
    }

    public void onActivate() {
        this.resetState();
        this.configureLegitMining();
        if (this.mc.field_1687 != null) {
            this.trackedWorld = this.mc.field_1687;
            this.worldChangeCount = 0;
            this.info("SpawnerProtect activated - Monitoring world: " + String.valueOf(this.mc.field_1687.method_27983().method_29177()), new Object[0]);
            this.info("Monitoring for players...", new Object[0]);
        }
        ChatUtils.warning((String)"Make sure to have an empty inventory with only a silk touch pickaxe and an ender chest nearby!", (Object[])new Object[0]);
    }

    private void resetState() {
        this.currentState = State.IDLE;
        this.detectedPlayer = "";
        this.detectionTime = 0L;
        this.spawnersMinedSuccessfully = false;
        this.itemsDepositedSuccessfully = false;
        this.tickCounter = 0;
        this.chestOpened = false;
        this.transferDelayCounter = 0;
        this.lastProcessedSlot = -1;
        this.sneaking = false;
        this.currentTarget = null;
        this.recheckDelay = 0;
        this.confirmDelay = 0;
        this.waiting = false;
        this.isMiningCycle = true;
        this.miningCycleTimer = 0;
        this.targetChest = null;
        this.chestOpenAttempts = 0;
        this.emergencyDisconnect = false;
        this.emergencyReason = "";
    }

    private void configureLegitMining() {
        this.info("Manual mining mode activated", new Object[0]);
    }

    private void disableAutoReconnectIfEnabled() {
        Module autoReconnect = Modules.get().get(AutoReconnect.class);
        if (autoReconnect != null && autoReconnect.isActive()) {
            autoReconnect.toggle();
            this.info("AutoReconnect disabled due to player detection", new Object[0]);
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        ++this.tickCounter;
        if (this.mc.field_1687 != this.trackedWorld) {
            this.handleWorldChange();
            return;
        }
        if (this.currentState == State.WORLD_CHANGED_ONCE) {
            return;
        }
        if (this.currentState == State.WORLD_CHANGED_TWICE) {
            this.currentState = State.IDLE;
            this.info("Returned to spawner world - resuming player monitoring", new Object[0]);
        }
        if (this.checkEmergencyDisconnect()) {
            return;
        }
        if (this.transferDelayCounter > 0) {
            --this.transferDelayCounter;
            return;
        }
        switch (this.currentState.ordinal()) {
            case 0: {
                this.checkForPlayers();
                break;
            }
            case 1: {
                this.handleGoingToSpawners();
                break;
            }
            case 2: {
                this.handleGoingToChest();
                break;
            }
            case 3: {
                this.handleOpeningChest();
                break;
            }
            case 4: {
                this.handleDepositingItems();
                break;
            }
            case 5: {
                this.handleDisconnecting();
            }
        }
    }

    private void handleWorldChange() {
        ++this.worldChangeCount;
        this.trackedWorld = this.mc.field_1687;
        if (this.worldChangeCount == 1) {
            this.currentState = State.WORLD_CHANGED_ONCE;
            this.info("World changed (TP to spawn) - pausing player detection until return", new Object[0]);
        } else if (this.worldChangeCount == 2) {
            this.currentState = State.WORLD_CHANGED_TWICE;
            this.worldChangeCount = 0;
            this.info("World changed (back to spawners) - will resume monitoring", new Object[0]);
        }
    }

    private boolean checkEmergencyDisconnect() {
        long otherPlayers = this.mc.field_1687.method_18456().stream().filter(p -> p != this.mc.field_1724).count();
        if (otherPlayers >= 3L) {
            return false;
        }
        for (class_1657 player : this.mc.field_1687.method_18456()) {
            double distance;
            if (player == this.mc.field_1724 || player == null || !(player instanceof class_742)) continue;
            String playerName = player.method_7334().getName();
            if (((Boolean)this.enableWhitelist.get()).booleanValue() && this.isPlayerWhitelisted(playerName) || !((distance = (double)this.mc.field_1724.method_5739((class_1297)player)) <= (double)((Integer)this.emergencyDistance.get()).intValue())) continue;
            this.info("EMERGENCY: Player " + playerName + " came too close (" + String.format("%.1f", distance) + " blocks)!", new Object[0]);
            this.emergencyDisconnect = true;
            this.emergencyReason = "User " + playerName + " came too close";
            this.toggle();
            if (this.mc.field_1687 != null) {
                this.mc.field_1687.method_8525();
            }
            this.detectedPlayer = playerName;
            this.detectionTime = System.currentTimeMillis();
            this.disableAutoReconnectIfEnabled();
            this.currentState = State.DISCONNECTING;
            return true;
        }
        return false;
    }

    private void checkForPlayers() {
        long otherPlayers = this.mc.field_1687.method_18456().stream().filter(p -> p != this.mc.field_1724).count();
        if (otherPlayers >= 3L) {
            return;
        }
        for (class_1657 player : this.mc.field_1687.method_18456()) {
            if (player == this.mc.field_1724 || player == null || !(player instanceof class_742)) continue;
            String playerName = player.method_7334().getName();
            if (((Boolean)this.enableWhitelist.get()).booleanValue() && this.isPlayerWhitelisted(playerName)) continue;
            this.detectedPlayer = playerName;
            this.detectionTime = System.currentTimeMillis();
            this.info("SpawnerProtect: Player detected - " + this.detectedPlayer, new Object[0]);
            this.disableAutoReconnectIfEnabled();
            this.currentState = State.GOING_TO_SPAWNERS;
            this.info("Player detected! Starting protection sequence...", new Object[0]);
            this.setSneaking(true);
            break;
        }
    }

    private boolean isPlayerWhitelisted(String playerName) {
        if (!((Boolean)this.enableWhitelist.get()).booleanValue() || ((List)this.whitelistPlayers.get()).isEmpty()) {
            return false;
        }
        return ((List)this.whitelistPlayers.get()).stream().anyMatch(whitelistedName -> whitelistedName.equalsIgnoreCase(playerName));
    }

    private void handleGoingToSpawners() {
        this.setSneaking(true);
        if (this.currentTarget == null) {
            class_2338 found = this.findNearestSpawner();
            if (found == null) {
                this.stopBreaking();
                this.spawnersMinedSuccessfully = true;
                this.setSneaking(false);
                this.currentTarget = null;
                this.currentState = State.GOING_TO_CHEST;
                this.info("All spawners mined successfully. Looking for ender chest...", new Object[0]);
                this.tickCounter = 0;
                return;
            }
            this.currentTarget = found;
            this.isMiningCycle = true;
            this.miningCycleTimer = 0;
            this.info("Starting to mine spawner at " + String.valueOf(this.currentTarget), new Object[0]);
        }
        if (this.isMiningCycle) {
            this.lookAtBlock(this.currentTarget);
            this.breakBlock(this.currentTarget);
            if (this.mc.field_1687.method_8320(this.currentTarget).method_26215()) {
                this.info("Spawner at " + String.valueOf(this.currentTarget) + " broken! Releasing click...", new Object[0]);
                this.stopBreaking();
                this.isMiningCycle = false;
                this.miningCycleTimer = 0;
                this.currentTarget = null;
                this.transferDelayCounter = 5;
            }
        } else {
            ++this.miningCycleTimer;
            if (this.miningCycleTimer >= 20) {
                // empty if block
            }
        }
    }

    private void handleWaitingForSpawners() {
        class_2338 foundSpawner;
        ++this.recheckDelay;
        if (this.recheckDelay == (Integer)this.delaySeconds.get() * 20 && (foundSpawner = this.findNearestSpawner()) != null) {
            this.waiting = false;
            this.currentTarget = foundSpawner;
            this.isMiningCycle = true;
            this.miningCycleTimer = 0;
            this.info("Found additional spawner at " + String.valueOf(foundSpawner), new Object[0]);
            return;
        }
        if (this.recheckDelay > (Integer)this.delaySeconds.get() * 20) {
            ++this.confirmDelay;
            if (this.confirmDelay >= 5) {
                this.stopBreaking();
                this.spawnersMinedSuccessfully = true;
                this.setSneaking(false);
                this.currentState = State.GOING_TO_CHEST;
                this.info("All spawners mined successfully. Looking for ender chest...", new Object[0]);
                this.tickCounter = 0;
            }
        }
    }

    private class_2338 findNearestSpawner() {
        class_2338 playerPos = this.mc.field_1724.method_24515();
        class_2338 nearestSpawner = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_2338 pos : class_2338.method_10097((class_2338)playerPos.method_10069(-((Integer)this.spawnerRange.get()).intValue(), -((Integer)this.spawnerRange.get()).intValue(), -((Integer)this.spawnerRange.get()).intValue()), (class_2338)playerPos.method_10069(((Integer)this.spawnerRange.get()).intValue(), ((Integer)this.spawnerRange.get()).intValue(), ((Integer)this.spawnerRange.get()).intValue()))) {
            double distance;
            if (this.mc.field_1687.method_8320(pos).method_26204() != class_2246.field_10260 || !((distance = pos.method_19770((class_2374)this.mc.field_1724.method_19538())) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestSpawner = pos.method_10062();
        }
        if (nearestSpawner != null) {
            this.info("Found spawner at " + String.valueOf(nearestSpawner) + " (distance: " + String.format("%.2f", Math.sqrt(nearestDistance)) + ")", new Object[0]);
        }
        return nearestSpawner;
    }

    private void lookAtBlock(class_2338 pos) {
        class_243 targetPos = class_243.method_24953((class_2382)pos);
        class_243 playerPos = this.mc.field_1724.method_33571();
        class_243 direction = targetPos.method_1020(playerPos).method_1029();
        double yaw = Math.toDegrees(Math.atan2(-direction.field_1352, direction.field_1350));
        double pitch = Math.toDegrees(-Math.asin(direction.field_1351));
        this.mc.field_1724.method_36456((float)yaw);
        this.mc.field_1724.method_36457((float)pitch);
    }

    private void breakBlock(class_2338 pos) {
        if (this.mc.field_1761 != null) {
            this.mc.field_1761.method_2902(pos, class_2350.field_11036);
            class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1886.method_1429(), (boolean)true);
        }
    }

    private void stopBreaking() {
        class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1886.method_1429(), (boolean)false);
    }

    private void setSneaking(boolean sneak) {
        if (this.mc.field_1724 == null || this.mc.method_1562() == null) {
            return;
        }
        if (sneak && !this.sneaking) {
            this.mc.field_1724.method_5660(true);
            this.mc.method_1562().method_52787((class_2596)new class_2848((class_1297)this.mc.field_1724, class_2848.class_2849.field_12979));
            this.sneaking = true;
        } else if (!sneak && this.sneaking) {
            this.mc.field_1724.method_5660(false);
            this.mc.method_1562().method_52787((class_2596)new class_2848((class_1297)this.mc.field_1724, class_2848.class_2849.field_12984));
            this.sneaking = false;
        }
    }

    private void handleGoingToChest() {
        if (this.targetChest == null) {
            this.targetChest = this.findNearestEnderChest();
            if (this.targetChest == null) {
                this.info("No ender chest found nearby!", new Object[0]);
                this.currentState = State.DISCONNECTING;
                return;
            }
            this.info("Found ender chest at " + String.valueOf(this.targetChest), new Object[0]);
        }
        this.moveTowardsBlock(this.targetChest);
        if (this.mc.field_1724.method_24515().method_10262((class_2382)this.targetChest) <= 9.0) {
            this.currentState = State.OPENING_CHEST;
            this.chestOpenAttempts = 0;
            this.info("Reached ender chest. Attempting to open...", new Object[0]);
        }
        if (this.tickCounter > 600) {
            ChatUtils.error((String)"Timed out trying to reach ender chest!", (Object[])new Object[0]);
            this.currentState = State.DISCONNECTING;
        }
    }

    private class_2338 findNearestEnderChest() {
        class_2338 playerPos = this.mc.field_1724.method_24515();
        class_2338 nearestChest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_2338 pos : class_2338.method_10097((class_2338)playerPos.method_10069(-16, -8, -16), (class_2338)playerPos.method_10069(16, 8, 16))) {
            double distance;
            if (this.mc.field_1687.method_8320(pos).method_26204() != class_2246.field_10443 || !((distance = pos.method_19770((class_2374)this.mc.field_1724.method_19538())) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestChest = pos.method_10062();
        }
        return nearestChest;
    }

    private void moveTowardsBlock(class_2338 target) {
        class_243 playerPos = this.mc.field_1724.method_19538();
        class_243 targetPos = class_243.method_24953((class_2382)target);
        class_243 direction = targetPos.method_1020(playerPos).method_1029();
        double yaw = Math.toDegrees(Math.atan2(-direction.field_1352, direction.field_1350));
        this.mc.field_1724.method_36456((float)yaw);
        class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1894.method_1429(), (boolean)true);
    }

    private void handleOpeningChest() {
        if (this.targetChest == null) {
            this.currentState = State.GOING_TO_CHEST;
            return;
        }
        class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1894.method_1429(), (boolean)false);
        class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1903.method_1429(), (boolean)true);
        if (this.chestOpenAttempts < 20) {
            this.lookAtBlock(this.targetChest);
        }
        if (this.chestOpenAttempts % 5 == 0 && this.mc.field_1761 != null && this.mc.field_1724 != null) {
            this.mc.field_1761.method_2896(this.mc.field_1724, class_1268.field_5808, new class_3965(class_243.method_24953((class_2382)this.targetChest), class_2350.field_11036, this.targetChest, false));
            this.info("Right-clicking ender chest... (attempt " + (this.chestOpenAttempts / 5 + 1) + ")", new Object[0]);
        }
        ++this.chestOpenAttempts;
        if (this.mc.field_1724.field_7512 instanceof class_1707) {
            class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1903.method_1429(), (boolean)false);
            this.currentState = State.DEPOSITING_ITEMS;
            this.chestOpened = true;
            this.lastProcessedSlot = -1;
            this.tickCounter = 0;
            this.info("Ender chest opened successfully! Made by GLZD ", new Object[0]);
        }
        if (this.chestOpenAttempts > 200) {
            class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1903.method_1429(), (boolean)false);
            ChatUtils.error((String)"Failed to open ender chest after multiple attempts!", (Object[])new Object[0]);
            this.currentState = State.DISCONNECTING;
        }
    }

    private void handleDepositingItems() {
        if (this.mc.field_1724.field_7512 instanceof class_1707) {
            class_1707 handler = (class_1707)this.mc.field_1724.field_7512;
            if (!this.hasItemsToDeposit()) {
                this.itemsDepositedSuccessfully = true;
                this.info("All items deposited successfully!", new Object[0]);
                this.mc.field_1724.method_7346();
                this.transferDelayCounter = 10;
                this.currentState = State.DISCONNECTING;
                return;
            }
            this.transferItemsToChest(handler);
        } else {
            this.currentState = State.OPENING_CHEST;
            this.chestOpened = false;
            this.chestOpenAttempts = 0;
        }
        if (this.tickCounter > 900) {
            ChatUtils.error((String)"Timed out depositing items!", (Object[])new Object[0]);
            this.currentState = State.DISCONNECTING;
        }
    }

    private boolean hasItemsToDeposit() {
        for (int i = 0; i < 36; ++i) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (stack.method_7960() || stack.method_7909() == class_1802.field_8162) continue;
            return true;
        }
        return false;
    }

    private void transferItemsToChest(class_1707 handler) {
        int chestSlots;
        int totalSlots = handler.field_7761.size();
        int playerInventoryStart = chestSlots = totalSlots - 36;
        int startSlot = Math.max(this.lastProcessedSlot + 1, playerInventoryStart);
        for (int i = 0; i < 36; ++i) {
            int slotId = playerInventoryStart + (startSlot - playerInventoryStart + i) % 36;
            class_1799 stack = handler.method_7611(slotId).method_7677();
            if (stack.method_7960() || stack.method_7909() == class_1802.field_8162) continue;
            this.info("Transferring item from slot " + slotId + ": " + stack.method_7909().toString(), new Object[0]);
            if (this.mc.field_1761 != null) {
                this.mc.field_1761.method_2906(handler.field_7763, slotId, 0, class_1713.field_7794, (class_1657)this.mc.field_1724);
            }
            this.lastProcessedSlot = slotId;
            this.transferDelayCounter = 2;
            return;
        }
        if (this.lastProcessedSlot >= playerInventoryStart) {
            this.lastProcessedSlot = playerInventoryStart - 1;
            this.transferDelayCounter = 3;
        }
    }

    private void handleDisconnecting() {
        class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1894.method_1429(), (boolean)false);
        class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1903.method_1429(), (boolean)false);
        this.sendWebhookNotification();
        if (this.emergencyDisconnect) {
            this.info("SpawnerProtect: " + this.emergencyReason + ". Successfully disconnected.", new Object[0]);
        } else {
            this.info("SpawnerProtect: " + this.detectedPlayer + " detected. Successfully disconnected.", new Object[0]);
        }
        if (this.mc.field_1687 != null) {
            this.mc.field_1687.method_8525();
        }
        this.info("Disconnected due to player detection.", new Object[0]);
        this.toggle();
    }

    private void sendWebhookNotification() {
        if (!((Boolean)this.webhook.get()).booleanValue() || this.webhookUrl.get() == null || ((String)this.webhookUrl.get()).trim().isEmpty()) {
            this.info("Webhook disabled or URL not configured.", new Object[0]);
            return;
        }
        String webhookUrlValue = ((String)this.webhookUrl.get()).trim();
        long discordTimestamp = this.detectionTime / 1000L;
        String messageContent = "";
        if (((Boolean)this.selfPing.get()).booleanValue() && this.discordId.get() != null && !((String)this.discordId.get()).trim().isEmpty()) {
            messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
        }
        String embedJson = this.createWebhookPayload(messageContent, discordTimestamp);
        new Thread(() -> {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(webhookUrlValue)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(embedJson)).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() >= 200 && response.statusCode() < 300) {
                    this.info("Webhook notification sent successfully!", new Object[0]);
                } else {
                    ChatUtils.error((String)("Failed to send webhook notification. Status: " + response.statusCode()), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                ChatUtils.error((String)("Failed to send webhook notification: " + e.getMessage()), (Object[])new Object[0]);
            }
        }).start();
    }

    private String createWebhookPayload(String messageContent, long discordTimestamp) {
        String title;
        String string = title = this.emergencyDisconnect ? "SpawnerProtect Emergency Alert" : "SpawnerProtect Alert";
        String description = this.emergencyDisconnect ? String.format("**Player Detected:** %s\\n**Detection Time:** <t:%d:R>\\n**Reason:** %s\\n**Disconnected:** Yes", this.escapeJson(this.detectedPlayer), discordTimestamp, this.escapeJson(this.emergencyReason)) : String.format("**Player Detected:** %s\\n**Detection Time:** <t:%d:R>\\n**Spawners Mined:** %s\\n**Items Deposited:** %s\\n**Disconnected:** Yes", this.escapeJson(this.detectedPlayer), discordTimestamp, this.spawnersMinedSuccessfully ? "\u2705 Success" : "\u274c Failed", this.itemsDepositedSuccessfully ? "\u2705 Success" : "\u274c Failed");
        int color = this.emergencyDisconnect ? 0xFF0000 : 16766720;
        return String.format("{\n    \"username\": \"Overkill Webhook\",\n    \"avatar_url\": \"https://i.imgur.com/OL2y1cr.png\",\n    \"content\": \"%s\",\n    \"embeds\": [{\n        \"title\": \"%s\",\n        \"description\": \"%s\",\n        \"color\": %d,\n        \"timestamp\": \"%s\",\n        \"footer\": {\n            \"text\": \"Sent by Overkill\"\n        }\n    }]\n}", this.escapeJson(messageContent), title, description, color, Instant.now().toString());
    }

    private String escapeJson(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public void onDeactivate() {
        this.stopBreaking();
        this.setSneaking(false);
        class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1894.method_1429(), (boolean)false);
        class_304.method_1416((class_3675.class_306)this.mc.field_1690.field_1903.method_1429(), (boolean)false);
    }

    private static enum State {
        IDLE,
        GOING_TO_SPAWNERS,
        GOING_TO_CHEST,
        OPENING_CHEST,
        DEPOSITING_ITEMS,
        DISCONNECTING,
        WORLD_CHANGED_ONCE,
        WORLD_CHANGED_TWICE;

    }
}

