/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringListSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.MeteorToast;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1802;
import net.minecraft.class_368;
import net.minecraft.class_640;

public class TabDetector
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<List<String>> targetPlayers;
    private final Setting<Mode> notificationMode;
    private final Setting<Boolean> logOffline;
    private final Set<String> currentTargetPlayers;
    private final Set<String> previousTargetPlayers;

    public TabDetector() {
        super(GlazedAddon.CATEGORY, "TabDetector", "Detects when specific players join or leave the server");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.targetPlayers = this.sgGeneral.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("target-players")).description("List of player names to detect when they join")).defaultValue(new ArrayList())).build());
        this.notificationMode = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("notification-mode")).description("How to notify when target players are detected")).defaultValue((Object)Mode.Both)).build());
        this.logOffline = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("log-offline")).description("Also log when target players go offline")).defaultValue((Object)true)).build());
        this.currentTargetPlayers = new HashSet<String>();
        this.previousTargetPlayers = new HashSet<String>();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null || this.mc.method_1562() == null) {
            return;
        }
        this.currentTargetPlayers.clear();
        Collection playerList = this.mc.method_1562().method_2880();
        block0: for (class_640 entry : playerList) {
            String playerName = entry.method_2966().getName();
            for (String targetName : (List)this.targetPlayers.get()) {
                if (!targetName.equalsIgnoreCase(playerName)) continue;
                this.currentTargetPlayers.add(playerName);
                continue block0;
            }
        }
        HashSet<String> newPlayers = new HashSet<String>(this.currentTargetPlayers);
        newPlayers.removeAll(this.previousTargetPlayers);
        if (!newPlayers.isEmpty()) {
            this.handlePlayerJoin(newPlayers);
        }
        if (((Boolean)this.logOffline.get()).booleanValue()) {
            HashSet<String> leftPlayers = new HashSet<String>(this.previousTargetPlayers);
            leftPlayers.removeAll(this.currentTargetPlayers);
            if (!leftPlayers.isEmpty()) {
                this.handlePlayerLeave(leftPlayers);
            }
        }
        this.previousTargetPlayers.clear();
        this.previousTargetPlayers.addAll(this.currentTargetPlayers);
    }

    private void handlePlayerJoin(Set<String> players) {
        String playerList = String.join((CharSequence)", ", players);
        String message = players.size() == 1 ? String.format("Target player joined: (highlight)%s", playerList) : String.format("Target players joined: (highlight)%s", playerList);
        switch (((Mode)((Object)this.notificationMode.get())).ordinal()) {
            case 0: {
                this.info(message, new Object[0]);
                break;
            }
            case 1: {
                String toastMessage = players.size() == 1 ? "Target Player Joined!" : "Target Players Joined!";
                this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8575, this.title, toastMessage));
                break;
            }
            case 2: {
                this.info(message, new Object[0]);
                String toastMessage = players.size() == 1 ? "Target Player Joined!" : "Target Players Joined!";
                this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8575, this.title, toastMessage));
            }
        }
    }

    private void handlePlayerLeave(Set<String> players) {
        String playerList = String.join((CharSequence)", ", players);
        String message = players.size() == 1 ? String.format("Target player left: (highlight)%s", playerList) : String.format("Target players left: (highlight)%s", playerList);
        switch (((Mode)((Object)this.notificationMode.get())).ordinal()) {
            case 0: {
                this.info(message, new Object[0]);
                break;
            }
            case 1: {
                String toastMessage = players.size() == 1 ? "Target Player Left!" : "Target Players Left!";
                this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8077, this.title, toastMessage));
                break;
            }
            case 2: {
                this.info(message, new Object[0]);
                String toastMessage = players.size() == 1 ? "Target Player Left!" : "Target Players Left!";
                this.mc.method_1566().method_1999((class_368)new MeteorToast(class_1802.field_8077, this.title, toastMessage));
            }
        }
    }

    public void onActivate() {
        this.currentTargetPlayers.clear();
        this.previousTargetPlayers.clear();
        if (this.mc.method_1562() != null) {
            Collection playerList = this.mc.method_1562().method_2880();
            block0: for (class_640 entry : playerList) {
                String playerName = entry.method_2966().getName();
                for (String targetName : (List)this.targetPlayers.get()) {
                    if (!targetName.equalsIgnoreCase(playerName)) continue;
                    this.previousTargetPlayers.add(playerName);
                    continue block0;
                }
            }
        }
    }

    public void onDeactivate() {
        this.currentTargetPlayers.clear();
        this.previousTargetPlayers.clear();
    }

    public String getInfoString() {
        if (this.currentTargetPlayers.isEmpty()) {
            return ((List)this.targetPlayers.get()).isEmpty() ? "No targets" : null;
        }
        return String.valueOf(this.currentTargetPlayers.size());
    }

    public static enum Mode {
        Chat("Chat"),
        Toast("Toast"),
        Both("Both");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

