/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringListSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class TpaAllMacro
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<TpaType> tpaType;
    private final Setting<Integer> delay;
    private final Setting<Boolean> useGui;
    private final Setting<List<String>> blacklist;
    private int tickCounter;
    private boolean waitingForConfirm;
    private long guiWaitStart;
    private static final long GUI_TIMEOUT_MS = 5000L;
    private final List<String> onlinePlayers;
    private int currentIndex;

    public TpaAllMacro() {
        super(GlazedAddon.CATEGORY, "TpaAllMacro", "Cycles through all online players and sends /tpa or /tpahere with optional GUI confirmation.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.tpaType = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("tpa-type")).description("Command to use.")).defaultValue((Object)TpaType.TPA)).build());
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("Ticks between command sends.")).defaultValue((Object)20)).min(20).sliderMax(200).build());
        this.useGui = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("use-gui")).description("Click the confirmation GUI automatically.")).defaultValue((Object)true)).build());
        this.blacklist = this.sgGeneral.add((Setting)((StringListSetting.Builder)((StringListSetting.Builder)((StringListSetting.Builder)new StringListSetting.Builder().name("blacklist")).description("Players to skip.")).defaultValue(List.of("Admin", "Mod", "YourFriend"))).build());
        this.tickCounter = 0;
        this.waitingForConfirm = false;
        this.guiWaitStart = 0L;
        this.onlinePlayers = new ArrayList<String>();
        this.currentIndex = 0;
    }

    public void onActivate() {
        this.tickCounter = 0;
        this.waitingForConfirm = false;
        this.guiWaitStart = 0L;
        this.currentIndex = 0;
        this.onlinePlayers.clear();
        this.info("Starting TPA Macro loop.", new Object[0]);
    }

    public void onDeactivate() {
        this.waitingForConfirm = false;
        this.guiWaitStart = 0L;
        this.info("TPA Macro deactivated.", new Object[0]);
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null || this.mc.field_1761 == null) {
            return;
        }
        if (this.onlinePlayers.isEmpty() || this.currentIndex >= this.onlinePlayers.size()) {
            this.onlinePlayers.clear();
            this.mc.field_1724.field_3944.method_2880().forEach(info -> {
                String name = info.method_2966().getName();
                if (!Objects.equals(name, this.mc.field_1724.method_7334().getName()) && !((List)this.blacklist.get()).contains(name)) {
                    this.onlinePlayers.add(name);
                }
            });
            this.currentIndex = 0;
            if (this.onlinePlayers.isEmpty()) {
                this.warning("No valid players online.", new Object[0]);
                return;
            }
        }
        if (((Boolean)this.useGui.get()).booleanValue()) {
            if (this.waitingForConfirm && this.mc.field_1755 instanceof class_465) {
                this.clickConfirmButtonIfPresent();
                return;
            }
            if (this.waitingForConfirm && this.guiWaitStart > 0L && System.currentTimeMillis() - this.guiWaitStart > 5000L) {
                ChatUtils.warning((String)"GUI timeout. Retrying...", (Object[])new Object[0]);
                this.waitingForConfirm = false;
                this.guiWaitStart = 0L;
            }
        }
        if (!this.waitingForConfirm) {
            ++this.tickCounter;
            if (this.tickCounter >= (Integer)this.delay.get()) {
                String target = this.onlinePlayers.get(this.currentIndex++);
                String command = (this.tpaType.get() == TpaType.TPA ? "/tpa " : "/tpahere ") + target;
                ChatUtils.sendPlayerMsg((String)command);
                ChatUtils.info((String)("\ud83d\udce8 Sent: " + command), (Object[])new Object[0]);
                if (((Boolean)this.useGui.get()).booleanValue()) {
                    this.waitingForConfirm = true;
                    this.guiWaitStart = System.currentTimeMillis();
                }
                this.tickCounter = 0;
            }
        }
    }

    private void clickConfirmButtonIfPresent() {
        class_437 class_4372 = this.mc.field_1755;
        if (!(class_4372 instanceof class_465)) {
            return;
        }
        class_465 screen = (class_465)class_4372;
        class_1703 handler = screen.method_17577();
        for (int i = 0; i < handler.field_7761.size(); ++i) {
            class_1799 stack = handler.method_7611(i).method_7677();
            String key = stack.method_7909().method_7876().toLowerCase();
            if (!key.contains("stained_glass_pane") || !key.contains("lime")) continue;
            this.mc.field_1761.method_2906(handler.field_7763, i, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            ChatUtils.info((String)("\ud83d\udfe2 Confirm button clicked (slot " + i + ")."), (Object[])new Object[0]);
            this.mc.field_1724.method_7346();
            this.waitingForConfirm = false;
            this.guiWaitStart = 0L;
            return;
        }
        ChatUtils.warning((String)"No confirmation button found in GUI.", (Object[])new Object[0]);
    }

    public static enum TpaType {
        TPA,
        TPAHERE;

    }
}

