/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.main;

import com.nnpg.glazed.GlazedAddon;
import com.nnpg.glazed.settings.RandomBetweenIntSetting;
import com.nnpg.glazed.settings.TextDisplaySetting;
import com.nnpg.glazed.utils.RandomBetweenInt;
import com.nnpg.glazed.utils.glazed.StringUtils;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2596;
import net.minecraft.class_2797;
import net.minecraft.class_2813;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_7472;

public class UIHelper
extends Module {
    private final SettingGroup sgAutoConfirm;
    private final Setting<String> acDescription;
    private final Setting<Boolean> enableAutoConfirm;
    private final Setting<Boolean> acAHBuy;
    private final Setting<Boolean> acAHSell;
    private final Setting<Boolean> acOrderFulfill;
    private final Setting<Boolean> acTPA;
    private final Setting<Boolean> acTPAHere;
    private final Setting<Boolean> acTPAReceive;
    private final Setting<Boolean> acTPAHereReceive;
    private final Setting<Boolean> acShardshopBuy;
    private final Setting<Boolean> acCrateBuy;
    private final Setting<Boolean> acBounty;
    private final Setting<Boolean> acSpawnerSellAll;
    private final Setting<RandomBetweenInt> acRandomDelay;
    private final CircularBuffer<String> lastScreens;
    private String currentScreen;
    private String currentCommand;
    private long commandTime;
    private static final long COMMAND_TIMEOUT = 10000L;
    private long acTimer;
    private long lastClickTime;
    private static final long CLICK_COOLDOWN = 1000L;
    private final SettingGroup sgAutoAdvance;
    private final Setting<String> aaDescription;
    private final Setting<Boolean> enableAutoAdvance;
    private final Setting<Direction> aaDirection;
    private final Setting<RandomBetweenInt> aaRandomDelay;
    private long aaTimer;

    public UIHelper() {
        super(GlazedAddon.CATEGORY, "UI Helper", "Helps perform various UI tasks automatically.");
        this.sgAutoConfirm = this.settings.createGroup("AutoConfirm");
        this.acDescription = this.sgAutoConfirm.add((Setting)((TextDisplaySetting.Builder)((Object)((TextDisplaySetting.Builder)((Object)((TextDisplaySetting.Builder)((Object)new TextDisplaySetting.Builder().name(""))).description(""))).defaultValue("Automatically confirms various confirm pop-up dialogs."))).build());
        this.enableAutoConfirm = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-auto-confirm")).description("Automatically confirms various actions in the UI.")).defaultValue((Object)false)).build());
        this.acAHBuy = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ah-buy")).description("Automatically confirms purchases in the Auction House.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acAHSell = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ah-sell")).description("Automatically confirms sales in the Auction House.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acOrderFulfill = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("order-fulfill")).description("Automatically confirms fulfilling orders.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acTPA = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tpa")).description("Automatically confirms TPA requests sent to someone else.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acTPAHere = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tpahere")).description("Automatically confirms TPAHERE requests sent to someone else.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acTPAReceive = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tpa-receive")).description("Automatically confirms TPA requests sent to you.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acTPAHereReceive = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tpahere-receive")).description("Automatically confirms TPAHERE requests sent to you.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acShardshopBuy = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("shardshop-buy")).description("Automatically confirms purchases in the Shard Shop.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acCrateBuy = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("crate-buy")).description("Automatically confirms purchases from crates.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acBounty = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("bounty-add")).description("Automatically confirms adding bounties on players.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acSpawnerSellAll = this.sgAutoConfirm.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("spawner-sell-all")).description("Automatically confirms selling all items in spawners.")).defaultValue((Object)false)).visible(() -> this.enableAutoConfirm.get())).build());
        this.acRandomDelay = this.sgAutoConfirm.add((Setting)((RandomBetweenIntSetting.Builder)((Object)((RandomBetweenIntSetting.Builder)((Object)((RandomBetweenIntSetting.Builder)((Object)new RandomBetweenIntSetting.Builder().name("random-delay"))).description("Random delay between actions in milliseconds."))).defaultRange(50, 150).range(0, 2000).sliderRange(10, 1000).visible(() -> this.enableAutoConfirm.get()))).build());
        this.lastScreens = new CircularBuffer(5);
        this.currentScreen = null;
        this.currentCommand = null;
        this.commandTime = 0L;
        this.acTimer = 0L;
        this.lastClickTime = 0L;
        this.sgAutoAdvance = this.settings.createGroup("AutoAdvance");
        this.aaDescription = this.sgAutoAdvance.add((Setting)((TextDisplaySetting.Builder)((Object)((TextDisplaySetting.Builder)((Object)((TextDisplaySetting.Builder)((Object)new TextDisplaySetting.Builder().name(""))).description(""))).defaultValue("Automatically advances pages in spawner GUI after dropping items."))).build());
        this.enableAutoAdvance = this.sgAutoAdvance.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enable-auto-advance")).description("Automatically advances pages in UIs after certain actions.")).defaultValue((Object)false)).build());
        this.aaDirection = this.sgAutoAdvance.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("direction")).description("The direction to advance the page.")).defaultValue((Object)Direction.FORWARDS)).visible(() -> this.enableAutoAdvance.get())).build());
        this.aaRandomDelay = this.sgAutoAdvance.add((Setting)((RandomBetweenIntSetting.Builder)((Object)((RandomBetweenIntSetting.Builder)((Object)((RandomBetweenIntSetting.Builder)((Object)new RandomBetweenIntSetting.Builder().name("random-delay"))).description("Random delay between actions in milliseconds."))).defaultRange(50, 150).range(0, 2000).sliderRange(10, 1000).visible(() -> this.enableAutoAdvance.get()))).build());
        this.aaTimer = 0L;
    }

    @EventHandler
    private void onOpenScreen(OpenScreenEvent event) {
        if (event.screen == null) {
            if (this.acTimer > 0L) {
                this.acTimer = 0L;
            }
            return;
        }
        if (event.screen instanceof class_465) {
            String newScreen = StringUtils.convertUnicodeToAscii(((class_465)event.screen).method_25440().getString()).toUpperCase();
            if (this.currentScreen != null && !this.currentScreen.equals(newScreen)) {
                this.lastScreens.add(this.currentScreen);
            }
            this.currentScreen = newScreen;
        }
        if (this.shouldConfirm(this.currentScreen)) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 1000L) {
                return;
            }
            this.acTimer = currentTime + (long)((RandomBetweenInt)this.acRandomDelay.get()).getRandom();
        }
    }

    @EventHandler
    private void onSendPacket(PacketEvent.Send event) {
        class_2596 class_25962 = event.packet;
        if (class_25962 instanceof class_2797) {
            class_2797 packet = (class_2797)class_25962;
            message = packet.comp_945().trim();
            if (((String)message).startsWith("/") && (((String)message).startsWith("/ah sell") || ((String)message).startsWith("/tpa ") || ((String)message).startsWith("/tpahere ") || ((String)message).startsWith("/tpaccept ") || ((String)message).startsWith("/bounty add "))) {
                this.currentCommand = message;
                this.commandTime = System.currentTimeMillis();
            }
        } else {
            class_7472 packet;
            String command;
            message = event.packet;
            if (message instanceof class_7472 && ((command = "/" + (packet = (class_7472)message).comp_808().trim()).startsWith("/ah sell") || command.startsWith("/tpa ") || command.startsWith("/tpahere ") || command.startsWith("/tpaccept ") || command.startsWith("/bounty add "))) {
                this.currentCommand = command;
                this.commandTime = System.currentTimeMillis();
            }
        }
    }

    private boolean shouldConfirm(String currentScreenTitle) {
        if (currentScreenTitle == null) {
            return false;
        }
        if (!currentScreenTitle.contains("CONFIRM") && !currentScreenTitle.contains("ACCEPT")) {
            return false;
        }
        boolean shouldConfirm = false;
        block14 : switch (currentScreenTitle) {
            case "CONFIRM PURCHASE": {
                boolean foundAuction = false;
                boolean foundShardShop = false;
                for (int i = 0; i < Math.min(this.lastScreens.size, 3); ++i) {
                    try {
                        String recentScreen = this.lastScreens.get(i);
                        if (recentScreen == null) continue;
                        if (recentScreen.contains("AUCTION")) {
                            foundAuction = true;
                        }
                        if (!recentScreen.contains("SHOP - SHARD SHOP")) continue;
                        foundShardShop = true;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (((Boolean)this.acAHBuy.get()).booleanValue() && foundAuction) {
                    shouldConfirm = true;
                    break;
                }
                if (!((Boolean)this.acShardshopBuy.get()).booleanValue() || !foundShardShop) break;
                shouldConfirm = true;
                break;
            }
            case "CONFIRM LISTING": {
                if (!((Boolean)this.acAHSell.get()).booleanValue()) break;
                shouldConfirm = true;
                break;
            }
            case "ORDERS -> CONFIRM DELIVERY": {
                String prevScreen = this.lastScreens.get(0);
                if (!((Boolean)this.acOrderFulfill.get()).booleanValue() || prevScreen == null || !prevScreen.contains("ORDERS")) break;
                shouldConfirm = true;
                break;
            }
            case "CONFIRM REQUEST": {
                if (this.currentCommand == null || System.currentTimeMillis() - this.commandTime >= 10000L) break;
                if (((Boolean)this.acTPA.get()).booleanValue() && this.currentCommand.startsWith("/tpa ")) {
                    shouldConfirm = true;
                    break;
                }
                if (!((Boolean)this.acTPAHere.get()).booleanValue() || !this.currentCommand.startsWith("/tpahere ")) break;
                shouldConfirm = true;
                break;
            }
            case "ACCEPT REQUEST": {
                if (!((Boolean)this.acTPAReceive.get()).booleanValue() || this.currentCommand == null || System.currentTimeMillis() - this.commandTime >= 10000L || !this.currentCommand.startsWith("/tpaccept ")) break;
                shouldConfirm = true;
                break;
            }
            case "ACCEPT TPAHERE REQUEST": {
                if (!((Boolean)this.acTPAHereReceive.get()).booleanValue() || this.currentCommand == null || System.currentTimeMillis() - this.commandTime >= 10000L || !this.currentCommand.startsWith("/tpaccept ")) break;
                shouldConfirm = true;
                break;
            }
            case "CONFIRM": {
                if (!((Boolean)this.acCrateBuy.get()).booleanValue()) break;
                for (int i = 0; i < Math.min(this.lastScreens.size, 3); ++i) {
                    try {
                        String recentScreen = this.lastScreens.get(i);
                        if (recentScreen == null || !recentScreen.contains("CHOOSE 1 ITEM")) continue;
                        shouldConfirm = true;
                        break block14;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
            case "CONFIRM BOUNTY": {
                if (!((Boolean)this.acBounty.get()).booleanValue() || this.currentCommand == null || System.currentTimeMillis() - this.commandTime >= 10000L || !this.currentCommand.startsWith("/bounty add ")) break;
                shouldConfirm = true;
                break;
            }
            case "CONFIRM SELL": {
                try {
                    String prevScreen = this.lastScreens.get(0);
                    if (!((Boolean)this.acSpawnerSellAll.get()).booleanValue() || prevScreen == null || !prevScreen.contains("SPAWNER")) break;
                    shouldConfirm = true;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return shouldConfirm;
    }

    private void pressConfirmButton() {
        if (this.mc.field_1724 == null || this.mc.field_1761 == null) {
            return;
        }
        if (this.mc.field_1755 == null) {
            if (System.currentTimeMillis() - this.lastClickTime < 1000L) {
                this.acTimer = 0L;
                return;
            }
            this.acTimer = System.currentTimeMillis() + 10L;
            return;
        }
        if (!(this.mc.field_1755 instanceof class_465)) {
            return;
        }
        class_465 screen = (class_465)this.mc.field_1755;
        class_1703 handler = screen.method_17577();
        for (int i = 0; i < handler.field_7761.size(); ++i) {
            class_1799 stack = handler.method_7611(i).method_7677();
            if (!this.isConfirmButton(stack)) continue;
            this.mc.field_1761.method_2906(handler.field_7763, i, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.mc.field_1761.method_2906(handler.field_7763, i, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.lastClickTime = System.currentTimeMillis();
            this.acTimer = 0L;
            return;
        }
    }

    private boolean isConfirmButton(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        boolean isGreenGlass = stack.method_7909() == class_1802.field_8581 || stack.method_7909() == class_1802.field_8656;
        String name = StringUtils.convertUnicodeToAscii(stack.method_7964().getString()).toLowerCase();
        boolean hasConfirmText = name.contains("confirm") || name.contains("accept");
        return isGreenGlass && hasConfirmText;
    }

    private void advancePage(Direction dir) {
        if (this.mc.field_1724 == null || this.mc.field_1761 == null || this.mc.field_1755 == null) {
            return;
        }
        class_437 class_4372 = this.mc.field_1755;
        if (!(class_4372 instanceof class_465)) {
            return;
        }
        class_465 screen = (class_465)class_4372;
        class_1703 handler = screen.method_17577();
        for (int i = 0; i < handler.field_7761.size(); ++i) {
            String name = StringUtils.convertUnicodeToAscii(handler.method_7611(i).method_7677().method_7964().getString());
            if ((dir != Direction.FORWARDS || !name.equals("next")) && (dir != Direction.BACKWARDS || !name.equals("back"))) continue;
            this.mc.field_1761.method_2906(handler.field_7763, i, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.mc.field_1761.method_2906(handler.field_7763, i, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            return;
        }
    }

    @EventHandler
    private void onPacketSend(PacketEvent.Send event) {
        class_2813 packet;
        class_2596 class_25962;
        if (!this.isActive()) {
            return;
        }
        if (((Boolean)this.enableAutoAdvance.get()).booleanValue() && (class_25962 = event.packet) instanceof class_2813 && StringUtils.convertUnicodeToAscii((packet = (class_2813)class_25962).method_12190().method_7964().getString()).equals("drop loot")) {
            this.aaTimer = System.currentTimeMillis() + (long)((RandomBetweenInt)this.aaRandomDelay.get()).getRandom();
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.acTimer > 0L && System.currentTimeMillis() >= this.acTimer) {
            this.acTimer = 0L;
            if (this.currentScreen != null && this.shouldConfirm(this.currentScreen)) {
                this.pressConfirmButton();
            }
        }
        if (this.aaTimer > 0L && System.currentTimeMillis() >= this.aaTimer) {
            this.aaTimer = 0L;
            this.advancePage((Direction)((Object)this.aaDirection.get()));
        }
    }

    private static class CircularBuffer<T> {
        private final Object[] buffer;
        private int index = 0;
        public int size = 0;

        public CircularBuffer(int capacity) {
            this.buffer = new Object[capacity];
        }

        public void add(T item) {
            this.buffer[this.index] = item;
            this.index = (this.index + 1) % this.buffer.length;
            if (this.size < this.buffer.length) {
                ++this.size;
            }
        }

        public T get(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            int idx = (this.index - this.size + i + this.buffer.length) % this.buffer.length;
            return (T)this.buffer[idx];
        }
    }

    private static enum Direction {
        FORWARDS,
        BACKWARDS;

    }
}

