/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.pvp;

import com.nnpg.glazed.GlazedAddon;
import java.util.Random;
import java.util.Set;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EntityTypeListSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.entity.EntityUtils;
import meteordevelopment.meteorclient.utils.entity.SortPriority;
import meteordevelopment.meteorclient.utils.entity.Target;
import meteordevelopment.meteorclient.utils.entity.TargetUtils;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class AimAssist
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgSpeed;
    private final SettingGroup sgBypass;
    private final Setting<Set<class_1299<?>>> entities;
    private final Setting<Double> range;
    private final Setting<Double> fov;
    private final Setting<Boolean> ignoreWalls;
    private final Setting<SortPriority> priority;
    private final Setting<Target> bodyTarget;
    private final Setting<Boolean> instant;
    private final Setting<Double> speed;
    private final Setting<Boolean> randomizeRotation;
    private final Setting<Double> randomNoise;
    private final Setting<Double> maxRotationDelta;
    private final Random random;
    private class_1297 target;

    public AimAssist() {
        super(GlazedAddon.pvp, "aim-assist", "Automatically aims at entities, with Grim AC v3 bypass.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgSpeed = this.settings.createGroup("Aim Speed");
        this.sgBypass = this.settings.createGroup("Grim Bypass");
        this.entities = this.sgGeneral.add((Setting)((EntityTypeListSetting.Builder)((EntityTypeListSetting.Builder)((EntityTypeListSetting.Builder)new EntityTypeListSetting.Builder().name("entities")).description("Entities to aim at.")).defaultValue(Set.of(class_1299.field_6097))).build());
        this.range = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("range")).description("The range at which an entity can be targeted.")).defaultValue(5.0).min(0.0).sliderRange(0.0, 10.0).build());
        this.fov = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("fov")).description("Will only aim entities in the FOV.")).defaultValue(360.0).min(0.0).max(360.0).sliderRange(0.0, 360.0).build());
        this.ignoreWalls = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-walls")).description("Whether or not to ignore aiming through walls.")).defaultValue((Object)false)).build());
        this.priority = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("priority")).description("How to filter targets within range.")).defaultValue((Object)SortPriority.LowestHealth)).build());
        this.bodyTarget = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("aim-target")).description("Which part of the entities body to aim at.")).defaultValue((Object)Target.Body)).build());
        this.instant = this.sgSpeed.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("instant-look")).description("Instantly looks at the entity.")).defaultValue((Object)false)).build());
        this.speed = this.sgSpeed.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("speed")).description("How fast to aim at the entity.")).defaultValue(5.0).min(0.0).sliderRange(0.0, 20.0).visible(() -> (Boolean)this.instant.get() == false)).build());
        this.randomizeRotation = this.sgBypass.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("randomize-rotation")).description("Add random noise to rotations to bypass Grim AC v3.")).defaultValue((Object)true)).build());
        this.randomNoise = this.sgBypass.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("random-noise")).description("Amount of random noise to add to rotations.")).defaultValue(0.5).min(0.0).max(3.0).sliderRange(0.0, 3.0).visible(() -> this.randomizeRotation.get())).build());
        this.maxRotationDelta = this.sgBypass.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("max-rotation-delta")).description("Maximum rotation change per tick to bypass Grim AC v3.")).defaultValue(2.5).min(0.5).max(10.0).sliderRange(0.5, 10.0).build());
        this.random = new Random();
    }

    public void onActivate() {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            ChatUtils.error((String)"Cannot activate AimAssist: Player or world is null!", (Object[])new Object[0]);
            this.toggle();
            return;
        }
        this.target = null;
        ChatUtils.info((String)("AimAssist activated. Targeting range: " + String.valueOf(this.range.get()) + " blocks."), (Object[])new Object[0]);
    }

    public void onDeactivate() {
        this.target = null;
        ChatUtils.info((String)"AimAssist deactivated.", (Object[])new Object[0]);
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        this.target = TargetUtils.get(entity -> {
            if (!entity.method_5805()) {
                return false;
            }
            if (!PlayerUtils.isWithin((class_1297)entity, (double)((Double)this.range.get()))) {
                return false;
            }
            if (!((Boolean)this.ignoreWalls.get()).booleanValue() && !PlayerUtils.canSeeEntity((class_1297)entity)) {
                return false;
            }
            if (entity == this.mc.field_1724 || !((Set)this.entities.get()).contains(entity.method_5864())) {
                return false;
            }
            if (entity instanceof class_1657 && !Friends.get().shouldAttack((class_1657)entity)) {
                return false;
            }
            return this.isInFov((class_1297)entity, (Double)this.fov.get());
        }, (SortPriority)((SortPriority)this.priority.get()));
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.target != null) {
            this.aim(this.target, event.tickDelta, (Boolean)this.instant.get());
        }
    }

    private void aim(class_1297 target, float delta, boolean instant) {
        class_243 pos = target.method_30950(delta);
        class_243 targetPos = new class_243(pos.field_1352, pos.field_1351, pos.field_1350);
        switch ((Target)this.bodyTarget.get()) {
            case Head: {
                targetPos = targetPos.method_1031(0.0, (double)target.method_18381(target.method_18376()), 0.0);
                break;
            }
            case Body: {
                targetPos = targetPos.method_1031(0.0, (double)(target.method_18381(target.method_18376()) / 2.0f), 0.0);
            }
        }
        double deltaX = targetPos.field_1352 - this.mc.field_1724.method_23317();
        double deltaZ = targetPos.field_1350 - this.mc.field_1724.method_23321();
        double deltaY = targetPos.field_1351 - (this.mc.field_1724.method_23318() + (double)this.mc.field_1724.method_18381(this.mc.field_1724.method_18376()));
        double angle = Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0;
        if (((Boolean)this.randomizeRotation.get()).booleanValue()) {
            angle += (double)(this.random.nextFloat() - 0.5f) * (Double)this.randomNoise.get() * 2.0;
        }
        if (instant) {
            this.mc.field_1724.method_36456((float)angle);
        } else {
            double deltaAngle = class_3532.method_15338((double)(angle - (double)this.mc.field_1724.method_36454()));
            double toRotate = Math.min(Math.abs(deltaAngle), (Double)this.speed.get() * (double)delta);
            if (Math.abs(toRotate = Math.copySign(toRotate, deltaAngle)) > (Double)this.maxRotationDelta.get()) {
                toRotate = Math.copySign((Double)this.maxRotationDelta.get(), toRotate);
            }
            this.mc.field_1724.method_36456(this.mc.field_1724.method_36454() + (float)toRotate);
        }
        double idk = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        angle = -Math.toDegrees(Math.atan2(deltaY, idk));
        if (((Boolean)this.randomizeRotation.get()).booleanValue()) {
            angle += (double)(this.random.nextFloat() - 0.5f) * (Double)this.randomNoise.get() * 2.0;
        }
        if (instant) {
            this.mc.field_1724.method_36457((float)angle);
        } else {
            double deltaAngle = class_3532.method_15338((double)(angle - (double)this.mc.field_1724.method_36455()));
            double toRotate = Math.min(Math.abs(deltaAngle), (Double)this.speed.get() * (double)delta);
            if (Math.abs(toRotate = Math.copySign(toRotate, deltaAngle)) > (Double)this.maxRotationDelta.get()) {
                toRotate = Math.copySign((Double)this.maxRotationDelta.get(), toRotate);
            }
            this.mc.field_1724.method_36457(this.mc.field_1724.method_36455() + (float)toRotate);
        }
    }

    private boolean isInFov(class_1297 entity, double fov) {
        double pitchDiff;
        if (fov >= 360.0) {
            return true;
        }
        class_243 entityPos = entity.method_19538();
        class_243 playerPos = this.mc.field_1724.method_33571();
        class_243 direction = entityPos.method_1020(playerPos).method_1029();
        double yaw = Math.toDegrees(Math.atan2(direction.field_1350, direction.field_1352)) - 90.0;
        double pitch = -Math.toDegrees(Math.asin(direction.field_1351));
        double yawDiff = class_3532.method_15338((double)(yaw - (double)this.mc.field_1724.method_36454()));
        return Math.sqrt(yawDiff * yawDiff + (pitchDiff = class_3532.method_15338((double)(pitch - (double)this.mc.field_1724.method_36455()))) * pitchDiff) <= fov / 2.0;
    }

    public String getInfoString() {
        return EntityUtils.getName((class_1297)this.target);
    }
}

