/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.pvp;

import com.nnpg.glazed.GlazedAddon;
import com.nnpg.glazed.VersionUtil;
import com.nnpg.glazed.utils.glazed.BlockUtil;
import com.nnpg.glazed.utils.glazed.KeyUtils;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_2246;
import net.minecraft.class_239;
import net.minecraft.class_3965;
import net.minecraft.class_9334;
import org.lwjgl.glfw.GLFW;

public class AnchorMacro
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Double> switchDelay;
    private final Setting<Double> glowstoneDelay;
    private final Setting<Double> explodeDelay;
    private final Setting<Integer> totemSlot;
    private int keybindCounter;
    private int glowstoneDelayCounter;
    private int explodeDelayCounter;
    private boolean hasPlacedGlowstone;
    private boolean hasExplodedAnchor;
    private class_3965 lastBlockHitResult;

    public AnchorMacro() {
        super(GlazedAddon.pvp, "AnchorMacro", "Automatically charges and explodes respawn anchors.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.switchDelay = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("switch-delay")).description("Delay in ticks before switching items.")).defaultValue(0.0).min(0.0).max(20.0).sliderMax(20.0).build());
        this.glowstoneDelay = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("glowstone-delay")).description("Delay in ticks before placing glowstone.")).defaultValue(0.0).min(0.0).max(20.0).sliderMax(20.0).build());
        this.explodeDelay = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("explode-delay")).description("Delay in ticks before exploding the anchor.")).defaultValue(0.0).min(0.0).max(20.0).sliderMax(20.0).build());
        this.totemSlot = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("totem-slot")).description("Hotbar slot to switch to when exploding (1-9).")).defaultValue((Object)1)).min(1).max(9).build());
        this.hasPlacedGlowstone = false;
        this.hasExplodedAnchor = false;
        this.lastBlockHitResult = null;
    }

    public void onActivate() {
        this.resetCounters();
        this.hasPlacedGlowstone = false;
        this.hasExplodedAnchor = false;
        this.lastBlockHitResult = null;
    }

    public void onDeactivate() {
        this.resetCounters();
        this.hasPlacedGlowstone = false;
        this.hasExplodedAnchor = false;
        this.lastBlockHitResult = null;
    }

    private void resetCounters() {
        this.keybindCounter = 0;
        this.glowstoneDelayCounter = 0;
        this.explodeDelayCounter = 0;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1755 != null) {
            return;
        }
        if (this.isShieldOrFoodActive()) {
            return;
        }
        if (KeyUtils.isKeyPressed(1)) {
            this.handleAnchorInteraction();
        } else {
            this.hasPlacedGlowstone = false;
            this.hasExplodedAnchor = false;
            this.lastBlockHitResult = null;
        }
    }

    private boolean isShieldOrFoodActive() {
        boolean isFood = this.mc.field_1724.method_6047().method_7909().method_57347().method_57832(class_9334.field_50075) || this.mc.field_1724.method_6079().method_7909().method_57347().method_57832(class_9334.field_50075);
        boolean isShield = this.mc.field_1724.method_6047().method_7909() instanceof class_1819 || this.mc.field_1724.method_6079().method_7909() instanceof class_1819;
        boolean isRightClickPressed = GLFW.glfwGetMouseButton((long)this.mc.method_22683().method_4490(), (int)1) == 1;
        return (isFood || isShield) && isRightClickPressed;
    }

    private void handleAnchorInteraction() {
        class_239 class_2392 = this.mc.field_1765;
        if (!(class_2392 instanceof class_3965)) {
            return;
        }
        class_3965 blockHitResult = (class_3965)class_2392;
        this.lastBlockHitResult = blockHitResult;
        if (!BlockUtil.isBlockAtPosition(blockHitResult.method_17777(), class_2246.field_23152)) {
            return;
        }
        this.mc.field_1690.field_1904.method_23481(false);
        if (BlockUtil.isRespawnAnchorUncharged(blockHitResult.method_17777()) && !this.hasPlacedGlowstone) {
            this.placeGlowstone(blockHitResult);
        } else if (BlockUtil.isRespawnAnchorCharged(blockHitResult.method_17777()) && !this.hasExplodedAnchor) {
            this.explodeAnchor(blockHitResult);
        }
    }

    private void placeGlowstone(class_3965 blockHitResult) {
        if (!this.mc.field_1724.method_6047().method_31574(class_1802.field_8801)) {
            if (this.keybindCounter < ((Double)this.switchDelay.get()).intValue()) {
                ++this.keybindCounter;
                return;
            }
            this.keybindCounter = 0;
            this.swapToItem(class_1802.field_8801);
            return;
        }
        if (this.mc.field_1724.method_6047().method_31574(class_1802.field_8801)) {
            if (this.glowstoneDelayCounter < ((Double)this.glowstoneDelay.get()).intValue()) {
                ++this.glowstoneDelayCounter;
                return;
            }
            this.glowstoneDelayCounter = 0;
            BlockUtil.interactWithBlock(blockHitResult, true);
            this.hasPlacedGlowstone = true;
        }
    }

    private void explodeAnchor(class_3965 blockHitResult) {
        int selectedSlot = (Integer)this.totemSlot.get() - 1;
        if (VersionUtil.getSelectedSlot(this.mc.field_1724) != selectedSlot) {
            if (this.keybindCounter < ((Double)this.switchDelay.get()).intValue()) {
                ++this.keybindCounter;
                return;
            }
            this.keybindCounter = 0;
            VersionUtil.setSelectedSlot(this.mc.field_1724, selectedSlot);
            return;
        }
        if (VersionUtil.getSelectedSlot(this.mc.field_1724) == selectedSlot) {
            if (this.explodeDelayCounter < ((Double)this.explodeDelay.get()).intValue()) {
                ++this.explodeDelayCounter;
                return;
            }
            this.explodeDelayCounter = 0;
            BlockUtil.interactWithBlock(blockHitResult, true);
            this.hasExplodedAnchor = true;
        }
    }

    private void swapToItem(class_1792 item) {
        FindItemResult result = InvUtils.findInHotbar((class_1792[])new class_1792[]{item});
        if (result.found()) {
            this.mc.field_1724.method_31548().method_61496(result.slot());
        }
    }
}

