/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.pvp;

import com.nnpg.glazed.GlazedAddon;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2663;
import net.minecraft.class_437;
import net.minecraft.class_490;

public class AutoInvTotem
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Integer> delay;
    private final Setting<Boolean> moveFromHotbar;
    private final Setting<Boolean> disableLogs;
    private final Setting<Boolean> openInv;
    private final Setting<Integer> invOpenDelay;
    private final Setting<Integer> invCloseDelay;
    private boolean needsTotem;
    private int delayTicks;
    private boolean hadTotemInOffhand;
    private boolean shouldOpenInv;
    private int invOpenTicks;
    private int invCloseTicks;
    private boolean invAutoOpened;

    public AutoInvTotem() {
        super(GlazedAddon.pvp, "Auto Inv Totem", "Automatically moves totems to offhand when inventory is opened after totem pop.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("Delay in ticks before moving totem (1-20 ticks)")).defaultValue((Object)3)).min(1).max(20).sliderMin(1).sliderMax(20).build());
        this.moveFromHotbar = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("move-from-hotbar")).description("Also move totems from hotbar slots")).defaultValue((Object)true)).build());
        this.disableLogs = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disable-logs")).description("Disable chat messages about totem movements")).defaultValue((Object)true)).build());
        this.openInv = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("open-inv")).description("Automatically open inventory when totem pops")).defaultValue((Object)false)).build());
        this.invOpenDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("inv-open-delay")).description("Ticks to wait before opening inventory after totem pop (1-10 ticks)")).defaultValue((Object)2)).min(1).max(10).sliderMin(1).sliderMax(10).visible(() -> (Boolean)this.openInv.get())).build());
        this.invCloseDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("inv-close-delay")).description("Ticks to wait before closing inventory after opening (5-20 ticks)")).defaultValue((Object)8)).min(5).max(20).sliderMin(5).sliderMax(20).visible(() -> (Boolean)this.openInv.get())).build());
        this.needsTotem = false;
        this.delayTicks = 0;
        this.hadTotemInOffhand = false;
        this.shouldOpenInv = false;
        this.invOpenTicks = 0;
        this.invCloseTicks = 0;
        this.invAutoOpened = false;
    }

    public void onActivate() {
        this.resetState();
    }

    public void onDeactivate() {
        this.resetInvAutoState();
    }

    private void resetState() {
        if (this.mc.field_1724 != null) {
            this.hadTotemInOffhand = this.hasTotemInOffhand();
            this.needsTotem = false;
            this.delayTicks = 0;
            this.resetInvAutoState();
        }
    }

    private void resetInvAutoState() {
        this.shouldOpenInv = false;
        this.invOpenTicks = 0;
        this.invCloseTicks = 0;
        this.invAutoOpened = false;
    }

    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        this.resetState();
        if (!((Boolean)this.disableLogs.get()).booleanValue()) {
            this.info("Auto Inv Totem state reset for new world/reconnection", new Object[0]);
        }
    }

    @EventHandler
    private void onPacketReceive(PacketEvent.Receive event) {
        class_2663 packet;
        class_2596 class_25962 = event.packet;
        if (class_25962 instanceof class_2663 && (packet = (class_2663)class_25962).method_11470() == 35 && this.mc.field_1724 != null && packet.method_11469((class_1937)this.mc.field_1687) == this.mc.field_1724 && ((Boolean)this.openInv.get()).booleanValue() && this.mc.field_1755 == null) {
            this.shouldOpenInv = true;
            this.invOpenTicks = (Integer)this.invOpenDelay.get();
            if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                this.info("Player totem pop detected! Will auto-open inventory in %d ticks.", new Object[]{this.invOpenTicks});
            }
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null) {
            return;
        }
        this.handleAutoInventory();
        boolean currentlyHasTotem = this.hasTotemInOffhand();
        if (this.hadTotemInOffhand && !currentlyHasTotem) {
            this.needsTotem = true;
            if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                this.info("Totem popped! Open inventory to auto-equip a new one.", new Object[0]);
            }
            if (this.mc.field_1755 instanceof class_490) {
                if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                    this.info("Inventory already open - moving totem immediately!", new Object[0]);
                }
                this.delayTicks = (Integer)this.delay.get();
            }
        }
        this.hadTotemInOffhand = currentlyHasTotem;
        if (currentlyHasTotem && this.needsTotem) {
            this.needsTotem = false;
            this.delayTicks = 0;
        }
    }

    private void handleAutoInventory() {
        if (this.shouldOpenInv && this.invOpenTicks > 0) {
            --this.invOpenTicks;
            if (this.invOpenTicks == 0 && this.mc.field_1755 == null) {
                this.mc.method_1507((class_437)new class_490((class_1657)this.mc.field_1724));
                this.invAutoOpened = true;
                this.invCloseTicks = (Integer)this.invCloseDelay.get();
                this.shouldOpenInv = false;
                if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                    this.info("Auto-opened inventory, will close in %d ticks.", new Object[]{this.invCloseTicks});
                }
            }
        }
        if (this.invAutoOpened && this.invCloseTicks > 0) {
            --this.invCloseTicks;
            if (this.invCloseTicks == 0 && this.mc.field_1755 instanceof class_490) {
                this.mc.method_1507(null);
                this.invAutoOpened = false;
                if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                    this.info("Auto-closed inventory.", new Object[0]);
                }
            }
        }
        if (this.invAutoOpened && !(this.mc.field_1755 instanceof class_490)) {
            this.invAutoOpened = false;
            this.invCloseTicks = 0;
        }
    }

    @EventHandler
    private void onOpenScreen(OpenScreenEvent event) {
        if (!(event.screen instanceof class_490) || !this.needsTotem || this.mc.field_1724 == null) {
            return;
        }
        this.delayTicks = (Integer)this.delay.get();
    }

    @EventHandler
    private void onTickDelayed(TickEvent.Post event) {
        if (this.delayTicks <= 0 || this.mc.field_1724 == null) {
            return;
        }
        --this.delayTicks;
        if (this.delayTicks == 0) {
            this.moveTotemToOffhand();
        }
    }

    private void moveTotemToOffhand() {
        block10: {
            int totemSlot = this.findTotemSlot();
            if (totemSlot == -1) {
                if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                    this.info("No totem found in inventory!", new Object[0]);
                }
                return;
            }
            try {
                class_1799 offhandStack;
                int containerSlot = totemSlot;
                if (totemSlot < 9) {
                    containerSlot = totemSlot + 36;
                }
                if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                    this.info("Found totem in slot %d (container slot %d)", new Object[]{totemSlot, containerSlot});
                }
                if ((offhandStack = this.mc.field_1724.method_6079()).method_7960()) {
                    this.mc.field_1761.method_2906(0, containerSlot, 40, class_1713.field_7791, (class_1657)this.mc.field_1724);
                    if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                        this.info("Swapped totem to empty offhand", new Object[0]);
                    }
                } else {
                    this.mc.field_1761.method_2906(0, containerSlot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    this.mc.field_1761.method_2906(0, 45, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    this.mc.field_1761.method_2906(0, containerSlot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
                    if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                        this.info("3-click swapped totem to offhand", new Object[0]);
                    }
                }
                this.needsTotem = false;
            }
            catch (Exception e) {
                if (((Boolean)this.disableLogs.get()).booleanValue()) break block10;
                this.error("Failed to move totem: " + e.getMessage(), new Object[0]);
            }
        }
    }

    private int findTotemSlot() {
        int i;
        for (i = 9; i < 36; ++i) {
            if (this.mc.field_1724.method_31548().method_5438(i).method_7909() != class_1802.field_8288) continue;
            return i;
        }
        if (((Boolean)this.moveFromHotbar.get()).booleanValue()) {
            for (i = 0; i < 9; ++i) {
                if (this.mc.field_1724.method_31548().method_5438(i).method_7909() != class_1802.field_8288) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean hasTotemInOffhand() {
        if (this.mc.field_1724 == null) {
            return false;
        }
        class_1799 offhandStack = this.mc.field_1724.method_6079();
        return !offhandStack.method_7960() && offhandStack.method_7909() == class_1802.field_8288;
    }
}

