/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.pvp;

import com.nnpg.glazed.GlazedAddon;
import com.nnpg.glazed.utils.InventoryUtils;
import meteordevelopment.meteorclient.events.entity.player.AttackEntityEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1799;
import net.minecraft.class_9304;

public class BreachSwap
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> autoSwap;
    private final Setting<Integer> targetSlot;
    private final Setting<Boolean> debugMode;
    private final Setting<Boolean> checkWeapon;
    private final Setting<Boolean> allowSword;
    private final Setting<Boolean> allowAxe;
    private final Setting<Boolean> swapBack;
    private final Setting<Integer> delay;
    private int prevSlot;
    private int dDelay;

    public BreachSwap() {
        super(GlazedAddon.pvp, "breach-swap", "Swaps with the breach mace in a target slot on attack");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.autoSwap = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-swap-breach-mace")).description("Automatically finds and swaps to a breach mace.")).defaultValue((Object)true)).build());
        this.targetSlot = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-slot")).description("The hotbar slot to swap to when attacking.")).sliderRange(1, 9).defaultValue((Object)1)).min(1).visible(() -> (Boolean)this.autoSwap.get() == false)).build());
        this.debugMode = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("debug")).description("Print debug messages in chat.")).defaultValue((Object)false)).build());
        this.checkWeapon = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("check-weapon")).description("Only activate when holding a sword or axe.")).defaultValue((Object)true)).build());
        this.allowSword = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("allow-sword")).description("Allow activation when holding a sword.")).defaultValue((Object)true)).visible(() -> this.checkWeapon.get())).build());
        this.allowAxe = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("allow-axe")).description("Allow activation when holding an axe.")).defaultValue((Object)true)).visible(() -> this.checkWeapon.get())).build());
        this.swapBack = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swap-back")).description("Swap back to the original slot after a short delay.")).defaultValue((Object)true)).build());
        this.delay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("swap-back-delay")).description("Delay in ticks before swapping back to the previous slot.")).sliderRange(1, 20).defaultValue((Object)8)).min(1).visible(() -> this.swapBack.get())).build());
        this.prevSlot = -1;
        this.dDelay = 0;
    }

    private int findBreachMace() {
        int bestSlot = -1;
        int highestLevel = 0;
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (stack.method_7960()) continue;
            class_9304 enchantInfo = stack.method_58657();
            String enchantString = enchantInfo.toString();
            if (((Boolean)this.debugMode.get()).booleanValue()) {
                this.info("Slot " + i + " enchants: " + enchantString, new Object[0]);
            }
            if (!enchantString.contains("minecraft:breach")) continue;
            try {
                int levelStart = enchantString.lastIndexOf("=>");
                if (levelStart == -1) continue;
                String levelStr = enchantString.substring(levelStart + 2).replaceAll("[^0-9]", "");
                int level = Integer.parseInt(levelStr);
                if (((Boolean)this.debugMode.get()).booleanValue()) {
                    this.info("Found breach level " + level + " in slot " + i, new Object[0]);
                }
                if (level <= highestLevel) continue;
                highestLevel = level;
                bestSlot = i;
                continue;
            }
            catch (Exception e) {
                if (!((Boolean)this.debugMode.get()).booleanValue()) continue;
                this.error("Error parsing level: " + e.getMessage(), new Object[0]);
            }
        }
        if (bestSlot != -1) {
            if (((Boolean)this.debugMode.get()).booleanValue()) {
                this.info("Selected slot " + bestSlot + " with level " + highestLevel, new Object[0]);
            }
        } else if (((Boolean)this.debugMode.get()).booleanValue()) {
            this.warning("No breach mace found", new Object[0]);
        }
        return bestSlot;
    }

    @EventHandler
    private void onAttack(AttackEntityEvent event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        if (((Boolean)this.checkWeapon.get()).booleanValue()) {
            String heldItemId = this.mc.field_1724.method_6047().method_7909().toString();
            boolean isSword = heldItemId.contains("sword");
            boolean isAxe = heldItemId.contains("_axe");
            if (!(((Boolean)this.allowSword.get()).booleanValue() && isSword || ((Boolean)this.allowAxe.get()).booleanValue() && isAxe)) {
                if (((Boolean)this.debugMode.get()).booleanValue()) {
                    this.info("Not holding selected weapon type", new Object[0]);
                }
                return;
            }
        }
        if (((Boolean)this.swapBack.get()).booleanValue()) {
            this.prevSlot = InventoryUtils.getSelectedSlot(this.mc.field_1724.method_31548());
        }
        if (((Boolean)this.autoSwap.get()).booleanValue()) {
            int breachMaceSlot = this.findBreachMace();
            if (breachMaceSlot != -1) {
                InvUtils.swap((int)breachMaceSlot, (boolean)false);
            }
        } else {
            InvUtils.swap((int)((Integer)this.targetSlot.get() - 1), (boolean)false);
        }
        if (((Boolean)this.swapBack.get()).booleanValue() && this.prevSlot != -1) {
            this.dDelay = (Integer)this.delay.get();
        }
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.dDelay > 0) {
            --this.dDelay;
            if (this.dDelay == 0 && this.prevSlot != -1) {
                InvUtils.swap((int)this.prevSlot, (boolean)false);
                this.prevSlot = -1;
            }
        }
    }
}

