/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.pvp;

import com.nnpg.glazed.GlazedAddon;
import com.nnpg.glazed.utils.glazed.BlockUtil;
import com.nnpg.glazed.utils.glazed.KeyUtils;
import java.util.HashSet;
import java.util.Set;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2868;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class CrystalMacro
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Integer> activateKey;
    private final Setting<Double> placeDelay;
    private final Setting<Double> breakDelay;
    private final Setting<Boolean> stopOnKill;
    private final Setting<Boolean> placeObsidianIfMissing;
    private int placeDelayCounter;
    private int breakDelayCounter;
    private final Set<class_1657> deadPlayers;
    private boolean paused;
    private long resumeTime;

    public CrystalMacro() {
        super(GlazedAddon.pvp, "CrystalMacro", "Automatically crystals fast for you");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.activateKey = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("activate-key")).description("Key that does the crystalling.")).defaultValue((Object)1)).min(-1).max(400).build());
        this.placeDelay = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("place-delay")).description("The delay in ticks between placing crystals.")).defaultValue(0.0).min(0.0).max(20.0).sliderMax(20.0).build());
        this.breakDelay = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("break-delay")).description("The delay in ticks between breaking crystals.")).defaultValue(0.0).min(0.0).max(20.0).sliderMax(20.0).build());
        this.stopOnKill = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("stop-on-kill")).description("Pauses the macro when a nearby player dies, then resumes after 5 seconds.")).defaultValue((Object)true)).build());
        this.placeObsidianIfMissing = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("place-obsidian-if-missing")).description("Places obsidian if the target block isn't obsidian or bedrock.")).defaultValue((Object)true)).build());
        this.deadPlayers = new HashSet<class_1657>();
        this.paused = false;
        this.resumeTime = 0L;
    }

    public void onActivate() {
        this.resetCounters();
        this.deadPlayers.clear();
        this.paused = false;
        this.resumeTime = 0L;
    }

    public void onDeactivate() {
        this.resetCounters();
        this.deadPlayers.clear();
        this.paused = false;
        this.resumeTime = 0L;
    }

    private void resetCounters() {
        this.placeDelayCounter = 0;
        this.breakDelayCounter = 0;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1755 != null) {
            return;
        }
        this.updateCounters();
        if (this.paused && System.currentTimeMillis() >= this.resumeTime) {
            this.paused = false;
            if (this.mc.field_1724 != null) {
                this.mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77[\u00a7bLegitCrystalMacro\u00a77] \u00a7aResumed after stop-on-kill"), false);
            }
        }
        if (this.paused) {
            return;
        }
        if (!this.isKeyActive()) {
            return;
        }
        if (this.mc.field_1724.method_6115()) {
            return;
        }
        if (this.mc.field_1724.method_6047().method_7909() != class_1802.field_8301) {
            return;
        }
        if (((Boolean)this.stopOnKill.get()).booleanValue() && this.checkForDeadPlayers()) {
            this.paused = true;
            this.resumeTime = System.currentTimeMillis() + 5000L;
            if (this.mc.field_1724 != null) {
                this.mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77[\u00a7bLegitCrystalMacro\u00a77] \u00a7cPaused due to player death (will resume in 5s)"), false);
            }
            return;
        }
        this.handleInteraction();
    }

    private void updateCounters() {
        if (this.placeDelayCounter > 0) {
            --this.placeDelayCounter;
        }
        if (this.breakDelayCounter > 0) {
            --this.breakDelayCounter;
        }
    }

    private boolean isKeyActive() {
        int d = (Integer)this.activateKey.get();
        return d == -1 || KeyUtils.isKeyPressed(d);
    }

    private void handleInteraction() {
        class_239 crosshairTarget = this.mc.field_1765;
        if (crosshairTarget instanceof class_3965) {
            class_3965 blockHit = (class_3965)crosshairTarget;
            this.handleBlockInteraction(blockHit);
        } else if (crosshairTarget instanceof class_3966) {
            class_3966 entityHit = (class_3966)crosshairTarget;
            this.handleEntityInteraction(entityHit);
        }
    }

    private void handleBlockInteraction(class_3965 blockHitResult) {
        boolean isObsidianOrBedrock;
        if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        if (this.placeDelayCounter > 0) {
            return;
        }
        class_2338 blockPos = blockHitResult.method_17777();
        boolean bl = isObsidianOrBedrock = BlockUtil.isBlockAtPosition(blockPos, class_2246.field_10540) || BlockUtil.isBlockAtPosition(blockPos, class_2246.field_9987);
        if (!isObsidianOrBedrock && ((Boolean)this.placeObsidianIfMissing.get()).booleanValue()) {
            int obsidianSlot = this.findObsidianSlot();
            int crystalSlot = this.findCrystalSlot();
            if (obsidianSlot == -1 || crystalSlot == -1) {
                return;
            }
            this.mc.field_1724.field_3944.method_52787((class_2596)new class_2868(obsidianSlot));
            BlockUtil.interactWithBlock(blockHitResult, true);
            this.mc.field_1724.method_6104(class_1268.field_5808);
            this.placeDelayCounter = ((Double)this.placeDelay.get()).intValue();
            this.mc.field_1724.field_3944.method_52787((class_2596)new class_2868(crystalSlot));
            return;
        }
        if (isObsidianOrBedrock && this.isValidCrystalPlacement(blockPos)) {
            BlockUtil.interactWithBlock(blockHitResult, true);
            this.placeDelayCounter = ((Double)this.placeDelay.get()).intValue();
        }
    }

    private void handleEntityInteraction(class_3966 entityHitResult) {
        if (this.breakDelayCounter > 0) {
            return;
        }
        class_1297 entity = entityHitResult.method_17782();
        if (!(entity instanceof class_1511) && !(entity instanceof class_1621)) {
            return;
        }
        this.mc.field_1761.method_2918((class_1657)this.mc.field_1724, entity);
        this.mc.field_1724.method_6104(class_1268.field_5808);
        this.breakDelayCounter = ((Double)this.breakDelay.get()).intValue();
    }

    private boolean isValidCrystalPlacement(class_2338 blockPos) {
        class_2338 up = blockPos.method_10084();
        if (!this.mc.field_1687.method_22347(up)) {
            return false;
        }
        int x = up.method_10263();
        int y = up.method_10264();
        int z = up.method_10260();
        return this.mc.field_1687.method_8335(null, new class_238((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 2.0, (double)z + 1.0)).isEmpty();
    }

    private boolean checkForDeadPlayers() {
        if (this.mc.field_1687 == null) {
            return false;
        }
        for (class_1657 player : this.mc.field_1687.method_18456()) {
            if (player == this.mc.field_1724) continue;
            String name = player.method_7334().getName();
            boolean isBedrock = name.startsWith(".");
            if (!player.method_29504() && !(player.method_6032() <= 0.0f) || this.deadPlayers.contains(player)) continue;
            this.deadPlayers.add(player);
            return true;
        }
        this.deadPlayers.removeIf(p -> !p.method_29504() && p.method_6032() > 0.0f);
        return false;
    }

    private int findObsidianSlot() {
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (!stack.method_31574(class_1802.field_8281)) continue;
            return i;
        }
        return -1;
    }

    private int findCrystalSlot() {
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = this.mc.field_1724.method_31548().method_5438(i);
            if (!stack.method_31574(class_1802.field_8301)) continue;
            return i;
        }
        return -1;
    }
}

