/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.modules.pvp;

import com.nnpg.glazed.GlazedAddon;
import com.nnpg.glazed.utils.InventoryUtils;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_239;
import net.minecraft.class_3966;

public class ShieldBreaker
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> autoBreak;
    private final Setting<Boolean> returnToPrevSlot;
    private final Setting<Integer> weaponSlot;
    private final Setting<Integer> attackDelay;
    private final Setting<Integer> killDelay;
    private final Setting<Integer> axeSwitchDelay;
    private final Setting<Integer> manualShieldBreakDelay;
    private final Setting<Integer> cycleCooldown;
    private final Setting<Integer> weaponSwitchDelay;
    private final Setting<Boolean> onlyPlayers;
    private final Setting<Double> range;
    private final Setting<Boolean> chatInfo;
    private final Setting<Boolean> killSwitch;
    private class_1657 targetPlayer;
    private int originalSlot;
    private int tickCounter;
    private ShieldBreakerState state;
    private boolean shieldBroken;
    private long lastBreakAttempt;
    private int cooldownTicks;

    public ShieldBreaker() {
        super(GlazedAddon.pvp, "shield-breaker", "Automatically breaks player shields with axe then switches back to weapon for kill.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.autoBreak = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-break")).description("Automatically break shields without requiring clicks")).defaultValue((Object)true)).build());
        this.returnToPrevSlot = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("return-to-prev-slot")).description("Return to the previous slot after breaking shield instead of a specific weapon slot")).defaultValue((Object)true)).build());
        this.weaponSlot = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("weapon-slot")).description("The hotbar slot to switch back to after breaking shield (1-9)")).defaultValue((Object)1)).range(0, 9).sliderRange(1, 9).visible(() -> (Boolean)this.returnToPrevSlot.get() == false)).build());
        this.attackDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("attack-delay")).description("Delay in ticks between shield break and weapon switch")).defaultValue((Object)0)).range(0, 40).sliderRange(1, 20).build());
        this.killDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("kill-delay")).description("Delay in ticks between weapon switch and kill attack")).defaultValue((Object)1)).range(0, 40).sliderRange(1, 20).build());
        this.axeSwitchDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("axe-switch-delay")).description("Delay in ticks to ensure axe switch is completed")).defaultValue((Object)0)).range(0, 20).sliderRange(1, 10).build());
        this.manualShieldBreakDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("manual-shield-break-delay")).description("Delay in ticks before switching back in manual mode")).defaultValue((Object)1)).range(0, 20).sliderRange(1, 10).build());
        this.cycleCooldown = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("cycle-cooldown")).description("Delay in ticks before starting the next shield break cycle.")).defaultValue((Object)4)).range(0, 20).sliderRange(0, 10).build());
        this.weaponSwitchDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("weapon-switch-delay")).description("Delay in ticks to ensure weapon switch is completed")).defaultValue((Object)0)).range(0, 20).sliderRange(1, 10).build());
        this.onlyPlayers = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-players")).description("Only break shields of players, not other entities")).defaultValue((Object)true)).build());
        this.range = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("range")).description("Maximum range to detect shield usage")).defaultValue(6.0).range(0.0, 10.0).sliderRange(1.0, 6.0).build());
        this.chatInfo = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("chat-info")).description("Send info messages to chat")).defaultValue((Object)true)).build());
        this.killSwitch = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("kill-switch")).description("Enable auto attack after breaking shield")).defaultValue((Object)true)).build());
        this.targetPlayer = null;
        this.originalSlot = -1;
        this.tickCounter = 0;
        this.state = ShieldBreakerState.IDLE;
        this.shieldBroken = false;
        this.lastBreakAttempt = 0L;
        this.cooldownTicks = 0;
    }

    public void onActivate() {
        this.resetState();
        if (((Boolean)this.chatInfo.get()).booleanValue()) {
            this.info("Shield Breaker activated - aim at players using shields!", new Object[0]);
        }
    }

    public void onDeactivate() {
        this.resetState();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        if (this.mc.field_1724.method_6115()) {
            return;
        }
        if (((Boolean)this.autoBreak.get()).booleanValue()) {
            if (this.cooldownTicks > 0) {
                --this.cooldownTicks;
                return;
            }
            switch (this.state.ordinal()) {
                case 0: {
                    this.checkForShieldUser();
                    break;
                }
                case 1: {
                    this.handleAxeSwitch();
                    break;
                }
                case 2: {
                    this.handleShieldBreak();
                    break;
                }
                case 3: {
                    this.handleWeaponSwitch();
                    break;
                }
                case 4: {
                    this.handleKillAttack();
                }
            }
        } else {
            this.checkForShieldUser();
        }
    }

    private void checkForShieldUser() {
        if (this.mc.field_1765 == null || this.mc.field_1765.method_17783() != class_239.class_240.field_1331) {
            return;
        }
        class_3966 entityHit = (class_3966)this.mc.field_1765;
        if (((Boolean)this.onlyPlayers.get()).booleanValue() && !(entityHit.method_17782() instanceof class_1657)) {
            return;
        }
        class_1297 class_12972 = entityHit.method_17782();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if ((double)this.mc.field_1724.method_5739((class_1297)player) > (Double)this.range.get()) {
                return;
            }
            if (this.isUsingShield(player)) {
                this.targetPlayer = player;
                boolean isAttacking = this.mc.field_1690.field_1886.method_1434();
                if (!((Boolean)this.autoBreak.get()).booleanValue() && isAttacking) {
                    this.originalSlot = InventoryUtils.getSelectedSlot(this.mc.field_1724.method_31548());
                    FindItemResult axeResult = InvUtils.findInHotbar(itemStack -> itemStack.method_7909() instanceof class_1743);
                    if (!axeResult.found()) {
                        if (((Boolean)this.chatInfo.get()).booleanValue()) {
                            this.error("No axe found in hotbar!", new Object[0]);
                        }
                        return;
                    }
                    if (((Boolean)this.chatInfo.get()).booleanValue()) {
                        this.info("Shield detected! Breaking with axe", new Object[0]);
                    }
                    InvUtils.swap((int)axeResult.slot(), (boolean)false);
                    this.mc.field_1761.method_2918((class_1657)this.mc.field_1724, (class_1297)player);
                    this.mc.field_1724.method_6104(class_1268.field_5808);
                    this.tickCounter = 0;
                    this.state = ShieldBreakerState.BREAKING;
                } else if (((Boolean)this.autoBreak.get()).booleanValue()) {
                    FindItemResult axeResult;
                    if (this.originalSlot == -1) {
                        this.originalSlot = InventoryUtils.getSelectedSlot(this.mc.field_1724.method_31548());
                    }
                    if (!(axeResult = InvUtils.findInHotbar(itemStack -> itemStack.method_7909() instanceof class_1743)).found()) {
                        if (((Boolean)this.chatInfo.get()).booleanValue()) {
                            this.error("No axe found in hotbar!", new Object[0]);
                        }
                        return;
                    }
                    if (((Boolean)this.chatInfo.get()).booleanValue()) {
                        this.info("Shield detected! Breaking with axe", new Object[0]);
                    }
                    InvUtils.swap((int)axeResult.slot(), (boolean)false);
                    this.state = ShieldBreakerState.SWITCHING_AXE;
                    this.tickCounter = 0;
                }
            }
        }
    }

    private void handleAxeSwitch() {
        ++this.tickCounter;
        if (this.tickCounter >= (Integer)this.axeSwitchDelay.get()) {
            long currentTime;
            if (!this.shieldBroken && (currentTime = System.currentTimeMillis()) - this.lastBreakAttempt > 150L) {
                this.mc.field_1761.method_2918((class_1657)this.mc.field_1724, (class_1297)this.targetPlayer);
                this.mc.field_1724.method_6104(class_1268.field_5808);
                this.lastBreakAttempt = currentTime;
                this.shieldBroken = true;
                if (((Boolean)this.chatInfo.get()).booleanValue()) {
                    this.info("Shield broken! Switching to weapon...", new Object[0]);
                }
            }
            this.state = ShieldBreakerState.BREAKING;
            this.tickCounter = 0;
        }
    }

    private void handleShieldBreak() {
        ++this.tickCounter;
        if (this.shieldBroken) {
            if (!((Boolean)this.autoBreak.get()).booleanValue()) {
                if (this.originalSlot != -1) {
                    InvUtils.swap((int)this.originalSlot, (boolean)false);
                    if (this.targetPlayer != null && !this.targetPlayer.method_31481() && (double)this.mc.field_1724.method_5739((class_1297)this.targetPlayer) <= (Double)this.range.get()) {
                        this.mc.field_1761.method_2918((class_1657)this.mc.field_1724, (class_1297)this.targetPlayer);
                        this.mc.field_1724.method_6104(class_1268.field_5808);
                        if (((Boolean)this.chatInfo.get()).booleanValue()) {
                            this.info("Attacking with original weapon!", new Object[0]);
                        }
                    }
                    this.resetState();
                    return;
                }
            } else {
                if (((Boolean)this.returnToPrevSlot.get()).booleanValue()) {
                    if (this.originalSlot != -1) {
                        InvUtils.swap((int)this.originalSlot, (boolean)false);
                    }
                } else {
                    int weaponSlotIndex = (Integer)this.weaponSlot.get() - 1;
                    InvUtils.swap((int)weaponSlotIndex, (boolean)false);
                }
                this.state = ShieldBreakerState.SWITCHING_BACK;
                this.tickCounter = 0;
            }
        } else if (this.tickCounter >= 3) {
            if (((Boolean)this.chatInfo.get()).booleanValue()) {
                this.error("Shield break failed, retrying...", new Object[0]);
            }
            this.state = ShieldBreakerState.IDLE;
            this.tickCounter = 0;
        }
    }

    private void handleWeaponSwitch() {
        ++this.tickCounter;
        if (this.tickCounter >= (Integer)this.weaponSwitchDelay.get()) {
            this.state = ShieldBreakerState.KILLING;
            this.tickCounter = 0;
        }
    }

    private void handleKillAttack() {
        ++this.tickCounter;
        if (this.tickCounter >= (Integer)this.killDelay.get()) {
            if (((Boolean)this.killSwitch.get()).booleanValue()) {
                if (this.targetPlayer != null && !this.targetPlayer.method_31481()) {
                    this.mc.field_1761.method_2918((class_1657)this.mc.field_1724, (class_1297)this.targetPlayer);
                    this.mc.field_1724.method_6104(class_1268.field_5808);
                    if (((Boolean)this.chatInfo.get()).booleanValue()) {
                        this.info("Kill attack executed!", new Object[0]);
                    }
                }
            } else if (((Boolean)this.chatInfo.get()).booleanValue()) {
                this.info("Shield broken - Kill switch disabled", new Object[0]);
            }
            this.resetState();
            this.cooldownTicks = (Integer)this.cycleCooldown.get();
        }
    }

    private boolean isUsingShield(class_1657 player) {
        if (this.isPlayerBehindTarget((class_1657)this.mc.field_1724, player)) {
            if (((Boolean)this.chatInfo.get()).booleanValue()) {
                this.info("Cannot break shield from behind!", new Object[0]);
            }
            return false;
        }
        class_1799 mainHand = player.method_6047();
        if (mainHand.method_7909() == class_1802.field_8255 && player.method_6115() && player.method_6058() == class_1268.field_5808) {
            return true;
        }
        class_1799 offHand = player.method_6079();
        return offHand.method_7909() == class_1802.field_8255 && player.method_6115() && player.method_6058() == class_1268.field_5810;
    }

    private boolean isPlayerBehindTarget(class_1657 source, class_1657 target) {
        double angleDiff;
        double dx = source.method_23317() - target.method_23317();
        double dz = source.method_23321() - target.method_23321();
        double angle = Math.toDegrees(Math.atan2(dz, dx));
        float targetYaw = target.method_36454() % 360.0f;
        if (targetYaw < 0.0f) {
            targetYaw += 360.0f;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return (angleDiff = Math.abs(angle - (double)targetYaw)) < 90.0 || angleDiff > 270.0;
    }

    private void resetState() {
        this.targetPlayer = null;
        this.originalSlot = -1;
        this.tickCounter = 0;
        this.state = ShieldBreakerState.IDLE;
        this.shieldBroken = false;
        this.lastBreakAttempt = 0L;
    }

    public String getInfoString() {
        return switch (this.state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> null;
            case 1 -> "Switching to Axe";
            case 2 -> "Breaking Shield";
            case 3 -> "Switching to Weapon";
            case 4 -> "Executing Kill";
        };
    }

    private static enum ShieldBreakerState {
        IDLE,
        SWITCHING_AXE,
        BREAKING,
        SWITCHING_BACK,
        KILLING;

    }
}

