/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.settings;

import com.nnpg.glazed.utils.RandomBetweenDouble;
import java.util.function.Consumer;
import meteordevelopment.meteorclient.settings.IVisible;
import meteordevelopment.meteorclient.settings.Setting;
import net.minecraft.class_2487;

public class RandomBetweenDoubleSetting
extends Setting<RandomBetweenDouble> {
    public final double absoluteMin;
    public final double absoluteMax;
    public final double sliderMin;
    public final double sliderMax;
    public final boolean noSlider;

    public RandomBetweenDoubleSetting(String name, String description, RandomBetweenDouble defaultValue, Consumer<RandomBetweenDouble> onChanged, Consumer<Setting<RandomBetweenDouble>> onModuleActivated, IVisible visible, double absoluteMin, double absoluteMax, double sliderMin, double sliderMax, boolean noSlider) {
        super(name, description, (Object)defaultValue, onChanged, onModuleActivated, visible);
        this.absoluteMin = absoluteMin;
        this.absoluteMax = absoluteMax;
        this.sliderMin = sliderMin;
        this.sliderMax = sliderMax;
        this.noSlider = noSlider;
    }

    public void resetImpl() {
        this.value = new RandomBetweenDouble(((RandomBetweenDouble)this.defaultValue).min, ((RandomBetweenDouble)this.defaultValue).max);
    }

    protected RandomBetweenDouble parseImpl(String str) {
        String[] parts = str.split("-");
        if (parts.length != 2) {
            return null;
        }
        try {
            double min = Double.parseDouble(parts[0].trim());
            double max = Double.parseDouble(parts[1].trim());
            return new RandomBetweenDouble(min, max);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean set(RandomBetweenDouble value) {
        if (value.min < this.absoluteMin || value.max > this.absoluteMax || value.min > value.max) {
            return false;
        }
        return super.set((Object)value);
    }

    protected boolean isValueValid(RandomBetweenDouble value) {
        return value.min >= this.absoluteMin && value.max <= this.absoluteMax && value.min <= value.max;
    }

    public class_2487 save(class_2487 tag) {
        tag.method_10549("min", ((RandomBetweenDouble)this.get()).min);
        tag.method_10549("max", ((RandomBetweenDouble)this.get()).max);
        return tag;
    }

    public RandomBetweenDouble load(class_2487 tag) {
        double min = tag.method_10545("min") ? tag.method_10574("min") : ((RandomBetweenDouble)this.defaultValue).min;
        double max = tag.method_10545("max") ? tag.method_10574("max") : ((RandomBetweenDouble)this.defaultValue).max;
        return new RandomBetweenDouble(min, max);
    }

    public static class Builder
    extends Setting.SettingBuilder<Builder, RandomBetweenDouble, RandomBetweenDoubleSetting> {
        private double absoluteMin = Double.NEGATIVE_INFINITY;
        private double absoluteMax = Double.POSITIVE_INFINITY;
        private double sliderMin = 0.0;
        private double sliderMax = 10.0;
        private boolean noSlider = false;

        public Builder() {
            super((Object)new RandomBetweenDouble(0.0, 1.0));
        }

        public Builder min(double min) {
            this.absoluteMin = min;
            return this;
        }

        public Builder max(double max) {
            this.absoluteMax = max;
            return this;
        }

        public Builder range(double min, double max) {
            this.absoluteMin = min;
            this.absoluteMax = max;
            return this;
        }

        public Builder sliderRange(double min, double max) {
            this.sliderMin = min;
            this.sliderMax = max;
            return this;
        }

        public Builder defaultMin(double min) {
            this.defaultValue = this.defaultValue == null ? new RandomBetweenDouble(min, 1.0) : new RandomBetweenDouble(min, ((RandomBetweenDouble)this.defaultValue).max);
            return this;
        }

        public Builder defaultMax(double max) {
            this.defaultValue = this.defaultValue == null ? new RandomBetweenDouble(0.0, max) : new RandomBetweenDouble(((RandomBetweenDouble)this.defaultValue).min, max);
            return this;
        }

        public Builder defaultRange(double min, double max) {
            this.defaultValue = new RandomBetweenDouble(min, max);
            return this;
        }

        public Builder noSlider() {
            this.noSlider = true;
            return this;
        }

        public RandomBetweenDoubleSetting build() {
            return new RandomBetweenDoubleSetting(this.name, this.description, (RandomBetweenDouble)this.defaultValue, this.onChanged, this.onModuleActivated, this.visible, this.absoluteMin, this.absoluteMax, this.sliderMin, this.sliderMax, this.noSlider);
        }
    }
}

