/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.settings;

import com.nnpg.glazed.utils.RandomBetweenInt;
import java.util.function.Consumer;
import meteordevelopment.meteorclient.settings.IVisible;
import meteordevelopment.meteorclient.settings.Setting;
import net.minecraft.class_2487;

public class RandomBetweenIntSetting
extends Setting<RandomBetweenInt> {
    public final int absoluteMin;
    public final int absoluteMax;
    public final int sliderMin;
    public final int sliderMax;
    public final boolean noSlider;

    public RandomBetweenIntSetting(String name, String description, RandomBetweenInt defaultValue, Consumer<RandomBetweenInt> onChanged, Consumer<Setting<RandomBetweenInt>> onModuleActivated, IVisible visible, int absoluteMin, int absoluteMax, int sliderMin, int sliderMax, boolean noSlider) {
        super(name, description, (Object)defaultValue, onChanged, onModuleActivated, visible);
        this.absoluteMin = absoluteMin;
        this.absoluteMax = absoluteMax;
        this.sliderMin = sliderMin;
        this.sliderMax = sliderMax;
        this.noSlider = noSlider;
    }

    public void resetImpl() {
        this.value = new RandomBetweenInt(((RandomBetweenInt)this.defaultValue).min, ((RandomBetweenInt)this.defaultValue).max);
    }

    protected RandomBetweenInt parseImpl(String str) {
        String[] parts = str.split("-");
        if (parts.length != 2) {
            return null;
        }
        try {
            int min = Integer.parseInt(parts[0].trim());
            int max = Integer.parseInt(parts[1].trim());
            return new RandomBetweenInt(min, max);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean set(RandomBetweenInt value) {
        if (value.min < this.absoluteMin || value.max > this.absoluteMax || value.min > value.max) {
            return false;
        }
        return super.set((Object)value);
    }

    protected boolean isValueValid(RandomBetweenInt value) {
        return value.min >= this.absoluteMin && value.max <= this.absoluteMax && value.min <= value.max;
    }

    public class_2487 save(class_2487 tag) {
        tag.method_10569("min", ((RandomBetweenInt)this.get()).min);
        tag.method_10569("max", ((RandomBetweenInt)this.get()).max);
        return tag;
    }

    public RandomBetweenInt load(class_2487 tag) {
        int min = tag.method_10545("min") ? tag.method_10550("min") : ((RandomBetweenInt)this.defaultValue).min;
        int max = tag.method_10545("max") ? tag.method_10550("max") : ((RandomBetweenInt)this.defaultValue).max;
        return new RandomBetweenInt(min, max);
    }

    public static class Builder
    extends Setting.SettingBuilder<Builder, RandomBetweenInt, RandomBetweenIntSetting> {
        private int absoluteMin = Integer.MIN_VALUE;
        private int absoluteMax = Integer.MAX_VALUE;
        private int sliderMin = 0;
        private int sliderMax = 100;
        private boolean noSlider = false;

        public Builder() {
            super((Object)new RandomBetweenInt(0, 10));
        }

        public Builder min(int min) {
            this.absoluteMin = min;
            return this;
        }

        public Builder max(int max) {
            this.absoluteMax = max;
            return this;
        }

        public Builder range(int min, int max) {
            this.absoluteMin = min;
            this.absoluteMax = max;
            return this;
        }

        public Builder sliderRange(int min, int max) {
            this.sliderMin = min;
            this.sliderMax = max;
            return this;
        }

        public Builder defaultMin(int min) {
            this.defaultValue = this.defaultValue == null ? new RandomBetweenInt(min, 10) : new RandomBetweenInt(min, ((RandomBetweenInt)this.defaultValue).max);
            return this;
        }

        public Builder defaultMax(int max) {
            this.defaultValue = this.defaultValue == null ? new RandomBetweenInt(0, max) : new RandomBetweenInt(((RandomBetweenInt)this.defaultValue).min, max);
            return this;
        }

        public Builder defaultRange(int min, int max) {
            this.defaultValue = new RandomBetweenInt(min, max);
            return this;
        }

        public Builder noSlider() {
            this.noSlider = true;
            return this;
        }

        public RandomBetweenIntSetting build() {
            return new RandomBetweenIntSetting(this.name, this.description, (RandomBetweenInt)this.defaultValue, this.onChanged, this.onModuleActivated, this.visible, this.absoluteMin, this.absoluteMax, this.sliderMin, this.sliderMax, this.noSlider);
        }
    }
}

