/*
 * Decompiled with CFR 0.152.
 */
package com.nnpg.glazed.utils;

import java.util.Random;

public class RandomBetweenInt {
    private static final Random random = new Random();
    public final int min;
    public final int max;

    public RandomBetweenInt(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("Min value cannot be greater than max value");
        }
        this.min = min;
        this.max = max;
    }

    public int getRandom() {
        if (this.min == this.max) {
            return this.min;
        }
        return random.nextInt(this.max - this.min + 1) + this.min;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RandomBetweenInt that = (RandomBetweenInt)obj;
        return this.min == that.min && this.max == that.max;
    }

    public int hashCode() {
        return 31 * this.min + this.max;
    }

    public String toString() {
        return this.min + " - " + this.max;
    }
}

